# Evaluating Cardiovascular Disease Risk in Young Healthcare Professionals: Insights from Q-Risk 3 Calculations

**Authors:** Rangarajan, Premnath
**Year:** 2025
**DOI:** 10.4103/ijoem.ijoem_272_23
**URL:** https://doi.org/10.4103/ijoem.ijoem_272_23

## Abstract

Background: There is a global rise in cardiovascular diseases (CVD), particularly among the current generation of young adults, including the health professionals. Factors such as poor lifestyle choices, inadequate nutrition, sedentary work, and prolonged working hours contribute to occupational stress. Aim: This study aimed to investigate the prevalence of CVD risk factors in young healthcare workers aged 25–40 and assess their 10-year CVD risk using the QRISK 3 prediction algorithm. Materials and Methods: A cross-sectional study was conducted on 248 health workers aged 25–40 years in a tertiary care hospital in Pondicherry. Data collected include questionnaire responses for the QRISK 3 algorithm, weight, height, and two SBP readings on two different days, and blood samples for HDL-c, Fasting glucose, and Total cholesterol level. Result: Nearly 26.6% of the participants had high body mass index (BMI), 5.24% had diabetes mellitus, 16.12% had hypertension, 25.4% were found with hyperlipidemia, 6.3% had a history of light smoking, and 47.5% had a family history of CVD. Most of the risk factors except hypertension and low HDL-c showed female preponderance. Despite the high prevalence, the mean QRISK score of a 10-year risk of getting CVD among young healthcare workers is less, which is only 1.3%. Conclusion: Though the prevalence of major risk factors is high among healthcare workers other risk factors that the QRISK 3 algorithm takes into consideration were very low among the participants. The higher prevalence of metabolic risk factors emphasizes the need for the change in lifestyle behaviors of participants.

## Citation Details

Evaluating Cardiovascular Disease Risk in Young Healthcare Professionals: Insights from Q-Risk 3 Calculations
**Authors**: Rangarajan, Premnath
**Year**: 2025
**DOI**: 10.4103/ijoem.ijoem_272_23
**URL**: https://doi.org/10.4103/ijoem.ijoem_272_23

**Abstract**: Background: There is a global rise in cardiovascular diseases (CVD), particularly among the current generation of young adults, including the health professionals. Factors such as poor lifestyle choices, inadequate nutrition, sedentary work, and prolonged working hours contribute to occupational stress. Aim: This study aimed to investigate the prevalence of CVD risk factors in young healthcare workers aged 25–40 and assess their 10-year CVD risk using the QRISK 3 prediction algorithm. Materials and Methods: A cross-sectional study was conducted on 248 health workers aged 25–40 years in a tertiary care hospital in Pondicherry. Data collected include questionnaire responses for the QRISK 3 algorithm, weight, height, and two SBP readings on two different days, and blood samples for HDL-c, Fasting glucose, and Total cholesterol level. Result: Nearly 26.6% of the participants had high body mass index (BMI), 5.24% had diabetes mellitus, 16.12% had hypertension, 25.4% were found with hyperlipidemia, 6.3% had a history of light smoking, and 47.5% had a family history of CVD. Most of the risk factors except hypertension and low HDL-c showed female preponderance. Despite the high prevalence, the mean QRISK score of a 10-year risk of getting CVD among young healthcare workers is less, which is only 1.3%. Conclusion: Though the prevalence of major risk factors is high among healthcare workers other risk factors that the QRISK 3 algorithm takes into consideration were very low among the participants. The higher prevalence of metabolic risk factors emphasizes the need for the change in lifestyle behaviors of participants.  # Truncate if very long

---
*Extracted from citation research database - all 39 citations available*
