# Influence of Human Resource Management on Employee Coping Behavior and Job Performance

**Authors:** Al-Qasos, Alansi, Li
**Year:** 2025
**DOI:** 10.59324/ejmeb.2025.2(6).12
**URL:** https://doi.org/10.59324/ejmeb.2025.2(6).12

## Abstract

Human resource management (HRM) plays a pivotal role not only in structuring organizational processes but also in shaping how employees cognitively appraise, affectively respond to, and behaviorally adapt to workplace demands. Drawing on structuration theory (Giddens, 1984) and integrating insights from stress and coping theory (Lazarus & Folkman, 1984) and cognitive evaluation theory (Deci & Ryan, 2012), this study investigates how HRM influences employee coping behaviors—specifically adaptation, resistance, and manipulation—and how these behaviors, in turn, affect job performance. The research addresses three core objectives: (1) to examine how HRM practices shape employees’ cognitive and affective responses, with attention to boundary conditions such as fairness, transparency, and employee participation; (2) to identify the types of coping behaviors employees employ in response to HRM and elucidate how cognitive and affective appraisals drive the selection of these strategies; and (3) to analyze the mediating role of coping behaviors in the relationship between HRM and dual dimensions of job performance— in-role task execution and extra-role organizational citizenship behaviors. By centering employee agency within a dynamic socio-technical framework, this study provides a micro-foundational understanding of HRM’s impact on performance and offers practical guidance for designing HR systems that are both effective and human-centered.

## Citation Details

Influence of Human Resource Management on Employee Coping Behavior and Job Performance
**Authors**: Al-Qasos, Alansi, Li
**Year**: 2025
**DOI**: 10.59324/ejmeb.2025.2(6).12
**URL**: https://doi.org/10.59324/ejmeb.2025.2(6).12

**Abstract**: Human resource management (HRM) plays a pivotal role not only in structuring organizational processes but also in shaping how employees cognitively appraise, affectively respond to, and behaviorally adapt to workplace demands. Drawing on structuration theory (Giddens, 1984) and integrating insights from stress and coping theory (Lazarus & Folkman, 1984) and cognitive evaluation theory (Deci & Ryan, 2012), this study investigates how HRM influences employee coping behaviors—specifically adaptation, resistance, and manipulation—and how these behaviors, in turn, affect job performance. The research addresses three core objectives: (1) to examine how HRM practices shape employees’ cognitive and affective responses, with attention to boundary conditions such as fairness, transparency, and employee participation; (2) to identify the types of coping behaviors employees employ in response to HRM and elucidate how cognitive and affective appraisals drive the selection of these strategies; and (3) to analyze the mediating role of coping behaviors in the relationship between HRM and dual dimensions of job performance— in-role task execution and extra-role organizational citizenship behaviors. By centering employee agency within a dynamic socio-technical framework, this study provides a micro-foundational understanding of HRM’s impact on performance and offers practical guidance for designing HR systems that are both effective and human-centered.  # Truncate if very long

---
*Extracted from citation research database - all 39 citations available*
