# Determinants of Employee Mental Health in Contemporary Work Environments: A Systematic Literature Review

**Authors:** Marianggodo, Noviekayati, Suhadianto
**Year:** 2025
**DOI:** 10.47191/ijcsrr/v8-i12-14
**URL:** https://doi.org/10.47191/ijcsrr/v8-i12-14

## Abstract

Mental health has become a critical dimension of workforce sustainability as contemporary organizations confront rising job demands, digital acceleration, and shifting work structures. This systematic literature review synthesizes empirical evidence on determinants of employee mental health from 25 internationally published and peer-reviewed articles spanning 2000–2025. Literature retrieval was conducted across Scopus, Web of Science, EBSCOhost, ScienceDirect, and SAGE Journals using Boolean operators such as (“employee mental health” OR “psychological well-being” OR “occupational mental health”) AND (“job demands” OR “technostress” OR “workload” OR “leadership” OR “organizational climate”). The initial search identified 1,872 records. After duplicate removal, title–abstract screening, full-text assessment, and methodological filtering based on PRISMA 2020 guidelines, 25 articles met the eligibility criteria and were included in the narrative synthesis.

## Citation Details

Determinants of Employee Mental Health in Contemporary Work Environments: A Systematic Literature Review
**Authors**: Marianggodo, Noviekayati, Suhadianto
**Year**: 2025
**DOI**: 10.47191/ijcsrr/v8-i12-14
**URL**: https://doi.org/10.47191/ijcsrr/v8-i12-14

**Abstract**: Mental health has become a critical dimension of workforce sustainability as contemporary organizations confront rising job demands, digital acceleration, and shifting work structures. This systematic literature review synthesizes empirical evidence on determinants of employee mental health from 25 internationally published and peer-reviewed articles spanning 2000–2025. Literature retrieval was conducted across Scopus, Web of Science, EBSCOhost, ScienceDirect, and SAGE Journals using Boolean operators such as (“employee mental health” OR “psychological well-being” OR “occupational mental health”) AND (“job demands” OR “technostress” OR “workload” OR “leadership” OR “organizational climate”). The initial search identified 1,872 records. After duplicate removal, title–abstract screening, full-text assessment, and methodological filtering based on PRISMA 2020 guidelines, 25 articles met the eligibility criteria and were included in the narrative synthesis.

The findings reveal three dominant clusters of determinants: individual factors, job-related factors, and organizational-level conditions. Individual determinants—such as psychological capital, coping strategies, personality traits, and resilience—shape susceptibility to stress and burnout. Job-related determinants, including workload intensity, role ambiguity, emotional labor, digital work intensification, and technostress, consistently predict psychological strain. Organizational determinants, particularly leadership style, organizational justice, social support, perceived fairness, and work–life policy structures, demonstrated the strongest influence on employee well-being, with supportive climates significantly mitigating anxiety, burnout, and de  # Truncate if very long

---
*Extracted from citation research database - all 39 citations available*
