# Promoting management skills: an intercultural comparative analysis

**Authors:** Aránega, Sánchez
**Year:** 2022
**DOI:** 10.1108/ijebr-06-2022-0531
**URL:** https://doi.org/10.1108/ijebr-06-2022-0531

## Abstract

PurposeSince the COVID-19 pandemic, young people have found their development obstructed and in some cases paralysed. Young professionals have had to learn to adapt to this new environment, and they have also lost opportunities to enter the labour market. The main objective of this study is to measure the effectiveness of tools based on experiential learning, such as outdoor training accompanied by mindfulness, in improving the emotional skills of young Asian professionals and, potentially, help them break down the barriers of their environment. It also compares the findings with the young Asian professionals with young European professionals.Design/methodology/approachThis study replicates the one used in the first study, in which the data were first compiled using a closed-ended questionnaire during an outdoor training and mindfulness. A sample of 46 Asian and 49 young European professionals completed a series of outdoor training sessions. The participants provided their self-assessments of their own emotional competencies. Pre- and post-sessions questionnaires were used to measure competencies of emotional intelligence among young professionals who have just finished their studies, as the current educational system was found to require young people to develop professional skills that they will need in employment in the near future.FindingsThe results show that outdoor training had a greater effect on the young Asian professionals than on their European counterparts, overall, and particularly in Teamwork competence. Finally, this tool was positively received in both segments.Research limitations/implicationsOne limitation of this study is that the Asian participants felt reserved when participating. Their cultural model includes a vision, education and politics that differ so much from European culture that it could have led to difficulties. They are not used to close contact with others or working as a team, and their character is more individualistic and independent (Hu, 2002). A second limitation is that (apart from the pre-activity questionnaire) the degree of cultural difference is not measured quantitatively but is based on a review of the literature and previous findings.Practical implicationsThe research provides an underlying finding that addresses how the emotional competencies in demand could be developed at a more globalised level after a post-pandemic environment.Originality/valueVery few studies have quantitatively confirmed its effectiveness, which is difficult, given the subjective nature of evaluation (Padilla-Melé ndez et al., 2014). Authors such as Barner (1989), Huszczo (1990), Lusher (1990), Bailey (1990), Fulmer (1992), Irvine and Wilson (1994) and Wagner and Campbell (1994) mention studies which implemented an outdoor training programme, but few studies attempt an objective evaluation. This study uses these tools in the Asian environment, after their application and confirmation of their measurability in Europe.

## Citation Details

Promoting management skills: an intercultural comparative analysis
**Authors**: Aránega, Sánchez
**Year**: 2022
**DOI**: 10.1108/ijebr-06-2022-0531
**URL**: https://doi.org/10.1108/ijebr-06-2022-0531

**Abstract**: PurposeSince the COVID-19 pandemic, young people have found their development obstructed and in some cases paralysed. Young professionals have had to learn to adapt to this new environment, and they have also lost opportunities to enter the labour market. The main objective of this study is to measure the effectiveness of tools based on experiential learning, such as outdoor training accompanied by mindfulness, in improving the emotional skills of young Asian professionals and, potentially, help them break down the barriers of their environment. It also compares the findings with the young Asian professionals with young European professionals.Design/methodology/approachThis study replicates the one used in the first study, in which the data were first compiled using a closed-ended questionnaire during an outdoor training and mindfulness. A sample of 46 Asian and 49 young European professionals completed a series of outdoor training sessions. The participants provided their self-assessments of their own emotional competencies. Pre- and post-sessions questionnaires were used to measure competencies of emotional intelligence among young professionals who have just finished their studies, as the current educational system was found to require young people to develop professional skills that they will need in employment in the near future.FindingsThe results show that outdoor training had a greater effect on the young Asian professionals than on their European counterparts, overall, and particularly in Teamwork competence. Finally, this tool was positively received in both segments.Research limitations/implicationsOne limitation of this study is that the Asian participants felt reserved when participating. Their cultural model includes a vision, education and   # Truncate if very long

---
*Extracted from citation research database - all 39 citations available*
