# How to Choose a Measure of Resilience: An Organizing Framework for Resilience Measurement

**Authors:** Fisher, Law
**Year:** 2020
**DOI:** 10.1111/apps.12243
**URL:** https://doi.org/10.1111/apps.12243

## Abstract

Existing measures of resilience include disparate content that is based on qualitatively different conceptualizations of the construct. Consequently, there is confusion and inconsistency regarding the measurement and application of resilience. To promote clarity, the authors conduct an examination of resilience measurement approaches. This was accomplished by elaborating on three fundamentally distinct conceptualizations of resilience that can serve as an organizing framework for measurement; (1) attribute/resource‐focused; (2) process‐focused; and (3) outcome‐focused. To verify the utility of this framework, qualified and trained subject matter experts (SMEs) completed a content analysis categorization task by sorting 227 items from 11 scales into these categories. Frame‐of‐reference (FOR) training was used to prepare the SMEs. Results were largely supportive of the three category framework, as overall SME agreement was 86.76 percent and only 10 of 227 items (4.41%) were categorized as “unclear” with regard to the categories. At the same time, SME agreement varied across the scales and sub‐dimensions examined, suggesting that some scales/sub‐dimensions are more conceptually clear than others in terms of the three categories. Based on the results, the authors provide guidance for how to choose a measure of resilience and discuss different workplace applications that are aligned with the aforementioned categories.

## Citation Details

How to Choose a Measure of Resilience: An Organizing Framework for Resilience Measurement
**Authors**: Fisher, Law
**Year**: 2020
**DOI**: 10.1111/apps.12243
**URL**: https://doi.org/10.1111/apps.12243

**Abstract**: Existing measures of resilience include disparate content that is based on qualitatively different conceptualizations of the construct. Consequently, there is confusion and inconsistency regarding the measurement and application of resilience. To promote clarity, the authors conduct an examination of resilience measurement approaches. This was accomplished by elaborating on three fundamentally distinct conceptualizations of resilience that can serve as an organizing framework for measurement; (1) attribute/resource‐focused; (2) process‐focused; and (3) outcome‐focused. To verify the utility of this framework, qualified and trained subject matter experts (SMEs) completed a content analysis categorization task by sorting 227 items from 11 scales into these categories. Frame‐of‐reference (FOR) training was used to prepare the SMEs. Results were largely supportive of the three category framework, as overall SME agreement was 86.76 percent and only 10 of 227 items (4.41%) were categorized as “unclear” with regard to the categories. At the same time, SME agreement varied across the scales and sub‐dimensions examined, suggesting that some scales/sub‐dimensions are more conceptually clear than others in terms of the three categories. Based on the results, the authors provide guidance for how to choose a measure of resilience and discuss different workplace applications that are aligned with the aforementioned categories.

### From Semantic Scholar (24 citations)  # Truncate if very long

---
*Extracted from citation research database - all 39 citations available*
