# Social Support and Psychosocial Resilience: Evaluating the Impact of Community-Based Interventions on Mental Health

**Authors:** Ekayani
**Year:** 2025
**DOI:** 10.61978/psychosocia.v3i1.788
**URL:** https://doi.org/10.61978/psychosocia.v3i1.788

## Abstract

Mental health remains a critical global concern, particularly in settings where structural and social disparities limit access to appropriate care. This narrative review aims to examine the effectiveness of social support interventions—both interpersonal and community-based—in promoting mental well-being and reducing psychological distress. Using an integrative approach, literature was collected from academic databases such as Scopus and Google Scholar, utilizing key terms including "social support," "mental health interventions," and "community engagement." Studies meeting inclusion criteria featured diverse methodologies and participant populations across multiple geographic contexts. The results demonstrate that interpersonal support, particularly from partners and family members, significantly improves psychological outcomes by reducing symptoms of depression and anxiety, enhancing emotional regulation, and fostering cognitive resilience. Community-level interventions, especially those grounded in participatory models, were shown to increase mental health literacy, combat stigma, and facilitate access to care. However, systemic barriers such as poverty, discrimination, and healthcare inequity continue to undermine these efforts, particularly in low-resource settings. The discussion suggests that addressing mental health requires a multi-level response integrating interpersonal, communal, and policy-based strategies. The review advocates for culturally adapted, inclusive, and sustainable mental health programs, supported by strong policy frameworks and local engagement. By emphasizing social connectedness and institutional support, these interventions offer a promising pathway toward resilient mental health systems worldwide.

## Citation Details

Social Support and Psychosocial Resilience: Evaluating the Impact of Community-Based Interventions on Mental Health
**Authors**: Ekayani
**Year**: 2025
**DOI**: 10.61978/psychosocia.v3i1.788
**URL**: https://doi.org/10.61978/psychosocia.v3i1.788

**Abstract**: Mental health remains a critical global concern, particularly in settings where structural and social disparities limit access to appropriate care. This narrative review aims to examine the effectiveness of social support interventions—both interpersonal and community-based—in promoting mental well-being and reducing psychological distress. Using an integrative approach, literature was collected from academic databases such as Scopus and Google Scholar, utilizing key terms including "social support," "mental health interventions," and "community engagement." Studies meeting inclusion criteria featured diverse methodologies and participant populations across multiple geographic contexts. The results demonstrate that interpersonal support, particularly from partners and family members, significantly improves psychological outcomes by reducing symptoms of depression and anxiety, enhancing emotional regulation, and fostering cognitive resilience. Community-level interventions, especially those grounded in participatory models, were shown to increase mental health literacy, combat stigma, and facilitate access to care. However, systemic barriers such as poverty, discrimination, and healthcare inequity continue to undermine these efforts, particularly in low-resource settings. The discussion suggests that addressing mental health requires a multi-level response integrating interpersonal, communal, and policy-based strategies. The review advocates for culturally adapted, inclusive, and sustainable mental health programs, supported by strong policy frameworks and local engagement. By emphasizing social connectedness and institutional support, these interventions offer a promising pathway toward resilient mental health  # Truncate if very long

---
*Extracted from citation research database - all 39 citations available*
