## Paper 9: Problematic personalities in teams: Implications for performance trajectories and resilience to unexpected change
**Authors:** Dierdorff, E. C., & Fisher, D. M.
**Year:** 2021
**Venue:** Personnel Psychology
**DOI:** [10.1111/peps.12481](https://doi.org/10.1111/peps.12481)

### Research Question
How does the presence of a single "problematic" personality (e.g., low agreeableness, low conscientiousness) affect a team's ability to maintain performance over time and demonstrate resilience when hit with unexpected change?

### Methodology
- **Design:** Longitudinal Team Study.
- **Approach:** Tracking team performance trajectories before and after a disruption.
- **Data:** Teams working on collaborative tasks over time.

### Key Findings
1. **The "Bad Apple" Effect:** A single problematic member significantly drags down the *entire* team's resilience trajectory.
2. **Recovery Lag:** Teams with problematic personalities take significantly longer to recover performance levels after a shock than "clean" teams.
3. **Social Capital Erosion:** Problematic personalities likely degrade the "relational redundancy" (see Powley, Paper 7) required for resilience.

### Implications
This paper adds a critical "team composition" layer. You can have the best protocols (Paper 2) and individual mindfulness (Paper 1), but one toxic team member can short-circuit the resilience mechanism.

### Limitations
- **Lab vs. Field:** [VERIFY] If this was a student team simulation (common in this field), results might differ from high-stakes corporate teams.

### Relevance to Your Research
**Score:** ⭐⭐⭐⭐ (4/5)
**Why:** Introduces a failure mode for resilience. It explains *why* resilience efforts might fail despite good intentions.

---

# Cross-Paper Analysis

### Common Themes

#### 1. The Shift from Individual to Relational Resilience
A distinct thematic arc exists across these papers. **Paper 1 (Panjwani)** and **Paper 8 (Latack)** focus on the *individual* (mindfulness, coping strategies). However, **Paper 7 (Powley)**, **Paper 6 (Ekayani)**, and **Paper 9 (Dierdorff)** argue that resilience is a *relational* property. Powley calls this "relational redundancy," while Ekayani emphasizes "community-based interventions." The consensus is shifting toward the idea that an individual cannot be resilient in isolation; they require a supportive web of relationships.

#### 2. Crisis as a Catalyst (The "Liminal" State)
**Paper 7 (Powley)** and **Paper 2 (MIT Sloan)** both view crisis not just as a disaster, but as a moment of "unfreezing." Powley uses the term "liminal suspension" to describe how crisis breaks rigid structures. MIT Sloan urges leaders to exploit this fluidity to "implement first." Both suggest that the chaos of crisis is the *only* time true adaptation happens.

#### 3. Structural Barriers to Resilience
**Paper 3 (Ageel & Shbeer)** and **Paper 6 (Ekayani)** introduce a critical realist perspective: Resilience is limited by structure. Ageel shows that ICU nurses cannot "cope" their way out of bad management standards. Ekayani notes that poverty and discrimination undermine social support. This serves as a counter-narrative to **Paper 1**, suggesting that mindfulness is insufficient if the system itself is toxic.

### Methodological Trends
- **Qualitative Deep Dives:** Papers 5 (Bimrose) and 7 (Powley) use qualitative/narrative methods to understand the *process* of resilience. This is crucial for understanding "how" it happens, not just "that" it happens.
- **Review & Synthesis:** There is a heavy reliance on synthesis papers (Paper 2, 4, 6) in this batch, indicating that the field is currently trying to consolidate fragmented theories into cohesive frameworks.
- **Longitudinal/Trajectory:** Paper 9 (Dierdorff) represents the modern gold standard—tracking resilience *over time* rather than just a snapshot survey.

### Contradictions or Debates
- **Planning vs. Agility:** **Paper 8 (Latack)** emphasizes "Control" coping (planning, taking charge), whereas **Paper 2 (MIT Sloan)** suggests that in a digital world, planning is impossible and "speed" is the only defense. This represents a tension between *strategic resilience* (planning) and *adaptive resilience* (improvising).
- **Individual Responsibility vs. Systemic Duty:** **Paper 1** places the onus on the worker (meditate to reduce burnout), while **Paper 3** places it on the organization (improve management standards). This is the central tension in current resilience literature.

### Citation Network & Connections
- **The "Relational" Hub:** **Paper 7 (Powley)** is a likely hub for **Paper 6 (Ekayani)** and **Paper 9 (Dierdorff)**. Powley's concept of "compassionate witnessing" provides the mechanism for the social support Ekayani reviews, while Dierdorff illustrates what happens when that mechanism is broken by a toxic personality.
- **The "Career" Thread:** **Paper 8 (Latack, 1984)** is the ancestor of **Paper 5 (Bimrose, 2012)**. Latack defined the stress of transition; Bimrose defined the narrative therapy to fix it.

---

# Research Trajectory

**Historical progression:**
- **1984 (Latack):** Resilience is about **Individual Coping** and "Control." The focus is on the single employee managing a linear career change.
- **2009-2012 (Powley, Bimrose):** Resilience is **Relational and Narrative.** It's about how we talk to each other and support each other during crises. The focus moves to the *group* and the *story*.
- **2019-2022 (MIT Sloan, Panjwani, Ageel):** Resilience is **Systemic and High-Speed.** The focus splits between protecting the human (mindfulness) and accelerating the organization (digital agility).
- **2025 (Ekayani):** Resilience is **Integrative and Multi-Level.** The future direction is combining individual, community, and policy interventions.

**Future directions suggested:**
1. **The "Multi-Level" Approach:** As suggested by **Ekayani (Paper 6)**, future research must stop studying individual and organizational resilience separately and study how they interact.
2. **Resilience to Digital Disruption:** Following **MIT Sloan (Paper 2)**, more empirical work is needed on how AI specifically impacts human resilience in the workplace.
3. **Team Composition:** **Dierdorff (Paper 9)** opens a door to studying how specific personality combinations enhance or destroy team resilience.

---

# Must-Read Papers (Top 3)

1. **Paper 7: Reclaiming resilience and safety (Powley, 2009)**
   - **Why:** It provides the most sophisticated theoretical model ("Liminal Suspension") for *how* resilience actually works during a crisis. It explains the mechanism, not just the outcome.

2. **Paper 2: Who Wins in a Digital World? (MIT Sloan, 2019)**
   - **Why:** It sets the context for the modern era. You cannot understand resilience today without understanding the "Digital World" pressures described here.

3. **Paper 6: Social Support and Psychosocial Resilience (Ekayani, 2025)**
   - **Why:** It is the most up-to-date synthesis, covering the "Social" aspect of resilience which is becoming the dominant paradigm.

---

# Gaps for Further Investigation

1. **The "Toxic" Factor in Remote Work:** Paper 9 discusses problematic personalities in teams, but does this effect hold in *virtual* teams (Paper 2 context)? There is a gap in understanding how "bad apples" affect resilience in remote/digital environments.
2. **Longitudinal Mindfulness:** Paper 1 shows mindfulness helps, but does it last? We need longitudinal studies (like Paper 9) applied to the interventions in Paper 1.
3. **Cross-Cultural Resilience Standards:** Paper 3 highlights Saudi Arabia. There is a gap in comparative studies that test if "Western" resilience models (like Latack or MIT Sloan) actually work in non-Western healthcare settings.