## Paper 8: Career transitions within organizations: An exploratory study of work, nonwork, and coping strategies
**Authors:** Latack, J. C.
**Year:** 1984
**Venue:** Organizational Behavior and Human Performance
**DOI:** [10.1016/0030-5073(84)90041-2](https://doi.org/10.1016/0030-5073(84)90041-2)
**Citations:** Very High (Classic/Foundational)

### Research Question
How do individuals cope with the stress associated with major career transitions (promotions, transfers, demotions) within an organization? This paper establishes early models of coping.

### Methodology
- **Design:** Exploratory/Empirical.
- **Approach:** Survey/Interview data regarding role stress and coping mechanisms.
- **Data:** Employees undergoing job transitions.

### Key Findings
1. **Control vs. Symptom Management:** Identified two main coping strategies: "Control" (taking action to solve the problem) and "Symptom Management" (dealing with the emotional fallout). Control strategies were generally more effective for long-term adaptation.
2. **Role Overload:** Identified that transitions often result in role overload, which is a primary driver of stress.
3. **Nonwork Factors:** Acknowledged that family and personal life stability significantly buffers work-transition stress.

### Implications
As a foundational text, it set the stage for modern "Job Demands-Resources" models. It teaches us that resilience is partly about "Control Coping"—giving employees the agency to shape their new roles.

### Limitations
- **Age:** Published in 1984; the work environment (pre-digital) was vastly different.
- **Static View:** View of careers was more linear (within one organization) than the modern gig/dynamic economy.

### Relevance to Your Research
**Score:** ⭐⭐⭐⭐ (4/5)
**Why:** Provides the historical baseline. You can contrast Latack's "linear transition" with the "digital chaos" described in Paper 2 (MIT Sloan).

---