## Paper 7: Reclaiming resilience and safety: Resilience activation in the critical period of crisis
**Authors:** Powley, E. H.
**Year:** 2009
**Venue:** Human Relations
**DOI:** [10.1177/0018726709334881](https://doi.org/10.1177/0018726709334881)
**Citations:** High (Foundational theory paper)

### Research Question
How does an organization's "latent" capacity for resilience actually get *activated* during a sudden crisis? The paper investigates the mechanisms of immediate response.

### Methodology
- **Design:** Case Study (Qualitative/Narrative).
- **Approach:** Analysis of a specific organizational crisis: a shooting and standoff at a business school.
- **Data:** Narrative accounts, interviews, and timeline reconstruction of the event.

### Key Findings
1. **Liminal Suspension:** Crisis creates a temporary "suspension" of normal hierarchy and roles, creating a space where new, resilient behaviors can emerge.
2. **Compassionate Witnessing:** Resilience is activated when members notice and validate the suffering of others—a relational act, not just a procedural one.
3. **Relational Redundancy:** The activation of latent social networks (social capital) that cut across formal boundaries is critical for rapid information flow and support.

### Implications
This is a theoretical heavyweight. It moves resilience from a "trait" (something you have) to a "process" (something you do). It implies that organizations must cultivate "relational redundancy" *before* a crisis so it can be activated *during* one.

### Limitations
- **Single Case Study:** Findings are derived from one extreme event (school shooting), which may not map perfectly to lower-intensity crises (e.g., market downturns).

### Relevance to Your Research
**Score:** ⭐⭐⭐⭐⭐ (5/5)
**Why:** Provides the theoretical mechanism ("Activation") that explains *how* the interventions in other papers might work. Essential reading.

---