# Narrative Consistency Report

**Sections Reviewed:**
- Chapter 1: Introduction
- Section 2.1: Literature Review
- Section 2.2: Methodology
- Section 2.3: Analysis & Results
- Section 2.4: Discussion
- Chapter 3: Conclusion
- Chapter 4: Appendices

**Overall Coherence:** ⭐⭐⭐⭐☆ (4.5/5)

---

## Summary

**Strengths:**
- **Strong Logical Arc:** The progression from identifying the "gap" (disconnect between individual grit and organizational policy) to the solution (a Design Science artifact) is excellent.
- **Expectation Management:** The Methodology and Results sections clearly state this is a *theoretical construction* (DSR), not an empirical field test, preventing reader disappointment.
- **Thematic Threading:** The biological metaphors (citrus plants, social insects) are successfully woven from Literature Review through Discussion and Appendices.

**Issues Found:** 1 Critical, 1 Moderate, 2 Minor

---

## Issues Identified

### CRITICAL (Must Fix)

**Issue 1: Inconsistent Framework Terminology (Acronym Mismatch)**
- **Location:** Section 2.3/2.4 vs. Appendix 4.1
- **Problem:**
    - In **Section 2.3 & 2.4**, the framework is named **"Integrated Professional Resilience Framework (IPRF)."**
    - In **Appendix 4.1**, the *same* framework is titled **"Integrated Bio-Psychosocial Resilience Framework (IBSRF)."**
- **Fix:** Select **one** name and acronym (likely IPRF for brevity, or IBSRF for descriptive accuracy) and use it exclusively in all sections.

### MODERATE (Should Fix)

**Issue 2: "Total Worker Health" Promise**
- **Location:** Section 2.1 (Lit Review) vs. Section 2.3 (Results)
- **Problem:** The Literature Review explicitly promises to synthesize "structural insights of Total Worker Health (TWH)." However, the Results snippet focuses heavily on "HRM practices" and general "organizational structures" without explicitly tying them back to the specific TWH framework.
- **Fix:** Ensure Section 2.3 explicitly mentions how Total Worker Health principles were integrated into the framework's organizational dimension, or broaden the Lit Review claim to "occupational health frameworks" generally.

### MINOR (Nice to Fix)

**Issue 3: Sample Size Introduction**
- **Location:** Section 2.3 (Analysis)
- **Problem:** The specific sample size "**(n=16)**" appears for the first time in the Results. While the Methodology mentions a "Narrative Literature Review," it doesn't explicitly state that the *artifact construction* is based on a narrow set of 16 key texts.
- **Fix:** Move the mention of the "16 selected key texts" to Section 2.2 (Methodology) under data collection/selection criteria so the number doesn't surprise the reader in the Results.

**Issue 4: Citation Placeholder Formatting**
- **Location:** Throughout
- **Problem:** The text uses `{cite_007}` format.
- **Fix:** Ensure these are converted to standard (Author, Year) or numeric [7] format before final publication.

---

## Transition Quality

### Introduction → Literature Review
**Quality:** ✅ Smooth
**Note:** Transition from the "VUCA" environment to the need for "robust resilience frameworks" is logical.

### Literature Review → Methodology
**Quality:** ✅ Excellent
**Note:** The shift from the "gap" in literature to the "Pragmatic Design Science Research" approach to *fill* that gap is very strong.

### Methodology → Results
**Quality:** ✅ Smooth
**Note:** Explicitly reminding the reader that "results = the framework" bridges these sections well.

### Results → Discussion
**Quality:** ✅ Excellent
**Note:** Discussion immediately picks up the "bifurcation" mentioned earlier and explains how the Results (IPRF) solve it.

---

## Narrative Arc Check

**Act 1 (Introduction):** Young professionals face unique VUCA stressors; current HR contracts are broken. ✓
**Act 2 (Literature):** Resilience is studied in silos (bio vs. psych vs. org). We need a unified model. ✓
**Act 3 (Methods):** We use Design Science to build that model (not test it). ✓
**Act 4 (Results):** Here is the Framework (IPRF/IBSRF) based on 16 key texts. ✓
**Act 5 (Discussion):** This framework works because it treats the professional as a node in a network (Interactionist). ✓
**Conclusion:** Recap: Resilience is dynamic, not static. ✓

**Overall:** Coherent story ✅

---

## Recommended Fixes (Priority Order)

1.  **[CRITICAL]** Standardize the Framework Name. Decide between **IPRF** or **IBSRF** and Find/Replace all instances.
2.  **[MODERATE]** In Section 2.2 (Methodology), add a sentence explaining the selection of the **16 key texts** so the "n=16" in Results is grounded.
3.  **[LOW]** Ensure "Total Worker Health" is explicitly referenced in the Results or Discussion to close the loop opened in the Lit Review.

---

## Before/After Examples

**Issue 1 Fix (Terminology):**

❌ **Before (Appendix 4.1):**
"4.1 Appendix A: The **Integrated Bio-Psychosocial Resilience Framework (IBSRF)**..."

✅ **After (Assuming "IPRF" is the chosen term):**
"4.1 Appendix A: The **Integrated Professional Resilience Framework (IPRF)**..."

**Issue 3 Fix (Methodology/Results Link):**

❌ **Before (Methodology 2.2):**
"...supported by a Narrative Literature Review. It moves beyond the descriptive limitations..."

✅ **After (Methodology 2.2):**
"...supported by a Narrative Literature Review. **From a broader corpus, 16 seminal texts were selected for deep structural analysis to inform the artifact design.** It moves beyond..."