# Advancing Automotive Software Supply Chain Security: A Blockchain-Reproducible Build Approach

**Authors:** Aideyan, Pesé, Brooks
**Year:** 2025
**DOI:** 10.4271/2025-01-0456
**URL:** https://doi.org/10.4271/2025-01-0456

## Abstract

The automotive industry’s systems and over-the-air (OTA) updates have vulnerabilities in its software supply chain (SSC). Although frameworks like Uptane have improved OTA security, gaps remain in ensuring software integrity and provenance. In this paper, we examine challenges securing the automotive SSC and introduce a framework, GUIXCHAIN, that integrates version control, reproducible builds, blockchain technology, and software bills of materials (SBoMs) for transparency, auditability, and resilience. Reproducible builds guarantee identical resulting binaries when compiling the same source code in different environments, as any deviation in the final output indicates a potential compromise in the build process, such as malware injection. Our preliminary study shows Guixchain’s use of reproducible builds ensures consistent and integrity-secured software across various build environments. The blockchain provides forensic capabilities, offering a history of the what, who and where of discrepancies within the SSC process. SBoMs provide an inventory of the software components used. Our preliminary study demonstrates that Guixchain effectively mitigates risks such as ransomware, unauthorized modifications, and build server compromises, reinforcing the system’s integrity and resilience throughout the software life cycle. Future work will focus on the full implementation of Guixchain and a comprehensive evaluation of its performance in real-world automotive software supply chain scenarios.

## Citation Details

Advancing Automotive Software Supply Chain Security: A Blockchain-Reproducible Build Approach
**Authors**: Aideyan, Pesé, Brooks
**Year**: 2025
**DOI**: 10.4271/2025-01-0456
**URL**: https://doi.org/10.4271/2025-01-0456

**Abstract**: The automotive industry’s systems and over-the-air (OTA) updates have vulnerabilities in its software supply chain (SSC). Although frameworks like Uptane have improved OTA security, gaps remain in ensuring software integrity and provenance. In this paper, we examine challenges securing the automotive SSC and introduce a framework, GUIXCHAIN, that integrates version control, reproducible builds, blockchain technology, and software bills of materials (SBoMs) for transparency, auditability, and resilience. Reproducible builds guarantee identical resulting binaries when compiling the same source code in different environments, as any deviation in the final output indicates a potential compromise in the build process, such as malware injection. Our preliminary study shows Guixchain’s use of reproducible builds ensures consistent and integrity-secured software across various build environments. The blockchain provides forensic capabilities, offering a history of the what, who and where of discrepancies within the SSC process. SBoMs provide an inventory of the software components used. Our preliminary study demonstrates that Guixchain effectively mitigates risks such as ransomware, unauthorized modifications, and build server compromises, reinforcing the system’s integrity and resilience throughout the software life cycle. Future work will focus on the full implementation of Guixchain and a comprehensive evaluation of its performance in real-world automotive software supply chain scenarios.  # Truncate if very long

---
*Extracted from citation research database - all 45 citations available*
