# AI-Driven SBOM: Automated Software Bill of Materials Generation and Management

**Authors:** Shukla
**Year:** 2025
**DOI:** 10.64917/feaiml/volume02issue12-08
**URL:** https://doi.org/10.64917/feaiml/volume02issue12-08

## Abstract

The openness of modern software development has increased the urgent demand and necessity to manage Software Bill of Materials (SBOM) comprehensively due to the increasing number of open-source elements and third-party dependencies. Manual methods of SBOM generation and maintenance are tedious, prone to error, and are unable to keep up with short development cycles. In this paper, a framework based on AI to generate SBOM, analyze it, and assess the vulnerability is introduced. By using machine learning algorithms such as natural language processing, graph neural networks, and deep learning models, we can automatically identify, classify, and trace components in a complex chain of dependencies of software [1][2]. Our multi-model system of architectural design that employs the methods of the static analysis and the AI-based pattern recognition allows us to reach the results of 94.7 percent component detection and 91.3 percent accuracy in vulnerability mapping. It uses automated package manager parsing, binary analysis and license compliance verification as methodology. The experimental findings prove to be markedly better than the traditional tools that minimize the time of SBOM generation by 78% and maximize completeness by 34%. The system has managed to point out 2,847 untested faiths in enterprise codebases and has accordingly classified 96.2 percent of software licenses. We find the results that AI-powered SBOM systems do not just improve the security posture but also facilitate compliance processes, so they must be part of present-day DevSecOps. This study is relevant to the developing body of AI-enhanced software supply chain security.

## Citation Details

AI-Driven SBOM: Automated Software Bill of Materials Generation and Management
**Authors**: Shukla
**Year**: 2025
**DOI**: 10.64917/feaiml/volume02issue12-08
**URL**: https://doi.org/10.64917/feaiml/volume02issue12-08

**Abstract**: The openness of modern software development has increased the urgent demand and necessity to manage Software Bill of Materials (SBOM) comprehensively due to the increasing number of open-source elements and third-party dependencies. Manual methods of SBOM generation and maintenance are tedious, prone to error, and are unable to keep up with short development cycles. In this paper, a framework based on AI to generate SBOM, analyze it, and assess the vulnerability is introduced. By using machine learning algorithms such as natural language processing, graph neural networks, and deep learning models, we can automatically identify, classify, and trace components in a complex chain of dependencies of software [1][2]. Our multi-model system of architectural design that employs the methods of the static analysis and the AI-based pattern recognition allows us to reach the results of 94.7 percent component detection and 91.3 percent accuracy in vulnerability mapping. It uses automated package manager parsing, binary analysis and license compliance verification as methodology. The experimental findings prove to be markedly better than the traditional tools that minimize the time of SBOM generation by 78% and maximize completeness by 34%. The system has managed to point out 2,847 untested faiths in enterprise codebases and has accordingly classified 96.2 percent of software licenses. We find the results that AI-powered SBOM systems do not just improve the security posture but also facilitate compliance processes, so they must be part of present-day DevSecOps. This study is relevant to the developing body of AI-enhanced software supply chain security.  # Truncate if very long

---
*Extracted from citation research database - all 45 citations available*
