# An Exploration of How Generative AI Affects Workflow and Collaboration in a Software Engineering Course

**Authors:** Salomon, Chin, Holmes, Fritz, Murphy
**Year:** 2025
**DOI:** 10.1145/3758317.3759680
**URL:** https://doi.org/10.1145/3758317.3759680

## Abstract

How does Generative AI (GenAI) impact how students work and collaborate in a software engineering course? To explore this question, we conducted an exploratory study in a project-based course where students developed three versions of a system across agile sprints, with unrestricted access to GenAI tools. From survey responses of 349 students, we found that the technology was used extensively with 84% of students reporting use and 90% of them finding the technology useful. Through semi-structured interviews with 24 of the students, we delved deeper, learning that students used GenAI pervasively, not only to generate code but also to validate work retrospectively, such as checking alignment with requirements and design after implementation had begun. Students often turned to GenAI as their first point of contact, even before consulting teammates, which reduced direct interpersonal collaboration. These results suggest the need for new pedagogical strategies that address not just individual tool use, but also design reasoning and collaborative practices in GenAI-augmented teams.

## Citation Details

An Exploration of How Generative AI Affects Workflow and Collaboration in a Software Engineering Course
**Authors**: Salomon, Chin, Holmes, Fritz, Murphy
**Year**: 2025
**DOI**: 10.1145/3758317.3759680
**URL**: https://doi.org/10.1145/3758317.3759680

**Abstract**: How does Generative AI (GenAI) impact how students work and collaborate in a software engineering course? To explore this question, we conducted an exploratory study in a project-based course where students developed three versions of a system across agile sprints, with unrestricted access to GenAI tools. From survey responses of 349 students, we found that the technology was used extensively with 84% of students reporting use and 90% of them finding the technology useful. Through semi-structured interviews with 24 of the students, we delved deeper, learning that students used GenAI pervasively, not only to generate code but also to validate work retrospectively, such as checking alignment with requirements and design after implementation had begun. Students often turned to GenAI as their first point of contact, even before consulting teammates, which reduced direct interpersonal collaboration. These results suggest the need for new pedagogical strategies that address not just individual tool use, but also design reasoning and collaborative practices in GenAI-augmented teams.  # Truncate if very long

---
*Extracted from citation research database - all 45 citations available*
