## Paper 18: AI-Driven SBOM: Automated Software Bill of Materials Generation and Management
**Authors:** Shukla
**Year:** 2025
**Venue:** FEAIML
**DOI:** [10.64917/feaiml/volume02issue12-08](https://doi.org/10.64917/feaiml/volume02issue12-08)

### Research Question
How can AI automate the generation and vulnerability analysis of Software Bill of Materials (SBOM) to secure the software supply chain?

### Methodology
- **Design:** System Proposal & Evaluation.
- **Approach:** Framework using NLP, Graph Neural Networks (GNN), and Deep Learning.
- **Data:** Enterprise codebases.

### Key Findings
1. **Accuracy:** Achieved **94.7%** component detection and **91.3%** accuracy in vulnerability mapping.
2. **Efficiency:** Reduced SBOM generation time by **78%** compared to traditional tools.
3. **Completeness:** Improved completeness by **34%**.
4. **Discovery:** Identified 2,847 untested paths/dependencies.

### Implications
AI is critical for *DevSecOps*. Manual SBOM management is impossible with modern dependency trees. AI provides the speed and depth required for compliance.

### Limitations
- **Venue:** Published in a lesser-known venue (FEAIML); rigorous peer review should be verified.
- **False Positives:** AI vulnerability scanning often suffers from high false-positive rates (not explicitly discussed in abstract).

### Relevance to Your Research
**Score:** ⭐⭐⭐⭐ (4/5)
**Why:** High relevance to "Security" and "Supply Chain" themes.

---

## Paper 16 & 17: Standards and Law (ISO 29119 & ISO 42001)
**Authors:** Ali & Yue (2015); Seet (2025)

### Summary
These papers represent the **Governance Layer**.
- **Paper 16** (2015) establishes the baseline for software testing standards (ISO 29119).
- **Paper 17** (2025) introduces **ISO 42001**, the new management system standard for AI.

### Relevance
Crucial for arguing that AI in SE is moving from "Wild West" experimentation to "Standardized" industrial application.

---

## Cross-Paper Analysis

### Common Themes

1.  **From "Writing" to "Reviewing" & "Managing":**
    Papers 1 (PR Titles), 2 (Workflow), and 18 (SBOM) all suggest that AI is taking over the *generation* and *administrative* tasks, pushing humans into high-level review and orchestration roles. The "Coder" is becoming the "Architect."

2.  **The Rise of Objective Measurement:**
    We see a shift from subjective surveys (Paper 4) to rigorous benchmarking (Paper 14 - HumanEval, Paper 10 - SWE-Bench) and even physiological measurement (Paper 8 - Wearables). The field is demanding hard data on productivity claims.

3.  **Trust, Safety, and Governance:**
    As capabilities increase, so does the focus on control. Paper 7 (Trust Framework), Paper 17 (ISO 42001), and Paper 18 (SBOM/Security) highlight that *generating* code is easy, but *trusting* it is the new bottleneck.

### Methodological Trends
- **Benchmarks:** SWE-Bench (Paper 10) and HumanEval (Paper 14) are the standard rulers for measuring progress.
- **Mixed Methods:** Combining quantitative metrics (speed/accuracy) with qualitative insights (trust/workflow) is becoming common (Paper 2).
- **Novel Metrics:** Paper 8 introduces "Biometric Developer Experience" – a radical departure from traditional SE metrics.

### Contradictions or Debates
- **Model Supremacy:** Paper 14 claims a massive (>20%) lead for Anthropic's Claude over OpenAI's GPT models in Python generation. This challenges the common industry default to GPT-4.
- **Productivity vs. Sustainability:** Paper 13 and 15 suggest that the pursuit of AI productivity comes with a hidden carbon cost, creating a tension between "faster development" and "green computing."

### Citation Network & Trajectory
- **Foundational:** Paper 9 (Seffah, 2009) and Paper 11 (Lill, 2014) provide the historic HCI and Agent testing foundations.
- **Current Hub:** Paper 10 (SWE-Bench) is likely a hub for modern agentic papers.
- **Emerging:** Paper 8 (Wearables) represents a new, experimental edge.

---

## Research Trajectory

**Historical progression:**
- **2009-2015:** Foundations of Human-Centered SE and Testing Standards (Papers 9, 11, 16).
- **2024:** Explosion of empirical studies on *adoption* and *workflow* integration (Papers 1, 2).
- **2025:** Shift toward *governance* (ISO 42001), *rigorous benchmarking* (SWE-Bench, HumanEval), and *sustainability* (Papers 13, 14, 15, 17).

**Future directions suggested:**
1.  **Autonomous Agents:** Moving beyond "Copilots" to "Agents" that can fix bugs and run tests autonomously (Paper 10).
2.  **Green SE:** Optimizing the energy efficiency of the AI models used in development (Paper 15).
3.  **Biometric Feedback:** Using physiological data to tune AI interactions in real-time (Paper 8).

---

## Must-Read Papers (Top 5)

1.  **Paper 14 (Bayram et al., 2025):** *Comparative Analysis of AI Models for Python Code Generation.* Essential for understanding the current performance landscape of LLMs (Claude vs. GPT).
2.  **Paper 10 (Zhu & Kang, 2025):** *UTBoost: Rigorous Evaluation...* Critical for the shift towards Agentic Software Engineering.
3.  **Paper 8 (Brandebusemeyer, 2025):** *Interactions with Generative AI: Wearables...* The most innovative methodology in the set.
4.  **Paper 7 (Barón, 2025):** *Towards an Adoption Framework...* Essential for the management/strategy perspective.
5.  **Paper 18 (Shukla, 2025):** *AI-Driven SBOM...* Represents the high-impact application of AI in security and compliance.

---

## Gaps for Further Investigation

1.  **Long-term Maintenance:** While Paper 14 discusses "maintainability index," there are no longitudinal studies (e.g., over 6-12 months) tracking the technical debt of AI-heavy codebases.
2.  **Standardization of Agentic Interfaces:** Paper 3 discusses Chat, but standards for *agentic* permissions (what an agent is allowed to touch/delete) are missing.
3.  **Verification of "Future" Models:** The mention of "Claude Sonnet 4" in Paper 14 requires immediate verification. Does this model exist, or is the literature moving faster than public releases?
4.  **Legal Liability:** Paper 5 touches on legal issues (Medicaid), but specific legal frameworks for *liability in AI-generated security vulnerabilities* (related to Paper 18) are under-explored.