**Research Problem and Approach:** The discipline of software engineering is currently experiencing a seismic paradigm shift driven by the rapid integration of Generative AI and Large Language Models (LLMs). This transition from deterministic, rule-based tooling to probabilistic, agentic workflows fundamentally alters the nature of code production, maintenance, and quality assurance. This thesis investigates the complex socio-technical impact of these technologies, addressing the critical "trust paradox" where an over-reliance on automated agents threatens to compromise security integrity and erode human expertise despite promising significant productivity gains.

**Methodology and Findings:** Employing a comprehensive analysis of professional workflow patterns and emerging regulatory frameworks, this study evaluates the friction between rapid AI adoption and necessary governance structures. The research identifies a dangerous gap between technical capability and risk management, finding that current "human-on-the-loop" configurations often fail to account for adversarial code risks and supply chain vulnerabilities. The analysis demonstrates that as tools evolve from passive assistants to autonomous agents, traditional quality assurance models must be reconstructed to handle the non-deterministic nature of LLM outputs.

**Key Contributions:** This research makes three primary contributions: (1) An empirical characterization of the shifting developer persona from code author to reviewer, delineating changes in cognitive load and problem decomposition; (2) A critical assessment of the security implications of AI-generated code, specifically regarding adversarial prompting and dependency confusion attacks; and (3) A robust governance framework for secure AI adoption that integrates ISO/IEC 42001 standards with practical mechanisms like mandatory Software Bill of Materials (SBOM) and blockchain-verified builds.

**Implications:** These findings have profound implications for the future of software development, suggesting that sustainable innovation requires a rigorous balance between automation and human oversight. The proposed framework offers a strategic roadmap for organizations transitioning toward intelligent cloud systems, emphasizing that the reliability of future software ecosystems depends on implementing context-aware security protocols and maintaining strict "human-in-the-loop" verification processes.

**Keywords:** Generative AI, Software Engineering, Large Language Models, Developer Workflow, Socio-Technical Systems, AI Governance, Software Supply Chain Security, Human-in-the-Loop, ISO/IEC 42001, Quality Assurance, Adversarial Code, SBOM, Intelligent Cloud Systems, GitHub Copilot, Automated Code Generation