# 1. Introduction

The discipline of software engineering is currently undergoing a paradigm shift of a magnitude not seen since the transition from assembly language to high-level programming languages. The rapid emergence and integration of Generative Artificial Intelligence (GenAI), specifically Large Language Models (LLMs), into the professional software development lifecycle has fundamentally altered the nature of code production, maintenance, and quality assurance. This thesis investigates the socio-technical impact of these technologies on professional workflows, moving beyond simple productivity metrics to understand the complex interplay between human cognition, automated agents, and institutional governance.

## 1.1 Background and Context

Software engineering has historically been defined by a continuous pursuit of abstraction and automation. From the introduction of compilers to the advent of Integrated Development Environments (IDEs) and Continuous Integration/Continuous Deployment (CI/CD) pipelines, the goal has consistently been to reduce the cognitive load on developers and minimize manual error. However, the introduction of GenAI represents a qualitative difference in this evolution. Unlike deterministic tools that execute explicit commands, GenAI tools—such as GitHub Copilot and various LLM-based agents—possess the capability to generate novel content, infer intent, and navigate complex semantic contexts {cite_004}{cite_013}.

The adoption of these tools has been precipitous. Industry reports and academic studies alike suggest that GenAI is redefining the very concept of software development, shifting the developer's role from a primary author of code to a reviewer and orchestrator of AI-generated artifacts {cite_008}{cite_013}. This shift is not merely operational but touches upon the core tenets of Human-Computer Interaction (HCI) within technical domains. As noted in foundational literature on human-centered software engineering, the architecture of tools dictates the patterns of interaction; thus, as the tools become more agentic, the architectural models for human interaction must evolve accordingly {cite_019}.

### 1.1.1 The Rise of AI-Augmented Workflows

The contemporary developer workflow is increasingly characterized by a "human-in-the-loop" or "human-on-the-loop" configuration. In this model, AI assistants are integrated directly into the IDE, providing real-time suggestions, refactoring capabilities, and even autonomous problem-solving. Recent empirical insights indicate that tools like GitHub Copilot are not just used for code completion but are becoming integral to the entire cognitive process of programming, influencing how developers approach problem decomposition and solution design {cite_006}.

Furthermore, the scope of AI intervention has expanded beyond mere code synthesis. It now encompasses critical peripheral activities such as the generation of pull request (PR) titles and descriptions, which are essential for maintaining project history and facilitating collaboration {cite_001}. The automation of these communication tasks suggests a future where the "social" aspects of coding—communicating intent to other humans—are mediated or even generated by artificial agents.

### 1.1.2 The Move Toward Agentic Architectures

While initial applications of GenAI focused on "copilots" that require active human prompting, the field is rapidly moving toward autonomous agents. Research into "Agentless" frameworks and rigorous evaluations on benchmarks like SWE-Bench demonstrate the potential for LLMs to handle complex software engineering tasks with minimal human intervention {cite_020}{cite_022}. These developments promise to further abstract the development process, potentially allowing systems to self-diagnose and self-repair. However, this transition raises profound questions regarding reliability, accountability, and the potential erosion of human expertise.

## 1.2 Problem Statement

Despite the enthusiastic adoption of GenAI in the software industry, there remains a significant gap in our understanding of the holistic implications of this technology. Much of the current discourse is dominated by vendor-driven narratives of productivity gains or purely technical evaluations of model accuracy. However, the integration of probabilistic models into deterministic software engineering processes introduces new vectors of risk and complexity that are not yet fully understood or managed.

### 1.2.1 The Trust and Quality Paradox

A critical problem facing the industry is the "trust paradox." As AI models become more capable, developers may become over-reliant on them, leading to a degradation in critical review practices. This is particularly concerning given the documented rise of adversarial prompted code. Benchmarks and datasets derived from platforms like Stack Overflow indicate that AI-generated code can contain subtle vulnerabilities or be manipulated by adversarial prompts, posing severe security risks if integrated without rigorous verification {cite_009}.

Furthermore, the definition of "quality" in an AI-augmented context is fluid. While GenAI can generate syntactically correct code at speed, its impact on long-term maintainability, architectural integrity, and system security is ambiguous. Reports from major consultancy firms highlight that while AI can enhance software development quality, it necessitates a reimagining of quality assurance (QA) frameworks to account for the non-deterministic nature of LLM outputs {cite_012}.

### 1.2.2 The Governance and Compliance Gap

The rapid deployment of these tools has outpaced the development of governance structures. Organizations are struggling to align AI adoption with legal frameworks and emerging international standards. The introduction of standards such as ISO/IEC 42001:2023 attempts to provide a management system for AI, but the practical translation of these high-level standards into daily software engineering practices remains a significant challenge {cite_032}{cite_033}. Failures in this domain can have catastrophic real-world consequences, as evidenced by system failures in public sector applications where AI or automated decision-making systems interact with critical social infrastructure {cite_010}.

## 1.3 Research Objectives

This thesis aims to empirically investigate the transformation of the professional software engineering workflow driven by GenAI. It seeks to bridge the gap between technical capability and socio-technical implementation.

The specific objectives of this research are:

1.  To characterize the evolving **workflow patterns** of professional software engineers using GenAI tools, specifically distinguishing between code generation, testing, and collaborative tasks.
2.  To analyze the **impact on software quality and security**, focusing on the detection of adversarial code and the integrity of the software supply chain.
3.  To evaluate the **governance mechanisms** currently employed or required to manage AI risks, including the application of ISO standards and Software Bill of Materials (SBOM) management.
4.  To propose a **framework for sustainable and secure AI adoption** that balances productivity gains with human-centric design and rigorous compliance.

## 1.4 Research Questions

To achieve the stated objectives, this study addresses the following primary research question:

*   **RQ1:** How does the integration of Generative AI into professional software development environments alter the socio-technical dynamics of the engineering workflow?

This is further decomposed into three sub-questions:

*   **RQ1.1 (Workflow & Productivity):** How do developers perceive and utilize GenAI for collaborative and non-coding tasks, such as pull request generation and code review?
*   **RQ1.2 (Security & Quality):** What are the emerging security risks associated with AI-generated code, particularly regarding supply chain vulnerabilities and adversarial inputs?
*   **RQ1.3 (Governance):** To what extent are current industry standards (e.g., ISO 42001) and governance tools (e.g., SBOMs) adequate for managing the risks of AI-assisted development?

## 1.5 Significance of the Study

This research holds significant value for multiple stakeholders, including software practitioners, engineering managers, policymakers, and the academic community. By providing a comprehensive analysis of the GenAI-augmented workflow, this thesis contributes to the formalization of "AI Engineering" as a distinct discipline.

### 1.5.1 Theoretical Significance

From a theoretical perspective, this work extends the body of knowledge in Human-Centered Software Engineering (HCSE). By analyzing developer interactions with AI agents through the lens of established HCSE models {cite_019}, this study contributes to our understanding of human-AI collaboration in complex cognitive tasks. It challenges existing productivity models by introducing variables related to "developer experience" (DX) and trust, suggesting that objective measures like wearables and biometric data may be necessary to fully capture the cognitive impact of AI interactions {cite_017}.

Furthermore, this thesis contributes to the discourse on "Evidence-Based Software Engineering" by examining how GenAI can be utilized to synthesize and retrieve engineering knowledge, potentially accelerating the dissemination of best practices {cite_014}.

### 1.5.2 Practical Implications

For practitioners and industry leaders, this study offers actionable insights into the operationalization of AI tools. The findings regarding automated code review {cite_040}{cite_041} and automatic pull request generation {cite_001} provide a roadmap for optimizing development pipelines.

Crucially, the research addresses the urgent need for security and compliance frameworks. With the increasing complexity of the software supply chain, understanding how to generate and manage AI-driven Software Bill of Materials (SBOMs) is essential for maintaining transparency and security {cite_034}{cite_036}. The discussion on ISO 42001 and legal compliance provides organizations with a benchmark for assessing their AI maturity and risk exposure {cite_032}.

Table 1 summarizes the shift in key software engineering activities, highlighting the transition from traditional methods to AI-augmented approaches as identified in the preliminary literature review.

| Activity Phase | Traditional Approach | AI-Augmented Approach | Key Implications |
| :--- | :--- | :--- | :--- |
| **Coding** | Manual syntax entry; reference to docs | Intent-based generation; context-aware completion | Shift from syntax to semantics; focus on verification {cite_006} |
| **Review** | Manual line-by-line inspection | Automated context-aware analysis; summary generation | Reduced cognitive load; risk of complacency {cite_040}{cite_041} |
| **Collaboration** | Manual drafting of PR descriptions | Auto-generated titles and summaries | Standardization of communication; potential loss of nuance {cite_001} |
| **Security** | Static analysis; manual audit | Automated adversarial detection; SBOM generation | New vectors (adversarial prompts); automated compliance {cite_009}{cite_034} |
| **Testing** | Manual test case writing | Automated test generation; self-healing tests | Increased coverage; challenge of oracle problem {cite_031} |

*Table 1: Comparison of Traditional versus AI-Augmented Software Engineering Activities.*

As illustrated in Table 1, the introduction of AI does not merely accelerate existing tasks but fundamentally transforms the nature of the activity. For instance, in the coding phase, the developer's cognitive effort shifts from recalling syntax to verifying the semantic correctness of AI-generated blocks. Similarly, in the security domain, the focus expands from checking for known vulnerabilities to detecting subtle adversarial patterns that may have been hallucinated or injected by the model {cite_009}.

## 1.6 Theoretical Framework and Scope

This thesis operates at the intersection of Software Engineering, Artificial Intelligence, and Human-Computer Interaction. The analysis is grounded in the concept of the "Socio-Technical System," which posits that technical optimization cannot be separated from the social and organizational context in which it occurs.

### 1.6.1 Adoption Frameworks and Trust

A central theoretical component of this research is the framework for AI adoption and trust. Trust in automation is a critical determinant of successful integration. If developers do not trust the tool, they will bypass it; if they trust it too much, they may fail to catch errors. Barón (2025) proposes an adoption framework specifically designed to foster trust in AI-assisted software engineering, emphasizing the need for transparency and explainability {cite_015}. This thesis utilizes such frameworks to analyze developer sentiment and behavior.

### 1.6.2 Governance and Standardization

The scope of this research also encompasses the regulatory environment. The recent publication of ISO/IEC 42001:2023 represents a milestone in AI governance. This standard provides a framework for establishing, implementing, maintaining, and continually improving an Artificial Intelligence Management System (AIMS) {cite_033}. This thesis examines how these high-level standards interact with specific engineering practices, such as the formalization of software testing standards (ISO/IEC/IEEE 29119) in the era of AI {cite_031}.

Table 2 outlines the governance dimensions considered in this study, linking specific risks to the relevant regulatory or theoretical frameworks.

| Governance Dimension | Specific Risk / Challenge | Relevant Standard / Framework | Citation |
| :--- | :--- | :--- | :--- |
| **Management System** | Lack of organizational oversight; shadow AI | ISO/IEC 42001:2023 | {cite_033} |
| **Legal & Liability** | Copyright infringement; liability for AI errors | Intersection of ISO 42001 & Law | {cite_032} |
| **Supply Chain** | Opaque dependencies; component vulnerabilities | AI-Driven SBOM Management | {cite_034}{cite_036} |
| **Testing & QA** | Non-deterministic outputs; verification difficulty | ISO/IEC/IEEE 29119 Formalization | {cite_031} |
| **Automotive/Safety** | Safety-critical failures; update integrity | Blockchain-Reproducible Build | {cite_037} |

*Table 2: Governance Dimensions and Regulatory Frameworks in AI Engineering.*

The integration of these governance dimensions is crucial. As noted in Table 2, the challenge of "Shadow AI"—where tools are used without organizational oversight—requires a robust management system compliant with ISO 42001. Furthermore, in safety-critical sectors like automotive software, the supply chain security becomes paramount. Emerging approaches, such as blockchain-reproducible builds, are being explored to ensure the integrity of software updates in an era where code might be generated by non-human agents {cite_037}.

## 1.7 Operational Definitions

To ensure clarity throughout this thesis, the following operational definitions are established based on the cited literature:

*   **Generative AI (GenAI):** A class of artificial intelligence systems capable of generating new content, including text and computer code, in response to prompts. In this thesis, this primarily refers to Large Language Models (LLMs) applied to software engineering tasks {cite_013}.
*   **AI-Assisted Software Engineering:** The practice of using AI tools to support specific tasks within the development lifecycle, such as code completion (e.g., GitHub Copilot) or automated code review {cite_015}.
*   **Adversarial Prompting:** The act of crafting inputs designed to cause an AI model to produce incorrect, biased, or malicious outputs. In the context of SE, this refers to generating code that introduces vulnerabilities {cite_009}.
*   **Software Bill of Materials (SBOM):** A formal record containing the details and supply chain relationships of various components used in building software. AI-driven SBOMs automate the generation and management of these records to handle the complexity of modern dependencies {cite_034}.
*   **Agentic/Agentless Workflow:** "Agentic" refers to autonomous AI systems performing multi-step tasks. "Agentless" refers to approaches that utilize LLMs for specific steps without a continuous autonomous agent loop, often used to demystify the complexity of full agents {cite_022}.

## 1.8 Thesis Outline

The remainder of this thesis is organized as follows:

**Chapter 2: Literature Review** analyzes the current state of academic and industry research regarding GenAI in software engineering. It covers three main pillars: the productivity and workflow impacts {cite_007}{cite_017}, the security and quality implications {cite_009}{cite_036}, and the evolving governance landscape {cite_032}{cite_033}. The review identifies specific gaps in the socio-technical understanding of these tools.

**Chapter 3: Methodology** details the mixed-methods approach employed in this study. It describes the data collection strategies, which include surveys of professional developers and analysis of software repository data. The methodology is designed to capture both the subjective experience of developers (using frameworks from {cite_015}) and objective artifacts of AI usage (e.g., PR analysis as discussed in {cite_001}).

**Chapter 4: Analysis and Results** presents the empirical findings. This chapter creates a taxonomy of AI usage patterns and quantifies the prevalence of security-aware practices. It includes a detailed analysis of how developers are adapting their code review processes in response to AI-generated code {cite_040}.

**Chapter 5: Discussion** interprets the findings in the context of the theoretical framework. It discusses the tension between the speed of AI adoption and the necessity for "intelligent cloud systems" that are secure and policy-driven {cite_025}. The discussion also addresses the "Agentless" paradigm {cite_022} and whether current trends favor fully autonomous agents or human-augmented workflows.

**Chapter 6: Conclusion** summarizes the key contributions, outlines the limitations of the study, and proposes directions for future research. It emphasizes the need for a balanced approach that leverages the transformative potential of GenAI {cite_004} while rigorously managing the associated risks through standards like ISO 42001 {cite_033}.

## 1.9 Delimitations

While Generative AI has applications across the entire spectrum of digital creation, this thesis is specifically delimited to **professional software engineering workflows**. It excludes:
*   Non-professional or hobbyist coding, as the workflow dynamics and governance requirements differ significantly.
*   Generative AI for non-technical creative assets (e.g., image generation for UI), unless directly integrated into the code generation pipeline (e.g., sensory experience-driven design in smart cabins {cite_028}).
*   The underlying mathematical development of Large Language Models. The focus is on the *application* and *implication* of these models, not their architectural design.

By focusing strictly on the professional engineering context, this study aims to provide high-fidelity insights that are directly applicable to industry leaders and engineering management professionals.

## 1.10 The Imperative for Research

The urgency of this research is underscored by the speed of technological diffusion. We are currently in a transition period where practices are being established ad-hoc. Without empirical guidance, the industry risks codifying inefficient or dangerous patterns of human-AI interaction.

For instance, the phenomenon of "context-aware" code review highlights the complexity of the current environment. Traditional manual reviews are becoming bottlenecks due to the volume of code AI can produce. Balachandran and Fawzer (2025) propose integrating GenAI into the review process itself to analyze pull requests {cite_040}. However, Cihan et al. (2025) note that while these tools are widespread, they are often perceived as time-consuming if not perfectly integrated {cite_041}. This contradiction—tools meant to save time being perceived as time-consuming—exemplifies the socio-technical friction this thesis aims to explore.

Moreover, the security landscape is shifting beneath our feet. The automotive industry's struggle with software supply chain security {cite_037} serves as a microcosm for the broader software ecosystem. As vehicles—and indeed all modern infrastructure—become "software-defined," the integrity of that software becomes a matter of public safety. If that software is written by AI, verified by AI, and managed by AI-driven SBOMs {cite_034}, the chain of custody and accountability must be mathematically and procedurally rigorous.

Finally, the sustainability of these systems cannot be ignored. Jamili et al. (2025) argue for a framework for intelligent cloud systems that enables not just secure and policy-driven AI, but *sustainable* AI at scale {cite_025}. As the computational cost of GenAI in development workflows increases, the environmental impact becomes a non-trivial factor in the engineering decision matrix.

In summary, this thesis posits that the successful integration of Generative AI into software engineering requires a holistic "systems thinking" approach. It is not enough to simply install a plugin like GitHub Copilot; organizations must re-architect their workflows, redefine their quality standards, and re-educate their workforce to operate effectively in a hybrid human-AI environment. Through rigorous empirical investigation, this work aims to provide the evidence base necessary to navigate this transformation safely and effectively.