# Placental growth factor for the prognosis of women with preeclampsia (fullPIERS model extension): context matters

**Authors:** Ukah, Payne, Hutcheon, Chappell, Seed, Conti-Ramsden, Ansermino, Magee, Dadelszen, Group
**Year:** 2020
**DOI:** 10.1186/s12884-020-03332-w
**URL:** https://doi.org/10.1186/s12884-020-03332-w

## Abstract

Background The fullPIERS risk prediction model was developed to identify which women admitted with confirmed diagnosis of preeclampsia are at highest risk of developing serious maternal complications. The model discriminates well between women who develop (vs. those who do not) adverse maternal outcomes. It has been externally validated in several populations. We assessed whether placental growth factor (PlGF), a biomarker associated with preeclampsia risk, adds incremental value to the fullPIERS model. Methods Using a cohort of women admitted into tertiary hospitals in well-resourced settings (the USA and Canada), between May 2010 to February 2012, we evaluated the incremental value of PlGF added to fullPIERS for prediction of adverse maternal outcomes within 48 h after admission with confirmed preeclampsia. The discriminatory performance of PlGF and the fullPIERS model were assessed in this cohort using the area under the receiver’s operating characteristic curve (AUROC) while the extended model (fullPIERS +PlGF) was assessed based on net reclassification index (NRI) and integrated discrimination improvement (IDI) performances. Results In a cohort of 541 women delivered shortly (< 1 week) after presentation, 8.1% experienced an adverse maternal outcome within 48 h of admission. Prediction of adverse maternal outcomes was not improved by addition of PlGF to fullPIERS (NRI: -8.7, IDI − 0.06). Discriminatory performance (AUROC) was 0.67 [95%CI: 0.59–0.75] for fullPIERS only and 0.67 [95%CI: 0.58–0.76]) for fullPIERS extended with PlGF, a performance worse than previously documented in fullPIERS external validation studies (AUROC > 0.75). Conclusions While fullPIERS model performance may have been affected by differences in healthcare context between this study cohort and the model development and validation cohorts, future studies are required to confirm whether PlGF adds incremental benefit to the fullPIERS model for prediction of adverse maternal outcomes in preeclampsia in settings where expectant management is practiced.

## Citation Details

Placental growth factor for the prognosis of women with preeclampsia (fullPIERS model extension): context matters
**Authors**: Ukah, Payne, Hutcheon, Chappell, Seed, Conti-Ramsden, Ansermino, Magee, Dadelszen, Group
**Year**: 2020
**DOI**: 10.1186/s12884-020-03332-w
**URL**: https://doi.org/10.1186/s12884-020-03332-w

**Abstract**: Background The fullPIERS risk prediction model was developed to identify which women admitted with confirmed diagnosis of preeclampsia are at highest risk of developing serious maternal complications. The model discriminates well between women who develop (vs. those who do not) adverse maternal outcomes. It has been externally validated in several populations. We assessed whether placental growth factor (PlGF), a biomarker associated with preeclampsia risk, adds incremental value to the fullPIERS model. Methods Using a cohort of women admitted into tertiary hospitals in well-resourced settings (the USA and Canada), between May 2010 to February 2012, we evaluated the incremental value of PlGF added to fullPIERS for prediction of adverse maternal outcomes within 48 h after admission with confirmed preeclampsia. The discriminatory performance of PlGF and the fullPIERS model were assessed in this cohort using the area under the receiver’s operating characteristic curve (AUROC) while the extended model (fullPIERS +PlGF) was assessed based on net reclassification index (NRI) and integrated discrimination improvement (IDI) performances. Results In a cohort of 541 women delivered shortly (< 1 week) after presentation, 8.1% experienced an adverse maternal outcome within 48 h of admission. Prediction of adverse maternal outcomes was not improved by addition of PlGF to fullPIERS (NRI: -8.7, IDI − 0.06). Discriminatory performance (AUROC) was 0.67 [95%CI: 0.59–0.75] for fullPIERS only and 0.67 [95%CI: 0.58–0.76]) for fullPIERS extended with PlGF, a performance worse than previously documented in fullPIERS external validation studies (AUROC > 0.75). C  # Truncate if very long

---
*Extracted from citation research database - all 51 citations available*
