# ESG Information Conflicts in Mutual Funds

**Authors:** Ding, Liu, Wang
**Year:** 2025
**DOI:** 10.1177/21582440251407508
**URL:** https://doi.org/10.1177/21582440251407508

## Abstract

ESG rating divergence (ESGRD) and ESG decoupling represent the primary manifestations of ESG information conflicts. Although ESGRD and ESG decoupling have garnered significant attention, research predominantly focuses on their implications at the corporate level. In contrast, the impact of ESGRD and ESG decoupling at the fund level, as well as their influence on fund manager behavior, remains underexplored. This study investigates the effects of ESGRD and ESG decoupling on fund performance, flow, and risk by using Chinese fund holdings and ESG ratings data. Our findings reveal that funds with higher levels of ESGRD and ESG decoupling exhibit lower returns, larger outflows, and higher risks. Moreover, the relationship between ESGRD/ESG decoupling and fund performance, flow, and risk varies across funds with differing cash asset ratios and portfolio concentrations. Additionally, we confirm that ESGRD and ESG decoupling attenuate the positive impact of a fund’s ESG performance. Furthermore, evidence suggests that fund managers incorporate ESGRD and ESG decoupling considerations into their asset allocation strategies. Notably, funds where fund managers invest in their own funds demonstrate lower levels of ESG decoupling compared to those where they do not. Finally, our results indicate that the negative correlation between fund managers’ self-investment behavior and both ESGRD and ESG decoupling is more pronounced in high-risk funds, reflecting a potential risk-mitigation strategy. JEL Classification: G12, G23, G32.

## Citation Details

ESG Information Conflicts in Mutual Funds
**Authors**: Ding, Liu, Wang
**Year**: 2025
**DOI**: 10.1177/21582440251407508
**URL**: https://doi.org/10.1177/21582440251407508

**Abstract**: ESG rating divergence (ESGRD) and ESG decoupling represent the primary manifestations of ESG information conflicts. Although ESGRD and ESG decoupling have garnered significant attention, research predominantly focuses on their implications at the corporate level. In contrast, the impact of ESGRD and ESG decoupling at the fund level, as well as their influence on fund manager behavior, remains underexplored. This study investigates the effects of ESGRD and ESG decoupling on fund performance, flow, and risk by using Chinese fund holdings and ESG ratings data. Our findings reveal that funds with higher levels of ESGRD and ESG decoupling exhibit lower returns, larger outflows, and higher risks. Moreover, the relationship between ESGRD/ESG decoupling and fund performance, flow, and risk varies across funds with differing cash asset ratios and portfolio concentrations. Additionally, we confirm that ESGRD and ESG decoupling attenuate the positive impact of a fund’s ESG performance. Furthermore, evidence suggests that fund managers incorporate ESGRD and ESG decoupling considerations into their asset allocation strategies. Notably, funds where fund managers invest in their own funds demonstrate lower levels of ESG decoupling compared to those where they do not. Finally, our results indicate that the negative correlation between fund managers’ self-investment behavior and both ESGRD and ESG decoupling is more pronounced in high-risk funds, reflecting a potential risk-mitigation strategy. JEL Classification: G12, G23, G32.  # Truncate if very long

---
*Extracted from citation research database - all 51 citations available*
