# Quantitative ESG disclosure and divergence of ESG ratings

**Authors:** Liu
**Year:** 2022
**DOI:** 10.3389/fpsyg.2022.936798
**URL:** https://doi.org/10.3389/fpsyg.2022.936798

## Abstract

Over the past decade, sustainable finance has been a topic of burgeoning significance for investors, and ESG ratings have become commonly used to implement ESG investment strategies in practice. Strikingly, it is widely documented in both academic literature and investment practices that ESG ratings of a given firm can be extremely different across rating providers. However, despite the disagreement in ESG ratings being subject to a lot of criticism, only few studies have examined the sources and determinants of rating divergence. This study examines whether quantitative ESG disclosure is conducive to rating convergence among agencies. Based on ESG rating data of Chinese A-share listed companies, the author finds that greater quantitative ESG disclosure, especially disclosure on environmental and social pillars, results in greater divergence of ESG ratings. When employing a difference-in-differences design with a quasi-experiment of disclosure guidance introduced by Hong Kong Exchange, the results show that if ESG disclosure is standardized and comparable, more numerical information reduces agencies' rating disagreement instead. Further analyses show that the lack of agreement is related to a low rating in the future. The author also finds that the effect of quantified ESG disclosure on rating divergence is more pronounced when firms are single businesses rather than diversified businesses with poor ESG performance rather than good ESG performance. The results are robust to alternative measures of ESG rating divergence, alternative sample, two-way clustering, and additional control variables. Taken together, the results indicate that quantitative ESG disclosure degenerates rating disagreement.

## Citation Details

Quantitative ESG disclosure and divergence of ESG ratings
**Authors**: Liu
**Year**: 2022
**DOI**: 10.3389/fpsyg.2022.936798
**URL**: https://doi.org/10.3389/fpsyg.2022.936798

**Abstract**: Over the past decade, sustainable finance has been a topic of burgeoning significance for investors, and ESG ratings have become commonly used to implement ESG investment strategies in practice. Strikingly, it is widely documented in both academic literature and investment practices that ESG ratings of a given firm can be extremely different across rating providers. However, despite the disagreement in ESG ratings being subject to a lot of criticism, only few studies have examined the sources and determinants of rating divergence. This study examines whether quantitative ESG disclosure is conducive to rating convergence among agencies. Based on ESG rating data of Chinese A-share listed companies, the author finds that greater quantitative ESG disclosure, especially disclosure on environmental and social pillars, results in greater divergence of ESG ratings. When employing a difference-in-differences design with a quasi-experiment of disclosure guidance introduced by Hong Kong Exchange, the results show that if ESG disclosure is standardized and comparable, more numerical information reduces agencies' rating disagreement instead. Further analyses show that the lack of agreement is related to a low rating in the future. The author also finds that the effect of quantified ESG disclosure on rating divergence is more pronounced when firms are single businesses rather than diversified businesses with poor ESG performance rather than good ESG performance. The results are robust to alternative measures of ESG rating divergence, alternative sample, two-way clustering, and additional control variables. Taken together, the results indicate that quantitative ESG disclosure degenerates rating disagreement.  # Truncate if very long

---
*Extracted from citation research database - all 51 citations available*
