## Paper 10: Quantitative ESG disclosure and divergence of ESG ratings
**Authors:** Liu
**Year:** 2022
**Venue:** Frontiers in Psychology (Organizational Psychology section)
**DOI:** 10.3389/fpsyg.2022.936798
**Citations:** [VERIFY]

### Research Question
Why do ESG rating agencies disagree so much? This paper investigates whether increasing the volume of *quantitative* ESG disclosure helps converge ratings, or if it paradoxically creates more divergence.

### Methodology
- **Design:** Empirical analysis with a Quasi-Experimental design.
- **Approach:** Difference-in-Differences (DID) using the Hong Kong Exchange's disclosure guidance as an exogenous shock.
- **Data:** Chinese A-share listed companies.

### Key Findings
1. **The Disclosure Paradox:** Generally, greater quantitative ESG disclosure (especially in Environmental and Social pillars) results in **greater divergence** of ESG ratings initially. More data gives analysts more points to disagree on.
2. **Standardization Solves It:** Using the HK Exchange guidance shock, the author found that when disclosure is **standardized and comparable**, numerical information *reduces* rating disagreement.
3. **Firm Characteristics:** The effect of disclosure on divergence is more pronounced for single-business firms (easier to analyze) and firms with poor ESG performance (harder to hide).
4. **Predictive Power:** High disagreement among raters is statistically associated with lower future ESG ratings.

### Implications
This is a crucial finding for policy and corporate strategy. It suggests that simply "reporting more numbers" is counterproductive without a standardized framework (like ISSB or GRI). It warns investors that high data availability does not equal high data reliability.

### Limitations
- **Geographic Focus:** Limited to Chinese A-shares; results might differ in markets with longer histories of ESG reporting (EU/US).
- **Psychological Venue:** Published in a Psychology journal, focusing on the cognitive/organizational aspect of rating, which might differ from a pure finance approach.

### Relevance to Your Research
**Score:** ⭐⭐⭐⭐⭐ (5/5)
**Why:** Addresses the "Data Quality" and "Greenwashing" aspects of the research topic. Explains *why* factor models might fail when using ESG data.

---