## Paper 6: Fama French 5 Factor Model Versus Alternative Fama French 5 Factor Model: Evidence from Selected Islamic Countries
**Authors:** Özer, Öncü, Özer, Çömlekçi
**Year:** 2021
**Venue:** Bilimname
**DOI:** 10.28949/bilimname.952079
**Citations:** [VERIFY]

### Research Question
How valid is the Fama-French 5-Factor (FF5F) model in developing Islamic markets, and can the model be improved for interest-sensitive (Sharia-compliant) investors by substituting the risk-free interest rate with the inflation rate?

### Methodology
- **Design:** Empirical comparative analysis.
- **Approach:** Time-series regression testing the validity of asset pricing models.
- **Data:** 
    - **Period:** 2012–2020.
    - **Indices:** Kuala Lumpur Composite Index (Malaysia), Jakarta Islamic Index (Indonesia), Karachi Meezan Index (Pakistan), Participation Index (Turkey).
    - **Subjects:** Top 30 companies in each index.

### Key Findings
1. **Model Equivalence:** The alternative model using **inflation rate** instead of risk-free interest rate performed very similarly to the original FF5F model. This validates the inflation-based model for Islamic finance where interest (Riba) is prohibited.
2. **Size Effect:** Small firms consistently showed higher excessive returns compared to large firms across the selected markets.
3. **Market Risk Variance:** Pakistan and Indonesia were identified as high-risk markets based on excess return fluctuations, whereas Malaysia was the least risky.
4. **Portfolio Inversion:** A portfolio generating the highest return in one country often generated the lowest in another, indicating low cross-border correlation among these Islamic markets.

### Implications
This provides a rigorous quantitative backing for Sharia-compliant portfolio construction. It allows Islamic investors to use sophisticated factor models without violating religious prohibitions against interest, effectively bridging modern portfolio theory (MPT) and Islamic finance.

### Limitations
- **Sample Size:** Limited to the top 30 companies per index, which may introduce survivorship bias or fail to capture the full small-cap effect.
- **Timeframe:** The 2012-2020 period includes the start of COVID-19 but might not capture the full post-pandemic recovery or inflation spike of 2021-2023.

### Notable Citations
- **Fama & French (2015):** The foundational 5-factor model paper.

### Relevance to Your Research
**Score:** ⭐⭐⭐⭐ (4/5)
**Why:** Essential for the "Emerging Markets" and "Alternative Factor Models" sections of your review.

---