## Paper 1: The logic of net zero investment portfolios: positioning long-term investors for financial outperformance
**Authors:** Casady, Monk
**Year:** 2025
**Venue:** Journal of Sustainable Finance & Investment (Inferred from DOI)
**DOI:** 10.1080/20430795.2025.2514189
**Citations:** [VERIFY]

### Research Question
This paper addresses the theoretical and practical framework for constructing "Net Zero" investment portfolios. It investigates whether aligning portfolios with net-zero carbon transition goals can be justified not merely on ethical grounds, but as a strategy for financial outperformance (alpha) for long-term investors.

### Methodology
- **Design:** Theoretical framework and Portfolio Construction Analysis [VERIFY].
- **Approach:** The authors likely employ a horizon-based investment framework, contrasting traditional mean-variance optimization with transition-risk adjusted models.
- **Data:** [VERIFY] Likely utilizes forward-looking climate transition data and asset pricing models relevant to 2025 market conditions.

### Key Findings
1. **Transition as Alpha:** The paper argues that the transition to a low-carbon economy creates structural shifts in asset pricing, making "net zero" alignment a fiduciary necessity rather than a constraint.
2. **Time Horizon Arbitrage:** Long-term investors are uniquely positioned to capture the "transition premium" that short-term market participants may misprice.
3. **[VERIFY] Specific Outperformance Metrics:** The specific basis points of outperformance or Sharpe ratio improvements claimed need verification from the full text.

### Implications
This work shifts the narrative from "divestment as a cost" to "alignment as an opportunity." It provides a fiduciary shield for institutional investors (pension funds, sovereigns) to aggressively pursue net-zero targets under the guise of risk management and return maximization.

### Limitations
- **Data Dependency:** Relies heavily on the accuracy of carbon trajectory models.
- **[VERIFY]**: Does not account for short-term volatility shocks driven by energy sector spikes.

### Relevance to Your Research
**Score:** ⭐⭐⭐⭐⭐ (5/5)
**Why:** As a 2025 paper, this represents the cutting edge of the "Climate Alpha" argument, moving beyond simple ESG screening to active transition management.

---