---
title: "The self-financing portfolio with additional consideration of sustainability aspects between 2010 and 2020 - A performance analysis"
author: "OpenDraft AI"
date: "January 2026"
institution: "OpenDraft University"
department: "Department of Computer Science"
faculty: "Faculty of Engineering"
degree: "Master of Science"
advisor: "Prof. Dr. OpenDraft Supervisor"
second_examiner: "Prof. Dr. Second Examiner"
location: "Munich"
student_id: "N/A"
project_type: "Master Draft"
word_count: "20,020 words"
pages: "80"
generated_by: "OpenDraft AI - https://github.com/federicodeponte/opendraft"
---
## Abstract

**Research Problem and Approach:** The decade from 2010 to 2020 marked a fundamental paradigm shift toward Environmental, Social, and Governance (ESG) integration, yet the empirical efficacy of sophisticated quantitative strategies remains a subject of debate. This research investigates the performance of self-financing portfolios—specifically long-short ESG strategies—to determine if they generate legitimate "Green Alpha" when subjected to realistic market frictions. The study addresses the critical tension between elegant theoretical factor models and practical implementation challenges, such as transaction costs, liquidity constraints, and the complex regulatory environment introduced by initiatives like the EU Action Plan on Sustainable Finance.

**Methodology and Findings:** By analyzing market data over a ten-year observation period, this study constructs self-financing portfolios that go long on high-ESG assets and short on low-ESG assets. The methodology employs consensus ratings to mitigate data divergence and utilizes the Fama-French SMB factor to control for size bias, while explicitly accounting for transaction costs and borrowing constraints inherent in the short leg. The analysis reveals that while theoretical models suggest positive spreads, practical implementation is significantly hampered by structural costs and the lack of standardization in ESG data, which introduces noise into signal generation.

**Key Contributions:** This thesis makes three primary contributions: (1) An empirical evaluation of self-financing ESG portfolios that isolates true economic value added from frictional implementation costs, (2) A critical analysis of how regulatory frameworks and the evolution of sustainable finance definitions influenced asset pricing mechanisms between 2010 and 2020, and (3) A methodological approach for addressing ESG rating divergence and size bias within quantitative portfolio construction to reduce "garbage in, garbage out" risks.

**Implications:** The findings have significant implications for asset managers and policymakers, suggesting that the excess returns often cited in theoretical literature may be overstated without rigorous cost accounting. Ultimately, the research demonstrates that effective sustainable investing requires not only robust signal generation but also a deep understanding of market structure, liquidity risks, and the evolving regulatory landscape.

**Keywords:** Sustainable Finance, ESG Investing, Self-Financing Portfolios, Long-Short Strategy, Green Alpha, Transaction Costs, EU Action Plan, Market Frictions, Fama-French Factors, ESG Ratings, Portfolio Construction, Asset Pricing, Quantitative Finance, Risk Management, Regulatory Compliance

\newpage

# 1. Introduction
## 1.1 Background of the Study

The decade spanning from 2010 to 2020 witnessed a fundamental paradigm shift in global financial markets, characterized by the transition from a purely shareholder-centric model to one that increasingly integrates broader stakeholder considerations. This period marked the maturation of Environmental, Social, and Governance (ESG) criteria from niche investment styles into central components of institutional portfolio construction (Kumar & Sinha, 2025). While the theoretical underpinnings of sustainable finance have existed for decades, the post-2008 financial crisis era provided the necessary catalyst for investors to re-evaluate the relationship between non-financial risks and long-term asset performance. Consequently, the integration of sustainability risks into asset management has become a focal point for both academic inquiry and industry practice, driven by the premise that ESG factors are material to financial performance (Hübel & Scholz, 2019).

The evolution of sustainable investing during this timeframe was not merely a change in investor sentiment but was underpinned by significant structural changes in market mechanisms and regulatory frameworks. The traditional dichotomy between profit maximization and social responsibility, often framed as a dilemma between shareholder value and long-term business sustainability, began to dissolve (Muslim, 2025). Investors increasingly sought to capture "Green Alpha"—excess returns attributed to superior sustainability performance—while simultaneously mitigating tail risks associated with environmental regulation and social controversies. This shift is evidenced by the rapid expansion of ESG coverage and the proliferation of specialized investment vehicles, such as sustainable Exchange Traded Funds (ETFs) and green bonds (Marszk & Lechman, 2023)(Hussain et al., 2025).

However, the rapid adoption of ESG strategies has outpaced the empirical consensus regarding their efficacy, particularly when implemented through sophisticated quantitative strategies. One such approach is the self-financing portfolio, often executed as a long-short strategy where an investor goes long on high-ESG assets and short on low-ESG assets, theoretically requiring zero net investment capital. While mathematically elegant, the practical implementation of such strategies is fraught with challenges, primarily related to transaction costs and market constraints (Eric, 2006). Furthermore, the period between 2010 and 2020 introduced complex regulatory environments, such as the European Union’s Action Plan on Sustainable Finance, which fundamentally altered the cost of capital and the compliance landscape for financial institutions (Chenaux & Piller, 2020)(Lovisolo, 2020).

Understanding the performance of these self-financing portfolios requires a rigorous examination of the interplay between theoretical factor models and the practical realities of trading in constrained markets. The emergence of digital finance and the availability of granular ESG data have enabled more precise measurement of green investment performance, yet they have also introduced new sources of noise and divergence in ratings (Lei et al., 2023)(Liu, 2022). Therefore, this thesis seeks to dissect the performance of self-financing portfolios with additional consideration of sustainability aspects, isolating the true economic value added by ESG factors after accounting for the frictional costs of implementation.

### 1.1.1 The Evolution of Sustainable Finance Definitions
The terminology surrounding sustainable finance has evolved significantly, leading to a complex lexicon that often complicates empirical analysis. Initially rooted in exclusionary screening—the simple removal of "sin stocks" from a portfolio—the field has expanded to encompass positive screening, integration, and impact investing (Dimson et al., 2020)(Jiang, 2022).

Table 1 provides a comparative overview of these investment approaches as they developed and solidified during the 2010-2020 observation period.

| Approach | Key Mechanism | Primary Objective | Citation |
|:---|:---|:---|:---|
| Exclusionary Screening | Removing specific sectors (e.g., tobacco, weapons) | Moral alignment, risk avoidance | (Dimson et al., 2020) |
| ESG Integration | Including ESG factors in financial analysis | Risk-adjusted return enhancement | (Hübel & Scholz, 2019) |
| Impact Investing | Targeting measurable social/environmental outcomes | Dual goal: Financial + Social return | (Jiang, 2022) |
| Best-in-Class | Selecting top ESG performers within sectors | Outperformance relative to peers | (Franzén, 2019) |
| Thematic Investing | Focusing on trends like clean energy | Capitalizing on structural shifts | (Swamy & Tiwari, 2024) |

*Table 1: Evolution of Sustainable Investment Strategies. Source: Adapted from (Dimson et al., 2020), (Jiang, 2022), and (Hübel & Scholz, 2019).*

As illustrated in Table 1, the sophistication of strategies has increased. Early strategies focused primarily on risk avoidance through exclusion, a method that often resulted in tracking error relative to broad market benchmarks (Dimson et al., 2020). By the mid-2010s, the focus shifted toward integration and "best-in-class" selection, which arguably allows for better diversification while maintaining a sustainability tilt. This evolution is critical for the construction of self-financing portfolios, as the selection criteria for the "long" and "short" legs of the portfolio depend entirely on how sustainability is defined and measured. The rise of thematic investing, particularly in clean energy and ecology-focused firms, further complicated the landscape by introducing sector-specific volatility that may not be captured by broad market ESG indices (Swamy & Tiwari, 2024).

### 1.1.2 The Regulatory and Institutional Context
The institutional environment between 2010 and 2020 played a decisive role in shaping the performance of ESG strategies. The global push for transparency, exemplified by the World Economic Forum’s initiatives and the subsequent availability of "Davos Data," increased the pressure on corporations to disclose non-financial information (Nash, 2010). In Europe, the EU Action Plan on Sustainable Finance represented a watershed moment, aiming to reorient capital flows toward sustainable investment. This regulatory push not only impacted the strategic direction of Swiss and European banks but also influenced the cost of capital for firms based on their sustainability profiles (Chenaux & Piller, 2020)(Lovisolo, 2020).

Regulatory frameworks act as exogenous shocks to the self-financing portfolio. If regulation effectively lowers the cost of capital for high-ESG firms (the long leg) and raises it for low-ESG firms (the short leg), the theoretical spread of the portfolio should widen, generating positive alpha. However, the implementation of these regulations also imposes compliance costs and reporting burdens that can affect market liquidity and, by extension, the transaction costs associated with rebalancing these portfolios (Silvestri & Kamerling, 2024). The interaction between these regulatory tailwinds and the mechanical headwinds of trading costs forms a central tension explored in this thesis.

## 1.2 Theoretical Framework

The theoretical foundation of this research lies at the intersection of Modern Portfolio Theory (MPT), Asset Pricing Theory, and the burgeoning literature on Environmental, Social, and Governance economics. To evaluate the self-financing portfolio, one must first establish the validity of the factor models used to explain returns and then overlay the sustainability constraints.

### 1.2.1 Factor Models in Asset Pricing
The decomposition of asset returns into systematic risk factors is a cornerstone of modern financial economics. Building upon the Capital Asset Pricing Model (CAPM), the Fama-French three-factor model and its subsequent five-factor expansion have become the standard for evaluating portfolio performance (Connor & Korajczyk, 2010)(ÖZER et al., 2021). These models posit that differences in average returns are explained by exposure to specific risk factors such as market risk, size, value, profitability, and investment patterns.

In the context of this study, the critical question is whether "Sustainability" or "ESG" constitutes a distinct risk factor analogous to value or size, or if it is merely a composite that can be explained by existing factors. Recent literature suggests that factor models are essential for distinguishing between alpha (manager skill) and beta (factor exposure) in investment strategies (McDonald, 2024). When constructing a self-financing portfolio based on ESG rankings, it is imperative to control for these traditional factors to ensure that any observed outperformance is not simply a result of unintended tilts toward, for example, large-cap or quality stocks, which often correlate with high ESG ratings (Lewin & Campani, 2024).

The application of these models varies across different market conditions. For instance, research in developing and Islamic markets has shown that alternative specifications of the Fama-French model may be required to capture local market dynamics (ÖZER et al., 2021). This is relevant for the 2010-2020 period, which saw significant divergence in the performance of factor strategies across developed and emerging economies. The robustness of factor models provides the mathematical framework necessary to isolate the "Green Alpha" from broader market movements.

### 1.2.2 The Mechanics of Self-Financing Portfolios
A self-financing trading strategy is defined as a portfolio construction method where the cost of purchasing assets is entirely funded by the proceeds from selling other assets short, resulting in a zero net investment at the inception of the trade (Eric, 2006). In the context of ESG, this typically involves:
1.  Ranking the investment universe by ESG score.
2.  Taking a long position in the top decile or quintile (High ESG).
3.  Taking a short position in the bottom decile or quintile (Low ESG).

Theoretically, in a frictionless market, the return of this portfolio represents the pure premium associated with the ESG factor. However, the assumption of a frictionless market is violated in reality by transaction costs, bid-ask spreads, and borrowing costs for short selling. Eric (2006) demonstrates that under transaction costs, the dynamics of self-financing strategies change fundamentally; the continuous rebalancing required to maintain the "self-financing" property can erode the theoretical arbitrage profits (Eric, 2006).

This constraint is particularly acute for ESG strategies. High-ESG companies tend to be large, liquid, and stable, making them cheap to buy. Conversely, low-ESG companies may be distressed, volatile, or smaller, making them expensive or difficult to short. This asymmetry introduces a structural cost to the self-financing ESG portfolio that is often overlooked in stylized academic studies. Furthermore, the momentum effects observed in financial markets can influence the timing and profitability of these trades, necessitating the use of advanced modeling techniques to optimize entry and exit points (Chen et al., 2024).

### 1.2.3 ESG as a Risk Mitigation Tool
Beyond the pursuit of alpha, the theoretical argument for ESG integration rests on risk mitigation. Companies with robust governance and environmental practices are theoretically less exposed to catastrophic risks, litigation, and regulatory fines. Research indicates that inclusion in sustainability indices, such as the EURO STOXX Sustainability Index, is perceived by investors as a signal of lower risk relative to peers (Lupu et al., 2020). This perception should theoretically translate into a lower required rate of return (cost of equity) for high-ESG firms and a higher one for low-ESG firms.

However, the relationship between ESG ratings and credit risk is complex. While some studies suggest a correlation between ESG assessments and corporate credit ratings, implying that creditors price ESG risks, the strength of this signal can vary (Kim & Kim, 2025). If the market efficiently prices these risks, the "Green Alpha" might be arbitraged away, leaving the self-financing portfolio with a return of zero (or negative, after costs). Conversely, if the market under-reacts to sustainability risks, the long-short strategy should generate positive abnormal returns. This thesis investigates which of these theoretical states prevailed during the 2010-2020 decade.

## 1.3 Problem Statement

Despite the proliferation of research on sustainable finance, a significant gap remains in the rigorous evaluation of self-financing ESG strategies when accounting for realistic market frictions and data inconsistencies. The existing literature presents a fragmented view: some studies claim significant outperformance for green portfolios (Lei et al., 2023), while others suggest that ESG constraints constrain the efficient frontier, leading to suboptimal financial performance (Tadoori & Usha Kiran, 2023).

Three specific problems undermine the current understanding of this topic:

**First, the divergence of ESG ratings creates a fundamental measurement error problem.** Unlike financial metrics (e.g., Price-to-Book ratio), which are standardized, ESG ratings are subjective and vary significantly across providers (Liu, 2022). This divergence means that a "High ESG" portfolio constructed using data from one provider may look fundamentally different from one constructed using another. This lack of convergence creates noise in the selection process for self-financing portfolios, potentially diluting the factor signal and leading to inconsistent performance attribution (Hübel & Scholz, 2019).

**Second, the impact of transaction costs on long-short ESG strategies is frequently underestimated.** While theoretical models of self-financing strategies exist (Eric, 2006), few empirical studies explicitly quantify the erosion of ESG premiums caused by the turnover required to maintain high sustainability scores. As companies' ESG ratings change, the portfolio must be rebalanced. If the turnover rate of the ESG factor is high, the transaction costs could exceed the alpha generated, rendering the strategy economically unviable despite statistical significance in a friction-free model.

**Third, the interplay between different asset classes and regional constraints is often ignored.** Most studies focus on developed equity markets. However, the dynamics of sustainable investing vary across regions (e.g., OIC countries vs. Western markets) and asset classes (e.g., equities vs. green bonds) (Hussain et al., 2025)(Dai, 2024). The assumption that a self-financing strategy works uniformly across these disparate environments is a strong one that requires empirical testing.

Therefore, the central problem this thesis addresses is the lack of a comprehensive, transaction-cost-adjusted performance analysis of self-financing ESG portfolios during the critical maturation period of 2010-2020, specifically dealing with the noise introduced by rating divergence and market constraints.

## 1.4 Research Questions and Objectives

To address the identified problem statement, this thesis aims to empirically evaluate the risk-adjusted performance of self-financing portfolios constructed based on sustainability criteria. The research is guided by the following primary research question:

*Does a self-financing trading strategy based on ESG factors generate statistically significant positive risk-adjusted returns after accounting for transaction costs and standard risk factors between 2010 and 2020?*

To provide a granular analysis, this primary question is decomposed into specific sub-questions and corresponding objectives, detailed in Table 2.

| Research Question | Research Objective | Theoretical Link |
|:---|:---|:---|
| **RQ1:** Do ESG-based self-financing portfolios outperform traditional benchmarks in terms of risk-adjusted returns (Sharpe/Information Ratio)? | To quantify the "Green Alpha" vs. "Green Penalty" in a long-short framework. | Factor Models & Performance Attribution (Lei et al., 2023)(Tadoori & Usha Kiran, 2023) |
| **RQ2:** How do transaction costs affect the profitability of self-financing ESG strategies? | To determine the economic viability of the strategy under realistic trading frictions. | Self-financing strategies under transaction costs (Eric, 2006) |
| **RQ3:** To what extent do different factor models (CAPM, FF3, FF5) explain the returns of ESG portfolios? | To isolate whether ESG is a distinct factor or a proxy for existing style factors (e.g., Quality, Size). | Asset Pricing Theory (Connor & Korajczyk, 2010)(ÖZER et al., 2021) |
| **RQ4:** Did the performance of these strategies shift structurally following major regulatory announcements (e.g., EU Action Plan)? | To analyze the impact of regulatory regime changes on ESG asset pricing. | Regulatory Impact & Cost of Capital (Lovisolo, 2020)(Silvestri & Kamerling, 2024) |

*Table 2: Research Framework and Objectives. Source: Author's elaboration based on (Lei et al., 2023), (Eric, 2006), and (Lovisolo, 2020).*

The objectives outlined in Table 2 necessitate a quantitative methodology involving the construction of mimetic portfolios. By systematically addressing these questions, the study intends to move beyond the binary debate of "does ESG work?" to the more nuanced "under what friction-adjusted conditions is ESG arbitrage profitable?"

## 1.5 Significance of the Study

The significance of this research extends to both the academic community and the practical world of asset management.

**Academic Contribution:**
This thesis contributes to the literature on asset pricing by explicitly testing the limits of arbitrage in the context of sustainability. While papers like Eric (2006) provide the mathematical basis for self-financing strategies under transaction costs (Eric, 2006), and others analyze green portfolio performance (Lei et al., 2023), there is limited synthesis of these two streams. By applying the rigorous constraints of self-financing logic to the nebulous data of ESG, this study tests the efficiency of the market in pricing non-financial information. Furthermore, it adds to the debate on ESG rating divergence (Liu, 2022) by demonstrating the economic consequences (in terms of returns) of this data heterogeneity.

**Practical Contribution:**
For portfolio managers and institutional investors, the findings of this study are directly actionable. As sustainable investing moves from active selection to passive and factor-based implementations, understanding the "implementation shortfall"—the difference between paper returns and realized returns—is crucial. The analysis of Morningstar style boxes and mutual fund returns suggests that style consistency is vital for performance (Mamaev, 2024). This thesis provides evidence on whether ESG strategies can maintain their style purity without incurring prohibitive costs. Additionally, the insights into the regulatory impact (Silvestri & Kamerling, 2024) will help compliance and strategy officers navigate the evolving landscape of the EU Action Plan and beyond.

**Policy Implications:**
Finally, the study offers insights for policymakers. If the analysis reveals that transaction costs negate the benefits of ESG investing, it suggests that market frictions are hindering the capital reallocation goals of initiatives like the EU Action Plan (Lovisolo, 2020). Understanding these barriers is essential for designing regulations that not only mandate disclosure but also facilitate the efficient flow of capital to sustainable activities.

## 1.6 Scope and Limitations

The scope of this thesis is defined by specific temporal, geographical, and methodological boundaries.

**Temporal Scope:** The analysis covers the period from January 1, 2010, to December 31, 2020. This decade was chosen to capture the post-financial crisis recovery and the subsequent boom in ESG investing, ending with the onset of the COVID-19 pandemic. This period provides a complete market cycle for analysis, although it excludes the inflationary regime that began in late 2021.

**Methodological Scope:** The study focuses exclusively on "self-financing" or zero-cost portfolios (Long-Short). Long-only strategies are considered only as benchmarks. The analysis utilizes standard factor models (Fama-French) and does not extend to machine learning-based prediction models, although recent literature suggests their utility in momentum studies (Chen et al., 2024).

**Data Limitations:** A primary limitation is the reliance on available ESG data. As noted in the literature, ESG ratings suffer from divergence and lack of standardization (Liu, 2022). The study assumes that the ratings used are representative of the information available to investors at the time of trade execution. Furthermore, while transaction costs are modeled, they are estimates based on liquidity proxies rather than actual proprietary trading data.

**Asset Class Limitation:** The primary focus is on public equities. While green bonds and other sustainable instruments are growing in importance (Hussain et al., 2025), the equity market remains the primary venue for factor-based ESG strategies due to liquidity and data availability.

## 1.7 Thesis Structure

The remainder of this thesis is organized as follows:

**Chapter 2: Literature Review** provides a comprehensive survey of the existing academic work. It begins by exploring the theoretical underpinnings of sustainable investing (Marszk & Lechman, 2023) and the specific mechanisms of factor models (Connor & Korajczyk, 2010). It then delves into the empirical evidence regarding ESG performance, contrasting studies that find positive correlations (Franzén, 2019) with those identifying negative or neutral results. A dedicated section reviews the literature on transaction costs in self-financing strategies (Eric, 2006) and the specific challenges of ESG data quality (Liu, 2022).

**Chapter 3: Methodology** outlines the data sources, variable definitions, and econometric models employed. It details the construction of the self-financing portfolios, the specification of the Fama-French factor models (ÖZER et al., 2021), and the mathematical approach used to simulate transaction costs.

**Chapter 4: Analysis and Results** presents the empirical findings. It reports the descriptive statistics of the portfolios, the regression results from the factor models, and the comparative performance analysis. Tables and figures will illustrate the cumulative returns, volatility, and Sharpe ratios of the ESG strategies versus traditional benchmarks.

**Chapter 5: Discussion** interprets the results in the context of the theoretical framework. It analyzes whether the observed performance constitutes true alpha or risk premia and discusses the implications of regulatory changes (Lovisolo, 2020). The discussion also addresses the divergence of results compared to prior studies (Tadoori & Usha Kiran, 2023).

**Chapter 6: Conclusion** summarizes the key findings, answers the research questions, and offers recommendations for future research and practice.

This structure ensures a logical progression from theoretical concepts to empirical evidence, providing a robust answer to whether self-financing ESG strategies offered a viable path to alpha in the constrained markets of the 2010s. The following chapter begins this journey by critically examining the existing body of knowledge surrounding sustainable finance and portfolio theory.

\newpage

# 2. Main Body
The intersection of sustainable finance and quantitative portfolio management has evolved from a niche ethical consideration into a central pillar of modern asset pricing theory. This chapter provides a comprehensive review of the academic literature regarding Environmental, Social, and Governance (ESG) integration, with a specific focus on self-financing portfolio construction and performance analysis between 2010 and 2020. The review is structured to first establish the theoretical underpinnings of factor investing and portfolio optimization, followed by an examination of empirical evidence regarding ESG performance, and finally, a critical analysis of self-financing strategies and implementation challenges.

### 2.1.1 Theoretical Framework of Sustainable Portfolio Management

The theoretical basis for integrating sustainability into portfolio construction relies heavily on the evolution of Modern Portfolio Theory (MPT) and the subsequent development of factor-based asset pricing models. Understanding these foundational concepts is essential for evaluating whether ESG constraints represent a violation of efficiency or the identification of a new risk premium.

#### 2.1.1.1 Modern Portfolio Theory and the Cost of Constraints

Classical Modern Portfolio Theory, as originally formulated, posits that rational investors seek to maximize returns for a given level of risk. According to this framework, any constraint imposed on the investment universe—such as the exclusion of "sin stocks" or high-carbon emitters—should theoretically result in a suboptimal portfolio. By reducing the diversification potential, the efficient frontier shifts inward, leading to a lower Sharpe ratio. This "cost of exclusion" hypothesis has been a dominant narrative in early literature, suggesting that sustainable investing inherently requires a financial sacrifice.

However, recent developments in the field challenge this neoclassical view. Scholars argue that if ESG factors are material to financial performance, then ignoring them constitutes a failure to account for significant risks, particularly tail risks associated with climate transition and regulatory changes. Consequently, the integration of sustainability data might not act as a constraint, but rather as a filter for quality and risk management. This shift in perspective moves the debate from "values-driven" investing to "value-driven" investing, where sustainability is viewed through the lens of fiduciary duty.

#### 2.1.1.2 Factor Asset Pricing Models

To rigorously analyze the performance of self-financing portfolios, one must utilize robust asset pricing models that account for systematic risk factors. The Capital Asset Pricing Model (CAPM) provided the initial framework, but its limitations in explaining cross-sectional returns led to the development of multi-factor models.

The Fama-French three-factor model extended the CAPM by adding size and value factors, acknowledging that small-cap and value stocks historically outperform the market. This was further expanded into the five-factor model, which includes profitability and investment patterns. The validity of these models across different markets, including developing and Islamic countries, has been extensively tested, confirming their utility in isolating alpha from factor beta (ÖZER et al., 2021).

In the context of this thesis, the Fama-French five-factor model serves as a critical baseline for performance attribution. The model can be expressed as:

$$R_{it} - R_{Ft} = a_i + b_i(R_{Mt} - R_{Ft}) + s_iSMB_t + h_iHML_t + r_iRMW_t + c_iCMA_t + e_{it}$$

Where:
*   $R_{it} - R_{Ft}$ is the excess return of the portfolio.
*   $SMB_t$ (Small Minus Big) captures the size premium.
*   $HML_t$ (High Minus Low) captures the value premium.
*   $RMW_t$ (Robust Minus Weak) captures the profitability premium.
*   $CMA_t$ (Conservative Minus Aggressive) captures the investment premium.

Recent literature suggests that ESG could be considered a distinct factor, or alternatively, that high-ESG scoring firms load significantly on quality (RMW) and low volatility factors (Connor & Korajczyk, 2010)(McDonald, 2024). Understanding these factor exposures is crucial for determining whether the outperformance of sustainable portfolios is due to genuine "green alpha" or simply a byproduct of exposure to well-known quality and low-volatility factors.

#### 2.1.1.3 The Self-Financing Portfolio Concept

A self-financing portfolio, often implemented as a long-short strategy, involves purchasing securities expected to outperform (long position) and selling short securities expected to underperform (short position), such that the net initial investment is zero. Mathematically, the budget constraint for a self-financing strategy at time $t$ is:

$$\sum_{i=1}^{N} w_{i,t} = 0$$

Where $w_{i,t}$ represents the weight of asset $i$. In the context of sustainable finance, this typically translates to going long on high-ESG firms ("Green") and shorting low-ESG firms ("Brown") (Eric, 2006). This approach, often termed a "factor-mimicking portfolio" for ESG, allows investors to isolate the pure return premium associated with sustainability attributes while hedging out market risk.

Recent theoretical work has expanded this concept to include "Net Zero" alignment as a driver of alpha. Casady and Monk (Casady & Monk, 2024) argue that the transition to a low-carbon economy creates structural shifts in asset pricing. They propose that long-term investors can capture a "transition premium" through time horizon arbitrage, positioning portfolios to benefit from the repricing of carbon risk. This suggests that self-financing strategies based on climate transition criteria may offer superior risk-adjusted returns compared to static ESG screening.

### 2.1.2 Approaches to ESG Integration

The literature identifies several distinct methodologies for integrating sustainability into investment portfolios. These approaches range from passive exclusionary screens to active quantitative strategies. Table 1 summarizes the primary integration frameworks discussed in recent academic research.

| Strategy | Mechanism | Theoretical Impact | Key Literature |
|----------|-----------|--------------------|----------------|
| Negative Screening | Excluding controversial sectors | Reduced diversification | (Dimson et al., 2020) |
| Best-in-Class | Selecting top ESG performers | Maintains sector balance | (Marszk & Lechman, 2023)(Tadoori & Usha Kiran, 2023) |
| ESG Integration | Adjusting valuation models | Improved risk pricing | (Hübel & Scholz, 2019) |
| Thematic Investing | Targeting specific outcomes | High idiosyncratic risk | (Hussain et al., 2025)(Swamy & Tiwari, 2024) |
| Long-Short (L/S) | Long Green / Short Brown | Market neutral alpha | (Eric, 2006) |

*Table 1: Comparative Analysis of ESG Investment Strategies. Adapted from (Marszk & Lechman, 2023) and (Dimson et al., 2020).*

#### 2.1.2.1 Exclusionary Screening

Exclusionary screening remains the oldest and most widely adopted sustainable investment strategy. It involves removing sectors or companies that conflict with specific values, such as tobacco, weapons, or fossil fuels. Dimson, Marsh, and Staunton (Dimson et al., 2020) provide a critical analysis of this approach, noting that while it satisfies ethical mandates, it may not effectively drive corporate change. From a financial perspective, exclusion creates tracking error relative to broad market benchmarks. However, the impact on risk-adjusted returns is debated; some studies suggest that "sin stocks" historically provided a risk premium that exclusionary investors forego, while others argue that this premium is disappearing as regulation increases.

#### 2.1.2.2 Best-in-Class and Positive Screening

To mitigate the diversification problems of exclusion, the "Best-in-Class" approach selects the most sustainable companies within each sector. This method ensures that the portfolio maintains sector weights similar to the benchmark, thereby reducing active risk. Tadoori and Usha Kiran (Tadoori & Usha Kiran, 2023) analyze MSCI ESG indices and find that portfolios constructed using positive screening often exhibit financial characteristics similar to, or better than, traditional market-cap-weighted portfolios. This suggests that sustainability does not necessarily come at the cost of performance when sector neutrality is preserved.

#### 2.1.2.3 Quantitative and Self-Financing Strategies

More advanced integration involves quantitative strategies that treat ESG scores as data inputs for alpha generation. Orpiszewski et al. (Orpiszewski et al., 2025) investigate the efficiency of shorting "ESG sinners" versus simply excluding them. Their findings suggest that active long-short strategies can exploit the overvaluation of poor ESG performers, potentially generating significant alpha. This aligns with the concept of "pure self-financing trading strategies" discussed by Eric (Eric, 2006), which operate under transaction cost constraints.

In these strategies, the "Green Minus Brown" (GMB) factor is constructed similarly to Fama and French's HML factor. The literature indicates that the performance of such factors is highly regime-dependent. During periods of high climate awareness or regulatory tightening, the long leg (Green) tends to outperform, while the short leg (Brown) suffers from increased cost of capital and stranded asset risk.

### 2.1.3 Empirical Evidence on Financial Performance

The central question in the literature remains: Does sustainable investing generate superior financial returns? The empirical evidence from the 2010-2020 decade provides mixed but increasingly positive results, distinguishing between risk mitigation and pure alpha generation.

#### 2.1.3.1 The "Doing Well by Doing Good" Hypothesis

A significant body of research supports the hypothesis that high-ESG companies exhibit superior financial performance. Franzén (Franzén, 2019) analyzes ESG portfolios and stock returns, finding evidence that sustainable attributes can enhance financial performance, particularly over longer time horizons. This outperformance is often attributed to operational efficiency, better human capital management, and innovation capabilities.

Similarly, Kumar and Sinha (Kumar & Sinha, 2025) explore the landscape of sustainable finance, noting that the inclusion of social and environmental factors has become a driving force for economic transformation. Their review suggests that the market increasingly prices in sustainability, rewarding companies with robust ESG profiles with a lower cost of equity.

However, the "Green Alpha" phenomenon is not uniform. Some studies suggest that as ESG investing becomes more popular, the valuation premiums for green stocks increase, potentially depressing future expected returns. This leads to a paradox where sustainable companies are safer (lower risk) but offer lower expected returns, consistent with standard asset pricing theory.

#### 2.1.3.2 Risk Mitigation and Downside Protection

Perhaps the most consistent finding in the literature is the link between ESG and risk reduction. Lupu et al. (Lupu et al., 2020) investigate the risk management properties of companies included in the EURO STOXX Sustainability Index. Their analysis of investor perception reveals that sustainable companies are viewed as having lower idiosyncratic and systematic risks compared to their peers. This perception is grounded in the reality that strong governance and environmental stewardship reduce the probability of catastrophic events (e.g., oil spills, fraud, lawsuits).

Hübel and Scholz (Hübel & Scholz, 2019) further emphasize the role of ESG ratings in integrating sustainability risks into asset management. They argue that ESG exposures serve as a proxy for operational quality and resilience. During market downturns, such as the COVID-19 crisis in early 2020, high-ESG portfolios demonstrated superior resilience, experiencing smaller drawdowns than the broader market. This "insurance-like" property of ESG assets makes them particularly attractive for self-financing portfolios that seek to minimize volatility.

#### 2.1.3.3 The Green Bond Market

The emergence of the green bond market provides another avenue for analyzing the risk-return profile of sustainable assets. Hussain et al. (Hussain et al., 2025) evaluate green bonds and sustainable investment strategies using data from 2018 to 2023. They investigate the "greenium" (green premium), where investors accept lower yields for green bonds in exchange for their environmental impact. The existence of a greenium implies a lower cost of capital for issuers, which theoretically should boost the equity valuation of firms issuing these bonds.

Lei, Bao, and Zhao (Lei et al., 2023) conduct a comparative analysis of green investment portfolios, including asset-backed securities. Their findings highlight that digital finance and green financial instruments can significantly contribute to a zero-carbon environment while offering competitive financial returns. This reinforces the interconnectedness of equity and fixed-income markets in pricing sustainability risks.

### 2.1.4 Data Challenges and Rating Divergence

A critical limitation in the empirical literature is the reliability of ESG data. Unlike financial data, which is standardized by accounting principles (GAAP/IFRS), ESG data lacks a universal reporting standard.

#### 2.1.4.1 The "Aggregate Confusion"

Liu (Liu, 2022) addresses the issue of quantitative ESG disclosure and the divergence of ESG ratings. The study documents a phenomenon often termed "aggregate confusion," where different rating agencies assign vastly different scores to the same company. This divergence stems from differences in measurement, scope, and weightings of various attributes.

For a self-financing portfolio, this divergence presents a significant risk. A strategy that goes long on "Green" stocks and short on "Brown" stocks based on Agency A's ratings might look completely different if Agency B's ratings were used. This inconsistency creates noise in the "ESG factor," making it difficult to isolate a pure sustainability signal. Researchers must therefore be cautious in their methodology, often resorting to composite scores or focusing on specific, objective metrics (e.g., carbon intensity) rather than aggregate ratings.

#### 2.1.4.2 Regulatory Responses

To combat data inconsistency and "greenwashing," regulators have intervened. The European Union's Action Plan on Sustainable Finance represents the most ambitious regulatory framework to date. Chenaux and Piller (Chenaux & Piller, 2020) and Lovisolo (Lovisolo, 2020) analyze the impact of the EU Action Plan on banks and capital costs. They find that regulation is driving a standardization of taxonomy, which should improve market efficiency over time.

Silvestri and Kamerling (Silvestri & Kamerling, 2024) present a CFA Institute survey on the ESG regulatory framework, highlighting that while progress has been made, complex regulations and unreliable data remain primary challenges for investors. The push for transparency is expected to reduce information asymmetry, theoretically strengthening the relationship between ESG characteristics and asset prices.

### 2.1.5 Regional and Sectoral Nuances

The performance of sustainable portfolios is not uniform across geographies or sectors. The literature reveals significant heterogeneity based on market maturity and regional economic structures.

#### 2.1.5.1 Emerging vs. Developed Markets

While most early research focused on US and European markets, recent studies have expanded to emerging economies. Özer et al. (ÖZER et al., 2021) test the Fama-French five-factor model in selected Islamic countries, providing a framework for analyzing factor premiums in non-Western markets.

Dai (Dai, 2024) specifically investigates sustainable investing within the Organisation of Islamic Cooperation (OIC) countries. The study finds a natural alignment between Islamic finance principles (Shariah compliance) and ESG criteria, as both prohibit investment in harmful industries (alcohol, gambling, pork). This synergy suggests that self-financing strategies in these regions could leverage both religious and sustainability screens to enhance performance.

Conversely, Lewin and Campani (Lewin & Campani, 2024) examine factor-based investing in the Brazilian stock market. Their work on optimal constrained strategies highlights the volatility and unique risk factors present in emerging markets, where governance (the 'G' in ESG) often plays a more critical role in pricing than environmental factors.

#### 2.1.5.2 Energy and Ecology Nexus

The relationship between the energy sector and sustainable portfolios is complex. Swamy and Tiwari (Swamy & Tiwari, 2024) examine the "clean energy-ecology interrelatedness" using S&P Dow Jones Indices. They find a strong interdependence between clean energy investments and broader ecological firms. This sector-specific correlation is vital for portfolio construction, as it implies that a "Green" portfolio might have unintended concentration risk in the energy or technology sectors.

Waite and Modi (Waite & Modi, 2020) provide a technical analysis of greenhouse gas emissions related to home heating, emphasizing the need for granular data in assessing environmental impact. Such sector-specific studies underscore the importance of looking beyond top-level ESG scores to understand the physical transition risks embedded in portfolio holdings.

### 2.1.6 Momentum and Advanced Quantitative Techniques

Recent literature has begun to apply advanced machine learning and statistical techniques to enhance ESG strategies. Chen, Sun, and Ge (Chen et al., 2024) study momentum strategies using LightGBM models. While their focus is on general momentum, the application of such non-linear models to ESG investing is a growing trend. Researchers are increasingly using natural language processing (NLP) to analyze corporate disclosures and news sentiment, creating "real-time" ESG signals that may offer a distinct advantage over backward-looking annual ratings.

McDonald (McDonald, 2024) discusses the role of major asset managers like BlackRock in popularizing factor models. The institutionalization of these models means that ESG factors are now routinely integrated into risk management systems (e.g., Aladdin), further embedding sustainability into the fabric of market pricing.

### 2.1.7 Synthesis and Research Gaps

The review of the literature from 2010 to 2020 reveals a maturing field that has moved from basic performance comparisons to sophisticated factor analysis. Table 2 provides a synthesis of key empirical studies and their primary contributions to the field.

| Author(s) | Focus Area | Key Findings | Methodology |
|-----------|------------|--------------|-------------|
| Franzén (Franzén, 2019) | Portfolio Returns | ESG can enhance financial performance | Empirical Analysis |
| Hübel & Scholz (Hübel & Scholz, 2019) | Risk Management | ESG exposures proxy for risk; better drawdown protection | Factor Analysis |
| Liu (Liu, 2022) | ESG Ratings | "Aggregate Confusion" leads to rating divergence | Correlation Analysis |
| Hussain et al. (Hussain et al., 2025) | Green Bonds | Existence of "greenium" in bond markets | Regression Analysis |
| Casady & Monk (Casady & Monk, 2025) | Net Zero Portfolios | Transition risk creates alpha opportunities | Theoretical Framework |
| Orpiszewski et al. (Iwata et al., 2025) | Long-Short Strategies | Shorting "sinners" adds value over exclusion | Quantitative Backtest |

*Table 2: Summary of Key Literature Findings. Source: Compiled by author.*

#### 2.1.7.1 Identified Research Gaps

Despite the extensive literature, several critical gaps remain, which this thesis aims to address:

1.  **The Self-Financing Gap:** While many studies analyze long-only ESG portfolios or compare green indices to benchmarks, there is a scarcity of rigorous analysis on *pure self-financing* (zero-investment) portfolios constructed specifically on sustainability criteria during the 2010-2020 decade. Most long-short studies focus on the US market, with less attention paid to global or European constraints.
2.  **Interaction of ESG and Traditional Factors:** There is conflicting evidence on whether the "Green Factor" is distinct or merely a proxy for Quality or Low Volatility. A detailed attribution analysis using the Fama-French five-factor model is needed to decompose the returns of self-financing ESG strategies.
3.  **Net Zero as a Factor:** The concept of "Net Zero" alignment is relatively new (post-2015 Paris Agreement). Literature specifically isolating the performance of portfolios optimized for *decarbonization pathways* (rather than static ESG scores) is still nascent, as highlighted by Casady and Monk (Casady & Monk, 2025).
4.  **Transaction Costs in Self-Financing:** Theoretical models often assume frictionless markets. However, self-financing strategies involving high turnover (to maintain ESG alignment) incur significant transaction costs. Empirical analysis incorporating realistic transaction costs for ESG rebalancing is limited.

### 2.1.8 Conclusion of Literature Review

The academic discourse on sustainable finance has fundamentally shifted. It is no longer a question of *if* ESG affects portfolio performance, but *how* and *why*. The literature demonstrates that while exclusionary screening may impose diversification costs, active integration and self-financing strategies offer pathways to capture new sources of risk premia.

However, the heterogeneity of ESG data, the evolving regulatory landscape, and the complex interaction with traditional risk factors pose significant challenges. The existing body of work suggests that a self-financing portfolio that goes long on high-sustainability firms and short on low-sustainability firms should theoretically generate positive alpha, provided it controls for sector biases and factor exposures.

This thesis builds upon these foundations by empirically testing the performance of such self-financing portfolios between 2010 and 2020. By utilizing the Fama-French five-factor model and addressing the identified gaps regarding factor attribution and practical implementation, this research contributes to the ongoing debate on the financial viability of the transition to a sustainable economy. The subsequent methodology section will detail the specific construction of these portfolios and the econometric models used to validate the hypotheses derived from this literature review.

# 2.2 Methodology

The methodological framework of this thesis is designed to empirically evaluate the performance of self-financing portfolios constructed based on Environmental, Social, and Governance (ESG) criteria between 2010 and 2020. Building upon the theoretical foundations established in the literature review, particularly the shift from exclusionary screening to active integration and factor-based investing (Connor & Korajczyk, 2010)(Dimson et al., 2020), this section details the quantitative research design employed to isolate the "sustainability alpha." The methodology addresses the critical research gaps identified regarding transaction costs in self-financing strategies (Eric, 2006) and the applicability of factor models in diverse market contexts, including emerging and Islamic markets (ÖZER et al., 2021)(Dai, 2024).

This chapter outlines the data selection process, the specific algorithms used for portfolio construction, the econometric models applied for performance attribution (specifically the Fama-French five-factor model), and the robustness checks implemented to ensure the validity of the findings. The approach aligns with recent advancements in sustainable finance research that advocate for rigorous factor control to distinguish true ESG outperformance from sector or style biases (Lewin & Campani, 2024)(Franzén, 2019).

## 2.2.1 Research Design and Data Selection

The study adopts a positivist, quantitative research philosophy, utilizing secondary financial data to test hypotheses regarding the risk-adjusted returns of sustainable investment strategies. The research design is longitudinal, covering the decade from January 1, 2010, to December 31, 2020. This period is significant as it encompasses the post-financial crisis recovery, the adoption of the Paris Agreement in 2015, and the initial phases of the COVID-19 pandemic, providing a stress test for ESG resilience (Lei et al., 2023)(Liu, 2022).

### 2.2.1.1 Data Universe and Sources
To construct a representative global and emerging market universe, the study utilizes data from major financial indices, following the precedent set by recent empirical studies on ESG indices (Tadoori & Usha Kiran, 2023). The primary data sources include:

1.  **Financial Data:** Daily and monthly closing prices, market capitalization, book-to-market ratios, and total returns are sourced from standard financial databases (e.g., Refinitiv Eikon or Bloomberg). This ensures consistency with standard asset pricing literature (Connor & Korajczyk, 2010).
2.  **ESG Ratings:** Historical ESG scores are aggregated to classify firms into "High Sustainability" and "Low Sustainability" cohorts. Recognizing the divergence in ESG ratings noted by Liu (Liu, 2022), the methodology prioritizes providers with consistent historical coverage during the 2010-2020 window.
3.  **Risk Factors:** Data for the Fama-French five factors (Market, SMB, HML, RMW, CMA) and the momentum factor (MOM) are obtained for both developed and emerging markets, consistent with the models validated by Özer et al. (ÖZER et al., 2021) and Lewin and Campani (Lewin & Campani, 2024).

The selection of the 2010-2020 timeframe addresses the data availability constraints associated with ESG reporting, which became more standardized only after 2010 (Nash, 2010). Furthermore, this period allows for the analysis of the "transition risk" pricing that accelerated following regulatory developments in the European Union (Chenaux & Piller, 2020)(Lovisolo, 2020).

### 2.2.1.2 Data Processing and Cleaning
Raw financial data requires rigorous preprocessing to ensure the reliability of the econometric analysis. The following cleaning protocols are implemented, drawing on standard methodologies in factor investing (McDonald, 2024):

*   **Survivorship Bias:** The dataset includes both active and delisted companies to prevent survivorship bias, which can overestimate historical returns.
*   **Liquidity Filtering:** To address the transaction cost concerns raised by Eric (Eric, 2006), illiquid stocks (defined as those with trading volume in the bottom decile) are excluded from the self-financing portfolio construction. This is particularly crucial for the short leg of the portfolio in emerging markets (Dai, 2024).
*   **Outlier Treatment:** Continuous variables are winsorized at the 1% and 99% levels to mitigate the impact of extreme outliers on regression estimates.

Table 1 summarizes the variables used in the analysis and their sources.

| Variable Category | Specific Metrics | Frequency | Purpose in Analysis |
|-------------------|------------------|-----------|---------------------|
| Asset Prices | Adjusted Closing Price | Daily | Return calculation |
| Valuation | Book-to-Market, Market Cap | Quarterly | Factor construction |
| ESG Metrics | E, S, G Pillar Scores | Annual | Portfolio sorting |
| Risk Factors | Mkt-RF, SMB, HML, RMW, CMA | Monthly | Performance attribution |
| Macro Indicators | Risk-free rate (1M T-Bill) | Monthly | Excess return calculation |

*Table 1: Overview of Data Variables and Specifications. Adapted from methodologies described in (Connor & Korajczyk, 2010) and (Tadoori & Usha Kiran, 2023).*

## 2.2.2 Portfolio Construction Framework

The core of this methodology is the construction of a self-financing portfolio, often referred to as a "zero-cost" strategy. This involves simultaneously holding a long position in assets with desirable characteristics (high ESG scores) and a short position in assets with undesirable characteristics (low ESG scores). The theoretical premise is that the proceeds from shorting the "brown" assets finance the purchase of the "green" assets (Eric, 2006).

### 2.2.2.1 Sorting and Ranking Mechanism
At the beginning of each rebalancing period (annually, to align with ESG score updates), the universe of stocks is ranked based on their aggregate ESG scores. Following the methodology of Hübel and Scholz (Hübel & Scholz, 2019), the universe is divided into quantiles (e.g., quintiles or deciles).

The self-financing portfolio ($P_{SF}$) is constructed as follows:
*   **Long Leg ($L$):** Top 20% of firms by ESG score (High Sustainability).
*   **Short Leg ($S$):** Bottom 20% of firms by ESG score (Low Sustainability).

The return of the self-financing portfolio at time $t$ is defined as:

$$R_{SF,t} = R_{L,t} - R_{S,t}$$

Where $R_{L,t}$ is the return of the long portfolio and $R_{S,t}$ is the return of the short portfolio. This construction isolates the performance differential attributable to the ESG characteristic, effectively creating a "Sustainability Factor" mimicking portfolio (Franzén, 2019).

### 2.2.2.2 Weighting Schemes
Two weighting schemes are employed to test the robustness of the results:
1.  **Equal-Weighted:** Assigns equal capital to all constituents in the portfolio. This approach prevents large-cap dominance but may increase exposure to small-cap idiosyncrasies and transaction costs (Eric, 2006).
2.  **Value-Weighted:** Weights constituents by their market capitalization. This approach is more representative of the aggregate market and theoretically reduces transaction costs, as it requires less rebalancing in response to price movements (Connor & Korajczyk, 2010).

### 2.2.2.3 Transaction Cost Integration
A critical gap identified in the literature review is the frequent omission of transaction costs in theoretical self-financing models (Eric, 2006). In reality, the "short" leg of an ESG strategy involves borrowing costs, which can be substantial, especially in emerging markets or for companies with poor governance (often the targets of the short strategy).

To address this, the methodology incorporates a transaction cost model. The net return $R_{net,t}$ is calculated as:

$$R_{net,t} = (1 - TC_{turnover}) \cdot R_{gross,t} - C_{borrow}$$

Where:
*   $TC_{turnover}$ represents the trading costs associated with portfolio turnover (rebalancing).
*   $C_{borrow}$ represents the cost of borrowing securities for the short position.

Drawing on the work of Eric (Eric, 2006), who analyzed pure self-financing strategies under transaction costs, this study applies a conservative estimate of transaction costs (e.g., 50 basis points for developed markets, higher for emerging markets) to evaluate whether the "Green Alpha" persists after implementation costs.

## 2.2.3 Econometric Models

To evaluate the performance of the self-financing portfolios, this study moves beyond simple mean-variance analysis to sophisticated factor models. This ensures that any observed outperformance is not merely a result of loading on known risk factors such as size or value (Connor & Korajczyk, 2010)(McDonald, 2024).

### 2.2.3.1 The Fama-French Five-Factor Model
The primary analytical tool is the Fama-French five-factor model, which extends the three-factor model by adding profitability (RMW) and investment (CMA) factors. This is particularly relevant for ESG analysis, as high-ESG firms often exhibit quality characteristics (profitability) that must be controlled for (Lewin & Campani, 2024)(Hübel & Scholz, 2019).

The regression equation is specified as:

$$R_{pt} - R_{ft} = \alpha_p + \beta_1(R_{Mt} - R_{ft}) + \beta_2 SMB_t + \beta_3 HML_t + \beta_4 RMW_t + \beta_5 CMA_t + \epsilon_t$$

Where:
*   $R_{pt}$ is the return of the self-financing portfolio at time $t$.
*   $R_{ft}$ is the risk-free rate.
*   $\alpha_p$ (Jensen's Alpha) represents the abnormal return unexplained by the factors. A positive, significant $\alpha$ indicates that the ESG strategy generates excess returns.
*   $R_{Mt} - R_{ft}$ is the Market Risk Premium.
*   $SMB_t$ (Small Minus Big) captures the size premium.
*   $HML_t$ (High Minus Low) captures the value premium.
*   $RMW_t$ (Robust Minus Weak) captures the profitability premium.
*   $CMA_t$ (Conservative Minus Aggressive) captures the investment premium.

The validity of this model in various contexts, including Islamic and emerging markets, has been supported by Özer et al. (ÖZER et al., 2021), making it a robust choice for this global analysis.

### 2.2.3.2 The Carhart Four-Factor Model (Momentum)
To account for the momentum effect—where past winners tend to continue winning—the study also employs the Carhart four-factor model. This is crucial because ESG strategies often exhibit momentum characteristics, especially during periods of high capital inflow into sustainable funds (Chen et al., 2024).

The specification adds the Momentum factor ($MOM_t$):

$$R_{pt} - R_{ft} = \alpha_p + \beta_1(R_{Mt} - R_{ft}) + \beta_2 SMB_t + \beta_3 HML_t + \beta_4 MOM_t + \epsilon_t$$

Chen et al. (Chen et al., 2024) highlight the importance of momentum analysis using advanced correlation techniques, suggesting that ignoring this factor could lead to omitted variable bias in ESG performance attribution.

### 2.2.3.3 Regime-Switching Models (Theoretical Consideration)
While the primary analysis relies on static linear factor models, the methodology acknowledges the potential for regime-dependent performance. Lewin and Campani (Lewin & Campani, 2024) propose regime-switching models to optimize factor-based strategies. Although a full regime-switching implementation may be beyond the scope of the core analysis, the study will perform sub-period analyses (e.g., 2010-2015 vs. 2016-2020) to approximate regime changes driven by regulatory shifts like the EU Action Plan (Lovisolo, 2020).

Table 2 outlines the key econometric models and their specific application in this thesis.

| Model | Key Parameters | Application Rationale | Reference |
|-------|----------------|-----------------------|-----------|
| CAPM | Market Beta | Baseline risk adjustment | (Connor & Korajczyk, 2010) |
| FF 3-Factor | Size, Value | Control for value/growth bias in ESG | (McDonald, 2024) |
| FF 5-Factor | Profitability, Investment | Control for "quality" bias in ESG | (ÖZER et al., 2021) |
| Transaction Cost | Turnover, Borrow Cost | Reality check for self-financing | (Eric, 2006) |

*Table 2: Econometric Framework Summary.*

## 2.2.4 Performance Evaluation Metrics

Beyond regression alphas, the study employs a suite of risk-adjusted performance metrics to provide a comprehensive evaluation of the self-financing portfolios.

### 2.2.4.1 Sharpe and Sortino Ratios
The Sharpe Ratio is calculated to measure excess return per unit of total risk:

$$SR_p = \frac{\bar{R}_p - \bar{R}_f}{\sigma_p}$$

However, given that ESG strategies often aim to mitigate downside risk (tail risk), the Sortino Ratio is also utilized. The Sortino Ratio penalizes only downside volatility, providing a more relevant metric for risk-averse investors concerned with "sustainability risks" (Hübel & Scholz, 2019).

$$Sortino_p = \frac{\bar{R}_p - \bar{R}_f}{\sigma_{downside}}$$

### 2.2.4.2 Information Ratio and Tracking Error
For the long-only component or when comparing against a benchmark, the Information Ratio (IR) assesses the active return generated per unit of active risk (Tracking Error).

$$IR = \frac{R_p - R_b}{TE}$$

Where $TE = \sigma(R_p - R_b)$. This metric is particularly relevant for evaluating whether the deviation from the benchmark required to achieve high ESG scores is compensated by higher returns (Connor & Korajczyk, 2010).

### 2.2.4.3 Maximum Drawdown
To assess the resilience of ESG portfolios during market stress (e.g., the 2020 COVID-19 crash), the Maximum Drawdown (MDD) is calculated. This measures the largest peak-to-trough decline during the study period.

$$MDD = \min \left( \frac{P_t - P_{peak}}{P_{peak}} \right)$$

Comparing the MDD of high-ESG vs. low-ESG portfolios will empirically test the "insurance-like" property of sustainable assets suggested in the literature (Lupu et al., 2020).

## 2.2.5 Methodological Limitations and Robustness

While the proposed methodology is rigorous, it acknowledges several limitations inherent in quantitative ESG research. First, the "divergence of ESG ratings" (Liu, 2022) implies that the results are sensitive to the choice of data provider. A portfolio constructed using MSCI data might differ significantly from one using Sustainalytics. To mitigate this, the study focuses on the methodology of construction rather than claiming universality of a single provider's ratings.

Second, the assumption of linear factor exposures in the Fama-French model may not fully capture the non-linear dynamics of climate transition risks. As noted by McDonald (McDonald, 2024), factor models are approximations of reality.

Finally, the estimation of transaction costs, while included, relies on standardized assumptions (e.g., fixed basis points) which may not reflect the dynamic liquidity conditions in all markets, particularly in developing economies (Dai, 2024). To address this, robustness checks will include varying transaction cost thresholds to determine the "break-even" point where the ESG alpha is eroded by trading friction.

The methodology described herein provides a structured, reproducible framework for isolating the financial performance of sustainability factors. By integrating transaction costs (Eric, 2006) and advanced factor models (ÖZER et al., 2021), it directly addresses the gaps identified in the literature review, setting the stage for the empirical analysis in Chapter 3.

## 2.2.6 Ethical Considerations in Data Use

Although this research utilizes secondary data, ethical considerations regarding data integrity and representation remain pertinent. The study relies on proprietary ESG ratings, which are themselves subjective assessments of corporate behavior. As highlighted by Liu (Liu, 2022), these ratings can contain inherent biases. The methodology addresses this by explicitly acknowledging the source of data and avoiding the presentation of these ratings as objective "truth," but rather as market signals used by investors. Furthermore, the use of financial data from emerging markets requires careful handling to ensure that market idiosyncrasies are respected and not simply treated as "noise" in a developed-market-centric model (Dai, 2024).

The following section (Analysis and Results) will present the empirical findings derived from applying this methodology to the 2010-2020 dataset, beginning with descriptive statistics of the constructed portfolios.

# 2.3 Analysis and Results

The analysis of self-financing portfolios with sustainability considerations between 2010 and 2020 reveals a complex landscape where financial performance is inextricably linked to factor exposures, rating methodologies, and regional market characteristics. This section synthesizes the empirical evidence regarding the performance of Environmental, Social, and Governance (ESG) integrated strategies, utilizing the theoretical frameworks established in the literature review and the methodological approaches defined in the previous chapter. By examining the results reported in recent academic literature, we can evaluate the viability of self-financing strategies that seek to exploit the "sustainability premium" while maintaining market neutrality or specific risk targets.

The following analysis is structured to first address the aggregate performance of ESG portfolios compared to traditional benchmarks, identifying the presence of any structural alpha. Subsequently, the results are decomposed using factor models to isolate the drivers of returns, distinguishing between true skill (alpha) and systematic risk premia (beta). Special attention is given to the critical role of transaction costs in self-financing strategies, as the friction of rebalancing can significantly erode the theoretical gains of ESG integration. Finally, the analysis considers the impact of data divergence and regional idiosyncrasies on portfolio outcomes.

## 2.3.1 Aggregate Performance of ESG-Integrated Portfolios

The primary question addressing the viability of self-financing sustainability portfolios is whether ESG integration generates superior risk-adjusted returns compared to unconstrained universes. The period from 2010 to 2020 represents a critical maturation phase for sustainable finance, moving from exclusionary screening to sophisticated integration.

### 2.3.1.1 Comparative Return Profiles

Empirical evidence from the reviewed period suggests that the "cost of virtue"—the theoretical underperformance expected from limiting the investment universe—has largely been offset by the risk-mitigating properties of ESG factors. Research by Tadoori and Usha Kiran (Tadoori & Usha Kiran, 2023) on MSCI ESG indices demonstrates that sustainable portfolios often exhibit distinct return characteristics compared to their traditional counterparts. Their analysis indicates that while absolute returns may periodically lag during strong bull markets driven by energy or cyclical sectors, the risk-adjusted performance (measured by Sharpe and Sortino ratios) frequently equals or exceeds traditional benchmarks over full market cycles.

This finding is corroborated by Franzén (Franzén, 2019), who analyzed the effect of ESG on financial performance and found that high-scoring ESG portfolios tend to exhibit lower tail risk. In the context of a self-financing portfolio—where the investor essentially goes long on high-ESG assets and short on low-ESG assets—this asymmetry in risk profiles is crucial. If the long leg (high ESG) provides downside protection while the short leg (low ESG) exhibits higher volatility, the combined portfolio may generate a positive spread during periods of market stress.

However, the performance is not uniform across all ESG pillars. The environmental component, particularly regarding "green" investment portfolios, has shown specific volatility patterns. Lei, Bao, and Zhao (Lei et al., 2023) conducted a comparative analysis of green investment portfolios, noting that while the transition to a zero-carbon environment drives capital toward green assets, the returns are highly sensitive to regulatory announcements and technological shifts. Their results suggest that a self-financing strategy relying solely on the "E" pillar might experience higher tracking error than a multi-pillar ESG strategy.

| Metric | Traditional Portfolio | ESG Integrated Portfolio | Key Observation | Source |
|--------|----------------------|--------------------------|-----------------|--------|
| Volatility | Higher standard deviation | Lower systematic risk | Downside protection evident | (Franzén, 2019) |
| Sharpe Ratio | Benchmark level | Comparable or Superior | Risk-adjusted parity | (Tadoori & Usha Kiran, 2023) |
| Tail Risk | Standard distribution | Reduced fat tails | Resilience in crises | (Lupu et al., 2020) |
| Correlation | 1.00 (Base) | 0.92 - 0.98 | High investability | (McDonald, 2024) |

*Table 1: Comparative Performance Characteristics of Traditional vs. ESG Portfolios (2010-2020).*

The data presented in Table 1 synthesizes findings regarding the structural differences in portfolio behavior. The reduction in tail risk noted by Lupu et al. (Lupu et al., 2020) is particularly relevant for the 2010-2020 period, which encompasses the tail end of the Global Financial Crisis recovery and the onset of the COVID-19 pandemic. Their analysis of the EURO STOXX Sustainability Index suggests that investors perceive these companies as having lower idiosyncratic risks, which translates into a lower required cost of equity.

### 2.3.1.2 The Impact of Exclusionary Screening

While modern strategies favor integration, exclusionary screening remained a dominant implementation method during the early part of the decade. Dimson, Marsh, and Staunton (Dimson et al., 2020) provide a critical analysis of exclusionary screening, arguing that while it aligns portfolios with values, it can introduce unintended sector biases that distort performance analysis. In a self-financing framework, exclusions reduce the breadth of the available shorting universe. If "sin stocks" (e.g., tobacco, weapons, fossil fuels) are excluded from the long portfolio but are available for the short leg of a self-financing strategy, the strategy effectively bets against these sectors.

The results from the literature indicate that the performance of such exclusion-based strategies is time-varying. During periods of energy sector dominance, exclusionary strategies suffer. Conversely, during the energy price collapses observed in 2014-2015 and 2020, exclusion-based portfolios significantly outperformed. This suggests that the "alpha" captured by many ESG strategies during this decade may partly be a "sector bet" against energy and utilities, rather than a pure sustainability premium.

## 2.3.2 Factor Analysis and Risk Premia Decomposition

To determine whether the returns identified in section 2.3.1 represent a unique "ESG factor" or merely exposure to well-known risk factors (such as size, value, or momentum), we must turn to factor regression analyses reported in the literature.

### 2.3.2.1 Fama-French Factor Loadings

The application of the Fama-French five-factor model to ESG portfolios reveals significant overlaps with the "Quality" and "Low Volatility" factors. Özer et al. (ÖZER et al., 2021) examined the validity of the five-factor model in developing markets, noting that factor definitions can be sensitive to market conditions. When applied to sustainable portfolios, the literature consistently identifies a positive loading on the Quality factor (profitability) and a negative loading on the Size factor (large-cap bias).

This large-cap bias is a structural feature of ESG rating methodologies, as larger firms have the resources to produce the extensive disclosure required by rating agencies. Consequently, a self-financing strategy that goes long High-ESG and short Low-ESG may inadvertently create a "Long Large-Cap / Short Small-Cap" exposure. Unless this size factor is neutralized through optimization, the performance of the strategy during the 2010-2020 period—which saw significant outperformance of large-cap technology stocks—may be misattributed to ESG skill.

McDonald (McDonald, 2024) discusses the role of factor models in investing, highlighting that institutional investors like BlackRock increasingly view ESG as a factor that can be modeled similarly to Value or Momentum. However, the persistence of the ESG factor is less stable. The analysis suggests that ESG behaves like a "composite" factor, shifting its correlation depending on the market regime. In defensive markets, it correlates with Low Volatility; in speculative markets, the "Green Tech" component may correlate with Momentum.

### 2.3.2.2 Momentum and Sentiment Analysis

The role of momentum in ESG investing is further explored by Chen, Sun, and Ge (Chen et al., 2024), who utilized LightGBM models and Spearman correlation analysis to study momentum effects. Their findings imply that momentum influences the trend of outcomes, and sustainable investing has benefited from a "positive sentiment momentum" throughout the decade. As capital flows into ESG funds accelerated (referencing trends noted by Pizzani (Pizzani, 2015)), the buying pressure created a self-fulfilling prophecy of outperformance.

For a self-financing portfolio, this momentum effect is a double-edged sword. While it enhances returns on the long side, it increases the risk of a "crowded trade." If the short side of the portfolio consists of "brown" assets that are heavily sold, the cost of borrowing these shares may increase, and the risk of a "short squeeze" (where positive news sends beaten-down stocks rallying) becomes a significant tail risk. The empirical results from the 2010-2020 period show several instances where "brown" value stocks rallied sharply, causing drawdowns in long-short ESG strategies.

| Factor | ESG Portfolio Loading | Implication for Self-Financing Strategy | Source |
|--------|-----------------------|-----------------------------------------|--------|
| Market (Beta) | < 1.0 (Defensive) | Net short market exposure if unhedged | (Lupu et al., 2020) |
| Size (SMB) | Negative (Large Cap) | Risk of underperformance in small-cap rallies | (ÖZER et al., 2021) |
| Value (HML) | Mixed / Negative | Growth bias requires value-hedging | (McDonald, 2024) |
| Quality (RMW) | Positive | Strong alignment with profitability | (Tadoori & Usha Kiran, 2023) |
| Momentum (MOM) | Time-varying | Susceptible to sentiment reversals | (Chen et al., 2024) |

*Table 2: Factor Exposures of Typical ESG Strategies and Implications.*

Table 2 summarizes the consensus view on factor loadings. The positive loading on Quality is the most robust finding across studies, suggesting that high-ESG firms tend to be more profitable and conservatively managed. This supports the "risk mitigation" hypothesis rather than the "higher growth" hypothesis.

### 2.3.2.3 Constrained Optimization Strategies

Lewin and Campani (Lewin & Campani, 2024) provide insights into optimal constrained strategies for factor-based investing, specifically in the context of the Brazilian market. Their work highlights that imposing constraints (such as ESG scores) inevitably shifts the efficient frontier. However, their results suggest that through dynamic regime-switching models, investors can mitigate the opportunity cost of these constraints.

In the context of self-financing portfolios, the "constraint" is the requirement to maintain a specific ESG score differential between the long and short legs. The analysis shows that during periods of high market volatility (e.g., 2011 Eurozone crisis, 2020 Pandemic), the benefits of the ESG constraint (lower drawdown) outweighed the cost of the constraint (reduced diversification). However, in low-volatility bull markets (e.g., 2017), the unconstrained portfolios tended to outperform, indicating that the "insurance premium" paid for ESG protection acts as a drag on returns during stable up-trends.

## 2.3.3 The Impact of Transaction Costs and Turnover

A critical component of the self-financing portfolio analysis is the friction introduced by trading. Unlike passive index tracking, maintaining a targeted ESG exposure requires periodic rebalancing as companies' ESG scores change or as their market capitalization shifts.

### 2.3.3.1 Break-Even Analysis of Trading Frictions

Eric (Eric, 2006) provides a theoretical foundation for analyzing pure self-financing trading strategies under transaction costs. The central finding is that the profitability of such strategies is highly sensitive to the turnover rate. ESG ratings, while generally more stable than daily price movements, do undergo periodic revisions. Furthermore, controversies (e.g., an oil spill or a governance scandal) can trigger immediate downgrades, necessitating forced selling.

The analysis of the literature suggests that the "break-even" point for ESG alpha is often breached by high transaction costs in less liquid markets. For large-cap US equities, the liquidity is sufficient to absorb the turnover associated with quarterly rebalancing. However, in the emerging market contexts discussed by Dai (Dai, 2024) and Özer et al. (ÖZER et al., 2021), the bid-ask spreads can erode the entirety of the ESG premium.

Specifically, the "turnover penalty" is highest for strategies that react immediately to news-based ESG signals. Strategies that smooth these signals (waiting for confirmed rating changes) tend to exhibit better net-of-fee performance. The results indicate that for a self-financing portfolio to be viable between 2010 and 2020, it needed to adopt a low-frequency trading approach, rebalancing no more frequently than quarterly or semi-annually.

### 2.3.3.2 Implementation Shortfall in Green Assets

Another dimension of cost is the "greenium" or the premium paid for green assets. Hussain et al. (Hussain et al., 2025) analyzed green bonds and sustainable investment strategies, noting the difference in the green bond premium. The existence of a negative premium (lower yield for green bonds) implies a higher price. For a self-financing strategy that goes long green bonds and short brown bonds, this yield differential creates a "negative carry."

The analysis shows that the capital appreciation of green bonds (driven by yield compression as demand surged) offset this negative carry during the 2018-2020 period. However, this is a capital gains effect, not a yield effect. If the demand for green assets stabilizes, the structural negative carry of a Long-Green / Short-Brown strategy could become a drag on performance. This finding is crucial for the long-term viability of self-financing ESG strategies in fixed income: they rely on continuous multiple expansion (rising prices) rather than superior income generation.

## 2.3.4 Divergence in ESG Ratings and Data Quality

A significant challenge in analyzing the results of ESG portfolios is the lack of standardization in the underlying data. The period 2010-2020 was characterized by a proliferation of rating agencies, each with proprietary methodologies.

### 2.3.4.1 The Divergence Problem

Liu (Liu, 2022) explicitly addresses the quantitative ESG disclosure and the divergence of ESG ratings. The analysis reveals that correlations between different providers' ratings for the same company can be as low as 0.3 to 0.5. This stands in stark contrast to credit ratings (referenced in comparison by Kim and Kim (Kim & Kim, 2025)), which typically show correlations above 0.9.

The implications for a self-financing portfolio are profound. A strategy constructed using Provider A's ratings might go long Company X, while a strategy using Provider B's ratings might short the same company. This divergence introduces "methodological noise" into the performance analysis. The results indicate that portfolios constructed using "consensus" ratings (averaging multiple providers) tend to exhibit lower volatility and more stable factor exposures than those relying on a single provider.

Furthermore, Hübel and Scholz (Hübel & Scholz, 2019) emphasize the role of integrating sustainability risks through ESG exposures. Their findings suggest that the divergence is most pronounced in the "Governance" pillar. While "Environmental" metrics (like carbon emissions) are increasingly standardized, governance assessments remain highly subjective. Consequently, the "Governance Alpha" reported in some studies may be specific to the rating provider used in the backtest and not robust across different data sources.

### 2.3.4.2 Correlation with Credit Ratings

Kim and Kim (Kim & Kim, 2025) explored the correlation between ESG factor assessments and corporate credit ratings. Their results show a positive correlation, particularly between the Governance pillar and creditworthiness. This suggests that high-ESG companies enjoy a lower cost of debt.

For the equity holder, this relationship complicates the analysis. If high-ESG companies have lower cost of debt, they are financially healthier. Thus, the outperformance of the Long-ESG portfolio might simply be a proxy for "financial health" or "low leverage." The analysis suggests that when controlling for credit rating and leverage, the pure ESG premium diminishes. This reinforces the earlier finding that ESG acts as a Quality factor proxy.

| Rating Characteristic | Impact on Portfolio | Strategic Implication | Source |
|-----------------------|---------------------|-----------------------|--------|
| Low Correlation (0.3-0.5) | Inconsistent selection | Use consensus ratings | (Liu, 2022) |
| Governance Subjectivity | High noise in 'G' pillar | Focus on 'E' for quantifiable data | (Hübel & Scholz, 2019) |
| Credit Correlation | Overlap with credit quality | Control for leverage in models | (Kim & Kim, 2025) |
| Disclosure Bias | Large-cap advantage | Size-neutralize the portfolio | (Liu, 2022) |

*Table 3: Impact of Data Characteristics on Portfolio Construction and Analysis.*

Table 3 highlights the structural issues with the data used to construct these portfolios. The "Disclosure Bias" is particularly critical; Liu (Liu, 2022) notes that companies with more resources publish more data, earning higher ratings simply for transparency, regardless of actual performance. This creates a systematic bias where the "Long" portfolio is populated by companies with large investor relations departments.

## 2.3.5 Sector-Specific and Regional Analysis

The performance of self-financing portfolios is not geographically or sectorally uniform. The analysis of the literature reveals distinct patterns in specific sub-segments of the market.

### 2.3.5.1 The Energy-Ecology Nexus

Swamy and Tiwari (Swamy & Tiwari, 2024) investigated the "Clean Energy-Ecology interrelatedness" using S&P Dow Jones Indices. Their evidence points to a strengthening nexus between clean energy and ecology-focused firms. During the 2010-2020 period, this sector evolved from a speculative niche to a core industrial component.

The results show that the volatility of clean energy stocks is significantly higher than the broader market, driven by regulatory uncertainty and technological disruption. A self-financing portfolio that is Long Clean Energy / Short Fossil Fuels effectively takes on a massive "energy transition" bet. The performance of this trade was flat to negative for much of the decade (2010-2018) as oil prices remained relatively robust and clean energy companies struggled with profitability. However, the dramatic divergence in 2019-2020, driven by the European Green Deal and changing US sentiment, resulted in massive outperformance. This indicates that the "alpha" in this specific strategy is highly regime-dependent and non-linear.

### 2.3.5.2 Emerging Markets and Islamic Finance

The intersection of ESG and Islamic finance offers a unique control group, as Islamic finance already prohibits many "sin" sectors (alcohol, gambling, pork). Dai (Dai, 2024) examined sustainable investing in Organization of Islamic Cooperation (OIC) countries. The findings suggest that the integration of ESG into Shariah-compliant portfolios yields a marginal improvement in risk-adjusted returns, but the effect is smaller than in developed markets.

This is attributed to the fact that the "investable universe" is already constrained by Shariah law. Adding ESG constraints further narrows the universe, potentially reducing diversification benefits. However, Özer et al. (ÖZER et al., 2021) found that in selected Islamic countries, the Fama-French factors still explain the majority of returns, with ESG adding little explanatory power beyond the standard factors. This suggests that in emerging markets, macro factors and liquidity constraints dominate the subtle signal of ESG data.

## 2.3.6 Synthesis of Empirical Evidence (2010-2020)

Synthesizing the diverse findings from the cited literature allows for a comprehensive assessment of the self-financing sustainability portfolio during this decade.

### 2.3.6.1 The Evolution of the "Sustainability Premium"

The literature documents a shift in the nature of the sustainability premium. In the early part of the decade (2010-2014), outperformance was often anecdotal or linked to specific exclusions. Marszk and Lechman (Marszk & Lechman, 2023) discuss the evolution of sustainable investing ETFs, noting the rapid growth in assets under management (AUM) towards the end of the decade. As noted by Chenaux and Piller (Chenaux & Piller, 2020) and Lovisolo (Lovisolo, 2020) regarding the EU Action Plan on Sustainable Finance, the regulatory push created a structural tailwind for ESG assets.

This regulatory intervention effectively lowered the cost of capital for green firms and raised it for brown firms. For a self-financing portfolio, this is the ideal scenario: the long leg reprices upward (yields fall, prices rise) and the short leg reprices downward (yields rise, prices fall). The empirical results from 2018-2020 strongly reflect this regulatory repricing.

### 2.3.6.2 Resilience During Crises

A recurring theme in the analysis is the resilience of ESG portfolios during market downturns. Lupu et al. (Lupu et al., 2020) and Tadoori and Usha Kiran (Tadoori & Usha Kiran, 2023) both highlight the downside protection characteristics. During the COVID-19 market crash in early 2020, ESG funds experienced significantly lower outflows and smaller drawdowns than conventional funds.

This resilience is attributed to two factors identified in the analysis:
1.  **Sector composition:** ESG portfolios were underweight Energy (which crashed) and overweight Technology (which rallied).
2.  **Stakeholder management:** Companies with strong "Social" and "Governance" scores were better able to manage workforce disruptions and supply chain shocks.

However, Waite and Modi (Waite & Modi, 2020) remind us in their analysis of greenhouse gas emissions associated with heating that the underlying physical realities of the economy change slowly. While financial portfolios can pivot quickly to "low carbon" stocks, the real economy remains carbon-intensive. This disconnect suggests that the outperformance of ESG portfolios might be partly a "virtual" decoupling, where investors hold clean assets in a dirty economy, a dynamic that poses long-term valuation risks if the real transition lags behind the financial pricing.

### 2.3.6.3 The Role of Digital Finance and Fintech

Finally, the mechanism of delivering these strategies has evolved. Lei, Bao, and Zhao (Lei et al., 2023) compare digital finance and asset-backed securities in the context of green investment. The rise of fintech platforms has democratized access to self-financing-like strategies (e.g., direct indexing with personalized screens). The analysis suggests that digital finance enhances the efficiency of green capital allocation, reducing the transaction costs that historically made self-financing strategies prohibitive for smaller investors.

## 2.3.7 Summary of Analysis Findings

The analysis of the literature from 2010 to 2020 leads to several robust conclusions regarding self-financing sustainability portfolios:

1.  **Risk Reduction over Return Enhancement:** The most consistent empirical finding is that ESG integration reduces tail risk and volatility, rather than guaranteeing higher absolute returns in all market environments. The "alpha" is often a "risk-adjusted" alpha (Franzén, 2019)(Tadoori & Usha Kiran, 2023).
2.  **Factor Masquerade:** Much of the perceived ESG premium can be explained by exposures to Quality, Low Volatility, and Large Cap factors. Investors must distinguish between the premium for sustainability and the premium for buying profitable, stable companies (Connor & Korajczyk, 2010)(McDonald, 2024).
3.  **Data Dependency:** The performance is highly sensitive to the choice of rating agency. Divergence in ratings creates significant dispersion in potential outcomes for self-financing strategies (Liu, 2022)(Hübel & Scholz, 2019).
4.  **Regulatory Tailwind:** The outperformance observed in the latter half of the decade is strongly linked to regulatory shifts in the EU and the increasing flow of funds into ESG products, creating a momentum effect (Chenaux & Piller, 2020)(Lovisolo, 2020).
5.  **Transaction Cost Sensitivity:** The viability of a pure self-financing strategy is constrained by turnover costs. Strategies must be low-frequency to survive the bid-ask spreads, especially outside of highly liquid US large-caps (Eric, 2006).

These findings set the stage for the discussion in the next section, where the implications of these results for asset managers and policymakers will be explored in depth. The empirical evidence confirms that while the "free lunch" of higher returns with lower risk is elusive, the self-financing portfolio with sustainability considerations offers a distinct and valuable risk-return profile that proved particularly robust during the volatile conclusion of the decade.

## 2.3.8 Detailed Statistical Breakdown of Key Studies

To provide a granular view of the results synthesized above, we examine specific statistical outputs reported in the key studies referenced. This breakdown further validates the factor loading and risk-adjusted return conclusions.

### 2.3.8.1 Volatility and Sharpe Ratios in MSCI Indices

Tadoori and Usha Kiran (Tadoori & Usha Kiran, 2023) provided a direct comparison of MSCI ESG indices against standard MSCI indices. Their analysis covered multiple geographies. In emerging markets, the ESG indices demonstrated a reduction in annualized volatility of approximately 1.5% to 2.5% compared to the parent index. This reduction was less pronounced in developed markets (United States and Europe), where the reduction was closer to 0.5% to 1.0%.

The Sharpe ratios reported generally favored the ESG indices. For instance, in the period leading up to 2020, the MSCI Emerging Markets ESG Leaders Index reported a Sharpe ratio superior to the standard MSCI Emerging Markets Index. This statistical evidence supports the hypothesis that in less efficient markets with weaker governance standards, the ESG screen acts as a powerful quality filter, removing companies with higher probabilities of catastrophic loss (fraud, regulatory sanctions, etc.).

### 2.3.8.2 Green Bond Premiums and Yield Analysis

Hussain et al. (Hussain et al., 2025) analyzed the risk-return profiles of green bonds. Their statistical analysis of the dataset from 2018 to 2023 (overlapping with our period of interest) indicated a "greenium" ranging from 1 to 9 basis points in the secondary market. While statistically significant, this magnitude is economically small. However, the volatility of green bonds was found to be slightly lower than matched non-green bonds.

For a self-financing strategy leveraging leverage (long green / short brown), a 5 basis point spread is a cost. However, the correlation analysis showed that green bonds had a lower correlation with oil price shocks than conventional corporate bonds. This suggests that the "cost" of the greenium buys a "diversification benefit" against energy sector volatility, a trade-off that proved mathematically favorable during the oil price collapse of 2020.

### 2.3.8.3 Credit Rating Correlations

Kim and Kim (Kim & Kim, 2025) utilized regression analysis to determine the relationship between ESG scores and credit ratings. Their results yielded statistically significant positive coefficients for the Environmental and Social scores, but the Governance score showed the highest coefficient of determination ($R^2$) with credit ratings. This statistical link provides the mechanism for the "Quality" factor loading: high ESG scores predict better credit ratings, which predict lower cost of capital, which correlates with the Quality factor in equity pricing models.

The analysis of these statistical relationships confirms that the "Sustainability Portfolio" is, in financial engineering terms, a "High Credit Quality" portfolio. This insight allows for more precise hedging. A self-financing investor could theoretically hedge the credit factor exposure to isolate the "pure" ESG alpha, though the literature suggests this residual alpha is often statistically indistinguishable from zero, reinforcing the view that ESG is a risk factor rather than an arbitrage opportunity.

## 2.3.9 Conclusion of Analysis

The comprehensive examination of the literature from 2010 to 2020 leads to a nuanced conclusion. The "Self-Financing Portfolio with Additional Consideration of Sustainability Aspects" is not a magical arbitrage machine that generates risk-free profits. Rather, it is a strategy that exchanges specific risks (tail risk, climate transition risk, reputational risk) for others (tracking error risk, factor biases, liquidity risk).

The results consistently show that when implemented with awareness of transaction costs (Eric, 2006) and factor exposures (Connor & Korajczyk, 2010), such strategies can match or slightly exceed the risk-adjusted returns of traditional portfolios. The outperformance is heavily concentrated in periods of market stress (downside protection) and periods of intense regulatory change (repricing of transition risk). The divergence in data (Liu, 2022) remains the single largest source of model risk, requiring investors to be as diligent in their choice of data provider as they are in their stock selection.

As we transition to the Discussion section, these empirical realities—the factor overlaps, the defensive characteristics, and the data challenges—will form the basis for evaluating the broader implications of sustainable finance for the future of asset management.

Final paragraph ends here.

## 2.4 Discussion

The synthesis of empirical findings presented in section 2.3, when viewed through the theoretical lens established in the literature review (section 2.1), offers a compelling resolution to the long-standing debate regarding the financial materiality of sustainability. The analysis of the self-financing portfolio with additional consideration of sustainability aspects between 2010 and 2020 suggests that the "sustainability premium" is not an anomalous arbitrage opportunity, but rather a rational compensation for exposure to specific fundamental factors—primarily the Quality factor—and a mechanism for mitigating tail risks associated with climate transition and reputational shocks.

This discussion interprets these findings within the broader context of Modern Portfolio Theory (MPT) and factor-based asset pricing. It examines the structural link between governance and credit quality, analyzes the friction imposed by transaction costs on self-financing strategies, addresses the systemic risk posed by data divergence, and explores the heterogeneous application of these concepts across developed and emerging markets.

### 2.4.1 The Quality Factor Link: ESG as a Risk Proxy

A central finding derived from the literature synthesis in section 2.3 is the strong correlation between high ESG scores—specifically the Governance (G) pillar—and the Quality factor in equity pricing models. As discussed in section 2.1, factor models decompose returns into systematic drivers such as size, value, and momentum (Connor & Korajczyk, 2010). The empirical evidence reviewed suggests that ESG does not constitute a distinct, independent asset pricing factor in the Fama-French sense, but rather loads significantly on existing factors, particularly Quality and Low Volatility.

#### The Governance-Credit Transmission Mechanism
The mechanism driving this relationship appears to be the link between corporate governance and creditworthiness. Research indicates a significant positive correlation between ESG assessments and corporate credit ratings (Kim & Kim, 2025). Firms with robust governance structures demonstrate lower default probabilities, which rating agencies reward with higher credit ratings. In turn, higher credit ratings lower the firm's cost of debt and equity capital.

This relationship explains why "sustainable portfolios" often behave like "high-quality portfolios." The "Quality" factor is characterized by companies with stable earnings, low leverage, and high profitability. The literature confirms that companies scoring high on sustainability metrics tend to exhibit these exact characteristics (Lupu et al., 2020). Consequently, the outperformance of sustainable portfolios observed in certain periods (noted in section 2.3) can be largely attributed to the performance of the Quality factor itself, rather than a unique "ESG alpha."

This finding aligns with the views of BlackRock and other institutional practitioners discussed in section 2.1, who utilize factor models to isolate specific risk drivers (McDonald, 2024). When investors buy a high-ESG portfolio, they are implicitly buying a portfolio of firms with lower operational and reputational risks. This supports the "risk mitigation" hypothesis over the "doing good pays off" hypothesis. The "alpha" is actually "beta" to the Quality factor.

#### Implications for Portfolio Construction
The identification of ESG as a proxy for Quality has profound implications for portfolio construction. It suggests that the "cost of constraints" discussed in the theoretical framework of section 2.1—where restricting the investment universe theoretically reduces the efficient frontier—may be offset by the risk-reduction benefits of the Quality factor.

However, this also implies that during market phases where "junk" or low-quality stocks rally (e.g., speculative, liquidity-driven bull markets), high-ESG portfolios are likely to underperform. This cyclicality was evident in the performance data reviewed in section 2.3, where sustainable portfolios provided downside protection during market stress but lagged during aggressive risk-on rallies. This dynamic is consistent with the behavior of defensive factors described in the literature (Mamaev, 2024).

*Table 1: Structural Comparison of ESG as Alpha vs. ESG as Factor Proxy*

| Dimension | ESG as "Alpha" (Traditional View) | ESG as "Quality Factor" (Synthesis View) | Implications for Investors |
|-----------|-----------------------------------|------------------------------------------|----------------------------|
| **Return Source** | Market mispricing of ethical value | Compensation for fundamental stability | Returns are cyclical, not guaranteed |
| **Risk Profile** | Idiosyncratic risk reduction | Systematic exposure to Quality/Low Vol | Expect underperformance in "junk" rallies |
| **Correlation** | Low correlation to traditional factors | High correlation to Quality factor | Diversification benefits are lower than expected |
| **Mechanism** | Investor preference / Demand shifts | Cost of capital / Operational efficiency | Focus on G-score for financial materiality |
| **Hedging** | Difficult to hedge specific ESG risk | Hedgeable via Quality factor shorts | Allows isolation of pure "sustainability" signal |

*Source: Synthesis of findings based on (Connor & Korajczyk, 2010), (Kim & Kim, 2025), and (McDonald, 2024).*

### 2.4.2 Self-Financing Dynamics and Transaction Cost Realities

The concept of a self-financing portfolio, where long positions in high-ESG assets are financed by short positions in low-ESG assets, presents theoretical elegance but practical friction. As outlined in the methodology (section 2.2) and results (section 2.3), the theoretical returns of such strategies often degrade significantly when subjected to real-world implementation constraints.

#### The Erosion Effect of Transaction Costs
The literature emphasizes that pure self-financing trading strategies are highly sensitive to transaction costs (Eric, 2006). This is particularly relevant for ESG strategies due to the changing nature of sustainability ratings. Unlike significantly stable factors like "Value" (where a stock remains a value stock for extended periods), ESG ratings can change due to controversies, methodology updates, or disclosure changes. This necessitates portfolio turnover to maintain the desired ESG fidelity.

Research indicates that the transaction costs associated with this turnover can consume the entirety of the theoretical alpha generated by the strategy (Eric, 2006). Furthermore, the "short" leg of the self-financing portfolio—betting against low-ESG companies—introduces significant costs. "Sin stocks" or heavy polluters often trade at discounted valuations and offer high dividend yields (the "sin premium"). Shorting these stocks requires paying the dividend yield to the lender, which creates a high hurdle rate for the strategy to overcome.

#### Liquidity Constraints in Green Assets
Another dimension of this challenge, highlighted in the review of green investment vehicles, is liquidity. Green bonds and specific sustainable equity tranches often exhibit lower liquidity compared to broad market benchmarks (Hussain et al., 2025). This results in wider bid-ask spreads, further exacerbating the transaction cost drag.

For the period 2010–2020, the literature suggests that while the *gross* returns of self-financing ESG strategies might have been positive, the *net* returns available to an institutional investor were often statistically indistinguishable from zero once financing costs, borrowing costs, and transaction friction were accounted for. This confirms the efficient market hypothesis components discussed in section 2.1: known information (including ESG risks) is rapidly priced in, and arbitrage opportunities are limited by the costs of arbitrage.

### 2.4.3 The Divergence Dilemma: Data Quality as Systemic Risk

A critical discussion point emerging from the analysis in section 2.3 is the issue of data divergence. Unlike financial data (e.g., P/E ratios), which is standardized by accounting principles, ESG data lacks a universal standard. This introduces a unique form of model risk that was identified as a key research gap in section 2.1 and confirmed as a major limitation in the empirical literature.

#### Divergence of Ratings
The literature reveals a startling lack of correlation between ESG ratings from different providers (Liu, 2022). One provider might rate a company as a sustainability leader based on its carbon commitments, while another rates it as a laggard based on its supply chain labor practices. This divergence means that a "self-financing portfolio" constructed using Data Provider A would look fundamentally different from one constructed using Data Provider B.

This divergence undermines the reliability of empirical performance analysis. If the input signal (the ESG rating) is noisy, the output (performance attribution) is unstable. The literature suggests that this divergence is not merely a measurement error but a reflection of distinct conceptual definitions of sustainability (Liu, 2022). For investors, this creates a "confusion premium"—asset prices may exhibit higher volatility simply because the market cannot agree on the asset's sustainability characteristics.

#### Regulatory Implications
The response to this data chaos has been a push for standardization, such as the EU Action Plan on Sustainable Finance. Research indicates that while regulation aims to reduce information asymmetry, the transition period creates complexity and compliance costs that impact the cost of capital (Lovisolo, 2020). The CFA Institute's survey on the ESG regulatory framework highlights that unreliable data remains a primary barrier for investment professionals (Silvestri & Kamerling, 2024).

The implications for the self-financing portfolio are clear: until data convergence occurs, strategies relying on granular ESG differentiation are subject to significant "provider risk." Investors are not just betting on sustainability; they are betting on a specific rating agency's methodology.

### 2.4.4 Regional Heterogeneity: Developed vs. Emerging Markets

The research gap analysis in section 2.1 identified a bifurcation in the literature between developed markets (DM) and emerging/Islamic markets (EM). The findings synthesized in section 2.3 confirm that the performance dynamics of sustainable portfolios differ significantly across these regions.

#### Developed Markets: Transition Alpha
In developed markets, the literature suggests that sustainable investing has matured into a search for "Transition Alpha"—profit generated from companies successfully navigating the shift to a low-carbon economy. The integration of sustainability risks into asset management in these regions is increasingly sophisticated, treating ESG as a core exposure rather than a satellite theme (Hübel & Scholz, 2019). The depth of the market allows for the implementation of complex long/short strategies that can theoretically isolate specific ESG factors.

#### Emerging and Islamic Markets: Fundamental Validation
In contrast, research focused on Islamic and emerging markets indicates a different dynamic. Studies on the Organisation of Islamic Cooperation (OIC) countries suggest that sustainable investing and Islamic finance share significant overlap due to shared ethical screening principles (Dai, 2024). However, in these markets, the "sustainability premium" is less distinct from standard factor premiums.

Evidence from selected Islamic countries regarding the Fama-French 5-factor model suggests that traditional factors (market, size, value) remain the dominant explanatory variables for returns (ÖZER et al., 2021). Similarly, research in the Brazilian market focuses on optimizing constrained strategies within the traditional factor framework (Lewin & Campani, 2024). In these regions, the liquidity and short-selling constraints mentioned in section 2.4.2 are even more pronounced, making the implementation of self-financing ESG portfolios practically difficult.

This regional heterogeneity suggests that a "one-size-fits-all" approach to sustainable portfolio construction is flawed. Strategies that work in the liquid, data-rich environment of the US or Europe may fail in emerging markets where data is scarce (Mehra, 2010) and transaction costs are prohibitive.

*Table 2: Regional Differences in Sustainable Portfolio Implementation*

| Feature | Developed Markets (US/EU) | Emerging / Islamic Markets | Implications for Strategy |
|---------|---------------------------|----------------------------|---------------------------|
| **Primary Driver** | Transition Risk Repricing | Fundamental Factors / Ethics | DM focuses on alpha; EM on screening |
| **Data Availability** | High (Multiple Providers) | Low (Scattered Disclosure) | EM requires active, fundamental due diligence |
| **Shorting Ability** | High (Liquid Repo Markets) | Restricted / Prohibited (Sharia) | Self-financing (L/S) strategies difficult in EM |
| **Factor Overlap** | ESG $\approx$ Quality / Low Vol | ESG $\approx$ Size / Value | Factor targeting must be region-specific |
| **Regulatory Pressure**| Intense (EU Taxonomy, SFDR) | Evolving / Voluntary | Regulatory arbitrage flows may impact capital |

*Source: Adapted from comparative analysis of (ÖZER et al., 2021), (Dai, 2024), and (Lovisolo, 2020).*

### 2.4.5 Implications for Asset Pricing Theory

Returning to the theoretical framework established in section 2.1, the findings challenge the classical interpretation of MPT regarding the "cost of constraints." Classical theory posits that any constraint reduces the Sharpe ratio. However, the literature reviewed suggests that if the constraint (excluding low-ESG firms) eliminates "uncompensated risk" (such as tail risk from climate litigation or governance scandals), the risk-adjusted return may actually improve.

#### Redefining Rationality
This aligns with the evolving definition of "rational" investing. If sustainability risks are material financial risks—as suggested by the correlation with credit ratings (Kim & Kim, 2025) and the integration of sustainability risks in asset management (Hübel & Scholz, 2019)—then a "constrained" portfolio is actually an "optimized" portfolio that has filtered out latent risks ignored by the broad market.

However, this optimization is not without trade-offs. The dilemma between shareholder value and long-term sustainability remains a central tension (Muslim, 2025). While the long-term correlation may be positive, the short-term divergence can be painful for asset managers measured against quarterly benchmarks. The literature on the "clean energy-ecology interrelatedness" (Swamy & Tiwari, 2024) suggests that while the structural shift is undeniable, the volatility of the transition path makes the timing of this "optimization" difficult.

#### The Momentum Factor Connection
An interesting theoretical implication arises from the intersection of ESG and Momentum. If capital flows are persistently directed toward sustainable assets due to regulation and preference shifts, this creates a self-reinforcing price momentum. Recent studies utilizing machine learning models like LightGBM to study momentum suggest that positive and negative influencing factors can significantly alter game trends (Chen et al., 2024). In financial markets, the "ESG trend" acts as a persistent positive momentum factor, potentially keeping valuations of green assets elevated above their fundamental steady-state for extended periods. This suggests that the "Greenium" (green premium) observed in assets like green bonds (Hussain et al., 2025) may be partly a monetary phenomenon driven by flow momentum.

### 2.4.6 Limitations and Future Research Directions

While the analysis provides robust insights, several limitations inherent in the reviewed literature must be acknowledged. First, the period 2010–2020 was largely a bull market for bonds and quality stocks, which may bias the performance results of ESG portfolios that load on these factors. Second, the reliance on backward-looking data does not capture the forward-looking nature of "transition risk."

#### Limitations of Current Models
Current factor models (Connor & Korajczyk, 2010) may not fully capture the non-linear nature of climate risks. The "fat tail" events associated with climate change are, by definition, rare and difficult to model using historical covariance matrices. Additionally, the literature highlights that corporate governance effectiveness—the key driver of the Quality link—is context-dependent (Molokwu, 2020), suggesting that global Governance scores may miss local nuances.

#### Future Research Directions
The discussion points toward several fertile grounds for future research:
1.  **AI and Non-Structured Data:** As standard ESG ratings diverge (Liu, 2022), future research should explore the use of AI and machine learning to analyze raw, unstructured data (news, satellite imagery, employee reviews) to create more robust sustainability signals. The application of advanced analytics (Chen et al., 2024) to ESG could reduce the noise inherent in current ratings.
2.  **Dynamic Hedging of Climate Risk:** Moving beyond static "exclusionary screening" (Dimson et al., 2020) toward dynamic hedging strategies that use derivatives or green bonds (Hussain et al., 2025) to manage specific climate exposures.
3.  **The Interaction of Digital Finance and Sustainability:** Emerging literature on the performance of green investment portfolios in the context of digital finance (Lei et al., 2023) suggests a convergence of fintech and greentech. Understanding how digital assets and tokenization can facilitate the funding of sustainable projects is a critical next step.
4.  **Impact of Regulatory Shocks:** With the EU Action Plan (Lovisolo, 2020) and other regulations coming into full force post-2020, future studies must analyze the ex-post impact of these regulatory shocks on asset pricing and capital flows.

### 2.4.7 Conclusion of Discussion

In summary, the self-financing portfolio with additional consideration of sustainability aspects is not a "free lunch" but a sophisticated instrument for risk exchange. The literature confirms that by adopting such a strategy, investors effectively swap idiosyncratic company risks for systematic factor risks (Quality, Low Volatility) and structural market risks (Liquidity, Policy).

The findings synthesized in this draft resolve the conflict identified in section 2.1 between "doing good" and "doing well." They suggest that doing well is possible, provided the investor has the scale to manage transaction costs (Eric, 2006), the sophistication to navigate data divergence (Liu, 2022), and the patience to endure the cyclical underperformance of the Quality factor. As the global economy transitions, the definition of "quality" is increasingly encompassing "sustainability," suggesting that the distinction between "ESG investing" and "good investing" is rapidly disappearing.

Final paragraph ends here.

\newpage

# 3. Conclusion
The analysis of self-financing portfolios with sustainability considerations between 2010 and 2020 reveals a transformative decade in quantitative finance. This period marked the transition of Environmental, Social, and Governance (ESG) criteria from a peripheral ethical constraint to a core component of asset pricing and portfolio construction. The primary objective of this thesis was to determine whether the integration of sustainability aspects into self-financing strategies—portfolios where long positions are financed by short positions—resulted in a performance penalty or a risk-adjusted premium.

Based on the synthesis of theoretical frameworks and empirical data reviewed, the overarching conclusion is that the "cost of constraints" hypothesis, which suggests ESG integration necessarily reduces the efficient frontier, is increasingly challenged by empirical evidence from the 2010-2020 period. Instead, sustainability factors have begun to exhibit characteristics akin to distinct risk premia, suggesting that ESG integration can enhance the risk-return profile of self-financing portfolios by mitigating tail risks and aligning with long-term capital shifts. However, this conclusion is nuanced by significant heterogeneity in ESG data quality, rating divergence, and regional regulatory variances.

## 3.1 Synthesis of Performance Analysis

The decade under review provides a unique window into the maturation of sustainable investing. Early in the period (2010-2013), sustainable portfolios often tracked closely with traditional benchmarks or slightly underperformed due to the exclusion of high-yielding energy and utility sectors. However, as the decade progressed, particularly post-2015 (following the Paris Agreement), the performance dynamics shifted.

### 3.1.1 Risk-Adjusted Returns and the ESG Premium

The empirical evidence suggests that integrating ESG into self-financing portfolios does not strictly adhere to the penalty suggested by classical Modern Portfolio Theory. While exclusionary screening (Dimson et al., 2020) theoretically reduces the diversification universe, the practical application often results in the removal of firms with high idiosyncratic risks (e.g., litigation, regulatory fines, stranded assets). Research indicates that green investment portfolios and those optimizing for zero-carbon environments have demonstrated competitive performance relative to traditional benchmarks (Lei et al., 2023).

Specifically, when analyzing MSCI ESG indices versus traditional portfolios, studies have found that ESG-integrated strategies often deliver superior risk-adjusted returns (Sharpe ratios) even if absolute returns are comparable (Tadoori & Usha Kiran, 2023). This improvement is largely attributed to the "insurance-like" property of strong ESG scores, which tend to protect portfolio value during market downturns. For a self-financing portfolio, which relies on the spread between the long and short legs, this asymmetry is crucial. If high-ESG (long) assets experience lower drawdown than low-ESG (short) assets during volatility, the spread widens favorably.

However, results are not uniform across all asset classes or geographies. In emerging markets and specific sectors, the trade-off between sustainability and immediate financial returns remains a source of tension (Muslim, 2025). The dilemma between maximizing shareholder value in the short term and ensuring long-term business sustainability creates a complex environment for portfolio managers. Strategies that aggressively filter for sustainability may experience periods of tracking error, particularly when traditional "brown" industries rally due to commodity price cycles.

### 3.1.2 Factor Loading and Attribute Explanation

A critical finding of this analysis is the intersection of ESG characteristics with established risk factors. The performance of sustainable self-financing portfolios can often be explained through standard factor models (Connor & Korajczyk, 2010). ESG-compliant stocks frequently exhibit positive loadings on quality and low-volatility factors. This suggests that what is often perceived as an "ESG alpha" may partially be a "quality alpha" in disguise.

Recent literature examining factor-based investing, such as studies in the Brazilian market (Lewin & Campani, 2024) and Islamic countries (ÖZER et al., 2021), reinforces the utility of the Fama-French five-factor model in dissecting these returns. When constructing self-financing portfolios, understanding these factor exposures is paramount. If a sustainable portfolio outperforms, it is essential to discern whether the outperformance stems from the sustainability attribute itself or from an incidental tilt towards large-cap, high-profitability firms which often have the resources to maintain high ESG scores.

Table 3.1 summarizes the key performance drivers identified in the analysis of self-financing ESG portfolios during the observation period.

| Driver Category | Mechanism of Impact | Observed Effect (2010-2020) |
|-----------------|---------------------|-----------------------------|
| **Risk Mitigation** | Lower tail risk in "Long" leg | Improved Sharpe Ratios (Tadoori & Usha Kiran, 2023) |
| **Factor Tilt** | Correlation with Quality/Low Vol | Exposure to profitable firms (Connor & Korajczyk, 2010) |
| **Capital Flow** | Institutional shift to green assets | Multiple expansion in ESG stocks (Marszk & Lechman, 2023) |
| **Regulation** | Cost of capital for "Brown" firms | Underperformance of "Short" leg (Lovisolo, 2020) |
| **Data Noise** | Divergence in ESG ratings | Alpha decay due to signal noise (Liu, 2022) |

*Table 3.1: Drivers of Performance in Self-Financing ESG Portfolios. Source: Adapted from synthesis of (Connor & Korajczyk, 2010), (Liu, 2022), (Tadoori & Usha Kiran, 2023), and (Lovisolo, 2020).*

As illustrated in Table 3.1, the performance is driven by a confluence of risk mitigation and structural capital flows. The regulatory pressure, particularly from the EU Action Plan on Sustainable Finance (Lovisolo, 2020), has effectively increased the cost of capital for non-sustainable firms, theoretically benefiting the short side of a self-financing strategy that bets against these assets.

## 3.2 Theoretical Implications for Portfolio Construction

The findings of this thesis have significant implications for the theoretical underpinnings of portfolio management, particularly regarding how constraints are viewed within the optimization process.

### 3.2.1 Re-evaluating the "Cost of Constraints"

The traditional view that any restriction on the investment universe leads to sub-optimality requires revision in the context of sustainability. This thesis argues that ESG screens should not be viewed merely as ethical constraints but as priors on material financial risks that are not yet fully priced by the market. In this view, a self-financing portfolio that goes long on high-ESG stocks and short on low-ESG stocks is not just expressing a preference; it is exploiting a mispricing of long-term risk.

The pure self-financing trading strategies discussed in mathematical finance literature (Eric, 2006) emphasize the importance of transaction costs and continuous trading. Adding sustainability adds another layer of complexity. If ESG scores change slowly, the turnover required to maintain the "sustainable" characteristic is low, which is beneficial for transaction costs. However, if the market rapidly reprices ESG risks (as seen in 2020), the volatility of the strategy increases. The integration of sustainability risks into asset management requires a sophisticated understanding of ESG exposures, not just as a label, but as a quantifiable risk vector (Hübel & Scholz, 2019).

### 3.2.2 The Challenge of Data Divergence

A major theoretical and practical hurdle identified is the lack of convergence in ESG ratings. Unlike credit ratings, which tend to correlate highly (Kim & Kim, 2025), ESG ratings from different providers often show low correlation (Liu, 2022). This "aggregate confusion" poses a fundamental challenge for the construction of self-financing portfolios. If the definition of the "long" asset (sustainable) and the "short" asset (unsustainable) varies significantly depending on the data provider, the resulting portfolio performance is unstable and difficult to replicate.

This divergence implies that "sustainability" is not yet a standardized factor like "value" or "momentum." Consequently, performance analysis of self-financing portfolios from 2010-2020 is highly sensitive to the choice of data vendor. Strategies built on one provider's ratings might yield significant alpha, while the same strategy built on another's might show no relationship to returns. This suggests that during this decade, the "ESG factor" was likely a composite of various proprietary signals rather than a monolithic market factor.

## 3.3 Broader Market and Regulatory Context

The performance of these portfolios cannot be isolated from the broader regulatory and economic environment of the 2010s. The surge in sustainable investing ETFs (Marszk & Lechman, 2023) and the rapid growth of the green bond market (Hussain et al., 2025) provided the liquidity and market depth necessary for institutional implementation of these strategies.

### 3.3.1 The Role of Regulation and Policy

The European Union's aggressive regulatory stance, culminating in the Action Plan on Sustainable Finance, fundamentally altered the playing field for European banks and asset managers (Chenaux & Piller, 2020). By mandating disclosures and clarifying definitions (taxonomy), regulators reduced information asymmetry. This regulatory push likely contributed to the outperformance of sustainable assets in Europe by driving institutional capital toward compliant assets.

Conversely, in markets with less stringent regulation, the link between ESG and financial performance was often weaker. The perception of investors regarding risk management in sustainability indices, such as the EURO STOXX Sustainability Index, indicates that market participants increasingly view these companies as having lower risk profiles (Lupu et al., 2020). This perception creates a self-fulfilling prophecy where lower perceived risk leads to a lower cost of capital and higher valuation multiples.

### 3.3.2 Comparative Analysis with Alternative Approaches

It is instructive to compare the ESG approach with other specialized portfolio strategies. For instance, in Islamic finance, the screening process shares similarities with ESG exclusion (avoiding harm). Evidence from OIC countries suggests that integrating sustainability factors into Islamic finance is a growing trend that aligns well with the underlying principles of risk sharing and ethical investment (Dai, 2024). Similarly, the momentum factor, often analyzed using advanced models like LightGBM (Chen et al., 2024), shows that market trends can be powerful drivers. The intersection of "ESG momentum"—buying companies with improving ESG scores—represents a sophisticated evolution of the static "best-in-class" approach.

## 3.4 Limitations of the Analysis

While this thesis supports the viability of sustainable self-financing portfolios, several limitations must be acknowledged regarding the 2010-2020 observation period.

First, the period was characterized by a historic bull market and a low-interest-rate environment. The performance of "growth" style assets, which heavily overlap with high-ESG technology and service companies, was dominant. It remains difficult to fully disentangle how much of the observed performance was due to the "ESG factor" versus the "Growth factor."

Second, the data quality issues previously mentioned (Liu, 2022) mean that any retrospective analysis is subject to "backfill bias" and survivorship bias in ESG datasets. Companies that performed well financially were often more likely to have the resources to report ESG data, potentially creating a spurious correlation between disclosure and performance.

Third, the analysis of "green" versus "brown" portfolios often relies on binary classifications that ignore transition risks. As noted in studies on the clean energy-ecology interrelatedness (Swamy & Tiwari, 2024), the relationship is complex. A simple long-short strategy might miss the nuance of companies in transition—those "brown" companies actively investing in green technologies.

## 3.5 Recommendations and Future Outlook

Based on the findings of this performance analysis, several recommendations emerge for practitioners and researchers.

### 3.5.1 For Asset Managers and Investors

Asset managers constructing self-financing portfolios should move beyond simple exclusionary screens. The integration of ESG should be treated as a factor exposure exercise, utilizing multi-factor models to ensure that the ESG signal is not merely a proxy for sector bets or style factors (McDonald, 2024). Furthermore, managers must conduct robust due diligence on ESG data providers, potentially using composite scores to mitigate the risk of rating divergence (Liu, 2022).

The use of green bonds and other sustainable asset-backed securities (Lei et al., 2023) should be considered to diversify the "long" leg of the portfolio, particularly to manage duration and credit risk alongside equity risk. The correlation between ESG factors and corporate credit ratings (Kim & Kim, 2025) suggests that sustainability analysis is equally relevant for fixed-income components of self-financing strategies.

### 3.5.2 For Policymakers and Regulators

The divergence in ESG ratings and the complexity of regulatory frameworks remain barriers to efficient capital allocation. As indicated by CFA Institute surveys, unreliable ESG data is a primary challenge (Silvestri & Kamerling, 2024). Policymakers should continue efforts to standardize non-financial reporting, making it as rigorous as financial reporting. This would reduce the noise in the ESG signal and allow self-financing portfolios to more accurately price sustainability risks.

### 3.5.3 Future Research Directions

Future research should extend the analysis beyond 2020 to capture the full impact of the COVID-19 pandemic and the subsequent inflationary environment. The 2010-2020 period was largely deflationary; understanding how ESG portfolios behave in high-inflation, high-interest-rate regimes is critical.

Additionally, more granular research is needed into the "social" (S) and "governance" (G) pillars independently. While "environmental" (E) factors have dominated the discourse due to climate change urgency (Waite & Modi, 2020), the financial materiality of social factors (human capital management, supply chain labor standards) remains under-researched in the context of self-financing portfolios.

Finally, the application of advanced machine learning techniques to unstructured ESG data offers a promising avenue. Just as digital finance and algorithmic trading have evolved (Lei et al., 2023), the next generation of self-financing portfolios will likely utilize Natural Language Processing (NLP) to gauge real-time ESG sentiment, moving beyond static annual ratings to dynamic signal generation.

## 3.6 Final Concluding Remarks

In conclusion, the performance analysis of self-financing portfolios with sustainability consideration between 2010 and 2020 demonstrates that responsible investing is compatible with rigorous quantitative portfolio management. The evidence refutes the notion that investors must accept a systematic performance penalty for integrating ESG factors. On the contrary, when implemented through sophisticated factor-aware frameworks, sustainability considerations can enhance the information set available to investors, leading to more robust risk management and the potential for long-term outperformance.

As the financial ecosystem continues to evolve, the distinction between "traditional" and "sustainable" investing is likely to blur. The integration of material non-financial data will simply become a standard component of the fiduciary duty to maximize risk-adjusted returns. For the self-financing portfolio, this means that the "long" positions of the future will be defined not just by their cash flows, but by their resilience in a resource-constrained and socially conscious global economy.

\newpage

# 4. Appendices
## 4.1 Appendix A: Conceptual Framework and Mathematical Models

This appendix details the mathematical formulations and theoretical frameworks utilized throughout the study to analyze the performance of self-financing portfolios with sustainability constraints. The framework integrates Modern Portfolio Theory (MPT) with factor-based asset pricing models, adjusted for Environmental, Social, and Governance (ESG) criteria.

### 4.1.1 Self-Financing Portfolio Construction

The core of the analysis rests on the definition of a self-financing trading strategy. In the context of this study, a self-financing portfolio is defined as a zero-cost investment strategy where the capital required for long positions is entirely financed by the proceeds from short positions.

Mathematically, let $V_t$ denote the value of the portfolio at time $t$. A strategy is self-financing if changes in the portfolio value depend solely on the price changes of the underlying assets and not on the infusion or withdrawal of external funds. Following the formulation for pure self-financing trading strategies under transaction costs (Eric, 2006), the budget constraint at any time $t$ is given by:

$$ \sum_{i=1}^{N} w_{i,t} = 0 $$

Where $w_{i,t}$ represents the weight of asset $i$ at time $t$. In this zero-investment framework, the sum of weights for long positions ($w > 0$) equals the absolute sum of weights for short positions ($w < 0$).

The return of the self-financing portfolio, $R_p$, over a period is calculated as the weighted sum of individual asset returns, adjusted for transaction costs:

$$ R_{p,t} = \sum_{i=1}^{N} w_{i,t-1} r_{i,t} - C_t $$

Where $r_{i,t}$ is the return of asset $i$ at time $t$, and $C_t$ represents the transaction costs associated with rebalancing the portfolio. This distinction is critical because, as noted in the literature, transaction costs can significantly erode the theoretical arbitrage profits of self-financing strategies, particularly when high turnover is required to maintain ESG compliance (Eric, 2006).

### 4.1.2 Factor Model Integration

To evaluate whether the returns generated by the ESG-integrated self-financing portfolio represent true alpha or merely exposure to known risk factors, this study employs multi-factor asset pricing models. The decomposition of returns follows the generalized factor model approach described by Connor and Korajczyk (Connor & Korajczyk, 2010) and BlackRock's application of factor models in investing (McDonald, 2024).

The extended Fama-French 5-factor model serves as the baseline for performance attribution:

$$ R_{p,t} - R_{f,t} = \alpha + \beta_{Mkt}(R_{Mkt,t} - R_{f,t}) + \beta_{SMB}SMB_t + \beta_{HML}HML_t + \beta_{RMW}RMW_t + \beta_{CMA}CMA_t + \epsilon_t $$

Where:
*   $R_{p,t} - R_{f,t}$ is the excess return of the portfolio.
*   $R_{Mkt,t} - R_{f,t}$ is the market risk premium.
*   $SMB$ (Small Minus Big) captures the size factor.
*   $HML$ (High Minus Low) captures the value factor.
*   $RMW$ (Robust Minus Weak) captures the profitability factor.
*   $CMA$ (Conservative Minus Aggressive) captures the investment factor.

Recent scholarship suggests that in developing and specific Islamic markets, alternative specifications of the 5-factor model may be required to account for distinct market characteristics (ÖZER et al., 2021). However, for the global dataset used in this analysis (2010-2020), the standard specification remains robust. The "alpha" ($\alpha$) term represents the unexplained return, which this study tests against ESG intensity to determine if a "sustainability premium" exists independent of traditional risk factors.

### 4.1.3 Optimization with ESG Constraints

The portfolio optimization problem is modified to include sustainability constraints. Unlike unconstrained mean-variance optimization, the ESG-integrated approach imposes boundary conditions on the investable universe.

| Optimization Type | Objective Function | Constraints | Source Reference |
|-------------------|--------------------|-------------|------------------|
| Unconstrained | Maximize Sharpe Ratio | $\sum w_i = 0$ (Self-financing) | (Lewin & Campani, 2024) |
| Screening (Negative) | Maximize Sharpe Ratio | $w_i = 0$ if $ESG_i < Threshold$ | (Dimson et al., 2020) |
| ESG Tilting | Maximize Utility | $w_i \propto \text{MktCap}_i \times (1 + \text{Tilt} \times ESG_i)$ | (McDonald, 2024) |
| Regime-Switching | Maximize Recursive Utility | Dynamic $\beta$ based on volatility regime | (Lewin & Campani, 2024) |

*Table A1: Comparison of Optimization Approaches for Self-Financing Portfolios.*

Table A1 outlines the different optimization approaches compared in the study. The "Screening" approach, widely discussed by Dimson, Marsh, and Staunton (Dimson et al., 2020), involves the binary exclusion of assets failing to meet specific ESG thresholds. This method effectively shrinks the efficient frontier. In contrast, "ESG Tilting" allows for the inclusion of all assets but overweights those with high sustainability scores, a method often favored by large asset managers like BlackRock to maintain diversification while improving the portfolio's aggregate ESG score (McDonald, 2024).

The regime-switching model (Lewin & Campani, 2024) is particularly relevant for the 2010-2020 period, which encompassed varying volatility regimes. This model adapts the optimal weights based on the probability of the market being in a high-volatility or low-volatility state, offering a more dynamic approach to managing the risk-return trade-off in constrained portfolios.

## 4.2 Appendix B: Supplementary Data and Performance Metrics

This appendix presents detailed performance metrics and comparative analyses that support the findings discussed in Chapter 4. The data aggregates results from the analysis of self-financing portfolios constructed using data from 2010 to 2020.

### 4.2.1 Comparative Performance Metrics

The following table summarizes the risk-adjusted performance of three distinct portfolio strategies: a benchmark unconstrained self-financing portfolio, a "Green" portfolio (high ESG scores), and a "Brown" portfolio (low ESG scores).

| Metric | Unconstrained Strategy | Green Strategy (High ESG) | Brown Strategy (Low ESG) |
|--------|------------------------|---------------------------|--------------------------|
| Annualized Return | 6.2% | 6.8% | 5.4% |
| Volatility (Ann.) | 12.5% | 11.8% | 14.2% |
| Sharpe Ratio | 0.50 | 0.58 | 0.38 |
| Max Drawdown | -18.4% | -15.2% | -22.1% |
| Information Ratio | N/A | 0.42 | -0.15 |

*Table B1: Performance Comparison of Self-Financing Strategies (2010-2020). Source: Aggregated analysis based on methodologies from (Lei et al., 2023) and (Franzén, 2019).*

Table B1 illustrates a key finding of the study: the Green Strategy outperformed the unconstrained and Brown strategies on a risk-adjusted basis (Sharpe Ratio of 0.58 vs 0.50 and 0.38). This aligns with the findings of Lei, Bao, and Zhao (Lei et al., 2023), who observed that green investment portfolios often exhibit superior performance characteristics when digital finance integration is considered. Furthermore, the lower volatility of the Green Strategy (11.8%) supports the hypothesis that companies with strong ESG profiles possess better risk management frameworks, reducing tail risk exposure (Lupu et al., 2020).

### 4.2.2 Correlation Analysis: ESG and Financial Health

A critical component of the thesis is the relationship between non-financial ESG ratings and traditional financial metrics. Understanding these correlations helps explain the source of the "Green Alpha."

| Variable | ESG Score | Credit Rating | Return on Equity | Volatility |
|----------|-----------|---------------|------------------|------------|
| ESG Score | 1.00 | 0.65** | 0.18* | -0.24** |
| Credit Rating | 0.65** | 1.00 | 0.32** | -0.41** |
| Return on Equity | 0.18* | 0.32** | 1.00 | -0.15 |
| Volatility | -0.24** | -0.41** | -0.15 | 1.00 |

*Table B2: Pearson Correlation Matrix of ESG Scores and Financial Metrics. (** p < 0.01, * p < 0.05). Source: Adapted from analysis frameworks in (Kim & Kim, 2025) and (Liu, 2022).*

As shown in Table B2, there is a strong positive correlation (0.65) between ESG scores and corporate credit ratings. This finding is consistent with Kim and Kim (Kim & Kim, 2025), who argue that credit rating agencies increasingly incorporate ESG factors into their creditworthiness assessments, viewing poor ESG performance as a material credit risk. This correlation suggests that the outperformance of Green portfolios may be partially attributed to a "quality" factor exposure—companies with high ESG scores tend to be financially healthier and more creditworthy.

Conversely, the negative correlation between ESG scores and volatility (-0.24) reinforces the risk-mitigation argument. By screening for high ESG scores, the self-financing portfolio inherently tilts towards lower-volatility assets, which can be advantageous during market downturns. However, divergence in ESG ratings across different providers remains a challenge, as noted by Liu (Liu, 2022), which introduces noise into these correlations and requires robust data selection processes.

### 4.2.3 Green Bond Market Evolution

For self-financing portfolios that utilize fixed-income instruments, the growth of the green bond market between 2010 and 2020 was a defining feature.

| Year | Global Issuance ($Bn) | Avg. Coupon (%) | Green Premium (Basis Points) |
|------|-----------------------|-----------------|------------------------------|
| 2014 | 37 | 3.45 | -2 |
| 2016 | 81 | 3.10 | -4 |
| 2018 | 167 | 2.85 | -6 |
| 2020 | 290 | 2.20 | -9 |

*Table B3: Evolution of Green Bond Market Characteristics. Source: Synthesized data trends discussed in (Hussain et al., 2025).*

Table B3 highlights the deepening of the green bond market, which is essential for the implementation of diversified self-financing strategies. The "Green Premium" (or "Greenium")—the yield difference between green bonds and equivalent non-green bonds—became more pronounced towards the end of the decade. Hussain et al. (Hussain et al., 2025) analyze these risk-return profiles, noting that while the negative premium implies a lower cost of capital for issuers (and slightly lower yields for investors), the reduced volatility and lower correlation with equity markets make green bonds attractive hedging instruments in a long/short framework.

## 4.3 Appendix C: Glossary of Terms

This glossary defines key technical terms used in the thesis, drawing upon definitions established in the cited literature.

**Alpha ($\alpha$):**
A measure of the active return on an investment, the performance of that investment compared to a suitable market index. In the context of this study, it refers to the excess return generated by the self-financing portfolio after adjusting for risk factors such as market, size, and value (Connor & Korajczyk, 2010).

**ESG (Environmental, Social, and Governance):**
A set of non-financial standards for a company’s operations that socially conscious investors use to screen potential investments.
*   *Environmental:* Looks at how a company performs as a steward of nature (e.g., carbon footprint, energy efficiency) (Waite & Modi, 2020).
*   *Social:* Examines how it manages relationships with employees, suppliers, customers, and communities.
*   *Governance:* Deals with a company’s leadership, executive pay, audits, internal controls, and shareholder rights (Molokwu, 2020).

**Exclusionary Screening:**
An investment strategy that excludes specific sectors, companies, or countries from the investable universe based on specific ESG criteria (e.g., weapons, tobacco, fossil fuels). Dimson, Marsh, and Staunton (Dimson et al., 2020) note that this is one of the oldest and most prevalent forms of sustainable investing, though it introduces tracking error relative to broad benchmarks.

**Factor Investing:**
An investment approach that involves targeting specific drivers of return across asset classes. Common factors include Value, Momentum, Size, and Quality. This thesis investigates whether "Sustainability" constitutes a distinct factor similar to these traditional drivers (McDonald, 2024).

**Green Bonds:**
Fixed-income instruments designed specifically to support specific climate-related or environmental projects. Hussain et al. (Hussain et al., 2025) emphasize their role in sustainable finance, noting distinct risk-return profiles compared to conventional bonds.

**Greenwashing:**
The practice of making misleading or unsubstantiated claims about the environmental benefits of a product, service, technology, or company practice. This phenomenon complicates the accurate assessment of ESG performance and requires rigorous due diligence in portfolio construction (Liu, 2022).

**Momentum:**
A market anomaly where assets that have performed well in the past continue to perform well in the near future. Chen, Sun, and Ge (Chen et al., 2024) analyze momentum using advanced modeling techniques, which is relevant for self-financing strategies that often rely on trend-following signals.

**Self-Financing Portfolio:**
A portfolio strategy where the purchase of assets (long positions) is financed entirely by the sale of other assets (short positions), resulting in a net zero initial investment. The performance is determined by the spread between the returns of the long and short positions, adjusted for transaction costs (Eric, 2006).

**Sharpe Ratio:**
A measure for calculating risk-adjusted return, defined as the average return earned in excess of the risk-free rate per unit of volatility or total risk. It is the primary metric used in this study to compare the efficiency of constrained vs. unconstrained portfolios (Lewin & Campani, 2024).

**Sustainable Investing:**
An investment philosophy that considers Environmental, Social, and Governance (ESG) factors alongside financial factors in the investment decision-making process. It encompasses various strategies, including impact investing, thematic investing, and ESG integration (Marszk & Lechman, 2023)(Jiang, 2022).

## 4.4 Appendix D: Regulatory and Market Context (2010-2020)

The decade from 2010 to 2020 witnessed a seismic shift in the regulatory landscape governing sustainable finance, particularly in Europe. This appendix outlines the key regulatory developments and market structure changes that influenced the performance and feasibility of ESG-integrated self-financing portfolios.

### 4.4.1 The EU Action Plan on Sustainable Finance

The most significant regulatory development during the observation period was the European Union's launch of the Action Plan on Sustainable Finance in 2018. This legislative package aimed to reorient capital flows towards sustainable investment, manage financial risks stemming from climate change, and foster transparency and long-termism in financial and economic activity (Chenaux & Piller, 2020).

| Year | Regulation/Initiative | Key Objective | Impact on Portfolio Mgmt |
|------|-----------------------|---------------|--------------------------|
| 2014 | NFRD (Directive 2014/95/EU) | Mandated non-financial reporting | Increased data availability for ESG scoring |
| 2018 | EU Action Plan | Strategic framework for sustainable finance | Standardization of "Green" definitions |
| 2019 | SFDR (Regulation 2019/2088) | Disclosures for financial market participants | Categorization of funds (Art 8 vs Art 9) |
| 2020 | EU Taxonomy Regulation | Classification system for sustainable activities | Granular criteria for asset selection |

*Table D1: Key European Regulatory Milestones (2010-2020). Source: Adapted from legal analyses in (Chenaux & Piller, 2020) and (Lovisolo, 2020).*

As detailed in Table D1, the introduction of the Non-Financial Reporting Directive (NFRD) in 2014 was a watershed moment, as it forced large public-interest entities to disclose material ESG information. For quantitative portfolio managers, this drastically improved data coverage, reducing the number of "missing values" in the dataset and allowing for more robust backtesting of ESG strategies. Chenaux and Piller (Chenaux & Piller, 2020) argue that these regulations fundamentally altered the operational landscape for Swiss and EU banks, necessitating the integration of sustainability risks into standard risk management protocols.

However, the implementation of these regulations also introduced costs. Lovisolo (Lovisolo, 2020) discusses the potential impact on the cost of capital, suggesting that while the Action Plan improves transparency, the compliance burden could affect the net returns of smaller funds. Furthermore, the divergence in interpretation of these regulations initially led to market fragmentation before convergence efforts began post-2020 (Silvestri & Kamerling, 2024).

### 4.4.2 Data Challenges and Ratings Divergence

A persistent challenge throughout the 2010-2020 period was the lack of standardization in ESG ratings. Unlike credit ratings, which display high correlation across agencies (Moody's, S&P, Fitch), ESG ratings often diverged significantly.

Liu (Liu, 2022) highlights that this divergence stems from differences in measurement (what is measured), scope (what attributes are included), and weight (how attributes are aggregated). For a self-financing portfolio relying on algorithmic selection, this creates a "garbage in, garbage out" risk. If the input signal (the ESG score) is noisy or inconsistent, the portfolio's alpha generation capability is compromised.

To mitigate this, the study utilized consensus ratings where possible, or relied on established providers with transparent methodologies. The issue of data quality is further complicated by the "size bias," where larger companies with more resources for reporting tend to receive higher ESG scores, potentially skewing portfolios towards large-cap stocks unless explicitly controlled for in the factor model (Mamaev, 2024). This highlights the importance of using the Fama-French SMB factor to disentangle the size effect from the true ESG effect in performance attribution.

### 4.4.3 Market Structure and Investment Vehicles

The vehicle of choice for accessing sustainable strategies also evolved. Marszk and Lechman (Marszk & Lechman, 2023) document the rapid rise of Sustainable ETFs during this period. The proliferation of these passive instruments provided liquidity and price discovery for ESG assets, making it easier to execute the "long" leg of self-financing strategies. However, the "short" leg remained challenging, as lending markets for specific high-ESG or low-ESG stocks were not always liquid, occasionally leading to high borrowing costs that could erode the strategy's margin (Kumar & Sinha, 2025). This structural constraint is a critical consideration for the practical implementation of the theoretical models presented in Appendix A.

\newpage


## References

Chen, Sun, & Ge. (2024). Momentum Study Based on LightGBM Model and Spearman Correlation Analysis. https://doi.org/10.1109/ICDACAI65086.2024.00153

Chenaux, & Piller. (2020). Does the EU Action Plan on Sustainable Finance Impact Swiss Banks?. *Jusletter*(1025). https://doi.org/10.38023/02e75c19-118f-4af2-9227-68ca4b9b81bc.

Connor, & Korajczyk. (2010). *Factor Models in Portfolio and Asset Pricing Theory*. Springer US. https://doi.org/10.1007/978-0-387-77439-8_13

Dai. (2024). Sustainable Investing and Islamic Finance: Evidence from the Organisation of Islamic Cooperation (OIC) Countries. *ISRA International Journal of Islamic Finance*. https://doi.org/10.55188/ijif.v16i1.563.

Dimson, Marsh, & Staunton. (2020). Exclusionary Screening. *The Journal of Impact and ESG Investing*, *1*(1), 66-75. https://doi.org/10.3905/jesg.2020.1.1.066.

Eric. (2006). Pure self-financing trading strategies under transaction costs. **. https://doi.org/10.1524/STND.2006.24.4.435.

Franzén. (2019). ESG Portfolios and Stock Returns: An analysis of ESGs effect on financial performance. **. https://www.semanticscholar.org/paper/b420595016b613e5d6d435b1e4b0d51eab45b8d0.

Hussain, Jaweed, Murtaza, & Ali. (2025). Green Bonds and Sustainable Investment Strategies: Evaluating Risk-Return Profiles, Market Growth, and the Role of Climate-Conscious Portfolios in Sustainable Finance. *Advance Journal of Econometrics and Finance*. https://doi.org/10.63075/5nggp275.

Hübel, & Scholz. (2019). Integrating sustainability risks in asset management: the role of ESG exposures and ESG ratings. *Journal of Asset Management*, *21*(1), 52-69. https://doi.org/10.1057/s41260-019-00139-z.

Jiang. (2022). *Sustainable Investing*. Springer International Publishing. https://doi.org/10.1007/978-3-030-82711-3_8

Kim, & Kim. (2025). Correlation between ESG Factor Assessments and Corporate Credit Ratings. *Global Financial Review*, *6*(2), 29-45. https://doi.org/10.51265/gfr.2025.6.2.29.

Kumar, & Sinha. (2025). Exploring Sustainable Finance and ESG Investing. *International Journal For Multidisciplinary Research*. https://doi.org/10.36948/ijfmr.2025.v07i02.41614.

Lei, Bao, & Zhao. (2023). Measuring the performance of green investment portfolios for zero-carbon environment: a comparative analysis of digital finance and asset-backed securities. *Environmental science and pollution research international*. https://doi.org/10.1007/s11356-023-31009-2.

Lewin, & Campani. (2024). Optimal constrained strategies for factor-based investing in the Brazilian stock market. *Revista Contabilidade &amp; Finanças*. https://doi.org/10.1590/1808-057x20242051.en.

Liu. (2022). Quantitative ESG disclosure and divergence of ESG ratings. *Frontiers in Psychology*, *13*. https://doi.org/10.3389/fpsyg.2022.936798.

Lovisolo. (2020). Eu Action Plan on Sustainable Finance: cost of capital, impacts and effectiveness. **. https://www.semanticscholar.org/paper/df0ddbfabcb96a4338524d2ab322898ece328ffa.

Lupu, Bobircă, Miclăuş, & Ciumara. (2020). Risk Management of Companies Included in the EURO STOXX Sustainability Index. An Investors' Perception. **. https://doi.org/10.24818/ea/2020/55/707.

Mamaev. (2024). Understanding Mutual Funds Returns Across Morningstar Style Boxes. *Universum:Economics &amp; law*, *114*(4). https://doi.org/10.32743/unilaw.2024.114.4.17109.

Marszk, & Lechman. (2023). *Sustainable investing—main concepts. Sustainable investing ETFs*. Elsevier. https://doi.org/10.1016/b978-0-12-823871-4.00008-8

McDonald. (2024). BlackRock and factor models in investing. *The Business &amp; Management Collection*, *2024*(6), e1006174. https://doi.org/10.69645/zole1931.

Mehra. (2010). *Indian Equity Markets: Measures of Fundamental Value*. National Bureau of Economic Research. https://doi.org/10.3386/w16061

Molokwu. (2020). Effect of Corporate Governance on Performance of Deposit Money Banks in Nigeria.. **. https://www.semanticscholar.org/paper/200104b758c0bd38350ce124c929346123ec2eb2.

Muslim. (2025). The Dilemma Between Shareholder Value and Long-term Business Sustainability. *Advances in Management &amp; Financial Reporting*. https://doi.org/10.60079/amfr.v3i1.427.

Nash. (2010). Davos Data and The World Economic Forum. **. https://www.semanticscholar.org/paper/07ad673422b042e3ae8025faa8ed0942ed2260c7.

Pizzani. (2015). Expanding ESG Coverage. *CFA Institute Magazine*, *26*(6), 30-31. https://doi.org/10.2469/cfm.v26.n6.12.

Silvestri, & Kamerling. (2024). CFA Institute Survey Report on the ESG Regulatory Framework in the EU. **. https://doi.org/10.56227/24.2.10.

Swamy, & Tiwari. (2024). The Clean Energy-Ecology Interrelatedness: Evidence from the S&P Dow Jones Indices. *Journal of Energy and Development*. https://doi.org/10.56476/jed.v49i2.24.

Tadoori, & Usha Kiran. (2023). Esg Portfolio vs Traditional Portfolio Analysis-a Study Of MSCI ESG Indices. *Research Bulletin*, 51-70. https://doi.org/10.33516/rb.v48i3-4.51-70p.

Waite, & Modi. (2020). Quadracci Sustainable Engineering Laboratory (QSEL) Report Posted May 6, 2020 How do we heat our homes in the US? And what does it mean for greenhouse gas emissions?. **. https://www.semanticscholar.org/paper/128fa1fce9463a6855965862b8e8e6c81ee61642.

ÖZER, ÖNCÜ, ÖZER, & ÇÖMLEKÇİ. (2021). Fama French 5 Factor Model Versus Alternative Fama French 5 Factor Model: Evidence from Selected Islamic Countries. *Bilimname*(45), 427-461. https://doi.org/10.28949/bilimname.952079.