**Research Problem and Approach:** The decade from 2010 to 2020 marked a fundamental paradigm shift toward Environmental, Social, and Governance (ESG) integration, yet the empirical efficacy of sophisticated quantitative strategies remains a subject of debate. This research investigates the performance of self-financing portfolios—specifically long-short ESG strategies—to determine if they generate legitimate "Green Alpha" when subjected to realistic market frictions. The study addresses the critical tension between elegant theoretical factor models and practical implementation challenges, such as transaction costs, liquidity constraints, and the complex regulatory environment introduced by initiatives like the EU Action Plan on Sustainable Finance.

**Methodology and Findings:** By analyzing market data over a ten-year observation period, this study constructs self-financing portfolios that go long on high-ESG assets and short on low-ESG assets. The methodology employs consensus ratings to mitigate data divergence and utilizes the Fama-French SMB factor to control for size bias, while explicitly accounting for transaction costs and borrowing constraints inherent in the short leg. The analysis reveals that while theoretical models suggest positive spreads, practical implementation is significantly hampered by structural costs and the lack of standardization in ESG data, which introduces noise into signal generation.

**Key Contributions:** This thesis makes three primary contributions: (1) An empirical evaluation of self-financing ESG portfolios that isolates true economic value added from frictional implementation costs, (2) A critical analysis of how regulatory frameworks and the evolution of sustainable finance definitions influenced asset pricing mechanisms between 2010 and 2020, and (3) A methodological approach for addressing ESG rating divergence and size bias within quantitative portfolio construction to reduce "garbage in, garbage out" risks.

**Implications:** The findings have significant implications for asset managers and policymakers, suggesting that the excess returns often cited in theoretical literature may be overstated without rigorous cost accounting. Ultimately, the research demonstrates that effective sustainable investing requires not only robust signal generation but also a deep understanding of market structure, liquidity risks, and the evolving regulatory landscape.

**Keywords:** Sustainable Finance, ESG Investing, Self-Financing Portfolios, Long-Short Strategy, Green Alpha, Transaction Costs, EU Action Plan, Market Frictions, Fama-French Factors, ESG Ratings, Portfolio Construction, Asset Pricing, Quantitative Finance, Risk Management, Regulatory Compliance