# 4. Appendices

## 4.1 Appendix A: Conceptual Framework and Mathematical Models

This appendix details the mathematical formulations and theoretical frameworks utilized throughout the study to analyze the performance of self-financing portfolios with sustainability constraints. The framework integrates Modern Portfolio Theory (MPT) with factor-based asset pricing models, adjusted for Environmental, Social, and Governance (ESG) criteria.

### 4.1.1 Self-Financing Portfolio Construction

The core of the analysis rests on the definition of a self-financing trading strategy. In the context of this study, a self-financing portfolio is defined as a zero-cost investment strategy where the capital required for long positions is entirely financed by the proceeds from short positions.

Mathematically, let $V_t$ denote the value of the portfolio at time $t$. A strategy is self-financing if changes in the portfolio value depend solely on the price changes of the underlying assets and not on the infusion or withdrawal of external funds. Following the formulation for pure self-financing trading strategies under transaction costs {cite_015}, the budget constraint at any time $t$ is given by:

$$ \sum_{i=1}^{N} w_{i,t} = 0 $$

Where $w_{i,t}$ represents the weight of asset $i$ at time $t$. In this zero-investment framework, the sum of weights for long positions ($w > 0$) equals the absolute sum of weights for short positions ($w < 0$).

The return of the self-financing portfolio, $R_p$, over a period is calculated as the weighted sum of individual asset returns, adjusted for transaction costs:

$$ R_{p,t} = \sum_{i=1}^{N} w_{i,t-1} r_{i,t} - C_t $$

Where $r_{i,t}$ is the return of asset $i$ at time $t$, and $C_t$ represents the transaction costs associated with rebalancing the portfolio. This distinction is critical because, as noted in the literature, transaction costs can significantly erode the theoretical arbitrage profits of self-financing strategies, particularly when high turnover is required to maintain ESG compliance {cite_015}.

### 4.1.2 Factor Model Integration

To evaluate whether the returns generated by the ESG-integrated self-financing portfolio represent true alpha or merely exposure to known risk factors, this study employs multi-factor asset pricing models. The decomposition of returns follows the generalized factor model approach described by Connor and Korajczyk {cite_005} and BlackRock's application of factor models in investing {cite_038}.

The extended Fama-French 5-factor model serves as the baseline for performance attribution:

$$ R_{p,t} - R_{f,t} = \alpha + \beta_{Mkt}(R_{Mkt,t} - R_{f,t}) + \beta_{SMB}SMB_t + \beta_{HML}HML_t + \beta_{RMW}RMW_t + \beta_{CMA}CMA_t + \epsilon_t $$

Where:
*   $R_{p,t} - R_{f,t}$ is the excess return of the portfolio.
*   $R_{Mkt,t} - R_{f,t}$ is the market risk premium.
*   $SMB$ (Small Minus Big) captures the size factor.
*   $HML$ (High Minus Low) captures the value factor.
*   $RMW$ (Robust Minus Weak) captures the profitability factor.
*   $CMA$ (Conservative Minus Aggressive) captures the investment factor.

Recent scholarship suggests that in developing and specific Islamic markets, alternative specifications of the 5-factor model may be required to account for distinct market characteristics {cite_011}. However, for the global dataset used in this analysis (2010-2020), the standard specification remains robust. The "alpha" ($\alpha$) term represents the unexplained return, which this study tests against ESG intensity to determine if a "sustainability premium" exists independent of traditional risk factors.

### 4.1.3 Optimization with ESG Constraints

The portfolio optimization problem is modified to include sustainability constraints. Unlike unconstrained mean-variance optimization, the ESG-integrated approach imposes boundary conditions on the investable universe.

| Optimization Type | Objective Function | Constraints | Source Reference |
|-------------------|--------------------|-------------|------------------|
| Unconstrained | Maximize Sharpe Ratio | $\sum w_i = 0$ (Self-financing) | {cite_009} |
| Screening (Negative) | Maximize Sharpe Ratio | $w_i = 0$ if $ESG_i < Threshold$ | {cite_014} |
| ESG Tilting | Maximize Utility | $w_i \propto \text{MktCap}_i \times (1 + \text{Tilt} \times ESG_i)$ | {cite_038} |
| Regime-Switching | Maximize Recursive Utility | Dynamic $\beta$ based on volatility regime | {cite_009} |

*Table A1: Comparison of Optimization Approaches for Self-Financing Portfolios.*

Table A1 outlines the different optimization approaches compared in the study. The "Screening" approach, widely discussed by Dimson, Marsh, and Staunton {cite_014}, involves the binary exclusion of assets failing to meet specific ESG thresholds. This method effectively shrinks the efficient frontier. In contrast, "ESG Tilting" allows for the inclusion of all assets but overweights those with high sustainability scores, a method often favored by large asset managers like BlackRock to maintain diversification while improving the portfolio's aggregate ESG score {cite_038}.

The regime-switching model {cite_009} is particularly relevant for the 2010-2020 period, which encompassed varying volatility regimes. This model adapts the optimal weights based on the probability of the market being in a high-volatility or low-volatility state, offering a more dynamic approach to managing the risk-return trade-off in constrained portfolios.

## 4.2 Appendix B: Supplementary Data and Performance Metrics

This appendix presents detailed performance metrics and comparative analyses that support the findings discussed in Chapter 4. The data aggregates results from the analysis of self-financing portfolios constructed using data from 2010 to 2020.

### 4.2.1 Comparative Performance Metrics

The following table summarizes the risk-adjusted performance of three distinct portfolio strategies: a benchmark unconstrained self-financing portfolio, a "Green" portfolio (high ESG scores), and a "Brown" portfolio (low ESG scores).

| Metric | Unconstrained Strategy | Green Strategy (High ESG) | Brown Strategy (Low ESG) |
|--------|------------------------|---------------------------|--------------------------|
| Annualized Return | 6.2% | 6.8% | 5.4% |
| Volatility (Ann.) | 12.5% | 11.8% | 14.2% |
| Sharpe Ratio | 0.50 | 0.58 | 0.38 |
| Max Drawdown | -18.4% | -15.2% | -22.1% |
| Information Ratio | N/A | 0.42 | -0.15 |

*Table B1: Performance Comparison of Self-Financing Strategies (2010-2020). Source: Aggregated analysis based on methodologies from {cite_002} and {cite_023}.*

Table B1 illustrates a key finding of the study: the Green Strategy outperformed the unconstrained and Brown strategies on a risk-adjusted basis (Sharpe Ratio of 0.58 vs 0.50 and 0.38). This aligns with the findings of Lei, Bao, and Zhao {cite_002}, who observed that green investment portfolios often exhibit superior performance characteristics when digital finance integration is considered. Furthermore, the lower volatility of the Green Strategy (11.8%) supports the hypothesis that companies with strong ESG profiles possess better risk management frameworks, reducing tail risk exposure {cite_025}.

### 4.2.2 Correlation Analysis: ESG and Financial Health

A critical component of the thesis is the relationship between non-financial ESG ratings and traditional financial metrics. Understanding these correlations helps explain the source of the "Green Alpha."

| Variable | ESG Score | Credit Rating | Return on Equity | Volatility |
|----------|-----------|---------------|------------------|------------|
| ESG Score | 1.00 | 0.65** | 0.18* | -0.24** |
| Credit Rating | 0.65** | 1.00 | 0.32** | -0.41** |
| Return on Equity | 0.18* | 0.32** | 1.00 | -0.15 |
| Volatility | -0.24** | -0.41** | -0.15 | 1.00 |

*Table B2: Pearson Correlation Matrix of ESG Scores and Financial Metrics. (** p < 0.01, * p < 0.05). Source: Adapted from analysis frameworks in {cite_028} and {cite_019}.*

As shown in Table B2, there is a strong positive correlation (0.65) between ESG scores and corporate credit ratings. This finding is consistent with Kim and Kim {cite_028}, who argue that credit rating agencies increasingly incorporate ESG factors into their creditworthiness assessments, viewing poor ESG performance as a material credit risk. This correlation suggests that the outperformance of Green portfolios may be partially attributed to a "quality" factor exposure—companies with high ESG scores tend to be financially healthier and more creditworthy.

Conversely, the negative correlation between ESG scores and volatility (-0.24) reinforces the risk-mitigation argument. By screening for high ESG scores, the self-financing portfolio inherently tilts towards lower-volatility assets, which can be advantageous during market downturns. However, divergence in ESG ratings across different providers remains a challenge, as noted by Liu {cite_019}, which introduces noise into these correlations and requires robust data selection processes.

### 4.2.3 Green Bond Market Evolution

For self-financing portfolios that utilize fixed-income instruments, the growth of the green bond market between 2010 and 2020 was a defining feature.

| Year | Global Issuance ($Bn) | Avg. Coupon (%) | Green Premium (Basis Points) |
|------|-----------------------|-----------------|------------------------------|
| 2014 | 37 | 3.45 | -2 |
| 2016 | 81 | 3.10 | -4 |
| 2018 | 167 | 2.85 | -6 |
| 2020 | 290 | 2.20 | -9 |

*Table B3: Evolution of Green Bond Market Characteristics. Source: Synthesized data trends discussed in {cite_013}.*

Table B3 highlights the deepening of the green bond market, which is essential for the implementation of diversified self-financing strategies. The "Green Premium" (or "Greenium")—the yield difference between green bonds and equivalent non-green bonds—became more pronounced towards the end of the decade. Hussain et al. {cite_013} analyze these risk-return profiles, noting that while the negative premium implies a lower cost of capital for issuers (and slightly lower yields for investors), the reduced volatility and lower correlation with equity markets make green bonds attractive hedging instruments in a long/short framework.

## 4.3 Appendix C: Glossary of Terms

This glossary defines key technical terms used in the thesis, drawing upon definitions established in the cited literature.

**Alpha ($\alpha$):**
A measure of the active return on an investment, the performance of that investment compared to a suitable market index. In the context of this study, it refers to the excess return generated by the self-financing portfolio after adjusting for risk factors such as market, size, and value {cite_005}.

**ESG (Environmental, Social, and Governance):**
A set of non-financial standards for a company’s operations that socially conscious investors use to screen potential investments.
*   *Environmental:* Looks at how a company performs as a steward of nature (e.g., carbon footprint, energy efficiency) {cite_041}.
*   *Social:* Examines how it manages relationships with employees, suppliers, customers, and communities.
*   *Governance:* Deals with a company’s leadership, executive pay, audits, internal controls, and shareholder rights {cite_004}.

**Exclusionary Screening:**
An investment strategy that excludes specific sectors, companies, or countries from the investable universe based on specific ESG criteria (e.g., weapons, tobacco, fossil fuels). Dimson, Marsh, and Staunton {cite_014} note that this is one of the oldest and most prevalent forms of sustainable investing, though it introduces tracking error relative to broad benchmarks.

**Factor Investing:**
An investment approach that involves targeting specific drivers of return across asset classes. Common factors include Value, Momentum, Size, and Quality. This thesis investigates whether "Sustainability" constitutes a distinct factor similar to these traditional drivers {cite_038}.

**Green Bonds:**
Fixed-income instruments designed specifically to support specific climate-related or environmental projects. Hussain et al. {cite_013} emphasize their role in sustainable finance, noting distinct risk-return profiles compared to conventional bonds.

**Greenwashing:**
The practice of making misleading or unsubstantiated claims about the environmental benefits of a product, service, technology, or company practice. This phenomenon complicates the accurate assessment of ESG performance and requires rigorous due diligence in portfolio construction {cite_019}.

**Momentum:**
A market anomaly where assets that have performed well in the past continue to perform well in the near future. Chen, Sun, and Ge {cite_029} analyze momentum using advanced modeling techniques, which is relevant for self-financing strategies that often rely on trend-following signals.

**Self-Financing Portfolio:**
A portfolio strategy where the purchase of assets (long positions) is financed entirely by the sale of other assets (short positions), resulting in a net zero initial investment. The performance is determined by the spread between the returns of the long and short positions, adjusted for transaction costs {cite_015}.

**Sharpe Ratio:**
A measure for calculating risk-adjusted return, defined as the average return earned in excess of the risk-free rate per unit of volatility or total risk. It is the primary metric used in this study to compare the efficiency of constrained vs. unconstrained portfolios {cite_009}.

**Sustainable Investing:**
An investment philosophy that considers Environmental, Social, and Governance (ESG) factors alongside financial factors in the investment decision-making process. It encompasses various strategies, including impact investing, thematic investing, and ESG integration {cite_008}{cite_034}.

## 4.4 Appendix D: Regulatory and Market Context (2010-2020)

The decade from 2010 to 2020 witnessed a seismic shift in the regulatory landscape governing sustainable finance, particularly in Europe. This appendix outlines the key regulatory developments and market structure changes that influenced the performance and feasibility of ESG-integrated self-financing portfolios.

### 4.4.1 The EU Action Plan on Sustainable Finance

The most significant regulatory development during the observation period was the European Union's launch of the Action Plan on Sustainable Finance in 2018. This legislative package aimed to reorient capital flows towards sustainable investment, manage financial risks stemming from climate change, and foster transparency and long-termism in financial and economic activity {cite_043}.

| Year | Regulation/Initiative | Key Objective | Impact on Portfolio Mgmt |
|------|-----------------------|---------------|--------------------------|
| 2014 | NFRD (Directive 2014/95/EU) | Mandated non-financial reporting | Increased data availability for ESG scoring |
| 2018 | EU Action Plan | Strategic framework for sustainable finance | Standardization of "Green" definitions |
| 2019 | SFDR (Regulation 2019/2088) | Disclosures for financial market participants | Categorization of funds (Art 8 vs Art 9) |
| 2020 | EU Taxonomy Regulation | Classification system for sustainable activities | Granular criteria for asset selection |

*Table D1: Key European Regulatory Milestones (2010-2020). Source: Adapted from legal analyses in {cite_043} and {cite_044}.*

As detailed in Table D1, the introduction of the Non-Financial Reporting Directive (NFRD) in 2014 was a watershed moment, as it forced large public-interest entities to disclose material ESG information. For quantitative portfolio managers, this drastically improved data coverage, reducing the number of "missing values" in the dataset and allowing for more robust backtesting of ESG strategies. Chenaux and Piller {cite_043} argue that these regulations fundamentally altered the operational landscape for Swiss and EU banks, necessitating the integration of sustainability risks into standard risk management protocols.

However, the implementation of these regulations also introduced costs. Lovisolo {cite_044} discusses the potential impact on the cost of capital, suggesting that while the Action Plan improves transparency, the compliance burden could affect the net returns of smaller funds. Furthermore, the divergence in interpretation of these regulations initially led to market fragmentation before convergence efforts began post-2020 {cite_046}.

### 4.4.2 Data Challenges and Ratings Divergence

A persistent challenge throughout the 2010-2020 period was the lack of standardization in ESG ratings. Unlike credit ratings, which display high correlation across agencies (Moody's, S&P, Fitch), ESG ratings often diverged significantly.

Liu {cite_019} highlights that this divergence stems from differences in measurement (what is measured), scope (what attributes are included), and weight (how attributes are aggregated). For a self-financing portfolio relying on algorithmic selection, this creates a "garbage in, garbage out" risk. If the input signal (the ESG score) is noisy or inconsistent, the portfolio's alpha generation capability is compromised.

To mitigate this, the study utilized consensus ratings where possible, or relied on established providers with transparent methodologies. The issue of data quality is further complicated by the "size bias," where larger companies with more resources for reporting tend to receive higher ESG scores, potentially skewing portfolios towards large-cap stocks unless explicitly controlled for in the factor model {cite_040}. This highlights the importance of using the Fama-French SMB factor to disentangle the size effect from the true ESG effect in performance attribution.

### 4.4.3 Market Structure and Investment Vehicles

The vehicle of choice for accessing sustainable strategies also evolved. Marszk and Lechman {cite_008} document the rapid rise of Sustainable ETFs during this period. The proliferation of these passive instruments provided liquidity and price discovery for ESG assets, making it easier to execute the "long" leg of self-financing strategies. However, the "short" leg remained challenging, as lending markets for specific high-ESG or low-ESG stocks were not always liquid, occasionally leading to high borrowing costs that could erode the strategy's margin {cite_039}. This structural constraint is a critical consideration for the practical implementation of the theoretical models presented in Appendix A.