# 2.2 Methodology

The methodological framework of this thesis is designed to empirically evaluate the performance of self-financing portfolios constructed based on Environmental, Social, and Governance (ESG) criteria between 2010 and 2020. Building upon the theoretical foundations established in the literature review, particularly the shift from exclusionary screening to active integration and factor-based investing {cite_005}{cite_014}, this section details the quantitative research design employed to isolate the "sustainability alpha." The methodology addresses the critical research gaps identified regarding transaction costs in self-financing strategies {cite_015} and the applicability of factor models in diverse market contexts, including emerging and Islamic markets {cite_011}{cite_035}.

This chapter outlines the data selection process, the specific algorithms used for portfolio construction, the econometric models applied for performance attribution (specifically the Fama-French five-factor model), and the robustness checks implemented to ensure the validity of the findings. The approach aligns with recent advancements in sustainable finance research that advocate for rigorous factor control to distinguish true ESG outperformance from sector or style biases {cite_009}{cite_023}.

## 2.2.1 Research Design and Data Selection

The study adopts a positivist, quantitative research philosophy, utilizing secondary financial data to test hypotheses regarding the risk-adjusted returns of sustainable investment strategies. The research design is longitudinal, covering the decade from January 1, 2010, to December 31, 2020. This period is significant as it encompasses the post-financial crisis recovery, the adoption of the Paris Agreement in 2015, and the initial phases of the COVID-19 pandemic, providing a stress test for ESG resilience {cite_002}{cite_019}.

### 2.2.1.1 Data Universe and Sources
To construct a representative global and emerging market universe, the study utilizes data from major financial indices, following the precedent set by recent empirical studies on ESG indices {cite_036}. The primary data sources include:

1.  **Financial Data:** Daily and monthly closing prices, market capitalization, book-to-market ratios, and total returns are sourced from standard financial databases (e.g., Refinitiv Eikon or Bloomberg). This ensures consistency with standard asset pricing literature {cite_005}.
2.  **ESG Ratings:** Historical ESG scores are aggregated to classify firms into "High Sustainability" and "Low Sustainability" cohorts. Recognizing the divergence in ESG ratings noted by Liu {cite_019}, the methodology prioritizes providers with consistent historical coverage during the 2010-2020 window.
3.  **Risk Factors:** Data for the Fama-French five factors (Market, SMB, HML, RMW, CMA) and the momentum factor (MOM) are obtained for both developed and emerging markets, consistent with the models validated by Özer et al. {cite_011} and Lewin and Campani {cite_009}.

The selection of the 2010-2020 timeframe addresses the data availability constraints associated with ESG reporting, which became more standardized only after 2010 {cite_048}. Furthermore, this period allows for the analysis of the "transition risk" pricing that accelerated following regulatory developments in the European Union {cite_043}{cite_044}.

### 2.2.1.2 Data Processing and Cleaning
Raw financial data requires rigorous preprocessing to ensure the reliability of the econometric analysis. The following cleaning protocols are implemented, drawing on standard methodologies in factor investing {cite_038}:

*   **Survivorship Bias:** The dataset includes both active and delisted companies to prevent survivorship bias, which can overestimate historical returns.
*   **Liquidity Filtering:** To address the transaction cost concerns raised by Eric {cite_015}, illiquid stocks (defined as those with trading volume in the bottom decile) are excluded from the self-financing portfolio construction. This is particularly crucial for the short leg of the portfolio in emerging markets {cite_035}.
*   **Outlier Treatment:** Continuous variables are winsorized at the 1% and 99% levels to mitigate the impact of extreme outliers on regression estimates.

Table 1 summarizes the variables used in the analysis and their sources.

| Variable Category | Specific Metrics | Frequency | Purpose in Analysis |
|-------------------|------------------|-----------|---------------------|
| Asset Prices | Adjusted Closing Price | Daily | Return calculation |
| Valuation | Book-to-Market, Market Cap | Quarterly | Factor construction |
| ESG Metrics | E, S, G Pillar Scores | Annual | Portfolio sorting |
| Risk Factors | Mkt-RF, SMB, HML, RMW, CMA | Monthly | Performance attribution |
| Macro Indicators | Risk-free rate (1M T-Bill) | Monthly | Excess return calculation |

*Table 1: Overview of Data Variables and Specifications. Adapted from methodologies described in {cite_005} and {cite_036}.*

## 2.2.2 Portfolio Construction Framework

The core of this methodology is the construction of a self-financing portfolio, often referred to as a "zero-cost" strategy. This involves simultaneously holding a long position in assets with desirable characteristics (high ESG scores) and a short position in assets with undesirable characteristics (low ESG scores). The theoretical premise is that the proceeds from shorting the "brown" assets finance the purchase of the "green" assets {cite_015}.

### 2.2.2.1 Sorting and Ranking Mechanism
At the beginning of each rebalancing period (annually, to align with ESG score updates), the universe of stocks is ranked based on their aggregate ESG scores. Following the methodology of Hübel and Scholz {cite_049}, the universe is divided into quantiles (e.g., quintiles or deciles).

The self-financing portfolio ($P_{SF}$) is constructed as follows:
*   **Long Leg ($L$):** Top 20% of firms by ESG score (High Sustainability).
*   **Short Leg ($S$):** Bottom 20% of firms by ESG score (Low Sustainability).

The return of the self-financing portfolio at time $t$ is defined as:

$$R_{SF,t} = R_{L,t} - R_{S,t}$$

Where $R_{L,t}$ is the return of the long portfolio and $R_{S,t}$ is the return of the short portfolio. This construction isolates the performance differential attributable to the ESG characteristic, effectively creating a "Sustainability Factor" mimicking portfolio {cite_023}.

### 2.2.2.2 Weighting Schemes
Two weighting schemes are employed to test the robustness of the results:
1.  **Equal-Weighted:** Assigns equal capital to all constituents in the portfolio. This approach prevents large-cap dominance but may increase exposure to small-cap idiosyncrasies and transaction costs {cite_015}.
2.  **Value-Weighted:** Weights constituents by their market capitalization. This approach is more representative of the aggregate market and theoretically reduces transaction costs, as it requires less rebalancing in response to price movements {cite_005}.

### 2.2.2.3 Transaction Cost Integration
A critical gap identified in the literature review is the frequent omission of transaction costs in theoretical self-financing models {cite_015}. In reality, the "short" leg of an ESG strategy involves borrowing costs, which can be substantial, especially in emerging markets or for companies with poor governance (often the targets of the short strategy).

To address this, the methodology incorporates a transaction cost model. The net return $R_{net,t}$ is calculated as:

$$R_{net,t} = (1 - TC_{turnover}) \cdot R_{gross,t} - C_{borrow}$$

Where:
*   $TC_{turnover}$ represents the trading costs associated with portfolio turnover (rebalancing).
*   $C_{borrow}$ represents the cost of borrowing securities for the short position.

Drawing on the work of Eric {cite_015}, who analyzed pure self-financing strategies under transaction costs, this study applies a conservative estimate of transaction costs (e.g., 50 basis points for developed markets, higher for emerging markets) to evaluate whether the "Green Alpha" persists after implementation costs.

## 2.2.3 Econometric Models

To evaluate the performance of the self-financing portfolios, this study moves beyond simple mean-variance analysis to sophisticated factor models. This ensures that any observed outperformance is not merely a result of loading on known risk factors such as size or value {cite_005}{cite_038}.

### 2.2.3.1 The Fama-French Five-Factor Model
The primary analytical tool is the Fama-French five-factor model, which extends the three-factor model by adding profitability (RMW) and investment (CMA) factors. This is particularly relevant for ESG analysis, as high-ESG firms often exhibit quality characteristics (profitability) that must be controlled for {cite_009}{cite_049}.

The regression equation is specified as:

$$R_{pt} - R_{ft} = \alpha_p + \beta_1(R_{Mt} - R_{ft}) + \beta_2 SMB_t + \beta_3 HML_t + \beta_4 RMW_t + \beta_5 CMA_t + \epsilon_t$$

Where:
*   $R_{pt}$ is the return of the self-financing portfolio at time $t$.
*   $R_{ft}$ is the risk-free rate.
*   $\alpha_p$ (Jensen's Alpha) represents the abnormal return unexplained by the factors. A positive, significant $\alpha$ indicates that the ESG strategy generates excess returns.
*   $R_{Mt} - R_{ft}$ is the Market Risk Premium.
*   $SMB_t$ (Small Minus Big) captures the size premium.
*   $HML_t$ (High Minus Low) captures the value premium.
*   $RMW_t$ (Robust Minus Weak) captures the profitability premium.
*   $CMA_t$ (Conservative Minus Aggressive) captures the investment premium.

The validity of this model in various contexts, including Islamic and emerging markets, has been supported by Özer et al. {cite_011}, making it a robust choice for this global analysis.

### 2.2.3.2 The Carhart Four-Factor Model (Momentum)
To account for the momentum effect—where past winners tend to continue winning—the study also employs the Carhart four-factor model. This is crucial because ESG strategies often exhibit momentum characteristics, especially during periods of high capital inflow into sustainable funds {cite_029}.

The specification adds the Momentum factor ($MOM_t$):

$$R_{pt} - R_{ft} = \alpha_p + \beta_1(R_{Mt} - R_{ft}) + \beta_2 SMB_t + \beta_3 HML_t + \beta_4 MOM_t + \epsilon_t$$

Chen et al. {cite_029} highlight the importance of momentum analysis using advanced correlation techniques, suggesting that ignoring this factor could lead to omitted variable bias in ESG performance attribution.

### 2.2.3.3 Regime-Switching Models (Theoretical Consideration)
While the primary analysis relies on static linear factor models, the methodology acknowledges the potential for regime-dependent performance. Lewin and Campani {cite_009} propose regime-switching models to optimize factor-based strategies. Although a full regime-switching implementation may be beyond the scope of the core analysis, the study will perform sub-period analyses (e.g., 2010-2015 vs. 2016-2020) to approximate regime changes driven by regulatory shifts like the EU Action Plan {cite_044}.

Table 2 outlines the key econometric models and their specific application in this thesis.

| Model | Key Parameters | Application Rationale | Reference |
|-------|----------------|-----------------------|-----------|
| CAPM | Market Beta | Baseline risk adjustment | {cite_005} |
| FF 3-Factor | Size, Value | Control for value/growth bias in ESG | {cite_038} |
| FF 5-Factor | Profitability, Investment | Control for "quality" bias in ESG | {cite_011} |
| Transaction Cost | Turnover, Borrow Cost | Reality check for self-financing | {cite_015} |

*Table 2: Econometric Framework Summary.*

## 2.2.4 Performance Evaluation Metrics

Beyond regression alphas, the study employs a suite of risk-adjusted performance metrics to provide a comprehensive evaluation of the self-financing portfolios.

### 2.2.4.1 Sharpe and Sortino Ratios
The Sharpe Ratio is calculated to measure excess return per unit of total risk:

$$SR_p = \frac{\bar{R}_p - \bar{R}_f}{\sigma_p}$$

However, given that ESG strategies often aim to mitigate downside risk (tail risk), the Sortino Ratio is also utilized. The Sortino Ratio penalizes only downside volatility, providing a more relevant metric for risk-averse investors concerned with "sustainability risks" {cite_049}.

$$Sortino_p = \frac{\bar{R}_p - \bar{R}_f}{\sigma_{downside}}$$

### 2.2.4.2 Information Ratio and Tracking Error
For the long-only component or when comparing against a benchmark, the Information Ratio (IR) assesses the active return generated per unit of active risk (Tracking Error).

$$IR = \frac{R_p - R_b}{TE}$$

Where $TE = \sigma(R_p - R_b)$. This metric is particularly relevant for evaluating whether the deviation from the benchmark required to achieve high ESG scores is compensated by higher returns {cite_005}.

### 2.2.4.3 Maximum Drawdown
To assess the resilience of ESG portfolios during market stress (e.g., the 2020 COVID-19 crash), the Maximum Drawdown (MDD) is calculated. This measures the largest peak-to-trough decline during the study period.

$$MDD = \min \left( \frac{P_t - P_{peak}}{P_{peak}} \right)$$

Comparing the MDD of high-ESG vs. low-ESG portfolios will empirically test the "insurance-like" property of sustainable assets suggested in the literature {cite_025}.

## 2.2.5 Methodological Limitations and Robustness

While the proposed methodology is rigorous, it acknowledges several limitations inherent in quantitative ESG research. First, the "divergence of ESG ratings" {cite_019} implies that the results are sensitive to the choice of data provider. A portfolio constructed using MSCI data might differ significantly from one using Sustainalytics. To mitigate this, the study focuses on the methodology of construction rather than claiming universality of a single provider's ratings.

Second, the assumption of linear factor exposures in the Fama-French model may not fully capture the non-linear dynamics of climate transition risks. As noted by McDonald {cite_038}, factor models are approximations of reality.

Finally, the estimation of transaction costs, while included, relies on standardized assumptions (e.g., fixed basis points) which may not reflect the dynamic liquidity conditions in all markets, particularly in developing economies {cite_035}. To address this, robustness checks will include varying transaction cost thresholds to determine the "break-even" point where the ESG alpha is eroded by trading friction.

The methodology described herein provides a structured, reproducible framework for isolating the financial performance of sustainability factors. By integrating transaction costs {cite_015} and advanced factor models {cite_011}, it directly addresses the gaps identified in the literature review, setting the stage for the empirical analysis in Chapter 3.

## 2.2.6 Ethical Considerations in Data Use

Although this research utilizes secondary data, ethical considerations regarding data integrity and representation remain pertinent. The study relies on proprietary ESG ratings, which are themselves subjective assessments of corporate behavior. As highlighted by Liu {cite_019}, these ratings can contain inherent biases. The methodology addresses this by explicitly acknowledging the source of data and avoiding the presentation of these ratings as objective "truth," but rather as market signals used by investors. Furthermore, the use of financial data from emerging markets requires careful handling to ensure that market idiosyncrasies are respected and not simply treated as "noise" in a developed-market-centric model {cite_035}.

The following section (Analysis and Results) will present the empirical findings derived from applying this methodology to the 2010-2020 dataset, beginning with descriptive statistics of the constructed portfolios.