## 2.1 Literature Review

The intersection of sustainable finance and quantitative portfolio management has evolved from a niche ethical consideration into a central pillar of modern asset pricing theory. This chapter provides a comprehensive review of the academic literature regarding Environmental, Social, and Governance (ESG) integration, with a specific focus on self-financing portfolio construction and performance analysis between 2010 and 2020. The review is structured to first establish the theoretical underpinnings of factor investing and portfolio optimization, followed by an examination of empirical evidence regarding ESG performance, and finally, a critical analysis of self-financing strategies and implementation challenges.

### 2.1.1 Theoretical Framework of Sustainable Portfolio Management

The theoretical basis for integrating sustainability into portfolio construction relies heavily on the evolution of Modern Portfolio Theory (MPT) and the subsequent development of factor-based asset pricing models. Understanding these foundational concepts is essential for evaluating whether ESG constraints represent a violation of efficiency or the identification of a new risk premium.

#### 2.1.1.1 Modern Portfolio Theory and the Cost of Constraints

Classical Modern Portfolio Theory, as originally formulated, posits that rational investors seek to maximize returns for a given level of risk. According to this framework, any constraint imposed on the investment universe—such as the exclusion of "sin stocks" or high-carbon emitters—should theoretically result in a suboptimal portfolio. By reducing the diversification potential, the efficient frontier shifts inward, leading to a lower Sharpe ratio. This "cost of exclusion" hypothesis has been a dominant narrative in early literature, suggesting that sustainable investing inherently requires a financial sacrifice.

However, recent developments in the field challenge this neoclassical view. Scholars argue that if ESG factors are material to financial performance, then ignoring them constitutes a failure to account for significant risks, particularly tail risks associated with climate transition and regulatory changes. Consequently, the integration of sustainability data might not act as a constraint, but rather as a filter for quality and risk management. This shift in perspective moves the debate from "values-driven" investing to "value-driven" investing, where sustainability is viewed through the lens of fiduciary duty.

#### 2.1.1.2 Factor Asset Pricing Models

To rigorously analyze the performance of self-financing portfolios, one must utilize robust asset pricing models that account for systematic risk factors. The Capital Asset Pricing Model (CAPM) provided the initial framework, but its limitations in explaining cross-sectional returns led to the development of multi-factor models.

The Fama-French three-factor model extended the CAPM by adding size and value factors, acknowledging that small-cap and value stocks historically outperform the market. This was further expanded into the five-factor model, which includes profitability and investment patterns. The validity of these models across different markets, including developing and Islamic countries, has been extensively tested, confirming their utility in isolating alpha from factor beta {cite_011}.

In the context of this thesis, the Fama-French five-factor model serves as a critical baseline for performance attribution. The model can be expressed as:

$$R_{it} - R_{Ft} = a_i + b_i(R_{Mt} - R_{Ft}) + s_iSMB_t + h_iHML_t + r_iRMW_t + c_iCMA_t + e_{it}$$

Where:
*   $R_{it} - R_{Ft}$ is the excess return of the portfolio.
*   $SMB_t$ (Small Minus Big) captures the size premium.
*   $HML_t$ (High Minus Low) captures the value premium.
*   $RMW_t$ (Robust Minus Weak) captures the profitability premium.
*   $CMA_t$ (Conservative Minus Aggressive) captures the investment premium.

Recent literature suggests that ESG could be considered a distinct factor, or alternatively, that high-ESG scoring firms load significantly on quality (RMW) and low volatility factors {cite_005}{cite_038}. Understanding these factor exposures is crucial for determining whether the outperformance of sustainable portfolios is due to genuine "green alpha" or simply a byproduct of exposure to well-known quality and low-volatility factors.

#### 2.1.1.3 The Self-Financing Portfolio Concept

A self-financing portfolio, often implemented as a long-short strategy, involves purchasing securities expected to outperform (long position) and selling short securities expected to underperform (short position), such that the net initial investment is zero. Mathematically, the budget constraint for a self-financing strategy at time $t$ is:

$$\sum_{i=1}^{N} w_{i,t} = 0$$

Where $w_{i,t}$ represents the weight of asset $i$. In the context of sustainable finance, this typically translates to going long on high-ESG firms ("Green") and shorting low-ESG firms ("Brown") {cite_015}. This approach, often termed a "factor-mimicking portfolio" for ESG, allows investors to isolate the pure return premium associated with sustainability attributes while hedging out market risk.

Recent theoretical work has expanded this concept to include "Net Zero" alignment as a driver of alpha. Casady and Monk {cite_MISSING: Casady, Monk (2025) The logic of net zero investment portfolios} argue that the transition to a low-carbon economy creates structural shifts in asset pricing. They propose that long-term investors can capture a "transition premium" through time horizon arbitrage, positioning portfolios to benefit from the repricing of carbon risk. This suggests that self-financing strategies based on climate transition criteria may offer superior risk-adjusted returns compared to static ESG screening.

### 2.1.2 Approaches to ESG Integration

The literature identifies several distinct methodologies for integrating sustainability into investment portfolios. These approaches range from passive exclusionary screens to active quantitative strategies. Table 1 summarizes the primary integration frameworks discussed in recent academic research.

| Strategy | Mechanism | Theoretical Impact | Key Literature |
|----------|-----------|--------------------|----------------|
| Negative Screening | Excluding controversial sectors | Reduced diversification | {cite_014} |
| Best-in-Class | Selecting top ESG performers | Maintains sector balance | {cite_008}{cite_036} |
| ESG Integration | Adjusting valuation models | Improved risk pricing | {cite_049} |
| Thematic Investing | Targeting specific outcomes | High idiosyncratic risk | {cite_013}{cite_033} |
| Long-Short (L/S) | Long Green / Short Brown | Market neutral alpha | {cite_015} |

*Table 1: Comparative Analysis of ESG Investment Strategies. Adapted from {cite_008} and {cite_014}.*

#### 2.1.2.1 Exclusionary Screening

Exclusionary screening remains the oldest and most widely adopted sustainable investment strategy. It involves removing sectors or companies that conflict with specific values, such as tobacco, weapons, or fossil fuels. Dimson, Marsh, and Staunton {cite_014} provide a critical analysis of this approach, noting that while it satisfies ethical mandates, it may not effectively drive corporate change. From a financial perspective, exclusion creates tracking error relative to broad market benchmarks. However, the impact on risk-adjusted returns is debated; some studies suggest that "sin stocks" historically provided a risk premium that exclusionary investors forego, while others argue that this premium is disappearing as regulation increases.

#### 2.1.2.2 Best-in-Class and Positive Screening

To mitigate the diversification problems of exclusion, the "Best-in-Class" approach selects the most sustainable companies within each sector. This method ensures that the portfolio maintains sector weights similar to the benchmark, thereby reducing active risk. Tadoori and Usha Kiran {cite_036} analyze MSCI ESG indices and find that portfolios constructed using positive screening often exhibit financial characteristics similar to, or better than, traditional market-cap-weighted portfolios. This suggests that sustainability does not necessarily come at the cost of performance when sector neutrality is preserved.

#### 2.1.2.3 Quantitative and Self-Financing Strategies

More advanced integration involves quantitative strategies that treat ESG scores as data inputs for alpha generation. Orpiszewski et al. {cite_MISSING: Orpiszewski et al. (2025) Should You Short or Exclude the ESG Sinners?} investigate the efficiency of shorting "ESG sinners" versus simply excluding them. Their findings suggest that active long-short strategies can exploit the overvaluation of poor ESG performers, potentially generating significant alpha. This aligns with the concept of "pure self-financing trading strategies" discussed by Eric {cite_015}, which operate under transaction cost constraints.

In these strategies, the "Green Minus Brown" (GMB) factor is constructed similarly to Fama and French's HML factor. The literature indicates that the performance of such factors is highly regime-dependent. During periods of high climate awareness or regulatory tightening, the long leg (Green) tends to outperform, while the short leg (Brown) suffers from increased cost of capital and stranded asset risk.

### 2.1.3 Empirical Evidence on Financial Performance

The central question in the literature remains: Does sustainable investing generate superior financial returns? The empirical evidence from the 2010-2020 decade provides mixed but increasingly positive results, distinguishing between risk mitigation and pure alpha generation.

#### 2.1.3.1 The "Doing Well by Doing Good" Hypothesis

A significant body of research supports the hypothesis that high-ESG companies exhibit superior financial performance. Franzén {cite_023} analyzes ESG portfolios and stock returns, finding evidence that sustainable attributes can enhance financial performance, particularly over longer time horizons. This outperformance is often attributed to operational efficiency, better human capital management, and innovation capabilities.

Similarly, Kumar and Sinha {cite_039} explore the landscape of sustainable finance, noting that the inclusion of social and environmental factors has become a driving force for economic transformation. Their review suggests that the market increasingly prices in sustainability, rewarding companies with robust ESG profiles with a lower cost of equity.

However, the "Green Alpha" phenomenon is not uniform. Some studies suggest that as ESG investing becomes more popular, the valuation premiums for green stocks increase, potentially depressing future expected returns. This leads to a paradox where sustainable companies are safer (lower risk) but offer lower expected returns, consistent with standard asset pricing theory.

#### 2.1.3.2 Risk Mitigation and Downside Protection

Perhaps the most consistent finding in the literature is the link between ESG and risk reduction. Lupu et al. {cite_025} investigate the risk management properties of companies included in the EURO STOXX Sustainability Index. Their analysis of investor perception reveals that sustainable companies are viewed as having lower idiosyncratic and systematic risks compared to their peers. This perception is grounded in the reality that strong governance and environmental stewardship reduce the probability of catastrophic events (e.g., oil spills, fraud, lawsuits).

Hübel and Scholz {cite_049} further emphasize the role of ESG ratings in integrating sustainability risks into asset management. They argue that ESG exposures serve as a proxy for operational quality and resilience. During market downturns, such as the COVID-19 crisis in early 2020, high-ESG portfolios demonstrated superior resilience, experiencing smaller drawdowns than the broader market. This "insurance-like" property of ESG assets makes them particularly attractive for self-financing portfolios that seek to minimize volatility.

#### 2.1.3.3 The Green Bond Market

The emergence of the green bond market provides another avenue for analyzing the risk-return profile of sustainable assets. Hussain et al. {cite_013} evaluate green bonds and sustainable investment strategies using data from 2018 to 2023. They investigate the "greenium" (green premium), where investors accept lower yields for green bonds in exchange for their environmental impact. The existence of a greenium implies a lower cost of capital for issuers, which theoretically should boost the equity valuation of firms issuing these bonds.

Lei, Bao, and Zhao {cite_002} conduct a comparative analysis of green investment portfolios, including asset-backed securities. Their findings highlight that digital finance and green financial instruments can significantly contribute to a zero-carbon environment while offering competitive financial returns. This reinforces the interconnectedness of equity and fixed-income markets in pricing sustainability risks.

### 2.1.4 Data Challenges and Rating Divergence

A critical limitation in the empirical literature is the reliability of ESG data. Unlike financial data, which is standardized by accounting principles (GAAP/IFRS), ESG data lacks a universal reporting standard.

#### 2.1.4.1 The "Aggregate Confusion"

Liu {cite_019} addresses the issue of quantitative ESG disclosure and the divergence of ESG ratings. The study documents a phenomenon often termed "aggregate confusion," where different rating agencies assign vastly different scores to the same company. This divergence stems from differences in measurement, scope, and weightings of various attributes.

For a self-financing portfolio, this divergence presents a significant risk. A strategy that goes long on "Green" stocks and short on "Brown" stocks based on Agency A's ratings might look completely different if Agency B's ratings were used. This inconsistency creates noise in the "ESG factor," making it difficult to isolate a pure sustainability signal. Researchers must therefore be cautious in their methodology, often resorting to composite scores or focusing on specific, objective metrics (e.g., carbon intensity) rather than aggregate ratings.

#### 2.1.4.2 Regulatory Responses

To combat data inconsistency and "greenwashing," regulators have intervened. The European Union's Action Plan on Sustainable Finance represents the most ambitious regulatory framework to date. Chenaux and Piller {cite_043} and Lovisolo {cite_044} analyze the impact of the EU Action Plan on banks and capital costs. They find that regulation is driving a standardization of taxonomy, which should improve market efficiency over time.

Silvestri and Kamerling {cite_046} present a CFA Institute survey on the ESG regulatory framework, highlighting that while progress has been made, complex regulations and unreliable data remain primary challenges for investors. The push for transparency is expected to reduce information asymmetry, theoretically strengthening the relationship between ESG characteristics and asset prices.

### 2.1.5 Regional and Sectoral Nuances

The performance of sustainable portfolios is not uniform across geographies or sectors. The literature reveals significant heterogeneity based on market maturity and regional economic structures.

#### 2.1.5.1 Emerging vs. Developed Markets

While most early research focused on US and European markets, recent studies have expanded to emerging economies. Özer et al. {cite_011} test the Fama-French five-factor model in selected Islamic countries, providing a framework for analyzing factor premiums in non-Western markets.

Dai {cite_035} specifically investigates sustainable investing within the Organisation of Islamic Cooperation (OIC) countries. The study finds a natural alignment between Islamic finance principles (Shariah compliance) and ESG criteria, as both prohibit investment in harmful industries (alcohol, gambling, pork). This synergy suggests that self-financing strategies in these regions could leverage both religious and sustainability screens to enhance performance.

Conversely, Lewin and Campani {cite_009} examine factor-based investing in the Brazilian stock market. Their work on optimal constrained strategies highlights the volatility and unique risk factors present in emerging markets, where governance (the 'G' in ESG) often plays a more critical role in pricing than environmental factors.

#### 2.1.5.2 Energy and Ecology Nexus

The relationship between the energy sector and sustainable portfolios is complex. Swamy and Tiwari {cite_033} examine the "clean energy-ecology interrelatedness" using S&P Dow Jones Indices. They find a strong interdependence between clean energy investments and broader ecological firms. This sector-specific correlation is vital for portfolio construction, as it implies that a "Green" portfolio might have unintended concentration risk in the energy or technology sectors.

Waite and Modi {cite_041} provide a technical analysis of greenhouse gas emissions related to home heating, emphasizing the need for granular data in assessing environmental impact. Such sector-specific studies underscore the importance of looking beyond top-level ESG scores to understand the physical transition risks embedded in portfolio holdings.

### 2.1.6 Momentum and Advanced Quantitative Techniques

Recent literature has begun to apply advanced machine learning and statistical techniques to enhance ESG strategies. Chen, Sun, and Ge {cite_029} study momentum strategies using LightGBM models. While their focus is on general momentum, the application of such non-linear models to ESG investing is a growing trend. Researchers are increasingly using natural language processing (NLP) to analyze corporate disclosures and news sentiment, creating "real-time" ESG signals that may offer a distinct advantage over backward-looking annual ratings.

McDonald {cite_038} discusses the role of major asset managers like BlackRock in popularizing factor models. The institutionalization of these models means that ESG factors are now routinely integrated into risk management systems (e.g., Aladdin), further embedding sustainability into the fabric of market pricing.

### 2.1.7 Synthesis and Research Gaps

The review of the literature from 2010 to 2020 reveals a maturing field that has moved from basic performance comparisons to sophisticated factor analysis. Table 2 provides a synthesis of key empirical studies and their primary contributions to the field.

| Author(s) | Focus Area | Key Findings | Methodology |
|-----------|------------|--------------|-------------|
| Franzén {cite_023} | Portfolio Returns | ESG can enhance financial performance | Empirical Analysis |
| Hübel & Scholz {cite_049} | Risk Management | ESG exposures proxy for risk; better drawdown protection | Factor Analysis |
| Liu {cite_019} | ESG Ratings | "Aggregate Confusion" leads to rating divergence | Correlation Analysis |
| Hussain et al. {cite_013} | Green Bonds | Existence of "greenium" in bond markets | Regression Analysis |
| Casady & Monk {cite_MISSING: Casady, Monk (2025)} | Net Zero Portfolios | Transition risk creates alpha opportunities | Theoretical Framework |
| Orpiszewski et al. {cite_MISSING: Orpiszewski et al. (2025)} | Long-Short Strategies | Shorting "sinners" adds value over exclusion | Quantitative Backtest |

*Table 2: Summary of Key Literature Findings. Source: Compiled by author.*

#### 2.1.7.1 Identified Research Gaps

Despite the extensive literature, several critical gaps remain, which this thesis aims to address:

1.  **The Self-Financing Gap:** While many studies analyze long-only ESG portfolios or compare green indices to benchmarks, there is a scarcity of rigorous analysis on *pure self-financing* (zero-investment) portfolios constructed specifically on sustainability criteria during the 2010-2020 decade. Most long-short studies focus on the US market, with less attention paid to global or European constraints.
2.  **Interaction of ESG and Traditional Factors:** There is conflicting evidence on whether the "Green Factor" is distinct or merely a proxy for Quality or Low Volatility. A detailed attribution analysis using the Fama-French five-factor model is needed to decompose the returns of self-financing ESG strategies.
3.  **Net Zero as a Factor:** The concept of "Net Zero" alignment is relatively new (post-2015 Paris Agreement). Literature specifically isolating the performance of portfolios optimized for *decarbonization pathways* (rather than static ESG scores) is still nascent, as highlighted by Casady and Monk {cite_MISSING: Casady, Monk (2025)}.
4.  **Transaction Costs in Self-Financing:** Theoretical models often assume frictionless markets. However, self-financing strategies involving high turnover (to maintain ESG alignment) incur significant transaction costs. Empirical analysis incorporating realistic transaction costs for ESG rebalancing is limited.

### 2.1.8 Conclusion of Literature Review

The academic discourse on sustainable finance has fundamentally shifted. It is no longer a question of *if* ESG affects portfolio performance, but *how* and *why*. The literature demonstrates that while exclusionary screening may impose diversification costs, active integration and self-financing strategies offer pathways to capture new sources of risk premia.

However, the heterogeneity of ESG data, the evolving regulatory landscape, and the complex interaction with traditional risk factors pose significant challenges. The existing body of work suggests that a self-financing portfolio that goes long on high-sustainability firms and short on low-sustainability firms should theoretically generate positive alpha, provided it controls for sector biases and factor exposures.

This thesis builds upon these foundations by empirically testing the performance of such self-financing portfolios between 2010 and 2020. By utilizing the Fama-French five-factor model and addressing the identified gaps regarding factor attribution and practical implementation, this research contributes to the ongoing debate on the financial viability of the transition to a sustainable economy. The subsequent methodology section will detail the specific construction of these portfolios and the econometric models used to validate the hypotheses derived from this literature review.