# Green Alpha or Transaction Costs? Evaluating Self-Financing ESG Strategies in Constrained Markets (2010-2020)

## 1.1 Background of the Study

The decade spanning from 2010 to 2020 witnessed a fundamental paradigm shift in global financial markets, characterized by the transition from a purely shareholder-centric model to one that increasingly integrates broader stakeholder considerations. This period marked the maturation of Environmental, Social, and Governance (ESG) criteria from niche investment styles into central components of institutional portfolio construction {cite_039}. While the theoretical underpinnings of sustainable finance have existed for decades, the post-2008 financial crisis era provided the necessary catalyst for investors to re-evaluate the relationship between non-financial risks and long-term asset performance. Consequently, the integration of sustainability risks into asset management has become a focal point for both academic inquiry and industry practice, driven by the premise that ESG factors are material to financial performance {cite_049}.

The evolution of sustainable investing during this timeframe was not merely a change in investor sentiment but was underpinned by significant structural changes in market mechanisms and regulatory frameworks. The traditional dichotomy between profit maximization and social responsibility, often framed as a dilemma between shareholder value and long-term business sustainability, began to dissolve {cite_007}. Investors increasingly sought to capture "Green Alpha"—excess returns attributed to superior sustainability performance—while simultaneously mitigating tail risks associated with environmental regulation and social controversies. This shift is evidenced by the rapid expansion of ESG coverage and the proliferation of specialized investment vehicles, such as sustainable Exchange Traded Funds (ETFs) and green bonds {cite_008}{cite_013}.

However, the rapid adoption of ESG strategies has outpaced the empirical consensus regarding their efficacy, particularly when implemented through sophisticated quantitative strategies. One such approach is the self-financing portfolio, often executed as a long-short strategy where an investor goes long on high-ESG assets and short on low-ESG assets, theoretically requiring zero net investment capital. While mathematically elegant, the practical implementation of such strategies is fraught with challenges, primarily related to transaction costs and market constraints {cite_015}. Furthermore, the period between 2010 and 2020 introduced complex regulatory environments, such as the European Union’s Action Plan on Sustainable Finance, which fundamentally altered the cost of capital and the compliance landscape for financial institutions {cite_043}{cite_044}.

Understanding the performance of these self-financing portfolios requires a rigorous examination of the interplay between theoretical factor models and the practical realities of trading in constrained markets. The emergence of digital finance and the availability of granular ESG data have enabled more precise measurement of green investment performance, yet they have also introduced new sources of noise and divergence in ratings {cite_002}{cite_019}. Therefore, this thesis seeks to dissect the performance of self-financing portfolios with additional consideration of sustainability aspects, isolating the true economic value added by ESG factors after accounting for the frictional costs of implementation.

### 1.1.1 The Evolution of Sustainable Finance Definitions
The terminology surrounding sustainable finance has evolved significantly, leading to a complex lexicon that often complicates empirical analysis. Initially rooted in exclusionary screening—the simple removal of "sin stocks" from a portfolio—the field has expanded to encompass positive screening, integration, and impact investing {cite_014}{cite_034}.

Table 1 provides a comparative overview of these investment approaches as they developed and solidified during the 2010-2020 observation period.

| Approach | Key Mechanism | Primary Objective | Citation |
|:---|:---|:---|:---|
| Exclusionary Screening | Removing specific sectors (e.g., tobacco, weapons) | Moral alignment, risk avoidance | {cite_014} |
| ESG Integration | Including ESG factors in financial analysis | Risk-adjusted return enhancement | {cite_049} |
| Impact Investing | Targeting measurable social/environmental outcomes | Dual goal: Financial + Social return | {cite_034} |
| Best-in-Class | Selecting top ESG performers within sectors | Outperformance relative to peers | {cite_023} |
| Thematic Investing | Focusing on trends like clean energy | Capitalizing on structural shifts | {cite_033} |

*Table 1: Evolution of Sustainable Investment Strategies. Source: Adapted from {cite_014}, {cite_034}, and {cite_049}.*

As illustrated in Table 1, the sophistication of strategies has increased. Early strategies focused primarily on risk avoidance through exclusion, a method that often resulted in tracking error relative to broad market benchmarks {cite_014}. By the mid-2010s, the focus shifted toward integration and "best-in-class" selection, which arguably allows for better diversification while maintaining a sustainability tilt. This evolution is critical for the construction of self-financing portfolios, as the selection criteria for the "long" and "short" legs of the portfolio depend entirely on how sustainability is defined and measured. The rise of thematic investing, particularly in clean energy and ecology-focused firms, further complicated the landscape by introducing sector-specific volatility that may not be captured by broad market ESG indices {cite_033}.

### 1.1.2 The Regulatory and Institutional Context
The institutional environment between 2010 and 2020 played a decisive role in shaping the performance of ESG strategies. The global push for transparency, exemplified by the World Economic Forum’s initiatives and the subsequent availability of "Davos Data," increased the pressure on corporations to disclose non-financial information {cite_048}. In Europe, the EU Action Plan on Sustainable Finance represented a watershed moment, aiming to reorient capital flows toward sustainable investment. This regulatory push not only impacted the strategic direction of Swiss and European banks but also influenced the cost of capital for firms based on their sustainability profiles {cite_043}{cite_044}.

Regulatory frameworks act as exogenous shocks to the self-financing portfolio. If regulation effectively lowers the cost of capital for high-ESG firms (the long leg) and raises it for low-ESG firms (the short leg), the theoretical spread of the portfolio should widen, generating positive alpha. However, the implementation of these regulations also imposes compliance costs and reporting burdens that can affect market liquidity and, by extension, the transaction costs associated with rebalancing these portfolios {cite_046}. The interaction between these regulatory tailwinds and the mechanical headwinds of trading costs forms a central tension explored in this thesis.

## 1.2 Theoretical Framework

The theoretical foundation of this research lies at the intersection of Modern Portfolio Theory (MPT), Asset Pricing Theory, and the burgeoning literature on Environmental, Social, and Governance economics. To evaluate the self-financing portfolio, one must first establish the validity of the factor models used to explain returns and then overlay the sustainability constraints.

### 1.2.1 Factor Models in Asset Pricing
The decomposition of asset returns into systematic risk factors is a cornerstone of modern financial economics. Building upon the Capital Asset Pricing Model (CAPM), the Fama-French three-factor model and its subsequent five-factor expansion have become the standard for evaluating portfolio performance {cite_005}{cite_011}. These models posit that differences in average returns are explained by exposure to specific risk factors such as market risk, size, value, profitability, and investment patterns.

In the context of this study, the critical question is whether "Sustainability" or "ESG" constitutes a distinct risk factor analogous to value or size, or if it is merely a composite that can be explained by existing factors. Recent literature suggests that factor models are essential for distinguishing between alpha (manager skill) and beta (factor exposure) in investment strategies {cite_038}. When constructing a self-financing portfolio based on ESG rankings, it is imperative to control for these traditional factors to ensure that any observed outperformance is not simply a result of unintended tilts toward, for example, large-cap or quality stocks, which often correlate with high ESG ratings {cite_009}.

The application of these models varies across different market conditions. For instance, research in developing and Islamic markets has shown that alternative specifications of the Fama-French model may be required to capture local market dynamics {cite_011}. This is relevant for the 2010-2020 period, which saw significant divergence in the performance of factor strategies across developed and emerging economies. The robustness of factor models provides the mathematical framework necessary to isolate the "Green Alpha" from broader market movements.

### 1.2.2 The Mechanics of Self-Financing Portfolios
A self-financing trading strategy is defined as a portfolio construction method where the cost of purchasing assets is entirely funded by the proceeds from selling other assets short, resulting in a zero net investment at the inception of the trade {cite_015}. In the context of ESG, this typically involves:
1.  Ranking the investment universe by ESG score.
2.  Taking a long position in the top decile or quintile (High ESG).
3.  Taking a short position in the bottom decile or quintile (Low ESG).

Theoretically, in a frictionless market, the return of this portfolio represents the pure premium associated with the ESG factor. However, the assumption of a frictionless market is violated in reality by transaction costs, bid-ask spreads, and borrowing costs for short selling. Eric (2006) demonstrates that under transaction costs, the dynamics of self-financing strategies change fundamentally; the continuous rebalancing required to maintain the "self-financing" property can erode the theoretical arbitrage profits {cite_015}.

This constraint is particularly acute for ESG strategies. High-ESG companies tend to be large, liquid, and stable, making them cheap to buy. Conversely, low-ESG companies may be distressed, volatile, or smaller, making them expensive or difficult to short. This asymmetry introduces a structural cost to the self-financing ESG portfolio that is often overlooked in stylized academic studies. Furthermore, the momentum effects observed in financial markets can influence the timing and profitability of these trades, necessitating the use of advanced modeling techniques to optimize entry and exit points {cite_029}.

### 1.2.3 ESG as a Risk Mitigation Tool
Beyond the pursuit of alpha, the theoretical argument for ESG integration rests on risk mitigation. Companies with robust governance and environmental practices are theoretically less exposed to catastrophic risks, litigation, and regulatory fines. Research indicates that inclusion in sustainability indices, such as the EURO STOXX Sustainability Index, is perceived by investors as a signal of lower risk relative to peers {cite_025}. This perception should theoretically translate into a lower required rate of return (cost of equity) for high-ESG firms and a higher one for low-ESG firms.

However, the relationship between ESG ratings and credit risk is complex. While some studies suggest a correlation between ESG assessments and corporate credit ratings, implying that creditors price ESG risks, the strength of this signal can vary {cite_028}. If the market efficiently prices these risks, the "Green Alpha" might be arbitraged away, leaving the self-financing portfolio with a return of zero (or negative, after costs). Conversely, if the market under-reacts to sustainability risks, the long-short strategy should generate positive abnormal returns. This thesis investigates which of these theoretical states prevailed during the 2010-2020 decade.

## 1.3 Problem Statement

Despite the proliferation of research on sustainable finance, a significant gap remains in the rigorous evaluation of self-financing ESG strategies when accounting for realistic market frictions and data inconsistencies. The existing literature presents a fragmented view: some studies claim significant outperformance for green portfolios {cite_002}, while others suggest that ESG constraints constrain the efficient frontier, leading to suboptimal financial performance {cite_036}.

Three specific problems undermine the current understanding of this topic:

**First, the divergence of ESG ratings creates a fundamental measurement error problem.** Unlike financial metrics (e.g., Price-to-Book ratio), which are standardized, ESG ratings are subjective and vary significantly across providers {cite_019}. This divergence means that a "High ESG" portfolio constructed using data from one provider may look fundamentally different from one constructed using another. This lack of convergence creates noise in the selection process for self-financing portfolios, potentially diluting the factor signal and leading to inconsistent performance attribution {cite_049}.

**Second, the impact of transaction costs on long-short ESG strategies is frequently underestimated.** While theoretical models of self-financing strategies exist {cite_015}, few empirical studies explicitly quantify the erosion of ESG premiums caused by the turnover required to maintain high sustainability scores. As companies' ESG ratings change, the portfolio must be rebalanced. If the turnover rate of the ESG factor is high, the transaction costs could exceed the alpha generated, rendering the strategy economically unviable despite statistical significance in a friction-free model.

**Third, the interplay between different asset classes and regional constraints is often ignored.** Most studies focus on developed equity markets. However, the dynamics of sustainable investing vary across regions (e.g., OIC countries vs. Western markets) and asset classes (e.g., equities vs. green bonds) {cite_013}{cite_035}. The assumption that a self-financing strategy works uniformly across these disparate environments is a strong one that requires empirical testing.

Therefore, the central problem this thesis addresses is the lack of a comprehensive, transaction-cost-adjusted performance analysis of self-financing ESG portfolios during the critical maturation period of 2010-2020, specifically dealing with the noise introduced by rating divergence and market constraints.

## 1.4 Research Questions and Objectives

To address the identified problem statement, this thesis aims to empirically evaluate the risk-adjusted performance of self-financing portfolios constructed based on sustainability criteria. The research is guided by the following primary research question:

*Does a self-financing trading strategy based on ESG factors generate statistically significant positive risk-adjusted returns after accounting for transaction costs and standard risk factors between 2010 and 2020?*

To provide a granular analysis, this primary question is decomposed into specific sub-questions and corresponding objectives, detailed in Table 2.

| Research Question | Research Objective | Theoretical Link |
|:---|:---|:---|
| **RQ1:** Do ESG-based self-financing portfolios outperform traditional benchmarks in terms of risk-adjusted returns (Sharpe/Information Ratio)? | To quantify the "Green Alpha" vs. "Green Penalty" in a long-short framework. | Factor Models & Performance Attribution {cite_002}{cite_036} |
| **RQ2:** How do transaction costs affect the profitability of self-financing ESG strategies? | To determine the economic viability of the strategy under realistic trading frictions. | Self-financing strategies under transaction costs {cite_015} |
| **RQ3:** To what extent do different factor models (CAPM, FF3, FF5) explain the returns of ESG portfolios? | To isolate whether ESG is a distinct factor or a proxy for existing style factors (e.g., Quality, Size). | Asset Pricing Theory {cite_005}{cite_011} |
| **RQ4:** Did the performance of these strategies shift structurally following major regulatory announcements (e.g., EU Action Plan)? | To analyze the impact of regulatory regime changes on ESG asset pricing. | Regulatory Impact & Cost of Capital {cite_044}{cite_046} |

*Table 2: Research Framework and Objectives. Source: Author's elaboration based on {cite_002}, {cite_015}, and {cite_044}.*

The objectives outlined in Table 2 necessitate a quantitative methodology involving the construction of mimetic portfolios. By systematically addressing these questions, the study intends to move beyond the binary debate of "does ESG work?" to the more nuanced "under what friction-adjusted conditions is ESG arbitrage profitable?"

## 1.5 Significance of the Study

The significance of this research extends to both the academic community and the practical world of asset management.

**Academic Contribution:**
This thesis contributes to the literature on asset pricing by explicitly testing the limits of arbitrage in the context of sustainability. While papers like Eric (2006) provide the mathematical basis for self-financing strategies under transaction costs {cite_015}, and others analyze green portfolio performance {cite_002}, there is limited synthesis of these two streams. By applying the rigorous constraints of self-financing logic to the nebulous data of ESG, this study tests the efficiency of the market in pricing non-financial information. Furthermore, it adds to the debate on ESG rating divergence {cite_019} by demonstrating the economic consequences (in terms of returns) of this data heterogeneity.

**Practical Contribution:**
For portfolio managers and institutional investors, the findings of this study are directly actionable. As sustainable investing moves from active selection to passive and factor-based implementations, understanding the "implementation shortfall"—the difference between paper returns and realized returns—is crucial. The analysis of Morningstar style boxes and mutual fund returns suggests that style consistency is vital for performance {cite_040}. This thesis provides evidence on whether ESG strategies can maintain their style purity without incurring prohibitive costs. Additionally, the insights into the regulatory impact {cite_046} will help compliance and strategy officers navigate the evolving landscape of the EU Action Plan and beyond.

**Policy Implications:**
Finally, the study offers insights for policymakers. If the analysis reveals that transaction costs negate the benefits of ESG investing, it suggests that market frictions are hindering the capital reallocation goals of initiatives like the EU Action Plan {cite_044}. Understanding these barriers is essential for designing regulations that not only mandate disclosure but also facilitate the efficient flow of capital to sustainable activities.

## 1.6 Scope and Limitations

The scope of this thesis is defined by specific temporal, geographical, and methodological boundaries.

**Temporal Scope:** The analysis covers the period from January 1, 2010, to December 31, 2020. This decade was chosen to capture the post-financial crisis recovery and the subsequent boom in ESG investing, ending with the onset of the COVID-19 pandemic. This period provides a complete market cycle for analysis, although it excludes the inflationary regime that began in late 2021.

**Methodological Scope:** The study focuses exclusively on "self-financing" or zero-cost portfolios (Long-Short). Long-only strategies are considered only as benchmarks. The analysis utilizes standard factor models (Fama-French) and does not extend to machine learning-based prediction models, although recent literature suggests their utility in momentum studies {cite_029}.

**Data Limitations:** A primary limitation is the reliance on available ESG data. As noted in the literature, ESG ratings suffer from divergence and lack of standardization {cite_019}. The study assumes that the ratings used are representative of the information available to investors at the time of trade execution. Furthermore, while transaction costs are modeled, they are estimates based on liquidity proxies rather than actual proprietary trading data.

**Asset Class Limitation:** The primary focus is on public equities. While green bonds and other sustainable instruments are growing in importance {cite_013}, the equity market remains the primary venue for factor-based ESG strategies due to liquidity and data availability.

## 1.7 Thesis Structure

The remainder of this thesis is organized as follows:

**Chapter 2: Literature Review** provides a comprehensive survey of the existing academic work. It begins by exploring the theoretical underpinnings of sustainable investing {cite_008} and the specific mechanisms of factor models {cite_005}. It then delves into the empirical evidence regarding ESG performance, contrasting studies that find positive correlations {cite_023} with those identifying negative or neutral results. A dedicated section reviews the literature on transaction costs in self-financing strategies {cite_015} and the specific challenges of ESG data quality {cite_019}.

**Chapter 3: Methodology** outlines the data sources, variable definitions, and econometric models employed. It details the construction of the self-financing portfolios, the specification of the Fama-French factor models {cite_011}, and the mathematical approach used to simulate transaction costs.

**Chapter 4: Analysis and Results** presents the empirical findings. It reports the descriptive statistics of the portfolios, the regression results from the factor models, and the comparative performance analysis. Tables and figures will illustrate the cumulative returns, volatility, and Sharpe ratios of the ESG strategies versus traditional benchmarks.

**Chapter 5: Discussion** interprets the results in the context of the theoretical framework. It analyzes whether the observed performance constitutes true alpha or risk premia and discusses the implications of regulatory changes {cite_044}. The discussion also addresses the divergence of results compared to prior studies {cite_036}.

**Chapter 6: Conclusion** summarizes the key findings, answers the research questions, and offers recommendations for future research and practice.

This structure ensures a logical progression from theoretical concepts to empirical evidence, providing a robust answer to whether self-financing ESG strategies offered a viable path to alpha in the constrained markets of the 2010s. The following chapter begins this journey by critically examining the existing body of knowledge surrounding sustainable finance and portfolio theory.