# Paper Architecture

**Paper Type:** Empirical Master's Thesis
**Research Question:** Does a self-financing Long-Short ESG portfolio generate significant risk-adjusted alpha after accounting for transaction costs and market constraints between 2010 and 2020?
**Target Audience:** Academic examiners, Quantitative Portfolio Managers
**Estimated Length:** 25,000 - 30,000 words (approx. 80-100 pages)

---

## Core Argument Flow

**Draft Statement:** While self-financing ESG portfolios may show theoretical alpha in ideal conditions, the "Transition Alpha" is significantly eroded when accounting for realistic transaction costs and short-selling constraints inherent in global markets.

**Logical Progression:**
1.  **Context:** Factor investing is established, but ESG is a contested new "factor."
2.  **Problem:** Existing literature bifurcates between sophisticated DM models (ignoring costs) and basic EM validation (ignoring complexity).
3.  **Method:** We construct a self-financing (zero-cost) portfolio: Long High-ESG / Short Low-ESG.
4.  **Analysis:** We test this across 2010-2020, first assuming perfect markets, then introducing friction (transaction costs, borrowing fees).
5.  **Finding:** The "Greenium" exists but is harder to capture than reported; constraints (like Sharia/regulations) alter the viability significantly.
6.  **Implication:** Investors need "Smart ESG" implementation that accounts for liquidity costs, not just raw ESG scores.

---

## Thesis Structure

### 1. Title Page & Front Matter
**Suggested Title:** "The Self-Financing Portfolio with Additional Consideration of Sustainability Aspects (2010-2020): A Performance and Friction Analysis"
**Alternative:** "Green Alpha or Transaction Costs? Evaluating Self-Financing ESG Strategies in Constrained Markets (2010-2020)"

### 2. Abstract (300-500 words)
- **Context:** Integration of ESG into Fama-French frameworks.
- **Gap:** Lack of realistic cost/constraint modeling in self-financing ESG strategies.
- **Method:** Long-Short portfolio construction (2010-2020) using Point-in-Time data to avoid look-ahead bias.
- **Results:** Gross returns vs. Net returns comparison.
- **Conclusion:** Sustainability adds information value, but implementation costs in illiquid/short-constrained markets negate pure arbitrage benefits.

### 3. Chapter 1: Introduction (2,500 words)
#### 1.1 Background
- The evolution from CAPM to Multi-Factor Models.
- The rise of ESG as an investment style vs. a risk factor.
- Definition of "Self-Financing Portfolio" (Zero net investment: Proceeds from Short = Cost of Long).

#### 1.2 Problem Statement
- **The Gap:** Literature ignores the "Implementation Gap." Papers show theoretical alpha but fail to account for the cost of shorting "Brown" stocks (often value stocks) and liquidity issues in EM/specific sectors.
- **Specific Issues:** Look-ahead bias in ESG data; prohibitive borrowing costs.

#### 1.3 Research Objectives
1. To construct a self-financing ESG factor portfolio.
2. To evaluate risk-adjusted performance (Sharpe, Sortino, Alpha) against standard benchmarks (MSCI World/EM).
3. To quantify the decay of returns when transaction costs and shorting constraints are applied.

#### 1.4 Thesis Structure
- Roadmap of the subsequent chapters.

### 4. Chapter 2: Theoretical Framework (4,000 words)
#### 2.1 Modern Portfolio Theory & Factor Investing
- Markowitz Efficient Frontier.
- CAPM and the limitation of Beta.
- Fama-French 3-Factor and 5-Factor models (The mathematical basis for the self-financing approach).

#### 2.2 Sustainable Finance Theory
- **Stakeholder Theory vs. Shareholder Primacy:** Theoretical basis for ESG outperformance.
- **Risk Mitigation View:** ESG as insurance against tail risk.
- **Mispricing View:** Behavioral biases causing under/overvaluation of Green/Brown assets.

#### 2.3 The Mechanics of Short Selling & Arbitrage
- Mathematics of Long-Short strategies.
- Limits to Arbitrage (Shleifer & Vishny): Why mispricing persists due to costs/risks.

### 5. Chapter 3: Literature Review (4,000 words)
#### 3.1 ESG and Financial Performance
- **The "Doing Well by Doing Good" Debate:** Summary of meta-analyses (Friede et al.).
- **Results divergence:** Why some studies show outperformance and others underperformance.

#### 3.2 Factor Investing and ESG
- Integration of ESG into Smart Beta.
- **Gap Analysis (Based on your input):**
    - Critique of sophisticated DM models (Paper 1 & 4 types) for ignoring friction.
    - Critique of EM studies (Paper 6 types) for lack of methodological sophistication.
- **The "Sin Stock" Anomaly:** Literature suggesting "Brown" stocks should outperform due to higher cost of capital (contrary to ESG alpha claims).

### 6. Chapter 4: Methodology (3,000 words)
#### 4.1 Data Description (2010-2020)
- **Universe:** [e.g., MSCI ACWI or specific regional focus].
- **ESG Data:** [Source: Refinitiv/MSCI/Sustainalytics]. *Crucial: Discussion of "Point-in-Time" data to address Look-Ahead Bias gap.*
- **Financial Data:** Prices, Market Cap, Book-to-Market ratios.

#### 4.2 Portfolio Construction
- **Sorting Mechanism:** Decile sorting based on ESG scores.
- **Strategy:** Long Top Decile (Green) / Short Bottom Decile (Brown).
- **Weighting:** Value-weighted vs. Equal-weighted.
- **Rebalancing:** Monthly/Quarterly.

#### 4.3 Performance Evaluation Models
- **Carhart 4-Factor Model Regression:** To isolate ESG alpha from Momentum/Value/Size.
- **Tail Risk Metrics:** VaR (Value at Risk), Maximum Drawdown.

#### 4.4 Friction Modeling (Addressing the Gap)
- **Transaction Cost Model:** Explicit modeling of spread + commission.
- **Shorting Cost Model:** Assumption of borrowing fees (hard-to-borrow adjustments).

### 7. Chapter 5: Empirical Results - Unconstrained (4,000 words)
#### 5.1 Descriptive Statistics
- Correlation matrices of ESG scores vs. traditional factors.
- Characteristics of the Long vs. Short portfolios (Sector biases).

#### 5.2 Performance Analysis (Gross Returns)
- Cumulative returns of the Self-Financing Portfolio.
- **Regression Results:** Factor loadings (is ESG just a proxy for Quality or Growth?).
- **Sub-period Analysis:** 2010-2015 vs. 2016-2020 (Paris Agreement impact).

### 8. Chapter 6: Empirical Results - Constrained & Robustness (4,000 words)
**This is the critical "Gap Filling" chapter.**

#### 6.1 Impact of Transaction Costs
- **Analysis:** Re-running performance with 10bps, 20bps, 50bps transaction costs.
- **Finding:** Break-even analysis – at what cost level does Alpha disappear?

#### 6.2 The Short-Selling Constraint (Islamic/Regulatory View)
- **Scenario A:** Long-Only ESG (Standard).
- **Scenario B:** Long-Short (Unconstrained).
- **Comparison:** Does the Short leg actually contribute positive alpha, or is it a drag? (Addressing the Sharia/Regulatory gap).

#### 6.3 Look-Ahead Bias Check
- Comparison of results using "Restated" ESG data vs. "Point-in-Time" data.

### 9. Chapter 7: Discussion (2,500 words)
#### 7.1 Interpreting the "Transition Alpha"
- Does the market price ESG risk correctly?
- The divergence between theoretical (Gross) and practical (Net) returns.

#### 7.2 Practical Implications
- **For Asset Managers:** The need for turnover management to preserve ESG alpha.
- **For Regulators:** How shorting constraints might hinder efficient price discovery in green transition.

### 10. Chapter 8: Conclusion (1,500 words)
#### 8.1 Summary of Findings
- Recap of the RQs and main evidence.

#### 8.2 Contributions
- Methodological contribution: Realistic friction modeling in ESG factors.
- Empirical contribution: 2010-2020 dataset analysis.

#### 8.3 Limitations & Future Research
- Data provider disagreement (ESG rating confusion).
- Scope limited to 2010-2020 (pre-inflationary spike).

---

## Evidence Placement Strategy

| Section | Focus | Key Evidence/Analysis |
|---------|-------|-----------------------|
| **Intro** | Hook | Contrast rapid ESG asset growth with mixed performance evidence. |
| **Lit Review** | Critique | Cite *Paper 1 & 4* (Sophisticated) vs *Paper 6* (Fundamental) to show the bifurcation gap. |
| **Methods** | Rigor | Detail the "Point-in-Time" data handling to refute Look-Ahead Bias. |
| **Results I** | Baseline | Show the "Greenium" exists in a friction-less vacuum (Gross Returns). |
| **Results II** | Reality | **Forest Plot/Table:** Net Returns after 50bps costs showing Alpha decay. |
| **Discussion** | Synthesis | Discuss how Shorting constraints (Sharia/EM) specifically alter the risk profile. |

---

## Quantitative Requirements (For Master's Level)

**You must generate/include:**
1.  **Descriptive Statistics Table:** Mean, Std Dev, Skewness, Kurtosis of ESG and Market returns.
2.  **Correlation Matrix:** ESG scores vs. Size, Value, Momentum.
3.  **Regression Tables:** Alphas and Betas from Fama-French 3-factor and 5-factor models (with t-statistics).
4.  **Equity Curves:** Visual comparison of Long-Short ESG vs. Market Neutral vs. Benchmarks.
5.  **Drawdown Charts:** Underwater plots for the strategy.
6.  **Cost Sensitivity Graph:** X-axis = Transaction Cost (bps), Y-axis = Information Ratio.

---

## Writing Priorities

1.  **Precision in Terminology:** Clearly distinguish between "ESG Screening" (exclusion) and "ESG Factor Investing" (systematic tilting).
2.  **Addressing the Gap:** Every time you present a positive result, immediately qualify it with the cost/constraint reality. This fulfills the "Evaluation" promise of the title.
3.  **Timeframe Context:** 2010-2020 is a specific regime (low interest rates, bull market). Acknowledge that this aids the Long leg of the portfolio.

## User Instructions

1.  **Data Collection:** Ensure you have access to a terminal (Bloomberg/Refinitiv) for 2010-2020 monthly data.
2.  **Software:** Use Python (pandas/statsmodels) or R for the regressions to ensure reproducibility.
3.  **Verification:** When writing Chapter 6, explicitly reference the "shorting cost" gap identified in the research analysis.