# Formatted Paper Outline

**Format Applied:** Empirical Master's Thesis (APA 7th Edition)
**Target Audience:** Academic Examiners, Quantitative Portfolio Managers
**Word Target:** ~25,000 - 30,000 words
**Citation Style:** APA 7th Edition

---

## Formatting Requirements

### Manuscript Specifications
- **Font:** Times New Roman 12pt (standard) or Arial 11pt.
- **Line Spacing:** Double-spaced throughout (including abstract and references).
- **Margins:** 1 inch (2.54 cm) on all sides. *Note: Check university guidelines for specific "binding margin" requirements (often 1.5 inch on left).*
- **Page Numbers:** Top right corner, starting on Title Page.
- **Running Head:** Shortened title (max 50 chars), all caps, top left.

### Heading Levels (APA 7)
- **Level 1 (Chapter Titles):** **Centered, Bold, Title Case**
- **Level 2 (Main Sections):** **Left-aligned, Bold, Title Case**
- **Level 3 (Subsections):** **_Left-aligned, Bold Italic, Title Case_**
- **Level 4:** **Indented, Bold, Title Case, End with Period.** (Text begins on same line)
- **Level 5:** **_Indented, Bold Italic, Title Case, End with Period._** (Text begins on same line)

### ⚠️ CITATION & REFERENCE RULES (CRITICAL)

**To all Crafter Agents:**
1.  **Style:** APA 7th Edition.
2.  **In-text:** Use `(Author, Year)` or `Author (Year)`.
    *   3+ Authors: `(Smith et al., 2020)` immediately.
3.  **DOIs:** Must be presented as hyperlinks: `https://doi.org/10.xxxx/xxxxx`.
4.  **Prohibited Links:** Do NOT use links to Google Scholar, Semantic Scholar, or ResearchGate in the reference list. Use the DOI or the Journal homepage.
5.  **Data Sources:** When citing financial data (Bloomberg, Refinitiv), cite the specific dataset and access date.

---

## Structure & Outline

### Title Page
**Suggested Title:** **Green Alpha or Transaction Costs? Evaluating Self-Financing ESG Strategies in Constrained Markets (2010-2020)**
*(Note: This title is more active and compelling than the "Additional Consideration" option, while retaining academic rigor.)*

**Elements:**
- Title
- Author Name
- Department/University
- Course/Degree Name
- Supervisor Name
- Date

### Abstract
**Page:** 2
**Format:** Single paragraph, no indentation, < 250 words (APA standard) or up to 500 (Thesis specific).
**Content:**
1.  **Problem:** ESG integration often ignores transaction costs in Long-Short strategies.
2.  **Method:** Construction of zero-cost portfolio (Long High-ESG/Short Low-ESG) using Point-in-Time data (2010-2020).
3.  **Results:** Contrast between gross theoretical alpha and net realizable alpha after friction.
4.  **Conclusion:** "Transition Alpha" exists but is eroded by liquidity constraints; simple ESG scores are insufficient for alpha generation.

**Keywords:** ESG Investing, Factor Models, Long-Short Strategy, Transaction Costs, Greenium.

---

### Chapter 1: Introduction
**Estimated Length:** 2,500 words

**1.1 Background and Context**
- The shift from CAPM to Multi-Factor Models (Fama-French).
- The emergence of ESG: From "negative screening" to "alpha factor."
- Definition of Self-Financing Portfolios in this context.

**1.2 Problem Statement**
- The "Paper Portfolio" problem: Academic literature often assumes perfect liquidity and zero borrowing costs.
- The bifurcation in literature: Sophisticated Developed Market (DM) models vs. basic Emerging Market (EM) validation.

**1.3 Research Question**
- *Primary:* Does a self-financing Long-Short ESG portfolio generate significant risk-adjusted alpha after accounting for transaction costs and market constraints between 2010 and 2020?
- *Secondary:* How do short-selling constraints (e.g., borrowing fees, regulatory bans) impact the "Greenium"?

**1.4 Research Objectives**
1.  Construct a Point-in-Time ESG factor portfolio.
2.  Quantify the "Friction Gap" (Gross vs. Net Returns).
3.  Analyze performance during market stress (e.g., Covid-19 onset in 2020).

**1.5 Significance of the Study**
- Contribution to the "Smart ESG" implementation debate.
- Practical relevance for Quantitative Portfolio Managers.

**1.6 Thesis Structure**
- Roadmap of the subsequent chapters.

---

### Chapter 2: Literature Review
**Estimated Length:** 6,000 words

**2.1 Theoretical Foundations of Asset Pricing**
- Modern Portfolio Theory (MPT).
- CAPM and the Arbitrage Pricing Theory (APT).
- Fama-French 3-Factor and 5-Factor Models.

**2.2 ESG as a Risk Factor**
- Theoretical arguments: Risk mitigation vs. Overvaluation (The "Greenium").
- *Table 1: Summary of Key Studies on ESG Performance (Meta-Analysis).*

**2.3 The Long-Short ESG Strategy**
- Mechanics of the strategy (buying leaders, shorting laggards).
- Review of empirical evidence in US vs. European markets.

**2.4 Implementation Friction in Academic Literature**
- **Transaction Costs:** Bid-ask spreads, market impact models.
- **Shorting Constraints:** Securities lending markets, hard-to-borrow lists.
- **Gap Analysis:** How few ESG studies rigorously apply these constraints.

**2.5 Hypotheses Development**
- *H1:* The unconstrained Long-Short ESG portfolio exhibits positive alpha.
- *H2:* Transaction costs reduce alpha to statistical insignificance.
- *H3:* Short-side constraints are the primary driver of performance erosion.

---

### Chapter 3: Data and Methodology
**Estimated Length:** 4,000 words

**3.1 Data Description**
- **Universe:** Global/Regional breakdown (e.g., MSCI World or S&P 500).
- **Timeframe:** Jan 2010 – Dec 2020.
- **ESG Data:** Source (e.g., MSCI, Sustainalytics) and handling of *Point-in-Time* data to prevent look-ahead bias.
- **Financial Data:** Price, Volume, Market Cap, Book-to-Market.

**3.2 Portfolio Construction Strategy**
- **Sorting Methodology:** Decile/Quintile sorting based on ESG scores.
- **Weighting Schemes:** Value-weighted vs. Equal-weighted.
- **Rebalancing Frequency:** Monthly vs. Quarterly.

**3.3 Modeling Frictions**
- **Transaction Cost Model:** Explicit (commissions) + Implicit (spread/impact).
- **Borrowing Cost Model:** Fee assumptions for shorting Low-ESG stocks.

**3.4 Performance Evaluation Models**
- **Equation 1:** CAPM Regression.
- **Equation 2:** Fama-French 5-Factor Regression.
- **Metrics:** Sharpe Ratio, Information Ratio, Maximum Drawdown, Turnover.

---

### Chapter 4: Empirical Results
**Estimated Length:** 8,000 words

**4.1 Descriptive Statistics**
- Characteristics of High-ESG vs. Low-ESG portfolios (Sector biases, Size biases).
- *Table 2: Descriptive Statistics of Portfolios.*

**4.2 The "Ideal" World: Unconstrained Performance**
- Cumulative returns of the Long-Short strategy (Gross).
- Factor loadings (Exposure to Market, Size, Value).
- *Figure 1: Cumulative Wealth Index (Unconstrained).*

**4.3 The "Real" World: Impact of Transaction Costs**
- Performance degradation at different cost basis points (bps).
- Break-even turnover analysis.
- *Table 3: Net Performance under Varying Cost Scenarios.*

**4.4 The Impact of Short-Selling Constraints**
- Analysis of "Hard-to-Borrow" Low-ESG firms.
- Impact of Sharia/Regulatory exclusions.

**4.5 Sub-Period Analysis**
- 2010-2015 (Early adoption) vs. 2016-2020 (Mainstream adoption).
- Performance during the 2020 Volatility spike.

---

### Chapter 5: Discussion
**Estimated Length:** 4,000 words

**5.1 Interpretation of Findings**
- Does the "Greenium" exist? (Comparing results to H1).
- The reality of "Transition Alpha" (Comparing results to H2 & H3).

**5.2 Comparison with Previous Studies**
- How this study contradicts or supports the "bifurcated" literature identified in Chapter 2.

**5.3 Implications for Portfolio Managers**
- The need for "Smart ESG" (optimizing for liquidity, not just score).
- The viability of Long-Only vs. Long-Short in ESG.

**5.4 Limitations**
- Data provider disagreement (ESG rating divergence).
- Estimation risk in transaction cost models.

---

### Chapter 6: Conclusion
**Estimated Length:** 1,500 words

**6.1 Summary of Key Findings**
- Restate that theoretical alpha exists but is largely inaccessible due to friction.

**6.2 Contributions to Knowledge**
- Empirical evidence of the cost of implementation in ESG factor investing.

**6.3 Recommendations for Future Research**
- Machine Learning for dynamic ESG weighting.
- Impact of carbon taxes on the "Short" leg of the portfolio.

---

### References
**Format:** APA 7th
**Expectation:** 80-120 references. High proportion of high-impact finance journals (*Journal of Finance, JFE, Review of Financial Studies*).

### Appendices
- **Appendix A:** Variable Definitions.
- **Appendix B:** Robustness Checks (Alternative rebalancing periods).
- **Appendix C:** Python/R Code Snippets (Portfolio Construction Logic).

---

## Quality Checklist for Crafters

1.  **Consistency:** Ensure the term "Long-Short" is used consistently (not "Long/Short" or "L/S" interchangeably).
2.  **Tables:** Ensure all regression tables report t-statistics or p-values clearly. Use asterisks for significance (*p<.05, **p<.01, ***p<.001).
3.  **Visuals:** All charts must be grayscale-friendly (use patterns or distinct markers, not just colors) as per standard academic printing requirements.
4.  **Tone:** Maintain strict objectivity. Avoid "We feel" or "It is believed." Use " The data suggests" or "Results indicate."

**Status:** Ready for Content Generation. Save as `outline_formatted.md`.