# Uncovering Key Service Improvement Areas in Digital Finance: A Topic Modeling Approach Using LDA on User Reviews

**Authors:** Othman
**Year:** 2025
**DOI:** 10.47738/jdmdc.v2i4.47
**URL:** https://doi.org/10.47738/jdmdc.v2i4.47

## Abstract

The rapid expansion of digital finance has transformed the way financial services are accessed and utilized, particularly in emerging markets such as Indonesia. This study aims to uncover key service improvement areas within the Easycash mobile lending platform by analyzing user reviews through topic modeling using Latent Dirichlet Allocation (LDA). The research employed a data-driven approach, combining text preprocessing in Bahasa Indonesia using the Sastrawi library, TF-IDF vectorization, and sentiment classification with machine learning models including Naive Bayes, K-Nearest Neighbors (KNN), and XGBoost. The XGBoost model achieved the highest performance with an F1-score of 0.9709, effectively distinguishing between positive, neutral, and negative sentiments. LDA analysis identified five major topics: Loan Limits and Repayment, Customer Gratitude and Satisfaction, Loan Application Process and Interest Rates, App Quality and Customer Service, and Data Management and Account Issues. Results indicate that while Easycash users generally express positive sentiment toward ease of use and service speed, concerns persist regarding high interest rates, customer service responsiveness, and data privacy. These findings provide actionable insights for fintech companies to enhance user satisfaction through targeted service improvements and continuous feedback analysis.

## Citation Details

Uncovering Key Service Improvement Areas in Digital Finance: A Topic Modeling Approach Using LDA on User Reviews
**Authors**: Othman
**Year**: 2025
**DOI**: 10.47738/jdmdc.v2i4.47
**URL**: https://doi.org/10.47738/jdmdc.v2i4.47

**Abstract**: The rapid expansion of digital finance has transformed the way financial services are accessed and utilized, particularly in emerging markets such as Indonesia. This study aims to uncover key service improvement areas within the Easycash mobile lending platform by analyzing user reviews through topic modeling using Latent Dirichlet Allocation (LDA). The research employed a data-driven approach, combining text preprocessing in Bahasa Indonesia using the Sastrawi library, TF-IDF vectorization, and sentiment classification with machine learning models including Naive Bayes, K-Nearest Neighbors (KNN), and XGBoost. The XGBoost model achieved the highest performance with an F1-score of 0.9709, effectively distinguishing between positive, neutral, and negative sentiments. LDA analysis identified five major topics: Loan Limits and Repayment, Customer Gratitude and Satisfaction, Loan Application Process and Interest Rates, App Quality and Customer Service, and Data Management and Account Issues. Results indicate that while Easycash users generally express positive sentiment toward ease of use and service speed, concerns persist regarding high interest rates, customer service responsiveness, and data privacy. These findings provide actionable insights for fintech companies to enhance user satisfaction through targeted service improvements and continuous feedback analysis.  # Truncate if very long

---
*Extracted from citation research database - all 45 citations available*
