# Blockchain and Smart Contracts for Know Your Customer (KYC)

**Authors:** Osborne
**Year:** 2021
**DOI:** 10.47330/cbc.2021.jtvv4544
**URL:** https://doi.org/10.47330/cbc.2021.jtvv4544

## Abstract

Distributed Ledger Technology (DLT) and Blockchain Technology (BCT) are options for introducing smart and transitive energy trading via a Know Your Customer or Know Your Client (KYC) system using an Ethereum Blockchain. The most significant context in which BCT can create transformative change is in the verification of other parties in an energy trading system. Currently the KYC trade mostly relies on internal controls to send and receive KYC information across the globe, resulting in slower and error prone data management and governance. BCT can solve this by providing immutable and verifiable data sources. Implementing smart contract addressing, the issue of storing critical data necessary at different stages of KYC and making it verifiable by all stakeholders is of critical importance. The literature review looks at the current research in BCT, programming languages used in BCT, Game Theory, Zero-Knowledge Proofs and energy trading in context to KYC. Having a foundational concept mathematically by creating game theoretic models and a simple computer programming simulation is the first step in the task of creating a true BCT platform that can be used in energy trading for KYC. Simulating the scenarios of n-player games is important to the advancement of this platform. The key result of these games and interaction between traders will help change the trading systems regionally and internationally. This can deliver new ways of working and brings visibility and control to each energy trade. The researcher analyses the strength of the system through the decisions of the traders using infinite games. New trading strategies and BCT resources with different parameters gain a larger market presence in international trade with these proofs, codifications and simulations. A gap exists in the literature in BCT in the creation of game theory algorithms as well as using simulation tools and software and using these methods to create forecasted energy trading scenarios with the implementation of KYC. Looking at an infinite game mathematically and presenting a simple codified computer simulation using Ethereum via Solidity involving a supplier, operator and regulator will give new implications in game theory and conflict-resolution scenarios within context to energy trading and KYC via BCT.

## Citation Details

Blockchain and Smart Contracts for Know Your Customer (KYC)
**Authors**: Osborne
**Year**: 2021
**DOI**: 10.47330/cbc.2021.jtvv4544
**URL**: https://doi.org/10.47330/cbc.2021.jtvv4544

**Abstract**: Distributed Ledger Technology (DLT) and Blockchain Technology (BCT) are options for introducing smart and transitive energy trading via a Know Your Customer or Know Your Client (KYC) system using an Ethereum Blockchain. The most significant context in which BCT can create transformative change is in the verification of other parties in an energy trading system. Currently the KYC trade mostly relies on internal controls to send and receive KYC information across the globe, resulting in slower and error prone data management and governance. BCT can solve this by providing immutable and verifiable data sources. Implementing smart contract addressing, the issue of storing critical data necessary at different stages of KYC and making it verifiable by all stakeholders is of critical importance. The literature review looks at the current research in BCT, programming languages used in BCT, Game Theory, Zero-Knowledge Proofs and energy trading in context to KYC. Having a foundational concept mathematically by creating game theoretic models and a simple computer programming simulation is the first step in the task of creating a true BCT platform that can be used in energy trading for KYC. Simulating the scenarios of n-player games is important to the advancement of this platform. The key result of these games and interaction between traders will help change the trading systems regionally and internationally. This can deliver new ways of working and brings visibility and control to each energy trade. The researcher analyses the strength of the system through the decisions of the traders using infinite games. New trading strategies and BCT resources with different parameters gain a larger market presence in international trade with these proofs, codifications and simulations. A gap   # Truncate if very long

---
*Extracted from citation research database - all 45 citations available*
