# User Reviews of Depression App Features: Sentiment Analysis (Preprint)

**Authors:** Meyer, Okuboyejo
**Year:** 2019
**DOI:** 10.2196/preprints.17062
**URL:** https://doi.org/10.2196/preprints.17062

## Abstract

BACKGROUND
                        Mental health in general, and depression in particular, remain undertreated conditions. Mobile health (mHealth) apps offer tremendous potential to overcome the barriers to accessing mental health care and millions of depression apps have been installed and used. However, little is known about the effect of these apps on a potentially vulnerable user population and the emotional reactions that they generate, even though emotions are a key component of mental health. App reviews, spontaneously posted by the users on app stores, offer up-to-date insights into the experiences and emotions of this population and are increasingly decisive in influencing mHealth app adoption.
                
                                
                    OBJECTIVE
                        This study aims to investigate the emotional reactions of depression app users to different app features by systematically analyzing the sentiments expressed in app reviews.
                
                                
                    METHODS
                        We extracted 3261 user reviews of depression apps. The 61 corresponding apps were categorized by the features they offered (&lt;i&gt;psychoeducation&lt;/i&gt;, &lt;i&gt;medical assessment&lt;/i&gt;, &lt;i&gt;therapeutic treatment&lt;/i&gt;, &lt;i&gt;supportive resources&lt;/i&gt;, and &lt;i&gt;entertainment&lt;/i&gt;). We then produced word clouds by features and analyzed the reviews using the Linguistic Inquiry Word Count 2015 (Pennebaker Conglomerates, Inc), a lexicon-based natural language analytical tool that analyzes the lexicons used and the valence of a text in 4 dimensions (&lt;i&gt;authenticity&lt;/i&gt;, &lt;i&gt;clout&lt;/i&gt;, &lt;i&gt;analytic&lt;/i&gt;, and &lt;i&gt;tone&lt;/i&gt;). We compared the language patterns associated with the different features of the underlying apps.
                
                                
                    RESULTS
                        The analysis highlighted significant differences in the sentiments expressed for the different features offered. Psychoeducation apps exhibited more &lt;i&gt;clout&lt;/i&gt; but less authenticity (ie, personal disclosure). &lt;i&gt;Medical assessment&lt;/i&gt; apps stood out for the strong negative emotions and the relatively negative ratings that they generated. &lt;i&gt;Therapeutic treatment&lt;/i&gt; app features generated more positive emotions, even though user feedback tended to be less authentic but more analytical (ie, more factual). &lt;i&gt;Supportive resources&lt;/i&gt; (connecting users to physical services and people) and &lt;i&gt;entertainment&lt;/i&gt; apps also generated fewer negative emotions and less anxiety.
                
                                
                    CONCLUSIONS
                        Developers should be careful in selecting the features they offer in their depression apps. &lt;i&gt;Medical assessment&lt;/i&gt; features may be riskier as users receive potentially disturbing feedback on their condition and may react with strong negative emotions. In contrast, offering information, contacts, or even games may be safer starting points to engage people with depression at a distance. We highlight the necessity to differentiate how mHealth apps are assessed and vetted based on the features they offer. Methodologically, this study points to novel ways to investigate the impact of mHealth apps and app features on people with mental health issues. mHealth apps exist in a rapidly changing ecosystem that is driven by user satisfaction and adoption decisions. As such, user perceptions are essential and must be monitored to ensure adoption and avoid harm to a fragile population that may not benefit from traditional health care resources.

## Citation Details

User Reviews of Depression App Features: Sentiment Analysis (Preprint)
**Authors**: Meyer, Okuboyejo
**Year**: 2019
**DOI**: 10.2196/preprints.17062
**URL**: https://doi.org/10.2196/preprints.17062

**Abstract**: BACKGROUND
                        Mental health in general, and depression in particular, remain undertreated conditions. Mobile health (mHealth) apps offer tremendous potential to overcome the barriers to accessing mental health care and millions of depression apps have been installed and used. However, little is known about the effect of these apps on a potentially vulnerable user population and the emotional reactions that they generate, even though emotions are a key component of mental health. App reviews, spontaneously posted by the users on app stores, offer up-to-date insights into the experiences and emotions of this population and are increasingly decisive in influencing mHealth app adoption.
                
                                
                    OBJECTIVE
                        This study aims to investigate the emotional reactions of depression app users to different app features by systematically analyzing the sentiments expressed in app reviews.
                
                                
                    METHODS
                        We extracted 3261 user reviews of depression apps. The 61 corresponding apps were categorized by the features they offered (&lt;i&gt;psychoeducation&lt;/i&gt;, &lt;i&gt;medical assessment&lt;/i&gt;, &lt;i&gt;therapeutic treatment&lt;/i&gt;, &lt;i&gt;supportive resources&lt;/i&gt;, and &lt;i&gt;entertainment&lt;/i&gt;). We then produced word clouds by features and analyzed the reviews using the Linguistic Inquiry Word Count 2015 (Pennebaker Conglomerates, Inc), a lexicon-based natural language analytical tool that analyzes the lexicons used and the valence of a text in 4 dimensions (&lt;i&gt;authenticity&lt;/i&gt;, &lt;i&gt;clout&lt;/i&gt;, &lt;i&gt;analytic&lt;/i&gt;, and &lt;i&gt;tone  # Truncate if very long

---
*Extracted from citation research database - all 45 citations available*
