**Research Problem and Approach:** The financial services sector is undergoing a paradigm shift driven by "cybercapitalism," where data serves as a critical asset and personalisation acts as a primary currency for user engagement. Despite the imperative for traditional institutions to digitize, a significant knowledge gap remains regarding the specific impact of frontend personalisation within high-stakes acquisition flows, particularly credit card applications. This research addresses the "innovation paradox" in banking by investigating how tailored user experiences can mitigate friction in complex, regulated digital environments and influence user decision-making behavior.

**Methodology and Findings:** To empirically measure the efficacy of interface adaptation, this study employs a longitudinal online controlled experiment (A/B testing) focusing on web-based credit card application flows. The research analyzes distinct user cohorts to determine the causal relationship between personalized interface options and key performance metrics, including application completion rates, user satisfaction, and long-term customer retention. The findings demonstrate that granular personalisation significantly reduces abandonment rates by addressing device fragmentation and data entry fatigue, effectively guiding users through the "hidden conversion funnel" inherent in legacy banking processes.

**Key Contributions:** This thesis makes three primary contributions to the intersection of Financial Technology (FinTech) and Human-Computer Interaction (HCI): (1) It provides robust empirical evidence quantifying the value of client-side personalisation in regulated financial processes, moving beyond backend risk modeling; (2) It identifies specific design mechanisms that reconcile the tension between regulatory compliance (e.g., KYC, SCA) and seamless user experience; and (3) It establishes a framework for next-generation digital banking interfaces that leverages behavioral data to enhance conversion without compromising security or trust.

**Implications:** The implications of this research extend to digital marketing strategies and banking infrastructure design, suggesting that personalisation should be treated as a fundamental architectural requirement rather than a cosmetic feature. For practitioners, the study offers actionable guidelines for optimizing digital acquisition channels, arguing that superior user experience is the defining differentiator in the mature "Digital 2.0" banking landscape where functionality is commoditized.

**Keywords:** FinTech, Personalisation, User Experience (UX), Credit Card Applications, Online Controlled Experiment, Digital Banking, Cybercapitalism, Human-Computer Interaction, Conversion Rate Optimization, KYC, Digital Transformation, A/B Testing, Customer Retention, Data Privacy, Financial Services