# Paper Architecture

**Paper Type:** Master's Thesis (Empirical Study)
**Research Question:** How do dynamic personalization options in web-based credit card applications influence user conversion rates and subsequent credit behavior over time?
**Target Venue:** University Repository / Academic Publication (Thesis)
**Estimated Length:** 25,000 - 30,000 words (approx. 80-100 pages)

---

## Core Argument Flow

**Draft Statement:**
While current FinTech literature treats User Experience (UX) and Credit Risk as separate silos, this thesis argues that personalized application interfaces—when aligned with regulatory frameworks—can simultaneously reduce application abandonment and improve long-term customer quality.

**Logical Progression:**
1.  **Problem:** Digital banking faces a tension between friction-less UX (personalization) and rigid risk/compliance requirements (standardization).
2.  **Gap:** Literature is bifurcated; no longitudinal studies exist connecting application-stage personalization to post-approval credit behavior (Risk).
3.  **Method:** A longitudinal online controlled experiment (A/B test) compares a static credit card application (Control) vs. a personalized/dynamic application (Treatment).
4.  **Results:** Evidence suggests personalization increases conversion (short-term) but requires careful calibration to avoid adverse selection (long-term).
5.  **Implication:** A "Macro-Aware AI UX" framework is viable but must solve the "Privacy vs. Personalization" paradox.

---

## Thesis Structure

### 1. Title Page & Front Matter
**Title:** "The Impact of Personalisation Options in a Web-Based Credit Card Application: A Longitudinal Online Controlled Experiment"
**Alternative:** "Bridging Risk and UX: A Longitudinal Study of Personalized Digital Onboarding in FinTech"

### 2. Abstract (300-500 words)
- **Context:** The digital origination gap.
- **Problem:** Generic forms cause drop-offs; risk models ignore UX signals.
- **Method:** Randomized Controlled Trial (RCT) with n=X users over Y months.
- **Results:** Impact on funnel conversion and early-month delinquency/usage.
- **Conclusion:** Personalization is a valid strategy for acquisition but requires regulatory guardrails.

### 3. Chapter 1: Introduction (2,500 words)
#### 1.1 Contextual Background
- The shift from branch-based to digital-first banking.
- The rise of "Hyper-personalization" in non-financial sectors (Netflix/Amazon effect).

#### 1.2 Problem Statement
- **The Friction-Risk Trade-off:** Reducing fields increases conversion but decreases data for risk scoring.
- **The "Bifurcation" Gap:** (From your analysis) Risk teams and UX teams are disconnected.

#### 1.3 Research Objectives & Questions
- **RQ1 (Conversion):** Does UI personalization significantly reduce application abandonment rates?
- **RQ2 (Longitudinal):** Does the "personalized" cohort exhibit different usage/delinquency patterns over 6 months?
- **RQ3 (Privacy):** How does privacy sensitivity moderate the effectiveness of personalization?

#### 1.4 Significance of the Study
- Contribution to the "Macro-Aware AI" framework.
- Practical utility for FinTech product managers.

### 4. Chapter 2: Literature Review (5,000 words)
**Organization:** Thematic

#### 2.1 Theoretical Foundations of Personalization
- Information Overload Theory.
- Technology Acceptance Model (TAM) in Banking.

#### 2.2 The Risk-UX Divide (Addressing the Gap)
- **Stream A:** UX/Engagement literature (Paper 4). Focus on delight/ease.
- **Stream B:** Credit Risk/Macro literature (Paper 1). Focus on delinquency/money supply.
- **Synthesis:** The lack of intersection.

#### 2.3 Regulatory & Ethical Constraints (Critical Gap)
- **Fair Lending (ECOA):** Can you personalize without discriminating?
- **Explainability (XAI):** The "Black Box" problem in credit decisions.
- **GDPR/CCPA:** The Privacy Calculus theory.

### 5. Chapter 3: Theoretical Framework (2,500 words)
#### 3.1 Proposed Model
- Adapting the **Privacy Calculus Model** (Benefits of personalization vs. Cost of data sharing).
- Integrating a **Nudge Theory** framework for financial decision-making.

#### 3.2 Hypotheses Development
- **H1:** Personalization increases application completion rate.
- **H2:** Personalization reduces time-to-completion.
- **H3:** Users in the personalized condition show higher app engagement post-approval (Longitudinal).

### 6. Chapter 4: Methodology (4,000 words)
#### 4.1 Research Design
- **Type:** Quantitative, Longitudinal, Experimental.
- **Design:** Between-subjects A/B Test (Randomized).

#### 4.2 Experimental Setup
- **Control Group:** Standard static form (linear).
- **Treatment Group:** Dynamic form (options reorder based on initial inputs/geo-location).
- **Platform:** Web-based prototype simulation.

#### 4.3 Sampling & Data Collection
- **Sample Size:** Power analysis justification (aiming for statistical significance).
- **Recruitment:** Online panel (e.g., Prolific/MTurk) screened for credit card intent.

#### 4.4 Variables & Instrumentation
- **Independent Variable:** Level of Personalization (Low vs. High).
- **Dependent Variables:** Conversion Rate, Time on Task, Net Promoter Score (NPS), Self-reported future usage intent.
- **Controls:** Financial literacy, Tech-savviness, Income level.

#### 4.5 Ethical Considerations
- Addressing the **"Look-Ahead Bias"** gap: Ensuring the experiment simulates real-time decisioning without using future data.
- Data privacy and informed consent.

### 7. Chapter 5: Results - Experiment Performance (4,000 words)
#### 5.1 Data Cleaning & Demographics
- Participant profile analysis.
- Randomization check (ANOVA to ensure groups are balanced).

#### 5.2 Hypothesis Testing: Conversion (H1 & H2)
- **Funnel Analysis:** Drop-off points in Control vs. Treatment.
- **Statistical Tests:** Chi-square (for conversion rates), t-tests (for time metrics).
- **Visuals:** Funnel charts, Box plots of completion times.

#### 5.3 Interaction Effects
- Did personalization work better for high-income vs. low-income users?
- Impact of privacy concerns on conversion (Moderation analysis).

### 8. Chapter 6: Results - Longitudinal Analysis (3,500 words)
*Note: Depending on actual timeline, this may use "intent" proxies or simulated time-series data.*

#### 6.1 Post-Application Engagement (H3)
- Analysis of login frequency / feature usage (simulated or tracked).

#### 6.2 Risk Indicators
- Correlation between personalization preference and risk profile.
- **Critical Check:** Did personalization attract "riskier" applicants? (Addressing the Risk/UX gap).

### 9. Chapter 7: Discussion (4,000 words)
#### 7.1 Interpreting the "Macro-Aware" UX
- Discussing how the results support bridging the gap between Risk (Paper 1) and UX (Paper 4).
- Does personalization act as a risk filter or a risk multiplier?

#### 7.2 The Privacy Paradox
- addressing the **Data Privacy vs. Personalization** gap.
- How users trade data for convenience in a high-stakes (credit) environment.

#### 7.3 Regulatory Implications
- How this framework fits within Fair Lending laws.
- Recommendations for "Explainable UX."

### 10. Chapter 8: Conclusion (2,000 words)
#### 8.1 Summary of Findings
- Recap of the experiment and longitudinal impacts.

#### 8.2 Theoretical Contributions
- Extending TAM/Privacy Calculus into the FinTech origination space.

#### 8.3 Managerial Implications
- Playbook for Digital Product Managers in Banking.

#### 8.4 Limitations & Future Research
- Simulation vs. Real-world limitations.
- Call for longer-term delinquency studies (12+ months).

---

## Argument Flow Map

```
Intro: Banks lose customers due to bad UX, but fear personalization due to Risk/Regs.
    ↓
Lit Review: Current science is split. Risk models ignore UX; UX models ignore Risk.
    ↓
Theory: Privacy Calculus suggests users will trade data for better UX if trust exists.
    ↓
Method: A controlled A/B test (Longitudinal) to measure both Conversion (UX) and Quality (Risk).
    ↓
Results (Exp): Personalization significantly boosts conversion (reduces friction).
    ↓
Results (Long): Personalization does NOT increase risk if macro-factors are integrated.
    ↓
Discussion: We can build "Macro-Aware" interfaces that satisfy both users and regulators.
    ↓
Conclusion: The future of FinTech is the convergence of UX and Risk modeling.
```

---

## ⚠️ Title Promise Audit

| Title Keyword | Requirement | Plan |
|---------------|-------------|------|
| **"Impact"** | Must measure change/effect size | Ch 5 & 6 include statistical effect sizes (Cohen's d, Odds Ratios). |
| **"Personalisation Options"** | Must define specific UI changes | Ch 4 must detail exactly *what* changed (e.g., dynamic sorting, pre-fill). |
| **"Web-based"** | Context specific | Experiment is browser-based, not mobile app native (important distinction for UI). |
| **"Longitudinal"** | Time element | Ch 6 is dedicated to time-series analysis (post-application behavior). |
| **"Controlled Experiment"** | Rigorous design | Ch 4 outlines Randomization, Control Group, and Variable isolation. |

---

## Evidence Placement Strategy

| Section | Gap Addressed | Strategy |
|---------|---------------|----------|
| **Lit Review** | **Bifurcation** (Risk vs UX) | Explicitly contrast Paper 1 (Macro/Risk) with Paper 4 (UX) to show the "Missing Middle." |
| **Methodology** | **Look-Ahead Bias** | Explicit statement on how the experiment avoids using future data for current personalization. |
| **Discussion** | **Regulatory/XAI** | Dedicate section 7.3 to "Explainability" and ECOA compliance of the proposed UI. |
| **Discussion** | **Privacy** | Dedicate section 7.2 to GDPR implications of the personalization engine. |

---

## Next Steps for User
1.  **Confirm Methodology:** Do you have access to a user base for a longitudinal study (e.g., 3-6 months), or will this be a simulated longitudinal study (e.g., a "scenario-based" experiment)? *The outline assumes a standard experimental timeframe.*
2.  **Define "Personalization":** What specific elements are changing? (e.g., Are you reordering credit card offers? Changing the form layout? Pre-filling data?)
3.  **Data Analysis Tools:** Confirm if you are using SPSS, R, or Python for the quantitative chapters.