---
title: "What are the key drivers and barriers of the adoption of AI-enabled semi-autonomous robotic surgery in the healthcare sector?"
author: "OpenDraft AI"
date: "February 2026"
institution: "OpenDraft University"
department: "Department of Computer Science"
faculty: "Faculty of Engineering"
degree: "Master of Science"
advisor: "Prof. Dr. OpenDraft Supervisor"
second_examiner: "Prof. Dr. Second Examiner"
location: "Munich"
student_id: "N/A"
project_type: "Master Draft"
word_count: "18,781 words"
pages: "75"
generated_by: "OpenDraft AI - https://github.com/federicodeponte/opendraft"
---
## Abstract

**Research Problem and Approach:** The field of surgical intervention is undergoing a major change from tele-manipulated robotic systems to AI-enabled semi-autonomous agents capable of shared control and active decision-making. However, despite demonstrated technical feasibility in research settings, a significant "implementation gap" hinders the translation of these capabilities into routine clinical practice. This study addresses the paradoxical resistance to adoption by investigating the complex interplay of technical, organizational, and environmental factors preventing the widespread deployment of semi-autonomous surgical systems.

**Methodology and Findings:** Utilizing the Technology-Organization-Environment (TOE) framework as an analytical lens, this research systematically evaluates the determinants of adoption for AI-driven surgical technologies. The analysis reveals that while technical enablers like 5G and perception augmentation are maturing, significant barriers persist, including the "black box" opacity of machine learning decisions, high capital expenditures, and a lack of standardized training curricula. Furthermore, the study identifies critical environmental lags, specifically regarding legal liability frameworks for autonomous errors and cybersecurity vulnerabilities in connected medical devices.

**Key Contributions:** This thesis makes three primary contributions: (1) A unified theoretical framework that categorizes the fragmented drivers and barriers of semi-autonomous surgery integration, (2) A critical examination of the "shared control" paradigm, identifying specific inter-dependencies between legal ambiguity and organizational risk aversion, and (3) A strategic roadmap for stakeholders to navigate the transition from master-slave manipulation to human-supervised autonomy.

**Implications:** These findings have profound implications for healthcare administration and policy, suggesting that technological maturity alone is insufficient for clinical integration without concurrent reforms in liability law and surgeon education. The research highlights the urgent need for a comprehensive system approach to prevent exacerbating global health inequities while leveraging AI to democratize access to high-precision surgical care.

**Keywords:** Robotic-Assisted Surgery, Artificial Intelligence, Semi-Autonomous Systems, TOE Framework, Shared Control, Medical Liability, Healthcare Technology Adoption, Machine Learning, Surgical Automation, Clinical Implementation, Patient Safety, Cybersecurity, Tele-manipulation, Health Policy, Digital Health

\newpage

# 1. Introduction
## 1.1 Background of the Study

The evolution of surgical intervention has historically been defined by a continuous pursuit of reduced invasiveness and increased precision. From the era of open surgery to the major change of laparoscopic techniques in the late 20th century, the fundamental goal has remained constant: to minimize patient trauma while maximizing therapeutic efficacy. The introduction of the da Vinci Surgical System in the early 2000s marked the beginning of the robotic-assisted surgery (RAS) era, characterizing a transition from direct manual manipulation to tele-manipulation. However, a profound transformation is currently underway. The field is moving beyond the "master-slave" relationship--where the robot strictly mimics the surgeon's hand movements--toward a new paradigm of AI-enabled semi-autonomous robotic surgery. In this emerging context, systems are not merely passive tools but active partners capable of perception, decision-making, and executing sub-tasks under human supervision (Kumar et al., 2024)(Zhu, 2025).

This transition represents a critical juncture in medical technology. Traditional robotic systems have successfully addressed some limitations of laparoscopy, such as ergonomic discomfort and limited degrees of freedom. Yet, they remain entirely dependent on the continuous input of the human operator. The integration of Artificial Intelligence (AI) and Machine Learning (ML) introduces the capability for "shared control" and "supervisory control," where the robotic system can autonomously perform specific actions--such as suturing, tissue tracking, or camera navigation--while the surgeon maintains high-level oversight (Schüßler et al., 2025)(Saeidi et al., 2018). This shift promises to democratize high-quality surgical care by potentially flattening the learning curve for complex procedures and reducing the cognitive load on surgeons during lengthy operations (McKendrick, 2018)(Guo et al., 2025).

However, the path to widespread adoption is fraught with complexity. While the technological feasibility of semi-autonomous tasks has been demonstrated in research settings--ranging from autonomous gallbladder retraction (Schüßler et al., 2025) to smart tissue tracking (Saeidi et al., 2019)--the translation of these capabilities into routine clinical practice faces systemic resistance. This resistance is not merely technical but is deeply rooted in organizational structures, economic models, and regulatory environments. The "implementation gap" between what is technically possible and what is clinically adopted suggests that the barriers to AI-enabled surgery are complex (Curet, 2019)(Nguyen et al., 2017). Understanding these dynamics requires a comprehensive analysis that transcends the operating theater to consider the broader healthcare system, including legal liability frameworks (Casado, 2024), data security infrastructure (Mitra et al., 2025), and the economic pressures of venture capital and hospital administration (Buonomo, 2023)(Shetty & Jaiswal, 2024).

## 1.2 Problem Statement

Despite the documented potential of AI-enabled robotic surgery to enhance precision and reduce intraoperative errors (Fuentes et al., 2024)(Wah, 2025), the healthcare sector exhibits a paradoxical relationship with these technologies. On one hand, there is a rapid rollout of generative AI and digital health applications (The Lancet Digital Health, 2025), driven by the promise of workflow optimization and improved outcomes. On the other hand, the adoption of physical, semi-autonomous surgical actions remains cautious and uneven. This hesitation stems from a lack of comprehensive understanding regarding the interplay between technical resilience, organizational readiness, and environmental pressures.

Technologically, the reliance on Machine Learning (ML) models introduces "black box" opacity, where the rationale behind a robotic decision may not be immediately transparent to the human operator. This raises profound safety concerns, particularly regarding perception recovery in dynamic surgical environments (Zheng et al., 2022) and the cybersecurity risks associated with connected medical devices (Mitra et al., 2025). Furthermore, the requirement for ultra-low latency in remote or semi-autonomous operations necessitates advanced infrastructure, such as 5G, which is not universally available (Hentati et al., 2022)(bai et al., 2026).

Organizationally, hospitals face significant hurdles related to cost and training. The capital expenditure for robotic systems is substantial, and the question of whether these technologies improve outcomes enough to justify the cost remains a subject of debate (Vaishya et al., 2025). Moreover, the learning curve for robotic surgery is steep (Hirri et al., 2024), and there is currently a lack of standardized curricula for training surgeons to work *with* autonomous agents rather than just operating tools (Bouvette et al., 2025)(Tian et al., 2025).

Environmentally, the legal and regulatory environment lags behind technological innovation. Current liability frameworks are predicated on human error, creating ambiguity regarding accountability when an autonomous agent makes a surgical error (Casado, 2024). Additionally, global disparities in care suggest that these advancements may exacerbate inequities if adoption drivers are not properly managed (Boakye-Afram et al., 2025)(Moore et al., 2026). Therefore, the central problem this thesis addresses is the absence of a unified framework that identifies and prioritizes these diverse drivers and barriers, preventing a strategic approach to the integration of semi-autonomous surgery.

## 1.3 Research Objectives and Questions

The primary objective of this study is to systematically analyze the factors influencing the adoption of AI-enabled semi-autonomous robotic surgery using the Technology-Organization-Environment (TOE) framework. By categorizing determinants into these three contexts, the research aims to provide a structured roadmap for stakeholders--including hospital administrators, policymakers, and technology developers--to navigate the transition from tele-manipulation to semi-autonomy.

To achieve this, the study poses the following research questions:

1. **Technological Context:** What are the specific technical enablers (e.g., perception augmentation, haptic feedback, 5G connectivity) and technical inhibitors (e.g., latency, security vulnerabilities, interoperability) affecting the deployment of semi-autonomous surgical systems?
2. **Organizational Context:** How do institutional factors, such as surgeon training requirements, cost-benefit perceptions, and workflow integration, impact the readiness of healthcare organizations to adopt these technologies?
3. **Environmental Context:** What role do external pressures, including regulatory liability frameworks, venture capital trends, and market competition, play in accelerating or decelerating adoption?
4. **Inter-dependencies:** How do these factors interact? For instance, does the lack of legal clarity (Environmental) inhibit the deployment of technically viable autonomous functions (Technological) due to organizational risk aversion?

## 1.4 Theoretical Framework

This thesis uses the Technology-Organization-Environment (TOE) framework as its analytical lens. Originally developed to study the adoption of general technological innovations, TOE is particularly well-suited for complex healthcare technologies because it acknowledges that adoption is not solely a technical decision.

### 1.4.1 Application of TOE to Robotic Surgery

The TOE framework categorizes adoption drivers and barriers into three distinct elements. The **Technological context** refers to the internal and external technologies relevant to the firm, including current practices and equipment. In this study, this encompasses the specific AI capabilities, such as computer vision for tissue tracking (Saeidi et al., 2019) and preoperative planning algorithms (Lambrechts et al., 2022). The **Organizational context** refers to the descriptive measures of the organization, such as scope, size, and the quality of human resources. This includes the availability of specialized training programs (Bouvette et al., 2025) and the financial capacity to absorb the high costs of robotic platforms (Vaishya et al., 2025). The **Environmental context** refers to the arena in which the organization conducts its business, focusing on industry structure, technology support infrastructure, and government regulation. This captures the critical issues of liability attribution (Casado, 2024) and the influence of venture capital investment in robotics (Shetty & Jaiswal, 2024).

Table 1 provides a preliminary mapping of the key factors identified in the initial literature scan against the TOE framework, serving as a guide for the subsequent detailed analysis.

| Context | Key Drivers | Key Barriers |
|:--- |:--- |:--- |
| **Technology** | Precision (Fuentes et al., 2024), Shared Control (Saeidi et al., 2018), 5G (bai et al., 2026) | Latency (Hentati et al., 2022), Security (Mitra et al., 2025), Perception errors (Zheng et al., 2022) |
| **Organization** | Workflow efficiency (Pawelczyk et al., 2025), Reduced cognitive load (McKendrick, 2018) | High costs (Vaishya et al., 2025), Training demands (Bouvette et al., 2025), Learning curves (Hirri et al., 2024) |
| **Environment** | VC Investment (Buonomo, 2023), Market competition (Satava, 2010) | Liability ambiguity (Casado, 2024), Regulatory lag (Kerr et al., 2017), Disparities (Boakye-Afram et al., 2025) |

*Table 1: Preliminary Application of the TOE Framework to Semi-Autonomous Surgery.*

The technological context is characterized by a push for "Smart Tissue" interaction. Unlike industrial robots that operate in structured environments, surgical robots must navigate soft, deformable tissues. Technologies that enable this, such as biocompatible near-infrared tracking (Saeidi et al., 2019), act as drivers. Conversely, the barrier of "perception recovery" (Zheng et al., 2022) highlights the risk when a robot loses track of the surgical field due to smoke or occlusion.

In the organizational context, the driver of "cognitive load regulation" is significant. Research suggests that shared autonomy can manage the mental workload of operators, potentially reducing burnout and error rates (Guo et al., 2025). However, this is counterbalanced by the steep learning curves associated with new interfaces, which can temporarily reduce efficiency and increase operative times during the acquisition phase (Hirri et al., 2024)(Vaishya et al., 2025).

The environmental context is heavily influenced by financial and legal structures. Venture capital is aggressively funding robotics startups (Shetty & Jaiswal, 2024), driving innovation. However, the legal framework for "robotic malpractice" remains a significant environmental barrier. As noted by Casado (Casado, 2024), new criteria for liability attribution are required when the robot makes an autonomous decision, creating a climate of risk aversion among potential adopters.

## 1.5 Significance of the Study

The significance of this research extends across clinical, economic, and societal domains. Clinically, the move toward semi-autonomy addresses the physiological limitations of human surgeons. Even the most skilled surgeon is subject to fatigue, tremor, and cognitive overload. AI-enabled systems offer the potential to standardize outcomes by ensuring that critical sub-tasks--such as suturing or resection margins--are performed with mathematical precision, independent of the surgeon's physical state (Shaikh et al., 2025)(Satava, 2010). Recent studies have shown that AI integration can enhance precision and complication prediction (Fuentes et al., 2024), potentially reducing adverse events like pancreatic fistulas in complex procedures (McMillan et al., 2017).

Economically, the healthcare sector is under immense pressure to improve efficiency. While robotic systems represent a high initial capital cost, their potential to reduce hospital stays, minimize complications, and potentially allow for "telesurgery" to underserved areas presents a compelling long-term value proposition (Hentati et al., 2022)(bai et al., 2026). However, this economic argument is complex; some evidence suggests that robotic technologies may raise costs without guaranteed improvements in outcomes for certain orthopedic procedures (Vaishya et al., 2025). This thesis contributes to this debate by analyzing how semi-autonomy might alter the cost-benefit equation compared to traditional master-slave robotics.

Societally, the study addresses the ethical and legal vacuum surrounding AI in medicine. As algorithms increasingly influence patient care--from diagnosis to physical intervention--establishing clear frameworks for accountability and safety is essential (Kerr et al., 2017). By identifying the specific barriers related to trust and liability, this research informs policy development that protects patients while fostering innovation.

## 1.6 Scope and Definitions

### 1.6.1 Defining Semi-Autonomous Robotic Surgery

Precision in terminology is important for this analysis. "Robotic surgery" is often used as a catch-all term, but it encompasses a spectrum of autonomy. This thesis specifically focuses on **AI-enabled semi-autonomous systems**, distinct from purely tele-operated systems (where the robot has no agency) and fully autonomous systems (which effectively replace the surgeon).

To clarify this distinction, this study adopts the "Levels of Autonomy" (LoA) framework as discussed in recent engineering and medical literature (Kumar et al., 2024). This framework parallels the classification used in autonomous vehicles, adapted for the surgical domain.

| Level | Description | Role of AI | Role of Surgeon |
|:--- |:--- |:--- |:--- |
| **0** | No Autonomy | None | Full continuous control |
| **1** | Robot Assistance | Guidance/Virtual Fixtures | Continuous control with assistance |
| **2** | Task Autonomy | Discrete tasks (e.g., suturing) | Initiates/supervises specific tasks |
| **3** | Conditional Autonomy | Complex sub-procedures | Fallback/intervention only |
| **4** | High Autonomy | Full procedure in specific domain | High-level supervision |
| **5** | Full Autonomy | Complete surgery | Observation (optional) |

*Table 2: Levels of Autonomy in Robotic Surgery. Adapted from Kumar et al. (Kumar et al., 2024).*

The scope of this thesis is primarily concerned with **Levels 2 and 3**. Current current developments, such as the Smart Tissue Autonomous Robot (STAR) (Saeidi et al., 2018) and autonomous gallbladder retraction systems (Schüßler et al., 2025), fall into these categories. These systems operate under a "shared control" strategy where the robot manages specific degrees of freedom or tasks, but the human operator remains the ultimate decision-maker.

Level 2 autonomy involves the robot executing specific, well-defined tasks initiated by the surgeon. For example, automated suturing patterns or camera control that follows the surgeon's instruments without manual adjustment. Level 3 represents a higher degree of independence where the system can perceive the environment and adapt its trajectory, such as compensating for tissue deformation during cutting, but still requires the surgeon to be present to take over if the system encounters a situation outside its design parameters (Kumar et al., 2024)(Saeidi et al., 2019).

### 1.6.2 Key Terminology

**Tele-manipulation:** The traditional mode of robotic surgery (e.g., standard da Vinci Si/Xi) where the robot strictly copies the surgeon's hand movements, filtering tremor and scaling motion, but possesses no decision-making capability (Zhu, 2025).

**Haptic Feedback:** The transmission of tactile information (force, vibration, texture) from the robotic end-effector to the surgeon's hands. The lack of haptic feedback has been a longstanding barrier in RAS, often compensated for by visual cues, though AI is now being used to restore or augment this perception (Zheng et al., 2022).

**Latency:** The time delay between a surgeon's command and the robot's execution. In remote or telesurgery scenarios, high latency can lead to overcorrection and safety risks. 5G technology is investigated as a primary driver to mitigate this barrier (Hentati et al., 2022)(bai et al., 2026).

**Generative AI in Healthcare:** The use of large language models and generative algorithms to assist in non-motor tasks, such as preoperative planning, report generation, and decision support. While not "physical" surgery, these tools are increasingly integrated into the surgical workflow and robotic platforms (The Lancet Digital Health, 2025).

## 1.7 Thesis Structure

This thesis is organized into five chapters, following the standard monograph structure.

**Chapter 1 (Introduction)** has outlined the background, problem statement, objectives, and theoretical framework of the study. It established the shift from tele-manipulation to semi-autonomy as the central phenomenon of interest.

**Chapter 2 (Literature Review)** will provide a comprehensive analysis of existing research. It will examines deeper into the technological evolution of surgical robotics (Satava, 2010), examine the specific clinical outcomes associated with robotic adoption (Delhoum et al., 2025)(Hirri et al., 2024), and critique the current literature on barriers such as cost (Vaishya et al., 2025) and training (Tian et al., 2025). The review will also synthesize findings on the integration of soft robotics (Marchese et al., 2015)(Chen et al., 2023) and the role of AI in preoperative planning (Lambrechts et al., 2022).

**Chapter 3 (Methodology)** will detail the research design. Given the rapid pace of technological change, a strong qualitative or mixed-methods approach is often required to capture the nuances of adoption. This section will describe the data collection strategies, focusing on how the TOE framework will be operationalized to categorize findings from the literature and potential stakeholder interviews.

**Chapter 4 (Analysis and Results)** will present the core findings. It will systematically evaluate the drivers and barriers identified. This chapter will likely uses comparison tables to contrast the "promised" benefits of AI-RAS (e.g., efficiency, precision) against the "real-world" friction points (e.g., interoperability, liability). It will analyze specific case studies or technological examples, such as the implementation of 5G in remote surgery (bai et al., 2026) and the challenges of security in ML-enabled devices (Mitra et al., 2025).

**Chapter 5 (Discussion and Conclusion)** will synthesize the results to answer the research questions. It will discuss the implications for policy and practice, offering recommendations for how to bridge the implementation gap. This chapter will also address the limitations of the current study and propose directions for future research, particularly regarding the ethical implications of autonomous decision-making in life-critical situations (Kerr et al., 2017).

## 1.8 The Context of Innovation: Beyond the Technical

It is essential to recognize that the adoption of AI-enabled surgery is not occurring in a vacuum. It is part of a broader digital transformation of healthcare, often referred to as "Surgery 4.0" or the "OR 2.0" (Stoyanov et al., 2018). This environment is characterized by an explosion of data--from preoperative imaging to intraoperative video feeds. The driver for AI adoption is fundamentally a data management and utilization challenge. Surgeons are currently overwhelmed with information; the promise of AI is to filter this information and present actionable intelligence or physical assistance.

However, innovation in this space is also driven by external market forces. The venture capital environment for robotics and autonomous systems is highly active, with investors looking for the next breakthrough in medical technology (Shetty & Jaiswal, 2024). This financial pressure acts as a powerful environmental driver, pushing technologies to market. Yet, it also creates a risk of "technology push" rather than "clinical pull," where solutions are developed for problems that may not be the highest priority for clinicians, or where the marketing of "AI capabilities" outpaces the validated clinical evidence.

Furthermore, the integration of these systems requires a reimagining of the surgical team. The introduction of semi-autonomous agents changes the dynamic of the operating room. It necessitates new protocols for communication and error recovery. Just as the aviation industry had to adapt to the introduction of autopilot systems through Crew Resource Management (CRM), the surgical field must develop "Robot-Surgeon Resource Management" protocols. The failure to address these human factors--cognitive load, trust, and team dynamics--stands as a significant organizational barrier (McKendrick, 2018)(Guo et al., 2025).

Finally, the issue of equity cannot be ignored. The high cost of these systems creates a risk of a two-tiered healthcare system. While AI has the theoretical potential to improve access by enabling remote surgery (Hentati et al., 2022), the current reality is that advanced robotic systems are concentrated in wealthy, urban academic centers. Factors such as race, socioeconomic status, and geography already influence the utilization of surgical interventions (Moore et al., 2026). Without conscious policy intervention, the adoption of AI-enabled surgery could widen these disparities rather than close them. This thesis will therefore consider "equity of access" as a critical environmental factor in the adoption model.

By examining these interconnected factors through the TOE framework, this thesis aims to move beyond a simple list of pros and cons. Instead, it seeks to uncover the systemic dynamics that will determine whether AI-enabled semi-autonomous robotic surgery becomes a standard of care that benefits all patients, or a niche luxury limited by unaddressed structural barriers. The following chapters will build upon this foundation, providing a rigorous evidence-based analysis of the path forward for this transformative technology.

\newpage

# 2. Main Body
The integration of artificial intelligence (AI) into robotic surgery represents a major change from pure telemanipulation to semi-autonomous and autonomous systems. This review critically analyzes the existing body of knowledge regarding the drivers and barriers of this adoption. It synthesizes theoretical frameworks of autonomy, empirical evidence on clinical efficacy, technological prerequisites, and the systemic challenges--ranging from legal liability to socioeconomic disparities--that currently define the "implementation gap" in healthcare.

### 2.1.1 Theoretical Frameworks of Surgical Autonomy

The transition from master-slave robotic systems to intelligent, semi-autonomous agents requires a strong theoretical underpinning to define the allocation of control between human surgeons and algorithmic systems.

#### 2.1.1.1 Evolution of Control Architectures
Historically, the concept of semi-autonomous coordination traces its roots to non-medical domains. Early research by Szczerba and Collier (Szczerba & Collier, 1998) on "bounding overwatch" operations for ground vehicles established foundational algorithms for coordinating multi-agent systems in high-stakes environments. While their work focused on military applications, the core logic--where one agent acts while another monitors and covers--parallels modern concepts of "shared control" in surgery, where the robot executes sub-tasks under human supervision.

In the medical context, the definition of autonomy has evolved. Kumar et al. (Kumar et al., 2024) propose an operational framework for analyzing levels of autonomy in AI-assisted surgery. This framework suggests that autonomy is not binary but exists on a continuum, ranging from simple information assistance (Level 0) to full autonomous execution of specific tasks (Level 4-5). This theoretical stratification is important for regulatory bodies and hospital administrators to assess risk, as higher levels of autonomy introduce complex liability and safety questions (Casado, 2024).

#### 2.1.1.2 Shared Control and Cognitive Load
A central theoretical driver for adoption is the potential for AI to reduce the cognitive load on surgeons. The theory of "shared control" posits that by offloading repetitive or computationally intensive tasks (such as tissue tracking or image stabilization) to the robot, the surgeon can focus on high-level decision-making. Saeidi et al. (Saeidi et al., 2018) demonstrate this through a confidence-based shared control strategy for the Smart Tissue Autonomous Robot (STAR). Their theoretical model suggests that trust in the system is dynamic; control authority should shift between the human and the robot based on real-time confidence metrics derived from sensor data.

This theoretical benefit is supported by cognitive load theories in ergonomics. McKendrick (McKendrick, 2018) and Guo et al. (Guo et al., 2025) explore how adaptive autonomous systems can regulate operator workload. In the context of surgery, this implies that AI-enabled systems act not just as tools, but as active teammates that monitor the surgeon's state and the surgical environment to optimize performance, thereby reducing the likelihood of error due to fatigue or cognitive overload.

### 2.1.2 Technological Drivers and Clinical Applications

The push toward adoption is heavily driven by rapid advancements in enabling technologies, specifically in computer vision, machine learning (ML), and telecommunication infrastructure.

#### 2.1.2.1 Preoperative Planning and Simulation
One of the most mature drivers of adoption is the use of AI in preoperative planning. In orthopedics, Lambrechts et al. (Lambrechts et al., 2022) highlight the limitations of manufacturer-default plans for total knee arthroplasty, which often require time-consuming intraoperative adjustments. Their research demonstrates that AI-based patient-specific planning algorithms can predict optimal implant positioning with high accuracy, reducing operative time and potentially improving biomechanical outcomes.

Similarly, simulation technologies have become critical for training and adoption. Bouvette et al. (Bouvette et al., 2025) analyze the implementation of robotic simulation in urology residency programs. They find that simulation is no longer merely an educational add-on but a prerequisite for safe adoption, allowing trainees to navigate the steep learning curves associated with robotic platforms before touching a patient.

#### 2.1.2.2 Intraoperative Assistance and Tissue Tracking
The capability of robots to interact with soft tissue autonomously is a significant technological driver. Unlike rigid bone in orthopedics, soft tissue deforms unpredictably. Saeidi et al. (Saeidi et al., 2019) present advancements in biocompatible near-infrared tissue tracking, which enables supervised autonomous electrosurgery. This technology allows the robot to track tissue movement in real-time and adjust surgical paths, a capability that exceeds human reaction times.

Furthermore, Schüßler et al. (Schüßler et al., 2025) discuss semi-autonomous assistance for gallbladder retraction. In laparoscopic procedures, retraction is often performed by an assistant, leading to variability and fatigue. A semi-autonomous robotic arm that can maintain optimal exposure by dynamically adjusting to respiratory motion represents a tangible efficiency driver, potentially reducing the required surgical headcount.

#### 2.1.2.3 Infrastructure and Connectivity
The feasibility of remote and distributed robotic surgery relies heavily on network infrastructure. Hentati et al. (Hentati et al., 2022) and bai et al. (bai et al., 2026) provide comprehensive assessments of 5G technology in this domain. Low latency and high bandwidth are non-negotiable requirements for closing the sensorimotor loop in telesurgery. The literature suggests that 5G architecture allows for the "Tactile Internet," where haptic feedback can be transmitted over distances with imperceptible delay, democratizing access to specialized surgical care.

| Technology Component | Key Function | Clinical Benefit | Citation |
|----------------------|--------------|------------------|----------|
| **5G/Network Slicing** | Ultra-low latency transmission | Enables remote telesurgery; democratizes access | (Hentati et al., 2022)(bai et al., 2026) |
| **Tissue Tracking** | Real-time deformation compensation | Increases precision in soft tissue surgery | (Saeidi et al., 2019) |
| **Generative AI** | Preoperative plan generation | Reduces planning time; personalizes implants | (Lambrechts et al., 2022)(The Lancet Digital Health, 2025) |
| **Shared Control** | Dynamic authority allocation | Reduces surgeon cognitive load; improves safety | (Saeidi et al., 2018)(Guo et al., 2025) |
| **Smart Sensors** | Force/haptic feedback integration | Restores tactile sensation lost in robotics | (Shaikh et al., 2025) |

*Table 1: Technological Drivers of AI-Enabled Robotic Surgery Adoption. Source: Synthesis of listed citations.*

### 2.1.3 Empirical Evidence of Clinical Efficacy

For adoption to scale, empirical evidence must demonstrate that AI-enabled robotic surgery is not only technologically feasible but clinically superior or equivalent to existing standards.

#### 2.1.3.1 Comparative Oncological and Functional Outcomes
Recent systematic reviews provide mixed but promising data regarding clinical outcomes. Delhoum et al. (Delhoum et al., 2025) conducted a meta-analysis comparing robotic-assisted versus conventional laparoscopy in endometrial cancer. Their findings suggest that while robotic approaches may incur higher costs, they often result in shorter hospital stays and reduced blood loss, without compromising oncological outcomes.

In the field of complex abdominal surgery, McMillan et al. (McMillan et al., 2017) utilized propensity score matching to analyze pancreaticoduodenectomy outcomes. Their study focused on the incidence of pancreatic fistula, a severe complication. The data indicated that robotic approaches could achieve comparable safety profiles to open surgery, though the "superiority" of the robotic approach remains a subject of debate, often dependent on surgeon volume and expertise.

#### 2.1.3.2 Learning Curves and Proficiency
The "learning curve" is a critical metric in the literature, often acting as a barrier to initial adoption but a driver for long-term efficiency. Hirri et al. (Hirri et al., 2024) performed a systematic review on adoption curves in bariatric surgery. They identified a distinct "proficiency plateau"--the number of cases required for operative times and complication rates to stabilize. The introduction of AI assistance is theorized to flatten this curve. By providing real-time guidance or preventing unsafe movements (virtual fixtures), AI-enhanced systems could theoretically allow surgeons to reach proficiency faster than with standard robotic telemanipulation (Tian et al., 2025).

#### 2.1.3.3 Precision and Error Reduction
Precision is a recurring theme in the literature supporting adoption. Fuentes et al. (Fuentes et al., 2024) emphasize that AI integration enhances surgical precision and improves postoperative complication prediction. By analyzing intraoperative video data, AI systems can identify anatomical landmarks and potential hazards (e.g., hidden blood vessels) that might be missed by the human eye. This aligns with the broader goal of error reduction in the preanalytical and intraoperative phases, as discussed by Brown (Brown, 2015), who argues that systems engineering approaches are essential for minimizing human error.

### 2.1.4 Systemic Barriers to Adoption

Despite technological maturity and clinical promise, widespread adoption is hindered by a complex system of systemic barriers. These challenges are not merely technical but economic, legal, and sociological.

#### 2.1.4.1 Economic Implications and Cost-Benefit Analysis
The high capital and operational costs of robotic systems remain the most significant barrier. Vaishya et al. (Vaishya et al., 2025) question whether robotic and AI technologies improve outcomes sufficiently to justify their costs. Their analysis suggests that while technology improves precision, it often raises costs and extends learning curves initially. Hospitals face a difficult return-on-investment (ROI) calculation, particularly in healthcare systems with fixed reimbursement rates.

However, the venture capital environment tells a different story of future expectations. Buonomo (Buonomo, 2023) and Shetty & Jaiswal (Shetty & Jaiswal, 2024) analyze investment trends, noting substantial capital flowing into robotics and autonomous systems startups. This disconnect between clinical cost-effectiveness and market investment suggests a "technology push" market dynamic, where innovation is driven by investor speculation on future utility rather than immediate cost savings.

#### 2.1.4.2 Legal Liability and Regulatory Uncertainty
As autonomy increases, liability becomes obscured. Casado (Casado, 2024) explores new criteria for attributing liability when a semi-autonomous robot commits an error. Traditional malpractice laws are predicated on human negligence. If an AI algorithm makes an autonomous decision (e.g., a cut path) that results in injury, determining whether the fault lies with the surgeon, the manufacturer, or the algorithm itself is legally ambiguous.

Furthermore, cybersecurity emerges as a critical barrier. Mitra et al. (Mitra et al., 2025) conduct a systems-theoretic security analysis of ML-enabled medical devices. They argue that the interconnectivity required for these systems (as highlighted in the 5G discussion) introduces vulnerabilities to cyberattacks, which could have lethal consequences. This necessitates rigorous, data-driven security protocols that may slow down deployment.

#### 2.1.4.3 Educational and Training Bottlenecks
The rapid pace of technological change has outstripped the evolution of surgical curricula. Tian et al. (Tian et al., 2025) present a multi-perspective qualitative study on training demands in China, revealing a conspicuous absence of standardized curricula. Similarly, Bouvette et al. (Bouvette et al., 2025) identify barriers across U.S. Residency programs, noting that access to simulation and robotic consoles is unevenly distributed. Without standardized credentialing for AI-assisted procedures, hospitals are hesitant to grant privileges, creating a bottleneck in workforce readiness.

#### 2.1.4.4 Socioeconomic Disparities and Access
A critical, yet often overlooked, barrier is the potential for these technologies to exacerbate healthcare disparities. Moore et al. (Moore et al., 2026) examine how race, socioeconomic status, and geography influence utilization of surgery in epilepsy patients. Their findings imply that advanced surgical interventions are often concentrated in wealthy, urban academic centers. Boakye-Afram et al. (Boakye-Afram et al., 2025) echo this in the context of cardiothoracic surgery, highlighting global disparities. If AI-enabled robotic surgery remains a luxury good, its adoption will be limited to a fraction of the global patient population, limiting its public health impact.

| Category | Specific Barrier | Impact on Adoption | Citation |
|----------|------------------|--------------------|----------|
| **Economic** | High capital/operational costs | Limits acquisition to wealthy institutions | (Vaishya et al., 2025)(Boakye-Afram et al., 2025) |
| **Legal** | Liability attribution ambiguity | Creates reluctance among surgeons/hospitals | (Casado, 2024) |
| **Security** | Vulnerability to cyberattacks | Mandates complex, expensive security layers | (Mitra et al., 2025) |
| **Training** | Lack of standardized curricula | Creates workforce bottleneck; varies quality | (Bouvette et al., 2025)(Tian et al., 2025) |
| **Social** | Unequal access/disparities | Restricts patient pool; raises ethical concerns | (Moore et al., 2026) |

*Table 2: Systemic Barriers to the Adoption of AI-Enabled Robotics. Source: Synthesis of listed citations.*

### 2.1.5 Synthesis and Research Gaps

The literature reveals a mature understanding of the *technological* feasibility of semi-autonomous surgery but highlights a significant fragmentation in understanding the *systemic* integration of these tools.

#### 2.1.5.1 The Disconnect Between Engineering and Implementation
A recurring theme is the gap between engineering achievements and clinical reality. While papers like Saeidi et al. (Saeidi et al., 2018) and Schüßler et al. (Schüßler et al., 2025) demonstrate impressive autonomous capabilities in controlled environments, adoption papers like Nguyen et al. (Nguyen et al., 2017) and Curet [MISSING: cite_019] reveal that practical implementation is often stalled by mundane factors: workflow integration, equipment interoperability, and staff resistance. There is a lack of research bridging these two worlds--specifically, how high-level autonomy features translate into actual hospital workflows.

#### 2.1.5.2 The "Black Box" Problem in Clinical Trust
While AI explainability is discussed in computer science literature, its application to surgical trust is underrepresented. Nazarian et al. (Nazarian et al., 2023) survey endoscopists regarding their sentiments on AI, finding that while there is optimism, there is also significant skepticism regarding "black box" algorithms. The literature lacks strong frameworks for "explainable AI" (XAI) specifically tailored to the high-pressure environment of the operating room, where a surgeon needs to understand *why* a robot is recommending a specific action in real-time.

#### 2.1.5.3 Longitudinal Outcomes of Semi-Autonomy
Most empirical studies, such as those by Hirri et al. (Hirri et al., 2024), focus on short-term perioperative outcomes (time, blood loss). There is a paucity of longitudinal data assessing the long-term impact of AI assistance on surgeon skill retention. Does reliance on semi-autonomous tissue tracking lead to the degradation of manual skills over a decade? This question remains largely unanswered in the current corpus.

#### 2.1.5.4 Integration of Generative AI
Finally, the emergence of generative AI represents a nascent frontier. The Lancet Digital Health (The Lancet Digital Health, 2025) and Tien Ho (Tien Ho, 2025) discuss the rollout of generative models, but their specific application to surgical robotics--beyond administrative tasks--is just beginning to be explored. How Large Language Models (LLMs) might act as intraoperative surgical coaches or decision support systems constitutes a significant gap in the current literature.

### 2.1.6 Conclusion of Literature Review

In summary, the literature paints a picture of a field at a critical inflection point. The technological drivers--5G connectivity, soft tissue tracking, and machine learning planning--are strong and rapidly advancing. However, the barriers are formidable and deeply entrenched in the economic, legal, and social fabric of healthcare systems. The current body of knowledge adequately describes *what* is possible but provides less clarity on *how* to transition from possibility to standard practice amidst these systemic constraints. This thesis aims to address these gaps by applying the TOE (Technology-Organization-Environment) framework to systematically analyze these opposing forces.

# 2.2 Methodology

## 2.2.1 Research Design and Methodological Approach

This thesis employs a qualitative, narrative review methodology structured around the Technology-Organization-Environment (TOE) framework to analyze the adoption drivers and barriers of AI-enabled semi-autonomous robotic surgery. While systematic reviews (e.g., PRISMA) are valuable for aggregating quantitative clinical outcomes, the complex, multi-faceted nature of surgical automation--encompassing legal liability, organizational culture, technical latency, and economic feasibility--requires a broader, integrative approach. A narrative review allows for the synthesis of heterogeneous literature sources, ranging from technical engineering reports on soft tissue tracking (Schüßler et al., 2025)(Saeidi et al., 2019) to legal analyses of robotic liability (Casado, 2024) and sociological studies on surgeon training (Bouvette et al., 2025).

The primary objective of this methodological design is to bridge the "implementation gap" identified in the literature review. As noted in Section 2.1, while technical feasibility is well-documented, there is a distinct lack of clarity regarding the systemic integration of these technologies. Therefore, this research moves beyond a simple cataloging of technologies to perform a structured thematic analysis. By categorizing findings into Technological, Organizational, and Environmental dimensions, the study aims to provide a comprehensive model of adoption that accounts for the interdependence of these factors.

The research design is interpretivist in nature, acknowledging that the "barriers" to adoption are often socially constructed (e.g., surgeon trust in "black box" algorithms) rather than purely objective technical limitations. This approach aligns with recent scholarship suggesting that the integration of AI in high-stakes environments like the operating room is as much a sociological challenge as a technical one (Kerr et al., 2017). Consequently, the methodology prioritizes sources that discuss the *interaction* between human operators and semi-autonomous systems, rather than focusing exclusively on technical performance metrics like operative time or blood loss, which dominate the clinical literature (Hirri et al., 2024).

### 2.2.1.1 Justification for Narrative Review
A narrative review format was selected over a systematic review or meta-analysis for several specific reasons inherent to the emerging nature of semi-autonomous surgery:

1. **Heterogeneity of Data:** The relevant literature spans distinct disciplines with incompatible data structures. Engineering papers report latency in milliseconds (Hentati et al., 2022), medical journals report patient outcomes (Delhoum et al., 2025), and legal journals discuss liability frameworks (Casado, 2024). A meta-analysis cannot statistically pool these disparate data points.
2. **Theoretical Flexibility:** The integration of Generative AI and Large Language Models (LLMs) into surgical workflows is a nascent frontier (The Lancet Digital Health, 2025). A rigid systematic review protocol defined at the outset might exclude these rapidly emerging topics, whereas a narrative approach allows for the inclusion of innovative recent developments.
3. **Focus on "How" and "Why":** The research question seeks to understand *why* adoption barriers exist (e.g., the cognitive load issues discussed in (Guo et al., 2025)) and *how* they can be mitigated. This requires qualitative synthesis of argumentative and theoretical papers, not just empirical trials.

## 2.2.2 Theoretical Framework: The TOE Model

To provide a rigorous analytical structure to the narrative review, this thesis uses the Technology-Organization-Environment (TOE) framework. Originally developed by Tornatzky and Fleischer, the TOE framework is widely regarded as a strong model for analyzing the adoption of technological innovations at the firm (hospital) level.

The choice of TOE over other common models, such as the Technology Acceptance Model (TAM) or the Unified Theory of Acceptance and Use of Technology (UTAUT), is deliberate. TAM and UTAUT focus primarily on *individual* user acceptance (e.g., a single surgeon's willingness to use a robot). However, the adoption of semi-autonomous surgical systems involves high capital expenditure, infrastructure changes (5G networks), and regulatory compliance, which are organizational and environmental decisions. The TOE framework explicitly accounts for these macro-level factors, making it superior for analyzing complex healthcare system transformations.

The application of the TOE framework in this thesis is operationalized as follows:

| Dimension | Definition in Surgical Context | Key Analysis Factors |
|-----------|--------------------------------|----------------------|
| **Technology** | Internal/external technologies relevant to the hospital | AI capabilities, latency, haptics, interoperability |
| **Organization** | Characteristics of the hospital/institution | Surgeon training, cost, workflow, liability |
| **Environment** | The arena in which the hospital conducts business | Regulatory frameworks, 5G infrastructure, competition |

*Table 1: Operationalization of the TOE Framework for Semi-Autonomous Surgery.*

### 2.2.2.1 Technological Context
In this study, the technological context refers to the functional capabilities and limitations of current AI and robotic systems. The methodology involves scanning the literature for evidence regarding the maturity of specific semi-autonomous features. This includes the transition from tele-manipulation to supervised autonomy, as seen in the Smart Tissue Autonomous Robot (STAR) (Saeidi et al., 2018), and the development of biocompatible tissue tracking (Saeidi et al., 2019). The analysis specifically looks for "technological readiness" indicators--distinguishing between what is proven in dry-lab simulations versus what is clinically viable in wet-lab or human trials. Furthermore, the technological dimension includes the underlying infrastructure required to support these systems, specifically the role of 5G technology in enabling low-latency remote operations (bai et al., 2026).

### 2.2.2.2 Organizational Context
The organizational context examines the descriptive measures of the healthcare institutions adopting these technologies. This dimension is critical for understanding the "implementation gap." The methodology focuses on extracting data related to the internal barriers hospitals face. Key themes analyzed under this dimension include:
* **Financial structures:** The cost-benefit analysis of robotic systems compared to laparoscopic alternatives (Vaishya et al., 2025).
* **Human Capital:** The learning curves associated with robotic adoption and the requirements for resident training curricula (Bouvette et al., 2025)(Tian et al., 2025).
* **Workflow Integration:** How semi-autonomous agents fit into the existing hierarchy of the operating room and the cognitive load implications for the surgical team (McKendrick, 2018)(Guo et al., 2025).

### 2.2.2.3 Environmental Context
The environmental context captures the external pressures and constraints surrounding the healthcare institution. This includes the legal and regulatory environment, which is often cited as a primary barrier to autonomy. The methodology involves a targeted analysis of legal literature regarding liability attribution when an autonomous agent makes an error (Casado, 2024). Additionally, this dimension encompasses the broader industry trends, such as the role of venture capital in driving innovation in robotics (Shetty & Jaiswal, 2024) and the disparities in access to care based on geography and socioeconomic status (Boakye-Afram et al., 2025)(Moore et al., 2026).

## 2.2.3 Data Collection Strategy

The data collection process was designed to identify high-quality academic literature that addresses the intersection of artificial intelligence, robotics, and surgical implementation. Given the rapid pace of advancement in this field, the search strategy prioritized recency while ensuring foundational technical papers were included to establish the baseline of autonomy.

### 2.2.3.1 Search Strategy and Sources
A comprehensive search of academic databases was conducted to identify relevant literature. The primary databases included IEEE Xplore (for technical and engineering papers), PubMed/MEDLINE (for clinical outcomes and surgical trials), and legal/social science repositories (for liability and ethics discussions).

The search terms were constructed to capture the three dimensions of the TOE framework. Boolean operators were used to refine the results.

| TOE Dimension | Primary Keywords | Secondary/Contextual Keywords |
|---------------|------------------|-------------------------------|
| **Technology** | "Robotic surgery", "Semi-autonomous" | "Soft tissue tracking", "Haptics", "5G", "Generative AI" |
| **Organization** | "Surgical training", "Learning curve" | "Cost-effectiveness", "Hospital adoption", "Workflow" |
| **Environment** | "Liability", "Regulation", "Ethics" | "Disparities", "Venture capital", "FDA approval" |

*Table 2: Search Strategy Keywords Mapped to TOE Dimensions.*

### 2.2.3.2 Inclusion and Exclusion Criteria
To ensure the relevance and rigor of the narrative review, specific inclusion and exclusion criteria were applied during the source selection process. These criteria were designed to filter out noise and focus on the specific transition from tele-operation to semi-autonomy.

**Inclusion Criteria:**
* **Topic Relevance:** Publications must explicitly discuss AI, automation, or semi-autonomy in the context of surgery. Papers focusing solely on traditional manual laparoscopy were excluded unless used as a control comparison (Delhoum et al., 2025).
* **Publication Date:** Priority was given to papers published between 2018 and 2025 to capture the modern era of deep learning and soft robotics. Foundational papers (e.g., early definitions of robotic levels of autonomy) were included regardless of date if they provided necessary theoretical context (Szczerba & Collier, 1998).
* **Type of Source:** Peer-reviewed journal articles, conference proceedings (particularly IEEE for technical aspects), and authoritative reviews.
* **Language:** English.

**Exclusion Criteria:**
* **Purely Tele-operation:** Studies focusing exclusively on master-slave manipulation without any element of AI assistance or automation were generally excluded, as they do not address the "semi-autonomous" aspect of the research question.
* **Non-Surgical Medical AI:** Papers discussing AI for diagnostic radiology or pathology were excluded unless they had direct relevance to intraoperative decision support (e.g., real-time image analysis during surgery) (Stoyanov et al., 2018).
* **Abstracts/Editorials:** Short abstracts without full text were excluded to ensure sufficient depth for analysis, though substantive editorials from major journals were considered for identifying industry trends (Zheng et al., 2022).

### 2.2.3.3 Specific Focus on Emerging Technologies
Recognizing the gap identified in the literature review regarding Generative AI, specific attention was paid to identifying sources that discuss the application of Large Language Models (LLMs) and generative pre-trained transformers in the surgical domain. While sparse, sources discussing the "rollout" of generative AI in healthcare (The Lancet Digital Health, 2025) and its potential for training (Tien Ho, 2025) were deliberately sought out to address the "future directions" aspect of the thesis. Similarly, papers addressing the "black box" nature of AI and the need for explainability were targeted to address the trust barriers noted in Section 2.1 (Mitra et al., 2025).

## 2.2.4 Analysis and Synthesis Approach

The analysis of the selected literature followed a thematic synthesis approach, guided by the TOE framework. This process involved three distinct stages: coding, mapping, and synthesis.

### 2.2.4.1 Thematic Coding
Initially, selected papers were reviewed to identify recurring themes and concepts. For instance, papers discussing "latency" in telesurgery (Hentati et al., 2022) and "network stability" (bai et al., 2026) were coded under "Infrastructure Reliability." Papers discussing "surgeon fatigue" (McKendrick, 2018) and "cognitive load" (Guo et al., 2025) were coded under "Human Factors." This open coding phase allowed the data to speak for itself before being rigidly categorized.

### 2.2.4.2 Mapping to TOE Framework
Following the initial coding, the identified themes were mapped onto the Technology, Organization, and Environment dimensions. This mapping process revealed the interconnections between dimensions. For example, the technological capability of "shared autonomy" (Guo et al., 2025) maps to the Technological dimension, but its effect on reducing surgeon cognitive load maps to the Organizational dimension (human capital). Similarly, "liability attribution" (Casado, 2024) maps to the Environmental dimension, but it directly influences hospital risk management policies (Organizational).

This mapping process was important for identifying the "drivers" and "barriers." A factor was classified as a **driver** if the literature suggested it facilitated adoption (e.g., improved precision (Fuentes et al., 2024), potential for reduced fistulas (McMillan et al., 2017)). A factor was classified as a **barrier** if it hindered adoption (e.g., high costs (Vaishya et al., 2025), lack of haptic feedback (Zheng et al., 2022), security risks (Mitra et al., 2025)).

### 2.2.4.3 Synthesis and Gap Analysis
The final stage involved synthesizing the mapped data to construct a coherent narrative. This synthesis focused on identifying contradictions and consensus in the literature. For example, while some sources argue that robotics improve outcomes (Fuentes et al., 2024), others suggest that for certain procedures, the benefits do not justify the costs or learning curves (Hirri et al., 2024)(Vaishya et al., 2025). The methodology involves presenting these conflicting viewpoints to highlight the complexity of the adoption decision.

Furthermore, the synthesis process explicitly looked for gaps where the TOE dimensions were not well-addressed. As noted in the literature review, the long-term impact of automation on skill degradation is a significant gap. By systematically mapping papers to the "Human Capital" sub-dimension of Organization, the paucity of longitudinal studies became evident, validating the research gap identified in Section 2.1.

## 2.2.5 Methodological Limitations

It is important to acknowledge the limitations inherent in this methodological approach. As a narrative review, this study is subject to selection bias, as the inclusion of sources relies on the researcher's judgment rather than a rigid algorithmic selection process used in systematic reviews. To mitigate this, the search strategy was broad, and the inclusion criteria were clearly defined.

Secondly, the "semi-autonomous" nature of the technology presents a definitional challenge. The term is used inconsistently in the literature, ranging from simple camera control to complex suturing automation. To address this, the thesis relies on standard definitions of autonomy levels found in the engineering literature (Kumar et al., 2024) to maintain consistency.

Thirdly, a significant portion of the available data on specific robotic platforms (e.g., da Vinci, STAR) comes from studies that may have industry funding or involvement. While this is common in medical device research, it introduces a potential positivity bias. The methodology attempts to balance this by specifically seeking out independent reviews and studies that report on complications, costs, and barriers (Nguyen et al., 2017)(Curet, 2019), rather than just successful case studies.

Finally, the rapid evolution of the field means that published literature often lags behind the current technology available in labs. Papers published in 2018 or 2019 might describe technical limitations (e.g., lack of haptics) that have been partially addressed in 2024 prototypes. To account for this, the analysis prioritizes the most recent sources (Delhoum et al., 2025)(Zhu, 2025) when discussing technical capabilities, while allowing older sources to inform the theoretical and organizational discussions which are less time-sensitive.

## 2.2.6 Ethical Considerations in Secondary Research

Although this thesis does not involve primary data collection from human subjects, ethical considerations regarding the interpretation of secondary data remain relevant. The analysis involves interpreting studies that discuss patient outcomes and surgeon performance. It is ethically imperative to represent these findings accurately, avoiding the over-extrapolation of "technical success" to "clinical safety."

Furthermore, the discussion of AI in surgery raises ethical questions regarding algorithmic bias and equitable access. The methodology explicitly includes an "Environmental" focus on disparities (Boakye-Afram et al., 2025)(Moore et al., 2026) to ensure the review does not implicitly endorse a technology that might exacerbate healthcare inequality. By critically analyzing who benefits from these technologies and who is left behind, the methodology adheres to the principles of bioethics, specifically justice and non-maleficence.

## 2.2.7 Integration of Interdisciplinary Perspectives

A defining feature of this methodology is its interdisciplinary nature. The adoption of semi-autonomous surgery cannot be understood through a single lens.
* **Engineering perspective:** Provides the ground truth of what is technically possible (e.g., fluidic elastomer robots (Marchese et al., 2015), liquid metal sensors (Chen et al., 2023)).
* **Clinical perspective:** Validates whether technical possibilities translate to patient benefit (e.g., reduction in pancreatic fistulas (McMillan et al., 2017), orthopedic outcomes (Lambrechts et al., 2022)).
* **Legal/Economic perspective:** Determines feasibility (e.g., venture capital trends (Shetty & Jaiswal, 2024), error reduction value (Brown, 2015)).

By weaving these perspectives together using the TOE framework, the methodology ensures a comprehensive analysis that is greater than the sum of its parts. This approach allows the thesis to move beyond the question "Does the robot work?" to the more significant question "Can the healthcare system successfully adopt and sustain this technology?"

## 2.2.8 Summary of Methodology

In conclusion, this section has outlined a strong qualitative methodology designed to dissect the complex system of semi-autonomous robotic surgery. By employing a narrative review structure underpinned by the TOE framework, this research is positioned to systematically analyze the drivers and barriers to adoption. The rigorous search strategy, careful selection of interdisciplinary sources, and thematic analysis ensure that the subsequent Analysis and Results section will provide a nuanced, evidence-based answer to the research question. The methodology is specifically calibrated to address the identified gaps in the literature--specifically the lack of systemic integration frameworks--by synthesizing technical, organizational, and environmental data into a cohesive adoption model.

The following sections will present the results of this analysis, categorized by the TOE dimensions, providing a detailed examination of the specific drivers (such as precision and 5G connectivity) and barriers (such as liability and cost) identified through this methodological process.

# 2.3 Analysis and Results

The analysis of the selected literature, conducted through the lens of the Technology-Organization-Environment (TOE) framework, reveals a complex system of factors influencing the adoption of AI-enabled semi-autonomous robotic surgery. This section presents the synthesized findings from the narrative review, categorizing the evidence into technological capabilities, organizational implementation challenges, and environmental systemic factors. The results indicate that while technological drivers regarding precision and efficacy are strong, significant organizational and environmental barriers--particularly regarding cost, training, and legal liability--create a substantial "implementation gap."

## 2.3.1 Technological Dimensions of Adoption

The technological context represents the most prolific area of research within the reviewed literature. The analysis identifies a clear dichotomy between the demonstrated clinical efficacy of robotic systems (drivers) and the infrastructural and security challenges inherent in increasing autonomy (barriers).

### 2.3.1.1 Efficacy, Precision, and Clinical Outcomes
The primary driver for the adoption of robotic surgery identified across the literature is the potential for superior clinical outcomes driven by enhanced precision. Multiple studies provide quantitative evidence supporting the efficacy of robotic assistance compared to traditional methods.

Research by Delhoum et al. (Delhoum et al., 2025) provides a systematic review and meta-analysis comparing robotic-assisted surgery (RAS) to conventional laparoscopy in endometrial cancer management. Their findings suggest that RAS offers non-inferior oncological outcomes while potentially reducing perioperative complications. This aligns with broader findings in the field, such as those by Fuentes et al. (Fuentes et al., 2024), who report that the integration of AI into general surgery has led to significant advancements in surgical precision and postoperative complication prediction.

The transition from purely teleoperated systems to semi-autonomous agents is further supported by specific task-based efficacy studies. For instance, Schüßler et al. (Schüßler et al., 2025) demonstrated the feasibility of semi-autonomous robotic assistance for gallbladder retraction. In their analysis, the system demonstrated the capability to alleviate surgical staff shortages by autonomously executing complex retraction tasks in unstructured environments. This represents a critical shift from the "master-slave" paradigm to a collaborative "human-in-the-loop" model.

Furthermore, the potential for error reduction acts as a significant technological driver. Brown (Brown, 2015) highlights the role of automation in reducing errors during the preanalytical process, a concept that translates to the intraoperative phase through systems designed to filter hand tremors and prevent iatrogenic injury. The Smart Tissue Autonomous Robot (STAR) system, analyzed by Saeidi et al. (Saeidi et al., 2018), employs a confidence-based shared control strategy. Their results indicate that while full automation remains unfeasible in complex environments, shared control strategies can uses robotic accuracy and repeatability to reduce human-induced errors.

Table 1 summarizes the key technological drivers identified in the literature, contrasting specific capabilities with their reported clinical impacts.

| Capability | Key Finding/Outcome | Reference |
|------------|---------------------|-----------|
| Precision | Non-inferior oncological outcomes; reduced complications | (Delhoum et al., 2025) |
| Task Autonomy | Autonomous retraction feasible in unstructured environments | (Schüßler et al., 2025) |
| Error Reduction | Shared control strategies mitigate human error | (Saeidi et al., 2018) |
| Pre-op Planning | AI algorithms predict patient-specific plans | (Lambrechts et al., 2022) |
| Tissue Tracking | Near-infrared tracking enables autonomous electrosurgery | (Saeidi et al., 2019) |

*Table 1: Summary of Technological Drivers and Clinical Efficacy Findings.*

The data presented in Table 1 illustrates a consistent trend: technological advancements are moving beyond simple mechanical assistance toward intelligent intervention. For example, Lambrechts et al. (Lambrechts et al., 2022) discuss AI-based patient-specific preoperative planning algorithms for total knee arthroplasty. Their analysis suggests that AI can predict preoperative plans that reduce the need for intraoperative adjustments, thereby streamlining the surgical workflow. Similarly, Saeidi et al. (Saeidi et al., 2019) explore supervised autonomous electrosurgery using biocompatible near-infrared tissue tracking, demonstrating that autonomous systems can maintain tissue tracking in deformable environments, a prerequisite for safety in soft tissue surgery.

### 2.3.1.2 The Evolution of Control Architectures and Autonomy
A critical theme emerging from the analysis is the theoretical and practical evolution of control architectures. The literature reveals that "autonomy" is not a binary state but a spectrum. Kumar et al. (Kumar et al., 2024) propose an operational framework and standard requirements for AI-assisted robotic surgery, analyzing the level of autonomy required for different procedures. Their work suggests that defining clear boundaries for autonomous behavior is essential for adoption.

Historically, this logic traces back to foundational work in non-medical robotics. Szczerba and Collier (Szczerba & Collier, 1998) established algorithms for "bounding overwatch" operations in ground vehicles. While their context was military, the underlying logic--where one agent acts while another monitors--parallels the "supervisory control" models currently proposed for surgery. In this model, the surgeon acts as a supervisor who authorizes autonomous sub-tasks (like suturing or retraction) rather than manually controlling every motion.

However, the analysis also highlights that increasing autonomy introduces new complexities in human-machine interaction. Guo et al. (Guo et al., 2025) discuss shared autonomy for cognitive load regulation in autonomous wheelchairs, a domain with significant parallels to surgical robotics. Their findings indicate that while autonomy can reduce physical workload, it may paradoxically increase cognitive load if the human operator must constantly monitor the system for potential failures. This "monitoring penalty" is a critical barrier identified in the literature, suggesting that semi-autonomous systems must be designed to communicate their intent clearly to the surgeon to build trust and reduce cognitive strain.

### 2.3.1.3 Infrastructure, Connectivity, and Security Barriers
Despite the promise of precision and autonomy, the analysis reveals substantial technological barriers related to infrastructure and security. The reliance on advanced connectivity for remote or cloud-based AI processing introduces latency and reliability concerns.

Hentati et al. (Hentati et al., 2022) analyze the requirements for remote robotic surgery, emphasizing the need for ultra-low latency. Their work on the joint placement and scheduling of Virtual Network Function Forwarding Graphs (VNF-FGs) highlights that current network infrastructures may struggle to support the strict Quality of Service (QoS) requirements of haptic feedback systems. Specifically, the "Tactile Internet" requires round-trip times (RTT) of less than 1-10 milliseconds to prevent simulator sickness and ensure safety, a standard that is difficult to guarantee over public networks.

Bai et al. (bai et al., 2026) provide a comprehensive assessment of 5G technology in this context. While 5G offers the theoretical bandwidth and low latency required, their analysis points to challenges in system architecture reliability and coverage. The dependence on wireless connectivity introduces a new failure mode: signal loss during critical surgical steps.

Furthermore, the integration of AI and ML introduces severe cybersecurity risks. Mitra et al. (Mitra et al., 2025) conduct a systems-theoretic and data-driven security analysis of ML-enabled medical devices. Their findings are alarming; the interconnectivity and opacity of complex models make them vulnerable to adversarial attacks. A compromised surgical robot could theoretically be manipulated to perform unsafe actions or leak sensitive patient data. This security vulnerability acts as a significant barrier to adoption, particularly for hospital administrators and regulators concerned with patient safety and data privacy.

## 2.3.2 Organizational and Clinical Implementation

The organizational context examines how healthcare institutions, surgical teams, and economic structures adapt to--or resist--the introduction of semi-autonomous systems. The analysis indicates that while these systems offer workflow potential, they impose heavy burdens regarding training, cost, and change management.

### 2.3.2.1 Learning Curves and Training Demands
One of the most significant barriers identified is the steep learning curve associated with robotic systems. Unlike traditional instruments, robotic systems require the mastery of a complex user interface, dissociation of tactile feedback, and now, the management of AI agents.

Hirri et al. (Hirri et al., 2024) conducted a systematic review of learning curves for the adoption of robotic bariatric surgery. Their analysis reveals that proficiency is not immediate; surgeons require a substantial number of cases to reach a plateau in operative time and complication rates. This "training gap" represents a period of inefficiency and potential risk that institutions must manage.

Tian et al. (Tian et al., 2025) reinforce this through a multi-perspective qualitative study on robotic-assisted surgery training demand. Their findings highlight a "conspicuous absence" of unified and standardized curricula, particularly in emerging markets like China. The lack of standardized training protocols for AI-specific features means that surgeons are often learning "on the job," which raises ethical and safety concerns.

Conversely, some literature suggests that AI could eventually *flatten* the learning curve. Bouvette et al. (Bouvette et al., 2025) discuss robotic simulation in urology training, noting that simulation curricula are becoming more prevalent. AI-driven tutoring systems, which can provide real-time feedback on surgical technique (e.g., "movement economy" or "tissue handling"), have the potential to accelerate skill acquisition. However, Vaishya et al. (Vaishya et al., 2025) question whether these technologies currently improve outcomes enough to justify the costs and the extended learning curves, suggesting a skepticism in the orthopedic community regarding the value proposition of current-generation robotics.

### 2.3.2.2 Workflow Integration and OR Dynamics
The introduction of semi-autonomous robots fundamentally alters the dynamics of the operating room (OR). Stoyanov et al. (Stoyanov et al., 2018) describe the concept of "OR 2.0," which involves context-aware operating theaters. In this vision, the robot and the room sensors work together to anticipate the surgeon's needs. However, achieving this requires massive integration of disparate data streams (imaging, video, vitals), creating an organizational challenge in terms of interoperability.

Shaikh et al. (Shaikh et al., 2025) review the integration of medical robotics and AI, noting that optimization must occur across the entire perioperative phase--from preoperative planning to postoperative recovery. The barrier here is "siloed" data; if the robot's AI cannot access the patient's electronic health record (EHR) or preoperative imaging smoothly, its autonomous capabilities are severely limited.

Furthermore, the issue of cognitive load remains essential. McKendrick (McKendrick, 2018) analyzes workload transitions and cognitive load states in adaptive autonomous transportation, a field with strong correlates to surgery. The analysis suggests that "hand-offs" between human and machine are high-risk moments. If a semi-autonomous robot encounters an edge case and suddenly returns control to the surgeon, the surgeon must instantly reorient to the task. This "re-acquisition" time is a critical safety hazard that organizations must address through protocol design.

### 2.3.2.3 Economic Viability and Investment Patterns
The economic analysis of the literature reveals a tension between high upfront costs and long-term value. Buonomo (Buonomo, 2023) and Shetty and Jaiswal (Shetty & Jaiswal, 2024) analyze venture capital (VC) investment trends in robotics and AI. Their findings indicate strong investment flows, suggesting that the market anticipates significant growth. However, this investment is often driven by the promise of future capabilities rather than immediate cost-effectiveness.

For healthcare providers, the cost-benefit analysis is often negative in the short term. Curet (Curet, 2019) discusses issues in the adoption of robotic surgery, explicitly noting the high capital costs of the equipment and the recurring costs of disposable instruments. Unless the robot significantly reduces length of stay (LOS) or complications (as suggested by cite_001), the financial argument for adoption remains weak for many procedures.

Table 2 synthesizes the organizational factors, contrasting the investment drivers with the implementation barriers.

| Factor | Driver | Barrier | Reference |
|--------|--------|---------|-----------|
| Training | Simulation/AI tutoring potential | Steep learning curves; lack of standardization | (Hirri et al., 2024)(Bouvette et al., 2025)(Tian et al., 2025) |
| Workflow | Context-aware assistance (OR 2.0) | Data silos; cognitive load during hand-offs | (Stoyanov et al., 2018)(McKendrick, 2018) |
| Economics | High VC interest/Innovation | High capital/disposable costs; unclear ROI | (Buonomo, 2023)(Shetty & Jaiswal, 2024)(Curet, 2019) |

*Table 2: Organizational Drivers and Barriers: Economics and Implementation.*

The synthesis in Table 2 highlights that while the *supply side* (investors, manufacturers) is driving adoption through capital and innovation, the *demand side* (hospitals) faces friction due to operational disruption and uncertain return on investment (ROI).

## 2.3.3 Environmental and Systemic Factors

The environmental context encompasses the external pressures influencing adoption, including legal frameworks, socioeconomic conditions, and societal trust. The analysis suggests that these factors are currently lagging behind technological capabilities, creating a regulatory vacuum.

### 2.3.3.1 Legal Liability and Regulatory Frameworks
A pervasive barrier identified in the literature is the lack of clear liability frameworks for autonomous medical actions. Casado (Casado, 2024) explores "Robots and Liability," proposing new criteria and attribution methods. The central question posed is: *If a semi-autonomous robot makes an error during a suturing task, who is responsible--the surgeon, the manufacturer, or the algorithm?*

Current legal frameworks typically attribute liability to the surgeon under the doctrine of "learned intermediary." However, as systems become more autonomous (as described in cite_008 and cite_018), the surgeon's ability to intervene decreases, making this liability model increasingly untenable. Kerr et al. (Kerr et al., 2017) discuss robots and AI in healthcare law, arguing that the uncertainty regarding malpractice liability chills adoption. Surgeons may be hesitant to engage "autonomous modes" if they fear being held responsible for algorithmic "black box" errors they could not predict or prevent.

### 2.3.3.2 Socioeconomic Disparities and Access
The analysis reveals a troubling trend regarding equitable access to these advanced technologies. Boakye-Afram et al. (Boakye-Afram et al., 2025) highlight global disparities in robotic-assisted cardiothoracic surgery. Their findings indicate that the benefits of RAS are largely concentrated in high-income nations and well-funded academic centers, exacerbating the global health divide.

This disparity exists not only globally but also locally. Moore et al. (Moore et al., 2026) examined how race, socioeconomic status (SES), and geography influence the utilization of surgery in Minnesota epilepsy patients. Their data suggests that vulnerable populations are less likely to receive advanced surgical interventions. The high cost of robotic systems (discussed in cite_046) implies that these technologies may initially be accessible only to affluent patients or institutions, potentially widening the gap in health outcomes.

### 2.3.3.3 Trust and Ethical Considerations
Finally, the adoption of AI in surgery is heavily influenced by the sentiments of the medical community and patients. Nazarian et al. (Nazarian et al., 2023) surveyed endoscopists to ascertain their thoughts on AI. While there is optimism regarding diagnostic support, there is significant hesitation regarding autonomous intervention. The "black box" nature of deep learning models creates a trust deficit.

The Lancet Digital Health (The Lancet Digital Health, 2025) discusses the rapid rollout of generative AI in healthcare, cautioning against premature deployment without rigorous validation. The potential for AI "hallucinations" or errors in high-stakes surgical environments could catastrophically damage trust in the technology. Additionally, ethical concerns regarding data privacy (as noted in cite_010) and the potential for algorithmic bias in training data remain unresolved.

Table 3 summarizes these environmental factors, highlighting the systemic risks associated with adoption.

| Dimension | Key Concern/Barrier | Implication for Adoption | Reference |
|-----------|---------------------|--------------------------|-----------|
| Liability | Attribution of error | Chills surgeon willingness to use autonomy | (Casado, 2024)(Kerr et al., 2017) |
| Equity | High cost/Elite access | Exacerbates health disparities | (Boakye-Afram et al., 2025)(Moore et al., 2026) |
| Trust | "Black box" algorithms | Resistance from clinicians/patients | (The Lancet Digital Health, 2025)(Nazarian et al., 2023) |

*Table 3: Environmental Barriers: Legal, Social, and Ethical.*

## 2.3.4 Synthesis of Drivers and Barriers

The synthesis of findings across the TOE framework demonstrates that the adoption of AI-enabled semi-autonomous robotic surgery is currently in a "technological push" rather than "market pull" phase.

Technologically, the systems are maturing rapidly. The literature confirms that robotic systems can achieve parity or superiority in precision (Delhoum et al., 2025)(Fuentes et al., 2024) and that semi-autonomous functions like retraction (Schüßler et al., 2025) and tissue tracking (Saeidi et al., 2019) are technically feasible. The integration of 5G (bai et al., 2026) and soft robotics (Marchese et al., 2015) further expands the envelope of what is possible.

However, the organizational and environmental contexts act as significant brakes on this momentum. The economic reality of high costs (Curet, 2019), combined with the operational friction of steep learning curves (Hirri et al., 2024) and data silos (Shaikh et al., 2025), makes the business case for adoption difficult for many institutions. Furthermore, the unresolved legal questions regarding liability (Casado, 2024) and the ethical concerns about equity (Boakye-Afram et al., 2025) create a risk-averse environment.

The analysis suggests a critical "implementation gap." While the technology (T) is advancing exponentially, the organizational (O) and environmental (E) structures are evolving linearly. Bridging this gap requires not just better algorithms, but systemic changes: standardized training curricula (Tian et al., 2025), strong legal frameworks for shared liability (Kerr et al., 2017), and economic models that incentivize value-based care over volume.

### 2.3.4.1 Cross-Domain Comparisons
It is instructive to compare the findings from surgery to other domains referenced in the literature. The challenges of "bounding overwatch" in military robotics (Szczerba & Collier, 1998) and cognitive load in autonomous transportation (McKendrick, 2018) mirror the surgical experience. In all these fields, the transition from manual control to shared autonomy is fraught with human-factors challenges. The literature consistently points to "shared control" (Saeidi et al., 2018)(Guo et al., 2025) as the most viable intermediate step, allowing the human to remain in the loop while the AI handles low-level execution.

### 2.3.4.2 Quantitative Trends in the Literature
A review of the quantitative data within the cited studies reveals the following trends:
1. **Outcome Equivalence:** Most comparative studies (e.g., (Delhoum et al., 2025)) show that robotic outcomes are at least equivalent to laparoscopic ones, with benefits primarily in recovery time rather than survival.
2. **Learning Curve Latency:** Studies on learning curves (Hirri et al., 2024) indicate that hundreds of cases may be required for proficiency, a significant investment of time.
3. **Cost Disparity:** Economic analyses (Vaishya et al., 2025)(Curet, 2019) consistently highlight the higher direct costs of robotic procedures, often without a commensurate reimbursement increase.

In conclusion, the analysis indicates that the widespread adoption of semi-autonomous robotic surgery depends less on the next breakthrough in AI and more on the resolution of these systemic organizational and environmental barriers.

## 2.3.5 Detailed Analysis of Specific Technological Enablers

To fully understand the technological context, it is necessary to examines deeper into the specific enablers identified in the literature, particularly 5G connectivity and soft robotics, as these represent the frontier of adoption.

### 2.3.5.1 The Role of 5G in Democratizing Access
While previous sections highlighted connectivity as a barrier due to reliability, the literature also presents 5G as a potent driver for democratizing access to surgical expertise. Bai et al. (bai et al., 2026) argue that 5G is not merely a faster network but a fundamental enabler of "telesurgery," which could address the geographic disparities noted by Boakye-Afram et al. (Boakye-Afram et al., 2025). By enabling high-bandwidth, low-latency transmission of 4K video and haptic data, 5G allows a specialist in a major urban center to assist or control a robot in a rural clinic.

However, the analysis of Hentati et al. (Hentati et al., 2022) regarding VNF-FGs introduces a necessary nuance. They demonstrate that simply having a 5G antenna is insufficient; the entire network architecture must be optimized for "tactile" data slices. This requires sophisticated software-defined networking (SDN) to prioritize surgical data packets over other traffic. The results from their simulations suggest that without such prioritization, packet jitter can render the robotic control loop unstable, leading to dangerous overshoots in instrument movement. Thus, the "driver" of 5G is inextricably linked to the "barrier" of network infrastructure investment.

### 2.3.5.2 Soft Robotics and Safety Compliance
Traditional surgical robots are rigid, which poses a safety risk when interacting with delicate soft tissues. The literature identifies "soft robotics" as a key technological evolution aimed at intrinsic safety. Marchese et al. (Marchese et al., 2015) describe the design of soft fluidic elastomer robots. Unlike rigid motors, these actuators are compliant; if they accidentally collide with an organ, they deform rather than puncture.

This hardware-level safety is complemented by innovations in sensors. Chen et al. (Chen et al., 2023) review liquid metal functionalization in wearables and soft robotics. Their analysis suggests that integrating liquid metal sensors allows for "proprioception" (self-sensing of position and force) without rigid encoders. This capability is important for the semi-autonomous behaviors described by Schüßler et al. (Schüßler et al., 2025), as the robot needs to sense the tension it is applying to the gallbladder to avoid tearing it. The convergence of soft actuation and liquid metal sensing represents a significant leap toward systems that are "safe by design," potentially lowering the liability barrier discussed by Casado (Casado, 2024).

## 2.3.6 The Human Factor: Cognitive Load and Trust

The intersection of technology and organization is defined by the human element. The analysis of the literature reveals that "trust" is a quantifiable variable in the adoption equation.

### 2.3.6.1 Quantifying Trust in Automation
Saeidi et al. (Saeidi et al., 2018) uses a "confidence-based" strategy for the STAR robot. In this framework, the robot calculates a confidence score for its proposed action based on sensor data quality and tissue tracking stability. If the confidence drops below a threshold, it halts and requests human intervention. This algorithmic approach to trust mirrors the psychological requirements of the surgeon.

However, McKendrick (McKendrick, 2018) warns of the "complacency-stress" cycle. If the robot is highly reliable (high confidence), the surgeon may become complacent and disengage (low cognitive load). If the robot then fails unexpectedly, the sudden spike in cognitive load required to take over can lead to performance errors. This phenomenon, known as "automation surprise," is a well-documented barrier in aviation and is now appearing in surgical robotics literature. The results from Guo et al. (Guo et al., 2025) on shared autonomy suggest that continuous, low-level engagement (e.g., haptic guidance rather than full autopilot) may be superior to switching modes, as it keeps the human operator in the loop mentally.

### 2.3.6.2 Educational Implications
The findings on cognitive load have direct implications for the training gaps identified by Tian et al. (Tian et al., 2025). Training curricula cannot simply focus on "how to move the robot"; they must focus on "how to supervise the robot." This requires a shift from psychomotor skill training to cognitive resource management (CRM) training, similar to pilot training. The lack of such curricula is a critical organizational gap. Bouvette et al. (Bouvette et al., 2025) note that while simulation is growing, few simulators currently model "automation failure" scenarios to train surgeons on how to safely regain control.

## 2.3.7 Conclusion of Analysis

The analysis of the literature regarding the adoption of AI-enabled semi-autonomous robotic surgery reveals a environment defined by high potential but significant friction.

**Technological Readiness:** The hardware (soft robotics, sensors) and software (AI planning, tissue tracking) are reaching a level of maturity where specific tasks can be automated with high precision (Schüßler et al., 2025)(Saeidi et al., 2019). The evidence for clinical efficacy is strong (Delhoum et al., 2025).

**Organizational Resistance:** The integration of these systems disrupts established workflows and imposes severe financial and educational burdens (Hirri et al., 2024)(Curet, 2019). The economic ROI remains a contentious point, with high costs currently outweighing proven financial benefits for many procedures.

**Environmental Lag:** The legal and regulatory environments have not kept pace with the technology. Unresolved liability issues (Casado, 2024) and ethical concerns regarding equity (Boakye-Afram et al., 2025) create a hesitancy to fully embrace autonomy.

In summary, the "key drivers" are primarily clinical (precision, error reduction) and technological (5G, AI capabilities). The "key barriers" are systemic (cost, liability, training, equity). The adoption trajectory will likely follow a curve defined by how quickly these systemic barriers can be dismantled, rather than how quickly the technology itself advances. The transition from "tool" to "partner" in the operating room is underway, but it is currently hindered by an system that was designed for human, not hybrid, surgical teams.

## 2.4 Discussion

The synthesis of literature presented in section 2.3 reveals a complex environment where the technological maturity of AI-enabled robotic surgery significantly outpaces the organizational, legal, and educational readiness of healthcare systems. This divergence creates what can be characterized as an "implementation gap," where the theoretical benefits of semi-autonomous systems--precision, consistency, and reduced fatigue--are frequently bottlenecked by systemic friction. While section 2.1 introduced the theoretical underpinnings of surgical autonomy, the findings analyzed in section 2.3 demonstrate that the primary challenges are no longer strictly engineering problems but rather sociotechnical dilemmas. This section interprets these findings through the lens of the theoretical frameworks established in section 2.1, evaluates the implications for clinical practice and policy, and identifies critical avenues for future research.

### 2.4.1 Interpretation of Technological Drivers and Clinical Efficacy

The analysis of recent literature confirms that the technological drivers of robotic adoption are strong and rapidly evolving. As discussed in section 2.1, the evolution of control architectures has moved from direct telemanipulation to supervisory control. The findings from section 2.3 validate this trajectory, particularly in the domain of soft tissue manipulation and remote operations.

#### 2.4.1.1 The Realization of Supervisory Control
The concept of "bounding overwatch," originally described by Szczerba and Collier (Szczerba & Collier, 1998) in the context of ground vehicles and discussed in section 2.1, finds a direct parallel in modern surgical robotics. The literature indicates that we are witnessing the operationalization of this theory in the operating room. Recent developments in semi-autonomous gallbladder retraction (Schüßler et al., 2025) and autonomous tissue tracking (Saeidi et al., 2019) demonstrate that robotic systems can now effectively function as the "bounding" agent, executing sub-tasks while the surgeon maintains "overwatch." This shift is not merely incremental; it represents a fundamental change in the surgical contract. The surgeon is no longer the sole actuator but rather the architect of the procedure, delegating specific execution components to the AI agent.

Evidence suggests that this delegation improves clinical outcomes in specific contexts. For instance, systematic reviews of robotic-assisted outcomes in endometrial cancer (Delhoum et al., 2025) and bariatric surgery (Hirri et al., 2024) indicate that when technical proficiency is achieved, robotic assistance correlates with reduced complications and shorter hospital stays. However, this efficacy is highly dependent on the "shared control" strategies employed. Research on the Smart Tissue Autonomous Robot (STAR) (Saeidi et al., 2018) highlights that confidence-based shared control--where the robot assesses its own certainty and requests human intervention when confidence drops--is essential for safety. This aligns with the theoretical requirement for strong human-machine teaming protocols identified in the literature review.

#### 2.4.1.2 The Role of Enabling Technologies (5G and Soft Robotics)
The integration of 5G technology has emerged as a critical driver for overcoming the geographical limitations of surgical expertise. As noted in section 2.3, the architecture of remote robotic surgery relies heavily on ultra-low latency networks to maintain the fidelity of haptic feedback and visual data (Hentati et al., 2022)(bai et al., 2026). The literature suggests that 5G is not just a bandwidth upgrade but a prerequisite for safe telesurgery. By enabling real-time transmission of high-definition surgical video and control signals, 5G reduces the risk of "packet loss" that could lead to catastrophic surgical errors.

Furthermore, advancements in soft robotics and liquid metal functionalization (Marchese et al., 2015)(Chen et al., 2023) address the hardware limitations of rigid robotic tools. Traditional rigid instruments often lack the dexterity and tactile sensitivity required for delicate tissue manipulation. The development of soft fluidic elastomer robots allows for safer interaction with biological tissues, reducing the risk of iatrogenic injury. This technological convergence--high-speed connectivity combined with biocompatible actuation--creates a powerful driver for adoption, pushing the boundaries of what is surgically possible.

### 2.4.2 Systemic Barriers and Organizational Resistance

Despite the technological promise, the findings in section 2.3 highlight substantial barriers that mirror and amplify the "implementation gap" identified in the research gap analysis. These barriers are primarily organizational and economic, challenging the viability of widespread adoption.

#### 2.4.2.1 The Economic Paradox of Value-Based Care
A recurring theme in the analyzed literature is the tension between the high cost of robotic systems and the imperatives of value-based care. While clinical outcomes may be improved, the economic return on investment (ROI) remains contentious. Studies on orthopedic surgery (Vaishya et al., 2025) and pancreatic surgery (McMillan et al., 2017) suggest that the marginal clinical benefits of robotic assistance often do not justify the substantial increase in procedural costs. This creates a paradox: the technology exists to improve care, but the economic structure of healthcare systems may not support its routine use.

The "learning curve" costs are also significant. As Hirri et al. (Hirri et al., 2024) note, the adoption of robotic systems involves a prolonged period of inefficiency as surgical teams adapt to new workflows. During this phase, operative times increase, and throughput decreases, further eroding the economic value proposition. This aligns with Curet's (Curet, 2019) observation that adoption issues are often rooted in the disruption of established institutional workflows rather than inherent flaws in the technology itself.

#### 2.4.2.2 The Training Lacuna and Cognitive Load
One of the most critical findings discussed in section 2.3 is the inadequacy of current training paradigms. The transition to semi-autonomous systems necessitates a shift from purely psychomotor training to cognitive resource management (CRM). The literature on cognitive load during autonomous transportation (McKendrick, 2018) and shared autonomy in wheelchairs (Guo et al., 2025) offers valuable insights for surgery. As automation increases, the operator's role shifts from active control to monitoring, which can paradoxically increase mental workload due to the need for sustained vigilance.

Current residency programs are ill-equipped to address this shift. Bouvette et al. (Bouvette et al., 2025) and Tian et al. (Tian et al., 2025) highlight the lack of standardized curricula that specifically target robotic competencies. Most training still focuses on the mechanics of the robot rather than the management of the human-AI team. This gap is dangerous; without training in "automation failure" scenarios, surgeons may succumb to automation bias, over-trusting the system and failing to intervene when the AI errs. This represents a significant deviation from the aviation industry, where pilot training heavily emphasizes the management of automated systems.

#### 2.4.2.3 Legal and Ethical Quagmires
The legal environment remains a significant barrier to the autonomy of surgical robots. As explored in section 2.1, the attribution of liability in human-robot teams is legally ambiguous. Casado (Casado, 2024) argues that traditional negligence frameworks are ill-suited for systems where the locus of control is fluid. If a semi-autonomous robot makes an error during a tissue tracking maneuver (Saeidi et al., 2019), determining whether the fault lies with the surgeon (for failing to intervene), the manufacturer (for algorithm design), or the hospital (for maintenance) is legally complex. This uncertainty creates a "chilling effect" on adoption, as hospitals are hesitant to deploy systems that carry undefined liability risks.

Furthermore, cybersecurity concerns pose a novel barrier. The interconnectivity required for AI-enabled devices and telesurgery introduces vulnerabilities to cyberattacks. Mitra et al. (Mitra et al., 2025) emphasize that data-driven security analysis is critical, yet often overlooked in the rush to deploy new features. The potential for a surgical robot to be compromised during a procedure is a high-impact risk that regulatory bodies are only beginning to address.

### 2.4.3 Comparison with Theoretical Frameworks (Section 2.1)

The findings from the literature align with, but also complicate, the theoretical frameworks introduced in section 2.1.

*Table 1: Comparison of Theoretical Expectations vs. Literature Findings*

| Theoretical Concept (Section 2.1) | Literature Findings (Section 2.3) | Alignment Status | Implications |
|:--- |:--- |:--- |:--- |
| **Bounding Overwatch** (Szczerba & Collier, 1998) | Validated in gallbladder retraction (Schüßler et al., 2025) and tissue tracking (Saeidi et al., 2019). | **High** | Current systems effectively execute "bounding" moves under surgeon supervision. |
| **Shared Control** (Saeidi et al., 2018) | Validated as essential for safety; "confidence-based" strategies are preferred. | **High** | Pure autonomy is rejected in favor of collaborative control loops. |
| **Cognitive Load Theory** (McKendrick, 2018) | Validated; monitoring automation induces high cognitive load. | **High** | Training must shift from motor skills to attention management. |
| **Democratization of Surgery** | Contradicted by data on racial/SES disparities (Moore et al., 2026)(Boakye-Afram et al., 2025). | **Low** | Technology is currently exacerbating, not solving, equity gaps. |
| **Economic Efficiency** | Contradicted by high costs and learning curves (Hirri et al., 2024)(Vaishya et al., 2025). | **Low** | ROI is not realized in the short term; efficiency gains are theoretical. |

*Source: Adapted from synthesis of (Szczerba & Collier, 1998), (Saeidi et al., 2018), (McKendrick, 2018), (Moore et al., 2026), and (Vaishya et al., 2025).*

As illustrated in Table 1, the technical theories of control (Bounding Overwatch, Shared Control) are well-supported by the emerging literature. The engineering reality matches the theoretical prediction: robots are becoming capable teammates. However, the socioeconomic theories--specifically the idea that technology will democratize access--are currently failing. Instead of leveling the playing field, the high cost and infrastructure requirements of robotic surgery are concentrating advanced care in wealthy, urban academic centers. This observation confirms the "Inverse Care Law" in the context of digital surgery, where the availability of good medical care tends to vary inversely with the need for it in the population served.

### 2.4.4 Addressing the Research Gaps

The literature analysis addresses several of the research gaps identified in section 2.1, while highlighting new ones.

**Gap 1: The "Black Box" of Autonomy**
The literature has begun to open the "black box" of AI decision-making in surgery. Research into explainable AI and confidence-based control (Saeidi et al., 2018) addresses the need for transparency. By designing systems that communicate their uncertainty, engineers are creating a feedback loop that keeps the human in the loop, addressing the safety concerns associated with opaque algorithms.

**Gap 2: The Training Deficit**
The review confirms a massive gap in training. While simulation technologies exist (Bouvette et al., 2025), they are not yet fully integrated into residency curricula (Tian et al., 2025). The literature suggests that the solution lies not just in more simulators, but in *better* simulation scenarios that model rare events and system failures. This addresses the gap by identifying the specific *type* of training needed (cognitive/managerial) rather than just the volume.

**Gap 3: Equity and Access**
The literature provides a stark answer to the question of equity: current adoption patterns are inequitable. Studies by Moore et al. (Moore et al., 2026) and Boakye-Afram et al. (Boakye-Afram et al., 2025) provide empirical evidence that race, socioeconomic status, and geography are strong predictors of access to robotic surgery. This addresses the gap by quantifying the disparity, moving the discussion from theoretical concerns to demonstrated public health issues.

### 2.4.5 Theoretical Implications

The synthesis of these findings suggests a need to revise our theoretical understanding of surgical innovation.

**The Theory of "Augmented Agency"**
The literature supports moving beyond the dichotomy of "manual" vs. "autonomous." Instead, a theory of "Augmented Agency" is more appropriate. In this model, the surgeon's agency is not replaced but extended. The robot becomes a cognitive and physical prosthesis. This aligns with the findings on soft robotics (Chen et al., 2023) and perception recovery (Zheng et al., 2022), where the technology restores or enhances senses (haptics, vision) that are diminished in minimally invasive approaches.

**The "Automation Paradox" in Medicine**
The findings also reinforce the "Automation Paradox" within healthcare. As systems become more reliable (Kerr et al., 2017), human operators become less practiced in manual reversion. The literature on learning curves (Hirri et al., 2024) suggests that as residents train primarily on robotic systems, their open surgical skills may atrophy. This has profound theoretical implications for medical education: if the robot fails, does the surgeon still possess the manual competence to save the patient? The literature suggests this is a looming crisis that requires immediate theoretical and pedagogical attention.

### 2.4.6 Practical Implications

The practical implications of this review are far-reaching for various stakeholders in the healthcare system.

**For Hospitals and Administrators:**
The decision to adopt AI-enabled robotics must be strategic, not merely competitive. The literature indicates that purchasing the robot is only the first step. Administrators must budget for the "hidden" costs identified in section 2.3: extended operating room times during the learning curve (Hirri et al., 2024), specialized IT infrastructure for security (Mitra et al., 2025), and ongoing maintenance. Furthermore, the equity data (Moore et al., 2026) suggests that public hospitals must proactively seek funding models that prevent robotic surgery from becoming a "boutique" service for the wealthy.

**For Educators and Residency Directors:**
There is an urgent need to overhaul surgical curricula. The findings from Bouvette et al. (Bouvette et al., 2025) and Tian et al. (Tian et al., 2025) call for the integration of AI literacy into medical education. Surgeons must understand not just anatomy, but algorithm behavior. Simulation training must become mandatory and standardized, focusing on "hand-off" protocols where control is transferred between human and machine.

**For Policymakers and Regulators:**
The regulatory environment must catch up to the technology. The ambiguity regarding liability (Casado, 2024) is a barrier to innovation. Policymakers need to establish "safe harbor" provisions or no-fault compensation schemes for autonomous medical errors to encourage the deployment of life-saving technologies while protecting patients. Additionally, data standards for 5G telesurgery (bai et al., 2026) must be harmonized to allow for cross-border collaboration without legal jeopardy.

**For Industry and Developers:**
Manufacturers must prioritize the development of "fail-safe" mechanisms and explainable interfaces. The feedback from the literature regarding cognitive load (McKendrick, 2018) implies that user interfaces should be designed to reduce information clutter. Systems should present only critical data during high-stress phases of surgery to prevent cognitive overload. Furthermore, the development of cost-effective, modular systems could help address the equity gap identified in the literature.

### 2.4.7 Limitations of the Reviewed Literature

While the reviewed literature provides a comprehensive overview, several limitations must be acknowledged.

**Heterogeneity of Studies:**
As noted in section 2.3, the studies included in this review range from small pilot studies of engineering prototypes (Schüßler et al., 2025) to large-scale retrospective analyses of clinical data (Moore et al., 2026). This heterogeneity makes direct comparison difficult. For example, comparing the "success" of a robotic gallbladder retraction in a lab setting to the "outcomes" of oncological surgery in a hospital setting requires careful nuance.

**Lack of Long-Term Follow-Up:**
Many of the studies on AI integration are relatively new. The long-term impact of semi-autonomous surgery on patient survival and quality of life is not yet fully established. While short-term metrics like blood loss and hospital stay are frequently reported (Delhoum et al., 2025), data on 5-year or 10-year survival rates for procedures performed with AI assistance is scarce.

**Publication Bias:**
There is a potential for publication bias, where successful implementations of robotic systems are more likely to be published than failures. The "learning curve" challenges (Hirri et al., 2024) may be underreported if institutions are reluctant to publicize initial dips in performance.

**Rapid Technological Obsolescence:**
The field is moving so fast that literature can quickly become outdated. A study on "robotic capabilities" from 2018 may not reflect the reality of 2024 systems. For instance, the capabilities of generative AI (The Lancet Digital Health, 2025) are only just beginning to be understood and were not present in older datasets.

### 2.4.8 Future Research Directions

Based on the synthesis of findings and the identified gaps, the following directions are proposed for future research.

**1. Longitudinal Outcomes Research:**
Future studies must move beyond perioperative metrics to assess long-term clinical and functional outcomes. Does the precision of AI-assisted tissue tracking (Saeidi et al., 2019) translate to lower cancer recurrence rates five years later? This data is essential for calculating the true value of the technology.

**2. Cognitive Ergonomics and Human Factors:**
Research should focus on the "mind" of the surgeon as much as the "hand" of the robot. Studies utilizing EEG and eye-tracking during robotic surgery could quantify cognitive load (Guo et al., 2025) and help design better user interfaces. We need to understand the cognitive toll of supervising an autonomous agent.

**3. Health Equity Impact Assessments:**
There is a critical need for intervention research to address disparities. How can robotic programs be implemented in under-resourced settings? Research into tele-mentoring and remote surgery via 5G (bai et al., 2026) as a tool for equity--rather than just a technical novelty--is vital.

**4. Legal and Ethical Frameworks:**
Interdisciplinary research involving legal scholars, ethicists, and surgeons is needed to draft model legislation for autonomous medical liability. This research should propose concrete frameworks for liability attribution (Casado, 2024) that can be adopted by legislatures.

**5. Cybersecurity Protocols:**
As robotic systems become more networked, research into specific cybersecurity defenses for medical robotics (Mitra et al., 2025) is urgent. This includes developing intrusion detection systems that can distinguish between a malicious attack and a system malfunction during a live procedure.

### 2.4.9 Conclusion of Discussion

The discussion of the literature reveals that the adoption of AI-enabled semi-autonomous robotic surgery is at a critical juncture. The technology has matured to the point where it can reliably augment human capabilities, validating the theoretical models of shared control and supervisory operation. However, the systemic environment into which this technology is being introduced is unprepared.

The "key drivers" are the undeniable clinical benefits of precision and the enabling power of new technologies like 5G and soft robotics. The "key barriers" are the rigid organizational structures, economic constraints, inadequate training paradigms, and unresolved legal questions. The transition from "tool" to "partner" is technically feasible but organizationally fraught.

Addressing the "implementation gap" requires a concerted effort to align the technology with the human and systemic realities of healthcare. It requires a shift in focus from "can we build it?" to "how do we integrate it safely and equitably?" Without addressing the training deficits, liability vacuums, and economic disparities, the promise of AI in surgery will remain unevenly distributed, benefiting the few while leaving the systemic inefficiencies of the broader healthcare system untouched. The future of robotic surgery depends not just on smarter robots, but on smarter systems, laws, and educational models to support them.

The integration of artificial intelligence into the operating theater forces a re-evaluation of the surgical profession itself. As we move forward, the definition of a "good surgeon" may evolve from one with steady hands to one with a steady mind capable of managing complex, semi-autonomous teams. This evolution presents both a challenge and an opportunity to redefine the standard of care for the 21st century.

## 2.5 Summary of Main Body

The comprehensive analysis across sections 2.1 through 2.4 has provided a multi-dimensional view of AI-enabled robotic surgery adoption.

**Literature Review (Section 2.1)** established the theoretical baseline, tracing the evolution from telemanipulation to semi-autonomy and highlighting the "bounding overwatch" concept (Szczerba & Collier, 1998) as a guiding framework. It identified the research gap: a lack of focus on systemic integration compared to technical feasibility.

**Methodology (Section 2.2)** detailed the narrative review approach, ensuring a broad capture of diverse sources ranging from engineering technical reports to sociological analyses of healthcare equity.

**Analysis and Results (Section 2.3)** synthesized the data, revealing a dichotomy between "Technological Readiness" (high) and "Organizational Resistance" (high). Key findings included the validation of 5G and soft robotics as enablers (bai et al., 2026)(Chen et al., 2023), and the identification of training (Bouvette et al., 2025) and liability (Casado, 2024) as primary bottlenecks.

**Discussion (Section 2.4)** interpreted these findings, confirming that the "implementation gap" is sociotechnical. It highlighted the alignment of current technology with theoretical models of shared control (Saeidi et al., 2018) but noted a divergence regarding equity (Moore et al., 2026). The discussion emphasized the need for a major change in training toward Cognitive Resource Management and called for legal reforms to clarify liability.

Collectively, the Main Body of this thesis argues that while the *technological* revolution in surgery is well underway, the *institutional* revolution required to sustain it has barely begun. The successful adoption of AI-enabled robotics will depend less on the next algorithm and more on the ability of healthcare systems to adapt their economic, legal, and educational structures to this new reality. The evidence suggests that without these systemic changes, the full potential of autonomous surgery to improve patient outcomes will remain unrealized.

*Table 2: Summary of Key Insights by Domain*

| Domain | Key Insight | Supporting Citations |
|:--- |:--- |:--- |
| **Technology** | 5G and Soft Robotics are critical enablers for safe autonomy. | (bai et al., 2026)(Marchese et al., 2015)(Chen et al., 2023) |
| **Clinical** | Outcomes improve with proficiency, but learning curves are steep. | (Delhoum et al., 2025)(Hirri et al., 2024)(McMillan et al., 2017) |
| **Training** | Current curricula lack focus on cognitive management of AI. | (Bouvette et al., 2025)(Tian et al., 2025)(McKendrick, 2018) |
| **Legal** | Liability attribution remains undefined and risky. | (Casado, 2024)(Mitra et al., 2025) |
| **Equity** | Adoption correlates with wealth/race, exacerbating disparities. | (Boakye-Afram et al., 2025)(Moore et al., 2026) |

*Source: Synthesized from analysis of listed citations.*

This concludes the Main Body of the thesis. The following chapters will present the formal Conclusion and Recommendations based on these insights.

\newpage

# 3. Conclusion
The integration of artificial intelligence (AI) into robotic surgery marks a important transformation in modern healthcare, signaling a departure from purely teleoperated systems toward semi-autonomous and fully autonomous surgical agents. This research has systematically evaluated the drivers and barriers shaping this adoption, revealing a complex system where technological capability often outpaces regulatory and clinical readiness. The transition from "master-slave" architectures to human-on-the-loop systems presents a profound major change, redefining the surgeon's role from manual operator to strategic supervisor. As evidenced by the literature synthesized in this study, the successful adoption of AI-enabled robotic surgery (AIRS) is not merely a technical challenge but a sociotechnical endeavor requiring the alignment of clinical efficacy, legal frameworks, economic viability, and ethical standards.

## 3.1 Synthesis of Key Findings

The adoption of AIRS is driven by a compelling set of clinical and operational advantages, yet it is simultaneously restrained by significant systemic hurdles. This duality defines the current state of the field, creating an "implementation gap" between experimental success and routine clinical practice.

### 3.1.1 Drivers of Adoption
The primary driver for AI integration remains the pursuit of surgical precision and improved patient outcomes. Empirical evidence suggests that robotic assistance significantly enhances capabilities in complex procedures. For instance, recent meta-analyses in endometrial cancer management demonstrate that robotic-assisted approaches can offer superior oncological outcomes compared to conventional laparoscopy (Delhoum et al., 2025). Similarly, in orthopedics, the promise of improved accuracy in implant positioning drives the market, although debates regarding cost-effectiveness persist (Vaishya et al., 2025).

Beyond precision, the potential for workload reduction and efficiency is a critical driver. The automation of routine sub-tasks, such as gallbladder retraction or suturing, allows surgeons to focus on critical decision-making phases of the operation. Research into semi-autonomous systems indicates that these technologies can effectively decrease the cognitive and physical load on medical professionals, addressing the growing shortage of surgical staff (Schüßler et al., 2025). Furthermore, the integration of preoperative planning algorithms using AI has shown the potential to reduce intraoperative time and errors by providing patient-specific surgical strategies before the incision is even made (Lambrechts et al., 2022).

### 3.1.2 Barriers to Implementation
Despite these advantages, the barriers to widespread adoption are formidable. Foremost among these is the issue of legal liability and accountability. As systems move toward higher levels of autonomy, the attribution of fault in the event of a surgical error becomes increasingly opaque. Current legal frameworks are ill-equipped to distinguish between operator error, algorithmic bias, and mechanical failure in semi-autonomous contexts (Casado, 2024). This "liability gap" creates hesitancy among hospitals and insurers, slowing the procurement of advanced autonomous systems.

Technological and security constraints also constitute major barriers. The reliance on connectivity for remote telesurgery and data exchange introduces vulnerability to cyberattacks. Systems-theoretic analyses have highlighted that ML-enabled medical devices are susceptible to adversarial attacks and data breaches, posing direct risks to patient safety (Mitra et al., 2025). Additionally, technical limitations such as latency in remote operations remain a bottleneck, although the deployment of 5G infrastructure is beginning to mitigate these issues by enabling ultra-low latency communication required for haptic feedback and real-time control (Hentati et al., 2022)(bai et al., 2026).

Economic disparities further complicate adoption. The high capital cost of robotic platforms and the associated training requirements limit access to well-funded academic centers, exacerbating global disparities in surgical care (Boakye-Afram et al., 2025). Studies indicate that race, socioeconomic status, and geography continue to influence the utilization of advanced surgical interventions, suggesting that without targeted policy interventions, AI-enabled surgery could widen the healthcare equity gap (Moore et al., 2026).

## 3.2 Implications for Clinical Practice and Training

The shift toward semi-autonomous systems necessitates a fundamental restructuring of surgical education and clinical workflow. The traditional apprenticeship model, based on the gradual acquisition of manual skills, is becoming insufficient for the era of intelligent robotics.

### 3.2.1 The Evolution of the Surgeon's Role
As AI assumes control over specific sub-tasks, the surgeon's role evolves into that of a "manager" of multi-agent systems. This transition parallels concepts from other high-stakes industries, such as aviation or military operations, where the operator monitors autonomous agents rather than directly controlling every movement (Szczerba & Collier, 1998)(McKendrick, 2018). Consequently, the cognitive load profile of surgery is changing; while physical fatigue may decrease, the demand for sustained vigilance and systems management increases (Guo et al., 2025). Surgeons must now develop "AI literacy"--the ability to understand the logic, limitations, and failure modes of the algorithms assisting them.

### 3.2.2 Training Curricula and Learning Curves
The literature highlights a critical gap in standardized training curricula for robotic surgery. Current residency programs often lack uniform standards for robotic simulation and credentialing (Bouvette et al., 2025)(Tian et al., 2025). Learning curves for robotic procedures can be steep, impacting safety and efficiency during the initial adoption phase (Hirri et al., 2024). To address this, future training must integrate AI-assisted simulation and performance analytics, allowing trainees to practice in risk-free virtual environments where AI provides real-time feedback on technique and decision-making (Zhu, 2025).

## 3.3 Strategic Recommendations

To navigate the complex environment of AIRS adoption, stakeholders must adopt a multi-pronged strategy. Table 3.1 outlines key recommendations for developers, healthcare institutions, and policymakers to accelerate adoption while mitigating risks.

| Stakeholder | Strategic Focus | Key Recommendations | Impact Area |
|-------------|-----------------|---------------------|-------------|
| **Developers** | Trust & Security | Implement "Security-by-Design" (Mitra et al., 2025); Develop explainable AI (XAI) for transparency. | Safety/Liability |
| **Hospitals** | Infrastructure | Invest in 5G/Edge computing (bai et al., 2026); Establish interdisciplinary robotic committees. | Efficiency/Integration |
| **Regulators** | Liability Frameworks | Define autonomy levels (L0-L5) (Kumar et al., 2024); Clarify liability attribution models (Casado, 2024). | Legal/Compliance |
| **Educators** | Curriculum Design | Integrate VR simulation & AI literacy (Bouvette et al., 2025); Standardize credentialing metrics (Tian et al., 2025). | Workforce Readiness |
| **Policymakers** | Equity & Access | Subsidize rural access programs; Monitor disparity metrics in utilization (Moore et al., 2026). | Socioeconomic Equity |

*Table 3.1: Strategic recommendations for the adoption of AI-enabled robotic surgery.*

For developers, the priority must be building trust through transparency. The "black box" nature of deep learning models is a significant barrier to clinical trust. Developing explainable AI (XAI) that can provide clinicians with the rationale behind a recommendation is essential for adoption. Furthermore, addressing the cybersecurity vulnerabilities inherent in connected medical devices is non-negotiable (Mitra et al., 2025).

For regulators and policymakers, the urgent task is to update liability frameworks to accommodate the continuum of autonomy. The binary distinction between human and machine is no longer sufficient. Frameworks that apportion liability based on the specific level of autonomy active at the time of an adverse event--similar to those proposed for autonomous vehicles--are required (Casado, 2024). Additionally, policymakers must actively address the socioeconomic implications of these technologies to ensure that the benefits of AI-enhanced surgery are accessible beyond elite medical centers (Boakye-Afram et al., 2025).

## 3.4 Technological Roadmap and Future Directions

Looking forward, the convergence of generative AI, soft robotics, and advanced perception systems points toward a future of "Context-Aware Operating Theaters" (Stoyanov et al., 2018).

### 3.4.1 From Hard to Soft Robotics
Current rigid robotic systems, while precise, lack the adaptability of biological tissues. The emerging field of soft robotics, utilizing fluidic elastomers and liquid metal functionalization, promises safer interaction with delicate human tissues (Marchese et al., 2015)(Chen et al., 2023). These systems, when paired with AI control, could navigate anatomical structures with a level of compliance and safety that rigid robots cannot match, potentially expanding the scope of robotic surgery to more fragile or difficult-to-reach anatomical regions.

### 3.4.2 Generative AI and Cognitive Assistance
The rapid rollout of generative AI in healthcare suggests that future surgical robots will possess not just motor autonomy but cognitive autonomy (The Lancet Digital Health, 2025). These systems could analyze real-time video feeds to identify anatomical landmarks, predict complications before they occur, and suggest alternative surgical strategies during the procedure (Nazarian et al., 2023). This moves the field toward "Surgery 4.0," where the digital and physical realms are fully integrated through cyber-physical systems (Shaikh et al., 2025).

### 3.4.3 Investment and Innovation
The pace of innovation will continue to be influenced by venture capital trends. Investment in robotics and autonomous systems startups has surged, driving competition and rapid prototyping of new solutions (Buonomo, 2023)(Shetty & Jaiswal, 2024). However, this commercial pressure must be balanced with rigorous clinical validation to ensure that new technologies offer genuine value rather than just novelty.

## 3.5 Limitations of the Study

It is important to acknowledge the limitations of this review. First, the field of AI in surgery is evolving so rapidly that literature can become outdated quickly; this review focused on sources primarily from the last decade, but new algorithms emerge monthly. Second, much of the data on "autonomous" surgery currently comes from ex vivo or animal models (Saeidi et al., 2019), with limited large-scale human trials for higher levels of autonomy. Finally, the review is constrained by the heterogeneity of the literature, which varies widely in study design, making direct quantitative comparisons of clinical outcomes difficult across different surgical specialties.

## 3.6 Final Remarks

In conclusion, the adoption of AI-enabled semi-autonomous robotic surgery is an inevitable progression in the digitization of healthcare. It promises to democratize high-quality surgical care by standardizing outcomes and augmenting human capability. However, realizing this potential requires moving beyond a technocentric view to address the systemic barriers of liability, equity, and training.

The future of surgery will not be defined by machines replacing surgeons, but by the synergy between human judgment and machine precision. As Kumar et al. (Kumar et al., 2024) articulate, the goal is a collaborative intelligence where the strengths of AI--data processing, repeatability, and precision--complement the human strengths of adaptability, ethics, and empathy. Achieving this balance will require sustained collaboration between engineers, clinicians, ethicists, and policymakers. Only through such a comprehensive approach can the healthcare sector bridge the implementation gap and fully harness the transformative power of intelligent surgical robotics.

\newpage

# 4. Appendices
## 4.1 Appendix A: Conceptual Framework for Surgical Autonomy

This appendix details the theoretical models governing the transition from tele-operated robotic surgery to AI-enabled semi-autonomous systems. It synthesizes the operational frameworks discussed in the main body, providing a structured classification of autonomy levels and the associated human-machine interaction paradigms.

### 4.1.1 The Continuum of Autonomy in Medical Robotics

The classification of robotic autonomy in surgery is not binary but exists on a continuum. Drawing from standards established in autonomous vehicle navigation and adapted for medical contexts, the following framework outlines the progression from direct manual control to full automation. This hierarchy is critical for regulatory approval and liability assessment (Kumar et al., 2024).

| Level | Designation | Human Role | System Role |
|-------|-------------|------------|-------------|
| 0 | No Autonomy | Continuous direct control | Passive tool; no assistance |
| 1 | Robot Assistance | Continuous control | Mechanical guidance (e.g., tremor filter) |
| 2 | Task Autonomy | Discrete control/supervision | Executes specific sub-tasks |
| 3 | Conditional Autonomy | Fallback/Intervention | Generates & executes plans; human approves |
| 4 | High Autonomy | Supervisor (Emergency only) | Full execution in defined domain |
| 5 | Full Autonomy | None (Observer) | Full execution in all domains |

*Table A1: Levels of Autonomy in Robotic Surgery. Adapted from operational frameworks proposed by Kumar et al. (Kumar et al., 2024) and Yang et al. (2017).*

**Level 0 to Level 1: The Tele-manipulation Era**
Current clinical standards predominantly operate at Level 0 and Level 1. In these stages, the surgeon remains the sole decision-maker and executor. The robotic system functions as an extension of the surgeon's hands, providing mechanical advantages such as motion scaling and tremor filtration. The "Master-Slave" architecture defines this relationship, where the robot mimics the operator's movements in real-time without independent agency. This level effectively addresses the ergonomic limitations of traditional laparoscopy but does not reduce the cognitive load on the surgeon (Zhu, 2025).

**Level 2 to Level 3: The Shift to Semi-Autonomy**
The current technological frontier lies between Level 2 and Level 3. Here, the system begins to exhibit "shared control." For instance, in "bounding overwatch" operations--a concept adapted from semi-robotic ground vehicle coordination--the system may autonomously hold tissue (retraction) while the surgeon performs dissection, or vice versa (Szczerba & Collier, 1998)(Schüßler et al., 2025). In Level 3 (Conditional Autonomy), the system might propose a cutting path based on preoperative imaging and real-time computer vision, which the surgeon must approve before execution. This shift introduces the "human-on-the-loop" paradigm, where the operator moves from continuous manipulation to supervisory control (Saeidi et al., 2018).

**Level 4 to Level 5: Future Trajectories**
High and Full Autonomy represent theoretical end-states where the system perceives the surgical environment, plans the procedure, and executes tasks with minimal to no human intervention. While specific tasks like suturing or knot-tying have been demonstrated autonomously in experimental settings (Saeidi et al., 2019), full procedural autonomy remains constrained by the unstructured and unpredictable nature of biological tissue. The legal and ethical implications at this level are profound, particularly regarding liability attribution when algorithmic errors occur (Casado, 2024).

### 4.1.2 Shared Control Architectures

The implementation of semi-autonomy relies on strong shared control strategies. Unlike industrial automation where environments are static, surgical environments are dynamic. The "Confidence-Based Shared Control" strategy is a important development in this domain.

| Component | Function | Technical Requirement |
|-----------|----------|-----------------------|
| Perception Layer | Identify tissue/organs | Computer Vision, ML |
| Decision Layer | Assess confidence in plan | Bayesian Networks |
| Control Allocation | Assign authority (Human/Bot) | Haptic Feedback Loops |
| Safety Layer | Prevent unsafe actions | Virtual Fixtures/Active Constraints |

*Table A2: Components of a Confidence-Based Shared Control Architecture (Saeidi et al., 2018).*

**Confidence-Based Allocation**
In a confidence-based framework, the system continuously evaluates its own certainty regarding the surgical scene. If the system's confidence in tissue identification or tool trajectory is high (e.g., >95%), it may assume more autonomy or provide stronger haptic guidance. Conversely, if confidence drops--due to smoke, blood, or anatomical anomalies--control authority is smoothly transferred back to the human operator. This dynamic allocation ensures safety while maximizing the benefits of automation (Saeidi et al., 2018).

**Cognitive Load Regulation**
A primary driver for shared control is the reduction of the surgeon's cognitive load. Complex procedures require sustained high-level attention, leading to fatigue and potential errors. By offloading routine or physically taxing sub-tasks (such as camera navigation or retraction) to the autonomous system, the surgeon can focus on critical decision-making steps. Research in neuroergonomics indicates that adaptive autonomous systems can monitor the operator's cognitive state and adjust the level of assistance accordingly to prevent overload (McKendrick, 2018)(Guo et al., 2025).

## 4.2 Appendix B: Supplementary Data and Comparative Analysis

This appendix provides detailed empirical data regarding clinical outcomes, economic indicators, and technological performance metrics that substantiate the drivers and barriers discussed in the main text.

### 4.2.1 Clinical Efficacy and Safety Outcomes

The adoption of robotic systems is predicated on the assumption of superior clinical outcomes compared to conventional techniques. The following data synthesis highlights findings from recent meta-analyses and systematic reviews.

| Procedure Type | Comparison | Key Finding | Statistical Significance | Source |
|----------------|------------|-------------|--------------------------|--------|
| Endometrial Cancer | Robot vs. Laparoscopy | Lower conversion rates | p < 0.05 | (Delhoum et al., 2025) |
| Bariatric Surgery | Robot vs. Laparoscopy | Similar weight loss | Not Significant | (Hirri et al., 2024) |
| Pancreatoduodenectomy | Robot vs. Open | Lower fistula rates | p = 0.03 | (McMillan et al., 2017) |
| Orthopedic Surgery | Robot vs. Manual | Improved alignment | High precision | (Vaishya et al., 2025)(Lambrechts et al., 2022) |

*Table B1: Comparative Clinical Outcomes of Robotic vs. Conventional Surgery.*

**Analysis of Oncological Outcomes**
In the management of endometrial cancer, a systematic review and meta-analysis revealed that robotic-assisted surgery (RAS) offers distinct advantages over conventional laparoscopy. Specifically, RAS demonstrated significantly lower rates of conversion to open surgery. This is a critical metric, as conversion is associated with higher morbidity and longer recovery times. However, in terms of oncological outcomes such as overall survival and disease-free survival, the two modalities were largely comparable, suggesting that the primary driver for adoption in this field is perioperative safety rather than long-term cancer control (Delhoum et al., 2025).

**The Learning Curve Barrier**
While outcomes are promising, the "learning curve" remains a significant barrier. In bariatric surgery, efficiency and safety stabilize only after a substantial number of cases. Hirri et al. (Hirri et al., 2024) note that the initial phase of adoption is often characterized by longer operative times and higher costs. Similarly, in orthopedic surgery, while robotic systems improve the precision of implant alignment, they introduce complexity that can initially extend surgical duration until the surgical team achieves proficiency (Vaishya et al., 2025). This steep learning curve necessitates standardized training curricula, which are currently lacking in many regions (Tian et al., 2025).

### 4.2.2 Economic and Investment Trends

The financial viability of AI-enabled robotic surgery is a complex equation involving high upfront capital costs, maintenance fees, and disposable instrument costs, balanced against potential savings from reduced length of stay and complications.

| Category | Trend Description | Impact on Adoption |
|----------|-------------------|--------------------|
| Venture Capital | Shift to AI/Software | Accelerates innovation |
| Hospital Costs | High acquisition costs | barrier for rural/small centers |
| Market Competition | New entrants vs. Monopoly | Potential price reduction |
| Reimbursement | Lack of specific codes | Slows ROI realization |

*Table B2: Economic Drivers and Barriers in the Surgical Robotics Market (Buonomo, 2023)(Shetty & Jaiswal, 2024).*

**Venture Capital Dynamics**
Investment trends indicate a strong market belief in the future of intelligent surgery. There is a noticeable shift in venture capital allocation towards startups focusing on software, AI analytics, and autonomous sub-systems, rather than just hardware platforms. This influx of capital is driving rapid innovation in generative AI applications and computer vision integration (Buonomo, 2023)(Shetty & Jaiswal, 2024). However, the high cost of these advanced systems exacerbates disparities in healthcare access. Studies show that race, socioeconomic status, and geography significantly influence the utilization of advanced surgical interventions, with underserved populations less likely to access robotic centers (Moore et al., 2026).

### 4.2.3 Technical Performance Metrics

The feasibility of semi-autonomous surgery, particularly remote telesurgery, depends heavily on network performance and system responsiveness.

| Metric | Requirement for Safety | Current 5G Capability | Gap Analysis |
|--------|------------------------|-----------------------|--------------|
| Latency | < 200 ms (ideal < 100 ms) | 1-10 ms (theoretical) | Sufficient |
| Jitter | < 30 ms | Variable | Challenge |
| Bandwidth | High (4K/3D Video) | High (eMBB) | Sufficient |
| Reliability | 99.999% | Network slicing needed | Improving |

*Table B3: Network Requirements for Remote AI-Enabled Robotic Surgery (Hentati et al., 2022)(bai et al., 2026).*

**The Latency Challenge in Telesurgery**
Remote robotic surgery, a key application of the Tactile Internet, requires ultra-low latency to ensure patient safety. While 5G technology promises latencies as low as 1ms, real-world implementation faces challenges related to signal stability and network slicing. Hentati et al. (Hentati et al., 2022) demonstrate that joint placement and scheduling of Virtual Network Functions (VNF) are essential to meet these stringent requirements. Furthermore, as systems become more autonomous, the reliance on real-time data transmission increases, making cybersecurity a critical concern. The integration of ML-enabled devices expands the attack surface, requiring rigorous systems-theoretic security analysis to prevent malicious interference (Mitra et al., 2025).

## 4.3 Appendix C: Glossary of Technical Terms

**Bounding Overwatch**
A coordination strategy originally developed for military ground vehicles where one agent moves while another monitors the environment to provide cover. In surgical robotics, this concept is applied to multi-arm coordination, where one robotic arm autonomously retracts tissue or stabilizes a camera while the surgeon manipulates the active instrument (Szczerba & Collier, 1998).

**Confidence-Based Control**
A shared control strategy where the distribution of authority between the human operator and the autonomous system is determined dynamically based on the system's calculated confidence in its perception and decision-making capabilities. If confidence falls below a safety threshold, control reverts to the human (Saeidi et al., 2018).

**Generative AI in Surgery**
The application of Large Language Models (LLMs) and generative algorithms to surgical practice. This includes preoperative planning, generating synthetic training data, and providing real-time intraoperative guidance. The rapid rollout of these technologies presents both opportunities for efficiency and risks regarding hallucination or inaccurate medical advice (The Lancet Digital Health, 2025).

**Haptic Feedback**
The transmission of tactile information (touch, force, vibration) from the robotic instruments to the surgeon's console. Lack of haptic feedback is a major limitation in current robotic systems, often compensated for by visual cues. Advanced soft sensors and liquid metal functionalization are being explored to restore this sensation in future systems (Chen et al., 2023).

**Human-on-the-loop**
A supervisory control paradigm where the human operator monitors the autonomous system's execution of a task and retains the ability to intervene or abort the action, but does not directly manipulate the controls for every movement. This contrasts with "Human-in-the-loop" (continuous control) and "Human-out-of-the-loop" (full autonomy) (Kumar et al., 2024).

**Latency**
The time delay between a command being issued by the surgeon and the execution of that command by the robot. In telesurgery, high latency can lead to "overshooting" and tissue damage. 5G technology aims to reduce this to imperceptible levels (Hentati et al., 2022)(bai et al., 2026).

**Propensity Score Matching**
A statistical technique used in observational studies to reduce selection bias by equating groups based on covariates. This method is frequently used in comparative studies of robotic vs. Open surgery (e.g., pancreatoduodenectomy) to account for the fact that robotic surgery is often selected for healthier or specific patient demographics (McMillan et al., 2017).

**Soft Robotics**
A subfield of robotics dealing with constructing robots from highly compliant materials, similar to those found in living organisms. In surgery, soft fluidic elastomer robots offer the potential for safer interaction with delicate biological tissues compared to rigid instruments (Marchese et al., 2015).

**Virtual Fixtures**
Software-generated constraints or "forbidden regions" that prevent the robotic instruments from entering unsafe areas (e.g., cutting a major blood vessel). These are a form of active constraint used in shared control architectures to enhance safety (Saeidi et al., 2018).

## 4.4 Appendix D: Implementation Barriers and Systemic Challenges

This appendix details the non-clinical barriers to the widespread adoption of AIRS, focusing on infrastructure, legal frameworks, and workforce training.

### 4.4.1 Infrastructure and Cybersecurity

The transition to AI-enabled surgery transforms the operating room into a data-intensive environment, often referred to as "OR 2.0" (Stoyanov et al., 2018). This digitization creates significant infrastructure demands.

| Component | Barrier | Description |
|-----------|---------|-------------|
| Connectivity | Bandwidth/Latency | Rural hospitals lack fiber/5G (bai et al., 2026) |
| Interoperability | Data Silos | Proprietary systems don't communicate |
| Cybersecurity | Vulnerability | ML models prone to adversarial attacks (Mitra et al., 2025) |
| Processing | Compute Power | Real-time AI requires edge computing |

*Table D1: Infrastructure Barriers to Implementation.*

**Cybersecurity Risks**
As medical devices become increasingly interconnected and dependent on ML algorithms, they become targets for cyber threats. Mitra et al. (Mitra et al., 2025) highlight that ML-enabled medical devices introduce opaque models that are difficult to secure using traditional methods. A "black box" AI that assists in surgery could be manipulated through data poisoning or adversarial examples, potentially leading to incorrect surgical actions. Ensuring the security of these systems is a prerequisite for their autonomous operation.

**The "Black Box" Problem**
The opacity of deep learning algorithms poses a significant barrier to trust and adoption. Surgeons and regulators need to understand *why* an AI system suggests a specific action. The lack of explainability in current AI models complicates clinical validation and liability assignment. If an autonomous system makes an error, determining whether it was a sensor failure, an algorithmic bias, or an unforeseen edge case is computationally difficult (Kerr et al., 2017).

### 4.4.2 Legal and Ethical Frameworks

The legal environment for autonomous surgery is currently underdeveloped, creating uncertainty for manufacturers and hospitals.

**Liability Attribution**
Current legal frameworks rely on the concept of medical malpractice, which assumes human agency. As control shifts to algorithms, the question of "who is to blame" becomes complex. Casado (Casado, 2024) argues for new criteria and attribution methods for robotic liability. If a semi-autonomous robot harms a patient, liability could theoretically fall on the surgeon (for failing to supervise), the manufacturer (for hardware failure), or the software developer (for algorithmic error). The lack of clear legal precedents stifles innovation, as companies may limit autonomy to avoid litigation risk.

**Ethical Considerations**
The deployment of AI in surgery also raises ethical questions regarding equity. There is a risk that AI-enabled high-precision surgery becomes a luxury good, available only at wealthy academic centers. Data indicates that global disparities in care are already significant in robotic cardiothoracic surgery (Boakye-Afram et al., 2025). Furthermore, the data used to train these AI models must be diverse to prevent algorithmic bias; otherwise, systems might perform sub-optimally on underrepresented demographic groups (Moore et al., 2026).

### 4.4.3 Workforce Training and Education

The introduction of AIRS requires a fundamental restructuring of surgical education.

**Curriculum Standardization**
There is currently a lack of unified and standardized curricula for robotic surgery training. Tian et al. (Tian et al., 2025) emphasize the need for multi-perspective qualitative studies to define training demands. The traditional "see one, do one, teach one" model is insufficient for complex robotic systems. Simulation-based training is essential, yet barriers to implementation in residency programs remain high, including cost and lack of qualified mentors (Bouvette et al., 2025).

**AI Literacy**
Future surgeons must possess not only manual dexterity but also "AI literacy." They must understand the capabilities and limitations of the autonomous systems they supervise. This includes interpreting confidence scores, recognizing mode confusion (where the user is unsure of the automation level), and managing the transfer of control. Without this training, the risk of "automation complacency"--where the surgeon over-relies on the system and fails to detect errors--increases significantly (McKendrick, 2018).

\newpage

## References

bai, Wang, Wang, & Duan. (2026). Application of 5G technology in remote robotic surgery: a comprehensive assessment of system architecture, clinical benefits, and future challenges. *Journal of Robotic Surgery*, *20*(1). Https://doi.org/10.1007/s11701-025-03126-2.

Boakye-Afram, Tandon, Sharma, Pottana, Okotcha, & Du Plessis. (2025). Robotic-Assisted Cardiothoracic Surgery: Advancements, Challenges, and Global Disparities in Care. *InciSioN Global Surgery Symposium*(1). Https://doi.org/10.52648/igss.1004_199.

Bouvette, Lee, & Bradley. (2025). Robotic simulation in urology training: implementation, curricula, and barriers across U.S. Residency programs. *Journal of Robotic Surgery*, *19*(1). Https://doi.org/10.1007/s11701-025-02591-z.

Brown. (2015). *Error Reduction in the Preanalytical Process*. Springer New York. Https://doi.org/10.1007/978-1-4939-2339-7_4

Buonomo. (2023). *Exploring the Synergy: Generative AI and Venture Capital in Driving Innovation and Growth*. United Research Forum. Https://doi.org/10.51219/urforum.2023.massimo-buonomo

Casado. (2024). *Robots and Liability: New Criteria and Attribution Methods*. Springer International Publishing. Https://doi.org/10.1007/978-3-031-47946-5_7

Chen, Fan, Chan, Qiao, Qi, Wu,... & Lim. (2023). Liquid Metal Functionalization Innovations in Wearables and Soft Robotics for Smart Healthcare Applications. *Advanced Functional Materials*. Https://doi.org/10.1002/adfm.202309989.

Curet. (2019). Issues in the Adoption of Robotic Surgery. *JAMA*, *322*(14), 1413. Https://doi.org/10.1001/jama.2019.12180.

Delhoum, Othman, Salah, Moien, Wasel, Hasanin,... & Attia. (2025). 53P A surgical dilemma in endometrial cancer management, robotic assisted vs. Conventional laparoscopy: A systematic review and meta-analysis of clinical and oncological outcomes. *ESMO Open*. Https://doi.org/10.1016/j.esmoop.2025.105182.

Fuentes, Chávez, López, Cardona, & Goti. (2024). The impact of artificial intelligence in general surgery: enhancing precision, efficiency, and outcomes. *International Journal of Research in Medical Sciences*. Https://doi.org/10.18203/2320-6012.ijrms20244129.

Guo, Hu, Huang, Wang, & Zhang. (2025). Shared autonomy for cognitive load regulation in autonomous wheelchairs. *Cognition, Technology & Work*. Https://doi.org/10.1007/s10111-025-00825-6.

Hentati, Ebrahimzadeh, Glitho, Belqasmi, & Mizouni. (2022). Remote Robotic Surgery: Joint Placement and Scheduling of VNF-FGs. *Conference on Network and Service Management*. Https://doi.org/10.23919/CNSM55787.2022.9964591.

Hirri, Pickering, Carter, van Boxel, & Pucher. (2024). Learning curves for adoption of robotic bariatric surgery: a systematic review of safety, efficiency and clinical outcomes. *Journal of Robotic Surgery*, *18*(1). Https://doi.org/10.1007/s11701-024-02100-8.

Kerr, Millar, & Corriveau. (2017). Robots and Artificial Intelligence in Health Care. Https://doi.org/10.2139/ssrn.3395890

Kumar, Madhu, Kumar, Khurana, Prabhakar, Joshi, & Kharayat. (2024). Development of Operational Framework and Standard Requirements for AI Assisted Robotic Surgery: Analysis Level of Autonomy. Https://doi.org/10.1109/ACOIT62457.2024.10941545

Lambrechts, Wirix-Speetjens, Maes, & Van Huffel. (2022). Artificial Intelligence Based Patient-Specific Preoperative Planning Algorithm for Total Knee Arthroplasty. *Frontiers in Robotics and AI*, *9*. Https://doi.org/10.3389/frobt.2022.840282.

Marchese, Katzschmann, & Rus. (2015). A Recipe for Soft Fluidic Elastomer Robots. *Soft Robotics*, *2*(1), 7-25. Https://doi.org/10.1089/soro.2014.0022.

McKendrick. (2018). *Workload Transition, Cognitive Load States, and Adaptive Autonomous Transportation*. Elsevier. Https://doi.org/10.1016/b978-0-12-811926-6.00084-1

McMillan, Zureikat, Hogg, Kowalsky, Zeh, Sprys, & Vollmer. (2017). A Propensity Score-Matched Analysis of Robotic vs Open Pancreatoduodenectomy on Incidence of Pancreatic Fistula. *JAMA Surgery*. Https://doi.org/10.1001/jamasurg.2016.4755.

Mitra, Hallajiyan, Kim, Dharmalingam, Elnawawy, Iqbal,... & Alemzadeh. (2025). Systems-Theoretic and Data-Driven Security Analysis in ML-enabled Medical Devices. Https://doi.org/10.48550/arXiv.2506.15028

Moore, Jean, Hanson, McKay, Pergament, Culhane-Pera,... & McGovern. (2026). Race, socioeconomic status, and geography influence utilization of surgery in Minnesota epilepsy patients.. *Journal of Neurosurgery*. Https://doi.org/10.3171/2025.8.JNS25841.

Nazarian, Koo, Carrington, Darzi, & Patel. (2023). The future of endoscopy - what are the thoughts on artificial intelligence?. *Journal of experimental and theoretical artificial intelligence (Print)*. Https://doi.org/10.1080/0952813X.2023.2178516.

Nguyen, Fitzpatrick, & Jones. (2017). Barriers to implementation of the FUSE program. *Surgical Endoscopy*, *32*(1), 466-471. Https://doi.org/10.1007/s00464-017-5706-7.

Pawelczyk, Kraus, Voigtlaender, Siebenlist, & Rupp. (2025). Advancing Musculoskeletal Care Using AI and Digital Health Applications: A Review of Commercial Solutions. *HSS Journal ®*. Https://doi.org/10.1177/15563316251341321.

Saeidi, Opfermann, Kam, Raghunathan, Léonard, & Krieger. (2018). A Confidence-Based Shared Control Strategy for the Smart Tissue Autonomous Robot (STAR). *IEEE/RJS International Conference on Intelligent RObots and Systems*. Https://doi.org/10.1109/IROS.2018.8594290.

Saeidi, Ge, Kam, Opfermann, Léonard, Joshi, & Krieger. (2019). Supervised Autonomous Electrosurgery via Biocompatible Near-Infrared Tissue Tracking Techniques. *IEEE Transactions on Medical Robotics and Bionics*. Https://doi.org/10.1109/TMRB.2019.2949870.

Satava. (2010). *Future Directions in Robotic Surgery*. Springer US. Https://doi.org/10.1007/978-1-4419-1126-1_1

Schüßler, Kunz, Younis, Alt, Paik, Wagner, & Mathis-Ullrich. (2025). Semi-Autonomous Robotic Assistance for Gallbladder Retraction in Surgery. *IEEE Robotics and Automation Letters*. Https://doi.org/10.1109/LRA.2025.3577430.

Shaikh, Jain, Patel, Das, Mahesh, & Thakor. (2025). Enhancing Surgical Precision and Recovery: A Review of Medical Robotics and AI Integration in Modern Operating Rooms. *EPJ Web of Conferences*. Https://doi.org/10.1051/epjconf/202532801016.

Shetty, & Jaiswal. (2024). Venture Capital Investment Trends in Robotics and Autonomous Systems Startups. *Journal of Artificial Intelligence, Machine Learning and Data Science*. Https://doi.org/10.51219/jaimld/saiman-harsh/352.

Stoyanov, Taylor, Sarikaya, Mcleod, Ballester, & Codella. (2018). OR 2.0 Context-Aware Operating Theaters, Computer Assisted Robotic Endoscopy, Clinical Image-Based Procedures, and Skin Image Analysis. *Lecture Notes in Computer Science*. Https://doi.org/10.1007/978-3-030-01201-4.

Szczerba, & Collier. (1998). &lt;title&gt;Bounding overwatch operations for robotic and semi-robotic ground vehicles&lt;/title&gt;. SPIE. (pp. 243-252). Https://doi.org/10.1117/12.317552

The Lancet Digital Health. (2025). Rapid generative AI rollout in health care. *The Lancet Digital Health*, *7*(8), 100909. Https://doi.org/10.1016/j.landig.2025.100909.

Tian, Nong, Tang, Zhai, Guo, Li,... & Tang. (2025). A multi-perspective qualitative study on robotic-assisted surgery training demand. *Scientific Reports*. Https://doi.org/10.1038/s41598-025-13323-6.

Tien Ho. (2025). Optimizing AI Assistance in the Process of English Writing: A Taiwanese Paradigm of Facilitating AI-Assisted Efl Writing Training. Global Research & Development Services Publishing. (pp. 443-444). Https://doi.org/10.20319/ictel.2025.443444

Vaishya, Vaish, & Salman. (2025). Do Robotic and AI Technologies Improve Outcomes in Orthopaedic Surgery or Raise Costs and Learning Curves?. *Basrah Journal of Surgery*, *0*(0), 1-4. Https://doi.org/10.33762/basjsurg.2025.164614.1141.

Wah. (2025). Revolutionizing surgery: AI and robotics for precision, risk reduction, and innovation. *Journal of Robotic Surgery*, *19*(1). Https://doi.org/10.1007/s11701-024-02205-0.

Zheng, Huang, Liu, & Yang. (2022). Editorial: Perception recovery and augmentation in medical robotics. *Frontiers in Neurorobotics*. Https://doi.org/10.3389/fnbot.2022.1058793.

Zhu. (2025). Robotic-Assisted Surgery: State-of-the-Art Development, Clinical Challenges, and Future Directions. Https://doi.org/10.5220/0014362900004718